/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.infraestrutura.util;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import serpro.ppgd.formatosexternos.ListaRelatoriosIf;
import serpro.ppgd.formatosexternos.RelatorioIf;
import serpro.ppgd.gui.PPGDFormBuilder;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.ItemRelatorio;

public class DialogImprimirRelatorio
extends JPanel {
    private static final PlataformaPPGD plataforma = PlataformaPPGD.getPlataforma();
    private JDialog dialog = new JDialog(plataforma.getJanelaPrincipal(), "Imprimir", true);
    private String msg = "Selecione o que deseja imprimir:";
    private JList lista = new JList();
    private JScrollPane scrollLista;
    private JPanel barraBotoes;
    private JButton btnVisualizar;
    private JButton btnOk;

    public DialogImprimirRelatorio() {
        super(new BorderLayout());
        this.initComponentes();
        super.add((Component)this.buildPanel(), "Center");
        super.setBorder(BorderFactory.createEmptyBorder(6, 6, 3, 6));
        this.dialog.setContentPane(this);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(plataforma.getJanelaPrincipal());
        this.dialog.setVisible(true);
    }

    private void initComponentes() {
        this.scrollLista = this.getListaRelatorios();
        this.barraBotoes = this.getBarraBotoes();
        this.btnVisualizar = new JButton("Visualizar...");
        this.btnVisualizar.setEnabled(false);
        this.btnOk.setEnabled(false);
        this.btnVisualizar.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogImprimirRelatorio.this.clickedVisualizar();
            }
        });
        this.lista.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                DialogImprimirRelatorio.this.selectionChanged(e);
            }
        });
    }

    protected void selectionChanged(ListSelectionEvent e) {
        ItemRelatorio item = (ItemRelatorio)this.lista.getSelectedValue();
        if (item != null) {
            boolean habilitado = item.getRelatorio().isHabilitado();
            this.btnVisualizar.setEnabled(habilitado);
            this.btnOk.setEnabled(habilitado);
        }
    }

    private JPanel buildPanel() {
        FormLayout layout = new FormLayout("fill:p:grow, fill:5dlu:grow, fill:100dlu:grow", "20dlu, 65dlu, 20dlu");
        PPGDFormBuilder builder = new PPGDFormBuilder(layout);
        JPanel panel = new JPanel(new FlowLayout(0));
        panel.add(this.btnVisualizar);
        builder.append((Component)new JLabel(this.msg), 3);
        builder.append((Component)this.scrollLista, 3);
        builder.append(panel);
        builder.append(this.barraBotoes);
        return builder.getPanel();
    }

    private void clickedCancel() {
        this.dialog.setVisible(false);
    }

    private void clickedOk() {
        this.dialog.setVisible(false);
        ItemRelatorio item = (ItemRelatorio)this.lista.getSelectedValue();
        if (item != null) {
            item.getRelatorio().imprimir();
        }
    }

    protected void clickedVisualizar() {
        ItemRelatorio item = (ItemRelatorio)this.lista.getSelectedValue();
        if (item != null) {
            item.getRelatorio().visualizar();
        }
    }

    private JPanel getBarraBotoes() {
        JPanel painel = new JPanel(new FlowLayout(2));
        JPanel gridPainel = new JPanel(new GridLayout(1, 4, 6, 2));
        this.btnOk = new JButton("Ok");
        JButton cancel = new JButton("Cancelar");
        this.btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogImprimirRelatorio.this.clickedOk();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogImprimirRelatorio.this.clickedCancel();
            }
        });
        gridPainel.add(this.btnOk);
        gridPainel.add(cancel);
        painel.add(gridPainel);
        return painel;
    }

    private JScrollPane getListaRelatorios() {
        Vector dados = new Vector();
        for (ListaRelatoriosIf listaRelatorio : plataforma.getListaRelatorios()) {
            this.adicionaItensRelatorio(dados, listaRelatorio);
        }
        this.lista.setListData(dados);
        JScrollPane scroll = new JScrollPane(this.lista);
        this.lista.setSelectionMode(0);
        return scroll;
    }

    private void adicionaItensRelatorio(Vector dados, ListaRelatoriosIf listaRelatorio) {
        for (RelatorioIf rel : listaRelatorio.getRelatorios()) {
            dados.add(new ItemRelatorio(rel));
        }
    }

    public static void main(String[] args) {
        new DialogImprimirRelatorio();
    }
}

