/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.gui;

import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import serpro.ppgd.gui.ButtonPPGD;
import serpro.ppgd.gui.ConstantesGlobaisGUI;
import serpro.ppgd.gui.PPGDFormBuilder;
import serpro.ppgd.gui.UtilitariosGUI;
import serpro.ppgd.negocio.util.UtilitariosString;

public class OpcaoDialog {
    public static final int OPCAO_FECHAR = 0;
    private static final String LABEL_TEXTO_DEFAULT = "Clique na op\u00e7\u00e3o desejada:";
    private static final String LABEL_BOTAO_FECHAR = "Fechar";
    protected static final ImageIcon ICO_INDICADOR = new ImageIcon(Thread.currentThread().getContextClassLoader().getResource("imagens/ico_indicador.gif"));
    protected int value;
    protected JDialog dialog;

    public OpcaoDialog(String[] opcao) {
        this(null, "", LABEL_TEXTO_DEFAULT, opcao, true);
    }

    public OpcaoDialog(String texto, String[] opcao) {
        this(null, "", texto, opcao, true);
    }

    public OpcaoDialog(JFrame owner, String titulo, String texto, String[] opcao, boolean modal) {
        this.dialog = owner != null ? new JDialog(owner, titulo, modal) : new JDialog(null, titulo, modal);
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.getContentPane().setBackground(ConstantesGlobaisGUI.COR_BRANCO);
        this.dialog.getContentPane().add(this.buildPanel(titulo, texto, opcao));
        this.dialog.setSize(this.dialog.getPreferredSize());
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.pack();
    }

    private void fechar() {
        this.value = 0;
        this.dialog.setVisible(false);
    }

    public int showDialog(String titulo) {
        this.dialog.setTitle(titulo);
        this.dialog.show();
        return this.value;
    }

    public JComponent buildPanel(String titulo, String texto, String[] opcao) {
        String rowsLayout = "8dlu, p, 10dlu";
        int i = 0;
        while (i < opcao.length) {
            rowsLayout = String.valueOf(rowsLayout) + ", p, 5dlu";
            ++i;
        }
        rowsLayout = String.valueOf(rowsLayout) + ", p, 15dlu, p, 3dlu";
        FormLayout layout = new FormLayout("5dlu, l:p:grow, 5dlu", rowsLayout);
        PPGDFormBuilder builder = new PPGDFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.getPanel().setBackground(ConstantesGlobaisGUI.COR_BRANCO);
        builder.nextLine();
        JLabel lbTexto = new JLabel(UtilitariosString.strToHtml((String)texto));
        UtilitariosGUI.setParametrosGUI((JComponent)lbTexto, (Font)ConstantesGlobaisGUI.FONTE_10_NORMAL, (Color)ConstantesGlobaisGUI.COR_PRETO, (Color)ConstantesGlobaisGUI.COR_BRANCO);
        builder.setColumn(2);
        builder.append(lbTexto);
        builder.nextLine(2);
        if (opcao != null) {
            ButtonPPGD[] btnOpcao = new ButtonPPGD[opcao.length];
            int i2 = 0;
            while (i2 < opcao.length) {
                btnOpcao[i2] = new ButtonPPGD(opcao[i2], (Icon)ICO_INDICADOR);
                UtilitariosGUI.setParametrosGUI((JComponent)btnOpcao[i2], (Font)ConstantesGlobaisGUI.FONTE_10_NORMAL, (Color)ConstantesGlobaisGUI.COR_PRETO, (Color)ConstantesGlobaisGUI.COR_BRANCO);
                btnOpcao[i2].addMouseListener((MouseListener)new ExecutarSelecionarOpcao(i2 + 1));
                builder.setColumn(2);
                builder.append((Component)btnOpcao[i2]);
                builder.nextLine(2);
                ++i2;
            }
        }
        builder.nextLine(2);
        ButtonPPGD btnFechar = new ButtonPPGD(LABEL_BOTAO_FECHAR, (Icon)ConstantesGlobaisGUI.ICO_STOP, (Icon)ConstantesGlobaisGUI.ICO_STOP_SEL, (Icon)ConstantesGlobaisGUI.ICO_STOP_PRES);
        UtilitariosGUI.setParametrosGUI((JComponent)btnFechar, (Font)ConstantesGlobaisGUI.FONTE_10_NORMAL, (Color)ConstantesGlobaisGUI.COR_PRETO, (Color)ConstantesGlobaisGUI.COR_BRANCO);
        btnFechar.setaDimensoes();
        btnFechar.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                OpcaoDialog.this.fechar();
            }
        });
        builder.appendCenter((JComponent)btnFechar);
        return builder.getPanel();
    }

    protected class ExecutarSelecionarOpcao
    extends MouseAdapter {
        private int numOpcao;

        public ExecutarSelecionarOpcao(int numOpcao) {
            this.numOpcao = numOpcao;
        }

        public void mouseClicked(MouseEvent e) {
            OpcaoDialog.this.value = this.numOpcao;
            OpcaoDialog.this.dialog.setVisible(false);
        }
    }
}

