/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.Format;

public class XMLOutputter
implements Cloneable {
    private static final String CVS_ID = "@(#) $RCSfile: XMLOutputter.java,v $ $Revision: 1.102 $ $Date: 2004/02/15 20:05:00 $ $Name: jdom_1_0_b10 $";
    public Format userFormat = Format.getRawFormat();
    public Format preserveFormat = Format.getRawFormat();
    public Format currentFormat = this.userFormat;

    public XMLOutputter() {
    }

    public XMLOutputter(Format format) {
        this.currentFormat = this.userFormat = format;
    }

    public XMLOutputter(String string) {
        this.userFormat.setIndent(string);
    }

    public XMLOutputter(String string, boolean bl2) {
        this.userFormat.setIndent(string);
        if (!bl2) {
            this.userFormat.setIndent(null);
        }
    }

    public XMLOutputter(String string, boolean bl2, String string2) {
        this.userFormat.setIndent(string);
        if (!bl2) {
            this.userFormat.setIndent(null);
        }
        this.userFormat.setEncoding(string2);
    }

    public XMLOutputter(XMLOutputter xMLOutputter) {
        this.currentFormat = this.userFormat = (Format)xMLOutputter.userFormat.clone();
    }

    public void setFormat(Format format) {
        this.currentFormat = this.userFormat = format;
    }

    public Format getFormat() {
        return this.userFormat;
    }

    public void setLineSeparator(String string) {
        this.userFormat.setLineSeparator(string);
    }

    public void setNewlines(boolean bl2) {
    }

    public void setEncoding(String string) {
        this.userFormat.setEncoding(string);
    }

    public void setOmitEncoding(boolean bl2) {
        this.userFormat.setOmitEncoding(bl2);
    }

    public void setOmitDeclaration(boolean bl2) {
        this.userFormat.setOmitDeclaration(bl2);
    }

    public void setExpandEmptyElements(boolean bl2) {
        this.userFormat.setExpandEmptyElements(bl2);
    }

    public void setTrimAllWhite(boolean bl2) {
        this.userFormat.setTextMode(Format.TextMode.TRIM_FULL_WHITE);
    }

    public void setTextTrim(boolean bl2) {
        this.userFormat.setTextMode(Format.TextMode.TRIM);
    }

    public void setTextNormalize(boolean bl2) {
        this.userFormat.setTextMode(Format.TextMode.NORMALIZE);
    }

    public void setIndent(String string) {
        this.userFormat.setIndent(string);
    }

    public void output(Document document, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(document, writer);
    }

    public void output(DocType docType, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(docType, writer);
    }

    public void output(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(element, writer);
    }

    public void outputElementContent(Element element, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.outputElementContent(element, writer);
    }

    public void output(List list, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(list, writer);
    }

    public void output(CDATA cDATA, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(cDATA, writer);
    }

    public void output(Text text, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(text, writer);
    }

    public void output(Comment comment, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(comment, writer);
    }

    public void output(ProcessingInstruction processingInstruction, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(processingInstruction, writer);
    }

    public void output(EntityRef entityRef, OutputStream outputStream) throws IOException {
        Writer writer = this.makeWriter(outputStream);
        this.output(entityRef, writer);
    }

    private Writer makeWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        return this.makeWriter(outputStream, this.userFormat.f);
    }

    private Writer makeWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if ("UTF-8".equals(string)) {
            string = "UTF8";
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(outputStream), string));
        return bufferedWriter;
    }

    public void output(Document document, Writer writer) throws IOException {
        this.printDeclaration(writer, document, this.userFormat.f);
        List list = document.getContent();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Object e2 = list.get(n3);
            if (e2 instanceof Element) {
                this.printElement(writer, document.getRootElement(), 0, this.createNamespaceStack());
            } else if (e2 instanceof Comment) {
                this.printComment(writer, (Comment)e2);
            } else if (e2 instanceof ProcessingInstruction) {
                this.printProcessingInstruction(writer, (ProcessingInstruction)e2);
            } else if (e2 instanceof DocType) {
                this.printDocType(writer, document.getDocType());
                writer.write(this.currentFormat.b);
            }
            this.newline(writer);
            this.indent(writer, 0);
            ++n3;
        }
        writer.write(this.currentFormat.b);
        writer.flush();
    }

    public void output(DocType docType, Writer writer) throws IOException {
        this.printDocType(writer, docType);
        writer.flush();
    }

    public void output(Element element, Writer writer) throws IOException {
        this.printElement(writer, element, 0, this.createNamespaceStack());
        writer.flush();
    }

    public void outputElementContent(Element element, Writer writer) throws IOException {
        List list = element.getContent();
        this.printContentRange(writer, list, 0, list.size(), 0, this.createNamespaceStack());
        writer.flush();
    }

    public void output(List list, Writer writer) throws IOException {
        this.printContentRange(writer, list, 0, list.size(), 0, this.createNamespaceStack());
        writer.flush();
    }

    public void output(CDATA cDATA, Writer writer) throws IOException {
        this.printCDATA(writer, cDATA);
        writer.flush();
    }

    public void output(Text text, Writer writer) throws IOException {
        this.printText(writer, text);
        writer.flush();
    }

    public void output(Comment comment, Writer writer) throws IOException {
        this.printComment(writer, comment);
        writer.flush();
    }

    public void output(ProcessingInstruction processingInstruction, Writer writer) throws IOException {
        this.printProcessingInstruction(writer, processingInstruction);
        writer.flush();
    }

    public void output(EntityRef entityRef, Writer writer) throws IOException {
        this.printEntityRef(writer, entityRef);
        writer.flush();
    }

    public String outputString(Document document) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(document, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(DocType docType) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(docType, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(Element element) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(element, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(List list) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(list, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(CDATA cDATA) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(cDATA, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(Text text) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(text, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(Comment comment) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(comment, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(ProcessingInstruction processingInstruction) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(processingInstruction, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public String outputString(EntityRef entityRef) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.output(entityRef, (Writer)stringWriter);
        }
        catch (IOException iOException) {}
        return stringWriter.toString();
    }

    public void printDeclaration(Writer writer, Document document, String string) throws IOException {
        if (!this.userFormat.e) {
            writer.write("<?xml version=\"1.0\"");
            if (!this.userFormat.d) {
                writer.write(" encoding=\"" + string + "\"");
            }
            writer.write("?>");
            writer.write(this.currentFormat.b);
        }
    }

    public void printDocType(Writer writer, DocType docType) throws IOException {
        String string = docType.getPublicID();
        String string2 = docType.getSystemID();
        String string3 = docType.getInternalSubset();
        boolean bl2 = false;
        writer.write("<!DOCTYPE ");
        writer.write(docType.getElementName());
        if (string != null) {
            writer.write(" PUBLIC \"");
            writer.write(string);
            writer.write("\"");
            bl2 = true;
        }
        if (string2 != null) {
            if (!bl2) {
                writer.write(" SYSTEM");
            }
            writer.write(" \"");
            writer.write(string2);
            writer.write("\"");
        }
        if (string3 != null && !string3.equals("")) {
            writer.write(" [");
            writer.write(this.currentFormat.b);
            writer.write(docType.getInternalSubset());
            writer.write("]");
        }
        writer.write(">");
    }

    public void printComment(Writer writer, Comment comment) throws IOException {
        writer.write("<!--");
        writer.write(comment.getText());
        writer.write("-->");
    }

    public void printProcessingInstruction(Writer writer, ProcessingInstruction processingInstruction) throws IOException {
        String string = processingInstruction.getTarget();
        String string2 = processingInstruction.getData();
        if (!"".equals(string2)) {
            writer.write("<?");
            writer.write(string);
            writer.write(" ");
            writer.write(string2);
            writer.write("?>");
        } else {
            writer.write("<?");
            writer.write(string);
            writer.write("?>");
        }
    }

    public void printEntityRef(Writer writer, EntityRef entityRef) throws IOException {
        writer.write("&");
        writer.write(entityRef.getName());
        writer.write(";");
    }

    public void printCDATA(Writer writer, CDATA cDATA) throws IOException {
        String string = this.currentFormat.a == Format.TextMode.NORMALIZE ? cDATA.getTextNormalize() : (this.currentFormat.a == Format.TextMode.TRIM ? cDATA.getText().trim() : cDATA.getText());
        writer.write("<![CDATA[");
        writer.write(string);
        writer.write("]]>");
    }

    public void printText(Writer writer, Text text) throws IOException {
        String string = this.currentFormat.a == Format.TextMode.NORMALIZE ? text.getTextNormalize() : (this.currentFormat.a == Format.TextMode.TRIM ? text.getText().trim() : text.getText());
        writer.write(this.escapeElementEntities(string));
    }

    public void printString(Writer writer, String string) throws IOException {
        if (this.currentFormat.a == Format.TextMode.NORMALIZE) {
            string = Text.normalizeString(string);
        } else if (this.currentFormat.a == Format.TextMode.TRIM) {
            string = string.trim();
        }
        writer.write(this.escapeElementEntities(string));
    }

    public void printElement(Writer writer, Element element, int n2, NamespaceStack namespaceStack) throws IOException {
        int n3;
        int n4;
        List list = element.getAttributes();
        List list2 = element.getContent();
        String string = null;
        if (list != null) {
            string = element.getAttributeValue("space", Namespace.XML_NAMESPACE);
        }
        Format format = this.currentFormat;
        if ("default".equals(string)) {
            this.currentFormat = this.userFormat;
        } else if ("preserve".equals(string)) {
            this.currentFormat = this.preserveFormat;
        }
        writer.write("<");
        writer.write(element.getQualifiedName());
        int n5 = namespaceStack.size();
        this.printElementNamespace(writer, element, namespaceStack);
        this.printAdditionalNamespaces(writer, element, namespaceStack);
        if (list != null) {
            this.printAttributes(writer, list, element, namespaceStack);
        }
        if ((n4 = this.skipLeadingWhite(list2, 0)) >= (n3 = list2.size())) {
            if (this.currentFormat.i) {
                writer.write("></");
                writer.write(element.getQualifiedName());
                writer.write(">");
            } else {
                writer.write(" />");
            }
        } else {
            writer.write(">");
            if (this.nextNonText(list2, n4) < n3) {
                this.newline(writer);
                this.printContentRange(writer, list2, n4, n3, n2 + 1, namespaceStack);
                this.newline(writer);
                this.indent(writer, n2);
            } else {
                this.printTextRange(writer, list2, n4, n3);
            }
            writer.write("</");
            writer.write(element.getQualifiedName());
            writer.write(">");
        }
        while (namespaceStack.size() > n5) {
            namespaceStack.pop();
        }
        this.currentFormat = format;
    }

    public void printContentRange(Writer writer, List list, int n2, int n3, int n4, NamespaceStack namespaceStack) throws IOException {
        int n5 = n2;
        while (n5 < n3) {
            boolean bl2 = n5 == n2;
            Object e2 = list.get(n5);
            if (e2 instanceof Text) {
                int n6 = this.skipLeadingWhite(list, n5);
                if (n6 >= (n5 = this.nextNonText(list, n6))) continue;
                if (!bl2) {
                    this.newline(writer);
                }
                this.indent(writer, n4);
                this.printTextRange(writer, list, n6, n5);
                continue;
            }
            if (!bl2) {
                this.newline(writer);
            }
            this.indent(writer, n4);
            if (e2 instanceof Comment) {
                this.printComment(writer, (Comment)e2);
            } else if (e2 instanceof Element) {
                this.printElement(writer, (Element)e2, n4, namespaceStack);
            } else if (e2 instanceof EntityRef) {
                this.printEntityRef(writer, (EntityRef)e2);
            } else if (e2 instanceof ProcessingInstruction) {
                this.printProcessingInstruction(writer, (ProcessingInstruction)e2);
            }
            ++n5;
        }
    }

    public void printTextRange(Writer writer, List list, int n2, int n3) throws IOException {
        int n4;
        String string = null;
        if ((n2 = this.skipLeadingWhite(list, n2)) < (n4 = list.size())) {
            n3 = this.skipTrialingWhite(list, n3);
            int n5 = n2;
            while (n5 < n3) {
                Object e2 = list.get(n5);
                String string2 = ((Text)e2).getText();
                if (string2 != null && !"".equals(string2)) {
                    if (string != null && (this.currentFormat.a == Format.TextMode.NORMALIZE || this.currentFormat.a == Format.TextMode.TRIM) && (this.endsWithWhite(string) || this.startsWithWhite(string2))) {
                        writer.write(" ");
                    }
                    if (e2 instanceof CDATA) {
                        this.printCDATA(writer, (CDATA)e2);
                    } else {
                        this.printString(writer, string2);
                    }
                    string = string2;
                }
                ++n5;
            }
        }
    }

    private void printNamespace(Writer writer, Namespace namespace, NamespaceStack namespaceStack) throws IOException {
        String string = namespace.getPrefix();
        String string2 = namespace.getURI();
        if (string2.equals(namespaceStack.getURI(string))) {
            return;
        }
        writer.write(" xmlns");
        if (!string.equals("")) {
            writer.write(":");
            writer.write(string);
        }
        writer.write("=\"");
        writer.write(string2);
        writer.write("\"");
        namespaceStack.push(namespace);
    }

    public void printAttributes(Writer writer, List list, Element element, NamespaceStack namespaceStack) throws IOException {
        int n2 = 0;
        while (n2 < list.size()) {
            Attribute attribute = (Attribute)list.get(n2);
            Namespace namespace = attribute.getNamespace();
            if (namespace != Namespace.NO_NAMESPACE && namespace != Namespace.XML_NAMESPACE) {
                this.printNamespace(writer, namespace, namespaceStack);
            }
            writer.write(" ");
            writer.write(attribute.getQualifiedName());
            writer.write("=");
            writer.write("\"");
            writer.write(this.escapeAttributeEntities(attribute.getValue()));
            writer.write("\"");
            ++n2;
        }
    }

    private void printElementNamespace(Writer writer, Element element, NamespaceStack namespaceStack) throws IOException {
        Namespace namespace = element.getNamespace();
        if (namespace == Namespace.XML_NAMESPACE) {
            return;
        }
        if (namespace != Namespace.NO_NAMESPACE || namespaceStack.getURI("") != null) {
            this.printNamespace(writer, namespace, namespaceStack);
        }
    }

    private void printAdditionalNamespaces(Writer writer, Element element, NamespaceStack namespaceStack) throws IOException {
        List list = element.getAdditionalNamespaces();
        if (list != null) {
            int n2 = 0;
            while (n2 < list.size()) {
                Namespace namespace = (Namespace)list.get(n2);
                this.printNamespace(writer, namespace, namespaceStack);
                ++n2;
            }
        }
    }

    private void newline(Writer writer) throws IOException {
        if (this.currentFormat.h != null) {
            writer.write(this.currentFormat.b);
        }
    }

    private void indent(Writer writer, int n2) throws IOException {
        if (this.currentFormat.h == null || this.currentFormat.h.equals("")) {
            return;
        }
        int n3 = 0;
        while (n3 < n2) {
            writer.write(this.currentFormat.h);
            ++n3;
        }
    }

    private int skipLeadingWhite(List list, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        int n4 = list.size();
        if (this.currentFormat.a == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.a == Format.TextMode.NORMALIZE || this.currentFormat.a == Format.TextMode.TRIM) {
            while (n3 < n4) {
                if (!this.isAllWhitespace(list.get(n3))) {
                    return n3;
                }
                ++n3;
            }
        }
        return n3;
    }

    private int skipTrialingWhite(List list, int n2) {
        int n3 = list.size();
        if (n2 > n3) {
            n2 = n3;
        }
        int n4 = n2;
        if (this.currentFormat.a == Format.TextMode.TRIM_FULL_WHITE || this.currentFormat.a == Format.TextMode.NORMALIZE || this.currentFormat.a == Format.TextMode.TRIM) {
            while (n4 >= 0) {
                if (!this.isAllWhitespace(list.get(n4 - 1))) break;
                --n4;
            }
        }
        return n4;
    }

    private int nextNonText(List list, int n2) {
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2;
        int n4 = list.size();
        while (n3 < n4) {
            if (!(list.get(n3) instanceof Text)) {
                return n3;
            }
            ++n3;
        }
        return n4;
    }

    private boolean isAllWhitespace(Object object) {
        String string = null;
        if (object instanceof String) {
            string = (String)object;
        } else if (object instanceof Text) {
            string = ((Text)object).getText();
        } else {
            return false;
        }
        int n2 = 0;
        while (n2 < string.length()) {
            if (!this.isWhitespace(string.charAt(n2))) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean startsWithWhite(String string) {
        return string != null && string.length() > 0 && this.isWhitespace(string.charAt(0));
    }

    private boolean endsWithWhite(String string) {
        return string != null && string.length() > 0 && this.isWhitespace(string.charAt(string.length() - 1));
    }

    private boolean isWhitespace(char c2) {
        return c2 == ' ' || c2 == '\n' || c2 == '\t' || c2 == '\r';
    }

    public String escapeAttributeEntities(String string) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < string.length()) {
            String string2;
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                default: {
                    string2 = this.currentFormat.c.shouldEscape(c2) ? "&#x" + Integer.toHexString(c2) + ";" : null;
                }
            }
            if (stringBuffer == null) {
                if (string2 != null) {
                    stringBuffer = new StringBuffer(string.length() + 20);
                    stringBuffer.append(string.substring(0, n2));
                    stringBuffer.append(string2);
                }
            } else if (string2 == null) {
                stringBuffer.append(c2);
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public String escapeElementEntities(String string) {
        StringBuffer stringBuffer = null;
        int n2 = 0;
        while (n2 < string.length()) {
            String string2;
            char c2 = string.charAt(n2);
            switch (c2) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                default: {
                    string2 = this.currentFormat.c.shouldEscape(c2) ? "&#x" + Integer.toHexString(c2) + ";" : null;
                }
            }
            if (stringBuffer == null) {
                if (string2 != null) {
                    stringBuffer = new StringBuffer(string.length() + 20);
                    stringBuffer.append(string.substring(0, n2));
                    stringBuffer.append(string2);
                }
            } else if (string2 == null) {
                stringBuffer.append(c2);
            } else {
                stringBuffer.append(string2);
            }
            ++n2;
        }
        return stringBuffer == null ? string : stringBuffer.toString();
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < this.userFormat.b.length()) {
            char c2 = this.userFormat.b.charAt(n2);
            switch (c2) {
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                default: {
                    stringBuffer.append("[" + c2 + "]");
                }
            }
            ++n2;
        }
        return "XMLOutputter[omitDeclaration = " + this.userFormat.e + ", " + "encoding = " + this.userFormat.f + ", " + "omitEncoding = " + this.userFormat.d + ", " + "indent = '" + this.userFormat.h + "'" + ", " + "expandEmptyElements = " + this.userFormat.i + ", " + "lineSeparator = '" + stringBuffer.toString() + "', " + "textMode = " + this.userFormat.a + "]";
    }

    private NamespaceStack createNamespaceStack() {
        return new NamespaceStack(this);
    }

    protected class NamespaceStack
    extends org.jdom.output.NamespaceStack {
        private final XMLOutputter this$0;

        public NamespaceStack(XMLOutputter xMLOutputter) {
            this.this$0 = xMLOutputter;
        }
    }
}

