/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Content;
import org.jdom.IllegalDataException;
import org.jdom.IllegalTargetException;
import org.jdom.Verifier;
import org.jdom.output.XMLOutputter;

public class ProcessingInstruction
extends Content {
    private static final String CVS_ID = "@(#) $RCSfile: ProcessingInstruction.java,v $ $Revision: 1.44 $ $Date: 2004/02/11 21:12:43 $ $Name: jdom_1_0_b10 $";
    public String target;
    public String rawData;
    public Map mapData;

    public ProcessingInstruction() {
    }

    public ProcessingInstruction(String string, Map map) {
        this.setTarget(string);
        this.setData(map);
    }

    public ProcessingInstruction(String string, String string2) {
        this.setTarget(string);
        this.setData(string2);
    }

    public ProcessingInstruction setTarget(String string) {
        String string2 = Verifier.checkProcessingInstructionTarget(string);
        if (string2 != null) {
            throw new IllegalTargetException(string, string2);
        }
        this.target = string;
        return this;
    }

    public String getValue() {
        return this.rawData;
    }

    public String getTarget() {
        return this.target;
    }

    public String getData() {
        return this.rawData;
    }

    public List getNames() {
        return this.getPseudoAttributeNames();
    }

    public List getPseudoAttributeNames() {
        Set set = this.mapData.entrySet();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = string.substring(0, string.indexOf("="));
            arrayList.add(string2);
        }
        return arrayList;
    }

    public ProcessingInstruction setData(String string) {
        String string2 = Verifier.checkProcessingInstructionData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, string2);
        }
        this.rawData = string;
        this.mapData = this.parseData(string);
        return this;
    }

    public ProcessingInstruction setData(Map map) {
        String string = this.toString(map);
        String string2 = Verifier.checkProcessingInstructionData(string);
        if (string2 != null) {
            throw new IllegalDataException(string, string2);
        }
        this.rawData = string;
        this.mapData = map;
        return this;
    }

    public String getValue(String string) {
        return this.getPseudoAttributeValue(string);
    }

    public String getPseudoAttributeValue(String string) {
        return (String)this.mapData.get(string);
    }

    public ProcessingInstruction setValue(String string, String string2) {
        return this.setPseudoAttribute(string, string2);
    }

    public ProcessingInstruction setPseudoAttribute(String string, String string2) {
        String string3 = Verifier.checkProcessingInstructionData(string);
        if (string3 != null) {
            throw new IllegalDataException(string, string3);
        }
        string3 = Verifier.checkProcessingInstructionData(string2);
        if (string3 != null) {
            throw new IllegalDataException(string2, string3);
        }
        this.mapData.put(string, string2);
        this.rawData = this.toString(this.mapData);
        return this;
    }

    public boolean removeValue(String string) {
        return this.removePseudoAttribute(string);
    }

    public boolean removePseudoAttribute(String string) {
        if (this.mapData.remove(string) != null) {
            this.rawData = this.toString(this.mapData);
            return true;
        }
        return false;
    }

    private String toString(Map map) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append(string).append("=\"").append(string2).append("\" ");
        }
        if (stringBuffer.length() > 0) {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private Map parseData(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string.trim();
        while (!string2.trim().equals("")) {
            String string3 = "";
            String string4 = "";
            int n2 = 0;
            char c2 = string2.charAt(n2);
            int n3 = 1;
            while (n3 < string2.length()) {
                char c3 = string2.charAt(n3);
                if (c3 == '=') {
                    string3 = string2.substring(n2, n3).trim();
                    int[] nArray = this.extractQuotedString(string2.substring(n3 + 1));
                    if (nArray == null) {
                        return new HashMap();
                    }
                    string4 = string2.substring(nArray[0] + n3 + 1, nArray[1] + n3 + 1);
                    n3 += nArray[1] + 1;
                    break;
                }
                if (Character.isWhitespace(c2) && !Character.isWhitespace(c3)) {
                    n2 = n3;
                }
                c2 = c3;
                ++n3;
            }
            string2 = string2.substring(n3);
            if (string3.length() <= 0 || string4 == null) continue;
            hashMap.put(string3, string4);
        }
        return hashMap;
    }

    private int[] extractQuotedString(String string) {
        boolean bl2 = false;
        char c2 = '\"';
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            char c3 = string.charAt(n3);
            if (c3 == '\"' || c3 == '\'') {
                if (!bl2) {
                    c2 = c3;
                    bl2 = true;
                    n2 = n3 + 1;
                } else if (c2 == c3) {
                    bl2 = false;
                    return new int[]{n2, n3};
                }
            }
            ++n3;
        }
        return null;
    }

    public String toString() {
        return "[ProcessingInstruction: " + new XMLOutputter().outputString(this) + "]";
    }

    public Object clone() {
        ProcessingInstruction processingInstruction = (ProcessingInstruction)super.clone();
        if (this.mapData != null) {
            processingInstruction.mapData = this.parseData(this.rawData);
        }
        return processingInstruction;
    }
}

