/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.AttributeList;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.EntityRef;
import org.jdom.FilterIterator;
import org.jdom.IllegalAddException;
import org.jdom.IllegalNameException;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public class Element
extends Content
implements Parent {
    private static final String CVS_ID = "@(#) $RCSfile: Element.java,v $ $Revision: 1.145 $ $Date: 2004/02/11 21:12:43 $ $Name: jdom_1_0_b10 $";
    private static final int INITIAL_ARRAY_SIZE = 5;
    public String name;
    public transient Namespace namespace;
    public transient List additionalNamespaces;
    public AttributeList a = new AttributeList(this);
    public ContentList b = new ContentList(this);

    public Element() {
    }

    public Element(String string, Namespace namespace) {
        this.setName(string);
        this.setNamespace(namespace);
    }

    public Element(String string) {
        this(string, (Namespace)null);
    }

    public Element(String string, String string2) {
        this(string, Namespace.getNamespace("", string2));
    }

    public Element(String string, String string2, String string3) {
        this(string, Namespace.getNamespace(string2, string3));
    }

    public String getName() {
        return this.name;
    }

    public Element setName(String string) {
        String string2 = Verifier.checkElementName(string);
        if (string2 != null) {
            throw new IllegalNameException(string, "element", string2);
        }
        this.name = string;
        return this;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public Element setNamespace(Namespace namespace) {
        if (namespace == null) {
            namespace = Namespace.NO_NAMESPACE;
        }
        this.namespace = namespace;
        return this;
    }

    public String getNamespacePrefix() {
        return this.namespace.getPrefix();
    }

    public String getNamespaceURI() {
        return this.namespace.getURI();
    }

    public Namespace getNamespace(String string) {
        if (string == null) {
            return null;
        }
        if (string.equals("xml")) {
            return Namespace.XML_NAMESPACE;
        }
        if (string.equals(this.getNamespacePrefix())) {
            return this.getNamespace();
        }
        if (this.additionalNamespaces != null) {
            int n2 = 0;
            while (n2 < this.additionalNamespaces.size()) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(n2);
                if (string.equals(namespace.getPrefix())) {
                    return namespace;
                }
                ++n2;
            }
        }
        if (this.parent instanceof Element) {
            return ((Element)this.parent).getNamespace(string);
        }
        return null;
    }

    public String getQualifiedName() {
        if (this.namespace.getPrefix().equals("")) {
            return this.getName();
        }
        return this.namespace.getPrefix() + ":" + this.name;
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        String string = Verifier.checkNamespaceCollision(namespace, this);
        if (string != null) {
            throw new IllegalAddException(this, namespace, string);
        }
        if (this.additionalNamespaces == null) {
            this.additionalNamespaces = new ArrayList(5);
        }
        this.additionalNamespaces.add(namespace);
    }

    public void removeNamespaceDeclaration(Namespace namespace) {
        if (this.additionalNamespaces == null) {
            return;
        }
        this.additionalNamespaces.remove(namespace);
    }

    public List getAdditionalNamespaces() {
        if (this.additionalNamespaces == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableList(this.additionalNamespaces);
    }

    public String getValue() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.getContent().iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            if (!(content instanceof Element) && !(content instanceof Text)) continue;
            stringBuffer.append(content.getValue());
        }
        return stringBuffer.toString();
    }

    public boolean isRootElement() {
        return this.parent instanceof Document;
    }

    public int getContentSize() {
        return this.b.size();
    }

    public int indexOf(Content content) {
        return this.b.indexOf(content);
    }

    public String getText() {
        if (this.b.size() == 0) {
            return "";
        }
        if (this.b.size() == 1) {
            Object object = this.b.get(0);
            if (object instanceof Text) {
                return ((Text)object).getText();
            }
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this.b.size()) {
            Object object = this.b.get(n2);
            if (object instanceof Text) {
                stringBuffer.append(((Text)object).getText());
                bl2 = true;
            }
            ++n2;
        }
        if (!bl2) {
            return "";
        }
        return stringBuffer.toString();
    }

    public String getTextTrim() {
        return this.getText().trim();
    }

    public String getTextNormalize() {
        return Text.normalizeString(this.getText());
    }

    public String getChildText(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string) {
        Element element = this.getChild(string);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public String getChildText(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getText();
    }

    public String getChildTextTrim(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextTrim();
    }

    public String getChildTextNormalize(String string, Namespace namespace) {
        Element element = this.getChild(string, namespace);
        if (element == null) {
            return null;
        }
        return element.getTextNormalize();
    }

    public Element setText(String string) {
        this.b.clear();
        if (string != null) {
            this.addContent(new Text(string));
        }
        return this;
    }

    public List getContent() {
        return this.b;
    }

    public List getContent(Filter filter) {
        return this.b.a(filter);
    }

    public List removeContent() {
        ArrayList arrayList = new ArrayList(this.b);
        this.b.clear();
        return arrayList;
    }

    public List removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator iterator = this.b.a(filter).iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Parent setContent(Collection collection) {
        this.b.a(collection);
        return this;
    }

    public Parent setContent(int n2, Content content) {
        this.b.set(n2, content);
        return this;
    }

    public Parent setContent(int n2, Collection collection) {
        this.b.remove(n2);
        this.b.addAll(n2, collection);
        return this;
    }

    public Parent addContent(String string) {
        return this.addContent(new Text(string));
    }

    public Parent addContent(Content content) {
        this.b.add(content);
        return this;
    }

    public Parent addContent(Collection collection) {
        this.b.addAll(collection);
        return this;
    }

    public Parent addContent(int n2, Content content) {
        this.b.a(n2, content);
        return this;
    }

    public Parent addContent(int n2, Collection collection) {
        this.b.addAll(n2, collection);
        return this;
    }

    public List cloneContent() {
        int n2 = this.getContentSize();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Content content = this.getContent(n3);
            arrayList.add(content.clone());
            ++n3;
        }
        return arrayList;
    }

    public Content getContent(int n2) {
        return (Content)this.b.get(n2);
    }

    public boolean removeContent(Content content) {
        return this.b.remove(content);
    }

    public Content removeContent(int n2) {
        return (Content)this.b.remove(n2);
    }

    public Parent setContent(Content content) {
        this.b.clear();
        this.b.add(content);
        return this;
    }

    public boolean isAncestor(Element element) {
        Parent parent = element.getParent();
        while (parent instanceof Element) {
            if (parent == this) {
                return true;
            }
            parent = ((Element)parent).getParent();
        }
        return false;
    }

    public List getAttributes() {
        return this.a;
    }

    public Attribute getAttribute(String string) {
        return this.getAttribute(string, Namespace.NO_NAMESPACE);
    }

    public Attribute getAttribute(String string, Namespace namespace) {
        return (Attribute)this.a.b(string, namespace);
    }

    public String getAttributeValue(String string) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE);
    }

    public String getAttributeValue(String string, String string2) {
        return this.getAttributeValue(string, Namespace.NO_NAMESPACE, string2);
    }

    public String getAttributeValue(String string, Namespace namespace) {
        return this.getAttributeValue(string, namespace, null);
    }

    public String getAttributeValue(String string, Namespace namespace, String string2) {
        Attribute attribute = (Attribute)this.a.b(string, namespace);
        return attribute == null ? string2 : attribute.getValue();
    }

    public Element setAttributes(List list) {
        this.a.a(list);
        return this;
    }

    public Element setAttribute(String string, String string2) {
        return this.setAttribute(new Attribute(string, string2));
    }

    public Element setAttribute(String string, String string2, Namespace namespace) {
        return this.setAttribute(new Attribute(string, string2, namespace));
    }

    public Element setAttribute(Attribute attribute) {
        this.a.add(attribute);
        return this;
    }

    public boolean removeAttribute(String string) {
        return this.removeAttribute(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeAttribute(String string, Namespace namespace) {
        return this.a.c(string, namespace);
    }

    public boolean removeAttribute(Attribute attribute) {
        return this.a.remove(attribute);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64).append("[Element: <").append(this.getQualifiedName());
        String string = this.getNamespaceURI();
        if (!string.equals("")) {
            stringBuffer.append(" [Namespace: ").append(string).append("]");
        }
        stringBuffer.append("/>]");
        return stringBuffer.toString();
    }

    public Object clone() {
        Cloneable cloneable;
        Object object;
        int n2;
        Element element = null;
        element = (Element)super.clone();
        element.b = new ContentList(element);
        element.a = new AttributeList(element);
        if (this.a != null) {
            n2 = 0;
            while (n2 < this.a.size()) {
                object = this.a.get(n2);
                cloneable = (Attribute)((Attribute)object).clone();
                element.a.add(cloneable);
                ++n2;
            }
        }
        if (this.additionalNamespaces != null) {
            n2 = this.additionalNamespaces.size();
            element.additionalNamespaces = new ArrayList(n2);
            int n3 = 0;
            while (n3 < n2) {
                cloneable = this.additionalNamespaces.get(n3);
                element.additionalNamespaces.add(cloneable);
                ++n3;
            }
        }
        if (this.b != null) {
            n2 = 0;
            while (n2 < this.b.size()) {
                object = this.b.get(n2);
                if (object instanceof Element) {
                    cloneable = (Element)((Element)object).clone();
                    element.b.add(cloneable);
                } else if (object instanceof CDATA) {
                    cloneable = (CDATA)((CDATA)object).clone();
                    element.b.add(cloneable);
                } else if (object instanceof Text) {
                    cloneable = (Text)((Text)object).clone();
                    element.b.add(cloneable);
                } else if (object instanceof Comment) {
                    cloneable = (Comment)((Comment)object).clone();
                    element.b.add(cloneable);
                } else if (object instanceof ProcessingInstruction) {
                    cloneable = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                    element.b.add(cloneable);
                } else if (object instanceof EntityRef) {
                    cloneable = (EntityRef)((EntityRef)object).clone();
                    element.b.add(cloneable);
                }
                ++n2;
            }
        }
        if (this.additionalNamespaces != null) {
            element.additionalNamespaces = new ArrayList();
            element.additionalNamespaces.addAll(this.additionalNamespaces);
        }
        return element;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.namespace.getPrefix());
        objectOutputStream.writeObject(this.namespace.getURI());
        if (this.additionalNamespaces == null) {
            objectOutputStream.write(0);
        } else {
            int n2 = this.additionalNamespaces.size();
            objectOutputStream.write(n2);
            int n3 = 0;
            while (n3 < n2) {
                Namespace namespace = (Namespace)this.additionalNamespaces.get(n3);
                objectOutputStream.writeObject(namespace.getPrefix());
                objectOutputStream.writeObject(namespace.getURI());
                ++n3;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
        int n2 = objectInputStream.read();
        if (n2 != 0) {
            this.additionalNamespaces = new ArrayList(n2);
            int n3 = 0;
            while (n3 < n2) {
                Namespace namespace = Namespace.getNamespace((String)objectInputStream.readObject(), (String)objectInputStream.readObject());
                this.additionalNamespaces.add(namespace);
                ++n3;
            }
        }
    }

    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public List getChildren() {
        return this.b.a(new ElementFilter());
    }

    public List getChildren(String string) {
        return this.getChildren(string, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String string, Namespace namespace) {
        return this.b.a(new ElementFilter(string, namespace));
    }

    public Element getChild(String string, Namespace namespace) {
        List list = this.b.a(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            return (Element)iterator.next();
        }
        return null;
    }

    public Element getChild(String string) {
        return this.getChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string) {
        return this.removeChild(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChild(String string, Namespace namespace) {
        List list = this.b.a(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        if (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            return true;
        }
        return false;
    }

    public boolean removeChildren(String string) {
        return this.removeChildren(string, Namespace.NO_NAMESPACE);
    }

    public boolean removeChildren(String string, Namespace namespace) {
        boolean bl2 = false;
        List list = this.b.a(new ElementFilter(string, namespace));
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
            bl2 = true;
        }
        return bl2;
    }

    public void canContain(Content content, int n2) throws IllegalAddException {
        if (content instanceof DocType) {
            throw new IllegalAddException("A DocType is not allowed except at the document level");
        }
    }
}

