/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.ContentList;
import org.jdom.DescendantIterator;
import org.jdom.DocType;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.FilterIterator;
import org.jdom.IllegalAddException;
import org.jdom.Parent;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.filter.Filter;

public class Document
implements Parent {
    private static final String CVS_ID = "@(#) $RCSfile: Document.java,v $ $Revision: 1.79 $ $Date: 2004/02/06 09:28:30 $ $Name: jdom_1_0_b10 $";
    public ContentList a = new ContentList(this);
    public String baseURI = null;
    private HashMap propertyMap = null;

    public Document() {
    }

    public Document(Element element, DocType docType, String string) {
        if (element != null) {
            this.setRootElement(element);
        }
        if (docType != null) {
            this.setDocType(docType);
        }
        if (string != null) {
            this.setBaseURI(string);
        }
    }

    public Document(Element element, DocType docType) {
        this(element, docType, null);
    }

    public Document(Element element) {
        this(element, null, null);
    }

    public Document(List list) {
        this(list, null);
    }

    public int getContentSize() {
        return this.a.size();
    }

    public int indexOf(Content content) {
        return this.a.indexOf(content);
    }

    public boolean hasRootElement() {
        return this.a.a() >= 0;
    }

    public Element getRootElement() {
        int n2 = this.a.a();
        if (n2 < 0) {
            throw new IllegalStateException("Root element not set");
        }
        return (Element)this.a.get(n2);
    }

    public Document setRootElement(Element element) {
        int n2 = this.a.a();
        if (n2 < 0) {
            this.a.add(element);
        } else {
            this.a.set(n2, element);
        }
        return this;
    }

    public Element detachRootElement() {
        int n2 = this.a.a();
        if (n2 < 0) {
            return null;
        }
        return (Element)this.removeContent(n2);
    }

    public DocType getDocType() {
        int n2 = this.a.b();
        if (n2 < 0) {
            return null;
        }
        return (DocType)this.a.get(n2);
    }

    public Document setDocType(DocType docType) {
        if (docType == null) {
            int n2 = this.a.b();
            if (n2 >= 0) {
                this.a.remove(n2);
            }
            return this;
        }
        if (docType.getParent() != null) {
            throw new IllegalAddException(docType, "The DocType already is attached to a document");
        }
        int n3 = this.a.b();
        if (n3 < 0) {
            this.a.a(0, docType);
        } else {
            this.a.set(n3, docType);
        }
        return this;
    }

    public Parent addContent(Content content) {
        this.a.add(content);
        return this;
    }

    public Parent addContent(Collection collection) {
        this.a.addAll(collection);
        return this;
    }

    public Parent addContent(int n2, Content content) {
        this.a.a(n2, content);
        return this;
    }

    public Parent addContent(int n2, Collection collection) {
        this.a.addAll(n2, collection);
        return this;
    }

    public List cloneContent() {
        int n2 = this.getContentSize();
        ArrayList<Object> arrayList = new ArrayList<Object>(n2);
        int n3 = 0;
        while (n3 < n2) {
            Content content = this.getContent(n3);
            arrayList.add(content.clone());
            ++n3;
        }
        return arrayList;
    }

    public Content getContent(int n2) {
        return (Content)this.a.get(n2);
    }

    public List getContent() {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.a;
    }

    public List getContent(Filter filter) {
        if (!this.hasRootElement()) {
            throw new IllegalStateException("Root element not set");
        }
        return this.a.a(filter);
    }

    public List removeContent() {
        ArrayList arrayList = new ArrayList(this.a);
        this.a.clear();
        return arrayList;
    }

    public List removeContent(Filter filter) {
        ArrayList<Content> arrayList = new ArrayList<Content>();
        Iterator iterator = this.a.a(filter).iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            arrayList.add(content);
            iterator.remove();
        }
        return arrayList;
    }

    public Parent setContent(Collection collection) {
        this.a.a(collection);
        return this;
    }

    public final void setBaseURI(String string) {
        this.baseURI = string;
    }

    public final String getBaseURI() {
        return this.baseURI;
    }

    public Parent setContent(int n2, Content content) {
        this.a.set(n2, content);
        return this;
    }

    public Parent setContent(int n2, Collection collection) {
        this.a.remove(n2);
        this.a.addAll(n2, collection);
        return this;
    }

    public boolean removeContent(Content content) {
        return this.a.remove(content);
    }

    public Content removeContent(int n2) {
        return (Content)this.a.remove(n2);
    }

    public Parent setContent(Content content) {
        this.a.clear();
        this.a.add(content);
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer().append("[Document: ");
        DocType docType = this.getDocType();
        if (docType != null) {
            stringBuffer.append(docType.toString()).append(", ");
        } else {
            stringBuffer.append(" No DOCTYPE declaration, ");
        }
        Element element = this.getRootElement();
        if (element != null) {
            stringBuffer.append("Root is ").append(element.toString());
        } else {
            stringBuffer.append(" No root element");
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        return object == this;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        Document document = null;
        try {
            document = (Document)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        document.a = new ContentList(document);
        int n2 = 0;
        while (n2 < this.a.size()) {
            Content content;
            Object object = this.a.get(n2);
            if (object instanceof Element) {
                content = (Element)((Element)object).clone();
                document.a.add(content);
            } else if (object instanceof Comment) {
                content = (Comment)((Comment)object).clone();
                document.a.add(content);
            } else if (object instanceof ProcessingInstruction) {
                content = (ProcessingInstruction)((ProcessingInstruction)object).clone();
                document.a.add(content);
            } else if (object instanceof DocType) {
                content = (DocType)((DocType)object).clone();
                document.a.add(content);
            }
            ++n2;
        }
        return document;
    }

    public Iterator getDescendants() {
        return new DescendantIterator(this);
    }

    public Iterator getDescendants(Filter filter) {
        return new FilterIterator(new DescendantIterator(this), filter);
    }

    public Parent getParent() {
        return null;
    }

    public Document(List list, DocType docType) {
        this.setContent(list);
        this.setDocType(docType);
    }

    public Document getDocument() {
        return this;
    }

    public void canContain(Content content, int n2) throws IllegalAddException {
        if (content instanceof Element) {
            if (content instanceof Element && this.a.a() >= 0) {
                throw new IllegalAddException("Cannot add a second root element, only one is allowed");
            }
            if (content instanceof Element && this.a.b() > n2) {
                throw new IllegalAddException("A root element cannot be added before the DocType");
            }
        }
        if (content instanceof DocType) {
            if (this.a.b() >= 0) {
                throw new IllegalAddException("Cannot add a second doctype, only one is allowed");
            }
            int n3 = this.a.a();
            if (n3 != -1 && n3 < n2) {
                throw new IllegalAddException("A DocType cannot be added after the root element");
            }
        }
        if (content instanceof CDATA) {
            throw new IllegalAddException("A CDATA is not allowed at the document root");
        }
        if (content instanceof Text) {
            throw new IllegalAddException("A Text is not allowed at the document root");
        }
        if (content instanceof EntityRef) {
            throw new IllegalAddException("An EntityRef is not allowed at the document root");
        }
    }

    public void setProperty(String string, Object object) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
        }
        this.propertyMap.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.propertyMap == null) {
            return null;
        }
        return this.propertyMap.get(string);
    }
}

