/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.hsqldb.util.CommonSwing;
import org.hsqldb.util.ConnectionDialogSwing;
import org.hsqldb.util.DatabaseManagerCommon;
import org.hsqldb.util.GridSwing;
import org.hsqldb.util.Transfer;
import org.hsqldb.util.jdbcSystem;

public class DatabaseManagerSwing
extends JApplet
implements ActionListener,
WindowListener,
KeyListener {
    public static final String j = System.getProperty("line.separator");
    public static int x = 24;
    public Connection p;
    public DatabaseMetaData v;
    public Statement l;
    public JMenu s;
    public String[] F;
    public int e;
    public JTextArea o;
    public JScrollPane r;
    public JTree C;
    public JScrollPane c;
    public DefaultTreeModel z;
    public DefaultMutableTreeNode k;
    public JPanel q;
    public long d;
    public int f;
    public GridSwing w;
    public JTable y;
    public JScrollPane u;
    public JTextArea h;
    public JScrollPane B;
    public JSplitPane E;
    public JSplitPane a;
    public boolean D;
    public JFrame t;
    public String b = "";
    public static String g = "org.hsqldb.jdbcDriver";
    public static String G = "jdbc:hsqldb:.";
    public static String m = "sa";
    public static String n = "";
    public static String i;
    public static String A;

    public void init() {
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.a();
        try {
            databaseManagerSwing.connect(ConnectionDialogSwing.createConnection(g, G, m, n));
            databaseManagerSwing.insertTestData();
            databaseManagerSwing.refreshTree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ((Hashtable)System.getProperties()).put("sun.java2d.noddraw", "true");
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2].toLowerCase();
            if (++n2 == stringArray.length) {
                DatabaseManagerSwing.showUsage();
                return;
            }
            if (string.equals("-driver")) {
                g = stringArray[n2];
                bl2 = true;
            } else if (string.equals("-url")) {
                G = stringArray[n2];
                bl2 = true;
            } else if (string.equals("-user")) {
                m = stringArray[n2];
                bl2 = true;
            } else if (string.equals("-password")) {
                n = stringArray[n2];
                bl2 = true;
            } else if (string.equals("-dir")) {
                A = stringArray[n2];
            } else if (string.equals("-script")) {
                i = stringArray[n2];
            } else {
                DatabaseManagerSwing.showUsage();
                return;
            }
            ++n2;
        }
        DatabaseManagerSwing databaseManagerSwing = new DatabaseManagerSwing();
        databaseManagerSwing.a();
        Connection connection = null;
        try {
            connection = bl2 ? ConnectionDialogSwing.createConnection(g, G, m, n) : ConnectionDialogSwing.createConnection(databaseManagerSwing.t, "Connect");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (connection == null) {
            return;
        }
        databaseManagerSwing.connect(connection);
    }

    private void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.p != null) {
            try {
                this.p.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.p = connection;
        try {
            this.v = this.p.getMetaData();
            this.l = this.p.createStatement();
            this.refreshTree();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    private static void showUsage() {
        System.out.println("Usage: java DatabaseManagerSwing [-options]\nwhere options include:\n    -driver <classname>  jdbc driver class\n    -url <name>          jdbc url\n    -user <name>         username used for connection\n    -password <password> password for this user\n    -dir <path>          default directory\n    -script <file>       reads from script file\n");
    }

    private void insertTestData() {
        try {
            DatabaseManagerCommon.b(this.l);
            this.refreshTree();
            this.o.setText(DatabaseManagerCommon.a(this.l));
            this.refreshTree();
            int n2 = 0;
            while (n2 < DatabaseManagerCommon.a.length) {
                this.addToRecent(DatabaseManagerCommon.a[n2]);
                ++n2;
            }
            this.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public void a() {
        CommonSwing.b();
        this.t = new JFrame("HSQL Database Manager");
        this.t.getContentPane().add((Component)this.createToolBar(), "North");
        ((Frame)this.t).setIconImage(CommonSwing.a());
        this.t.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(jMenuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text"};
        this.addMenu(jMenuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "---", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-CHECKPOINT", "-SCRIPT", "-SET", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(jMenuBar, "Command", stringArray3);
        this.s = new JMenu("Recent");
        jMenuBar.add(this.s);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data"};
        this.addMenu(jMenuBar, "Options", stringArray4);
        String[] stringArray5 = new String[]{"-Dump", "-Restore", "-Transfer"};
        this.addMenu(jMenuBar, "Tools", stringArray5);
        this.t.setJMenuBar(jMenuBar);
        this.initGUI();
        this.F = new String[x];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.t.getSize();
        if (dimension.width >= 640) {
            ((Component)this.t).setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        } else {
            ((Component)this.t).setLocation(0, 0);
            ((Component)this.t).setSize(dimension);
        }
        this.t.show();
        if (i != null) {
            if (A != null) {
                i = A + File.separator + i;
            }
            StringBuffer stringBuffer = new StringBuffer();
            this.b = DatabaseManagerCommon.a(i);
            if (4096 <= this.b.length()) {
                stringBuffer.append("This huge file cannot be edited. Please execute\n");
                this.o.setText(stringBuffer.toString());
            } else {
                this.o.setText(this.b);
            }
        }
        this.o.requestFocus();
    }

    private void addMenu(JMenuBar jMenuBar, String string, String[] stringArray) {
        JMenu jMenu = new JMenu(string);
        this.addMenuItems(jMenu, stringArray);
        jMenuBar.add(jMenu);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addMenuItems(JMenu jMenu, String[] stringArray) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("--")) {
                jMenu.addSeparator();
            } else if (stringArray[n2].equals("---")) {
                if (dimension.width < 640) return;
                jMenu.addSeparator();
            } else {
                JMenuItem jMenuItem = new JMenuItem(stringArray[n2].substring(1));
                char c2 = stringArray[n2].charAt(0);
                if (c2 != '-') {
                    jMenuItem.setMnemonic(c2);
                }
                jMenuItem.addActionListener(this);
                jMenu.add(jMenuItem);
            }
            ++n2;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof JMenuItem) {
            string = ((JMenuItem)actionEvent.getSource()).getText();
        }
        if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("Transfer")) {
            Transfer.work(null);
        } else if (string.equals("Dump")) {
            Transfer.work(new String[]{"-d"});
        } else if (string.equals("Restore")) {
            Transfer.work(new String[]{"-r"});
        } else if (string.equals("Logging on")) {
            jdbcSystem.a(true);
        } else if (string.equals("Logging off")) {
            jdbcSystem.a(false);
        } else if (string.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (string.startsWith("#")) {
            int n2 = Integer.parseInt(string.substring(1));
            this.o.setText(this.F[n2]);
        } else if (string.equals("Connect...")) {
            this.connect(ConnectionDialogSwing.createConnection(this.t, "Connect"));
            this.refreshTree();
        } else if (string.equals("Results in Grid")) {
            this.f = 0;
            this.q.removeAll();
            this.q.add((Component)this.u, "Center");
            this.q.doLayout();
            this.w.fireTableChanged(null);
            this.q.repaint();
        } else if (string.equals("Open Script...")) {
            File file;
            int n3;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Open Script...");
            if (A != null) {
                jFileChooser.setCurrentDirectory(new File(A));
            }
            if ((n3 = jFileChooser.showOpenDialog(this.t)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                StringBuffer stringBuffer = new StringBuffer();
                this.b = DatabaseManagerCommon.a(file.getAbsolutePath());
                if (4096 <= this.b.length()) {
                    stringBuffer.append("This huge file cannot be edited. Please execute\n");
                    this.o.setText(stringBuffer.toString());
                } else {
                    this.o.setText(this.b);
                }
            }
        } else if (string.equals("Save Script...")) {
            File file;
            int n4;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save Script");
            if (A != null) {
                jFileChooser.setCurrentDirectory(new File(A));
            }
            if ((n4 = jFileChooser.showSaveDialog(this.t)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                DatabaseManagerCommon.a(file.getAbsolutePath(), this.o.getText());
            }
        } else if (string.equals("Save Result...")) {
            File file;
            int n5;
            JFileChooser jFileChooser = new JFileChooser(".");
            jFileChooser.setDialogTitle("Save Result...");
            if (A != null) {
                jFileChooser.setCurrentDirectory(new File(A));
            }
            if ((n5 = jFileChooser.showSaveDialog(this.t)) == 0 && (file = jFileChooser.getSelectedFile()) != null) {
                this.showResultInText();
                DatabaseManagerCommon.a(file.getAbsolutePath(), this.h.getText());
            }
        } else if (string.equals("Results in Text")) {
            this.f = 1;
            this.q.removeAll();
            this.q.add((Component)this.B, "Center");
            this.q.doLayout();
            this.showResultInText();
            this.q.repaint();
        } else if (string.equals("AutoCommit on")) {
            try {
                this.p.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("AutoCommit off")) {
            try {
                this.p.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Commit")) {
            try {
                this.p.commit();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Insert test data")) {
            this.insertTestData();
        } else if (string.equals("Rollback")) {
            try {
                this.p.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Disable MaxRows")) {
            try {
                this.l.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Set MaxRows to 100")) {
            try {
                this.l.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("SELECT")) {
            this.showHelp(DatabaseManagerCommon.k);
        } else if (string.equals("INSERT")) {
            this.showHelp(DatabaseManagerCommon.b);
        } else if (string.equals("UPDATE")) {
            this.showHelp(DatabaseManagerCommon.d);
        } else if (string.equals("DELETE")) {
            this.showHelp(DatabaseManagerCommon.e);
        } else if (string.equals("CREATE TABLE")) {
            this.showHelp(DatabaseManagerCommon.h);
        } else if (string.equals("DROP TABLE")) {
            this.showHelp(DatabaseManagerCommon.i);
        } else if (string.equals("CREATE INDEX")) {
            this.showHelp(DatabaseManagerCommon.m);
        } else if (string.equals("DROP INDEX")) {
            this.showHelp(DatabaseManagerCommon.g);
        } else if (string.equals("CHECKPOINT")) {
            this.showHelp(DatabaseManagerCommon.c);
        } else if (string.equals("SCRIPT")) {
            this.showHelp(DatabaseManagerCommon.f);
        } else if (string.equals("SHUTDOWN")) {
            this.showHelp(DatabaseManagerCommon.l);
        } else if (string.equals("SET")) {
            this.showHelp(DatabaseManagerCommon.n);
        } else if (string.equals("Test Script")) {
            this.showHelp(DatabaseManagerCommon.j);
        }
    }

    private void showHelp(String[] stringArray) {
        this.o.setText(stringArray[0]);
        this.D = true;
        this.q.removeAll();
        this.q.add((Component)this.B, "Center");
        this.q.doLayout();
        this.h.setText(stringArray[1]);
        this.q.repaint();
        this.o.requestFocus();
        this.o.setCaretPosition(stringArray[0].length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.t.dispose();
    }

    private void clear() {
        this.b = "";
        this.o.setText(this.b);
    }

    private void execute() {
        this.w.clear();
        String string = null;
        string = 4096 <= this.b.length() ? this.b : this.o.getText();
        if (string.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] stringArray = new String[1];
        try {
            this.d = System.currentTimeMillis();
            this.l.execute(string);
            int n2 = this.l.getUpdateCount();
            if (n2 == -1) {
                this.formatResultSet(this.l.getResultSet());
            } else {
                stringArray[0] = "update count";
                this.w.setHead(stringArray);
                stringArray[0] = "" + n2;
                this.w.addRow(stringArray);
            }
            this.d = System.currentTimeMillis() - this.d;
            this.addToRecent(this.o.getText());
            this.w.fireTableChanged(null);
        }
        catch (SQLException sQLException) {
            this.d = System.currentTimeMillis() - this.d;
            stringArray[0] = "SQL Error";
            this.w.setHead(stringArray);
            String string2 = sQLException.getMessage();
            string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
            stringArray[0] = string2 = string2 + " / State: " + sQLException.getSQLState();
            this.w.addRow(stringArray);
            this.w.fireTableChanged(null);
        }
        this.updateResult();
        System.gc();
    }

    private void updateResult() {
        if (this.f == 0) {
            if (this.D) {
                this.q.removeAll();
                this.q.add((Component)this.u, "Center");
                this.q.doLayout();
                this.w.fireTableChanged(null);
                this.q.repaint();
                this.D = false;
            }
        } else {
            this.showResultInText();
        }
        this.o.selectAll();
        this.o.requestFocus();
    }

    private void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            String[] stringArray = new String[]{"Result"};
            this.w.setHead(stringArray);
            stringArray[0] = "(empty)";
            this.w.addRow(stringArray);
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n2];
            int n3 = 1;
            while (n3 <= n2) {
                stringArray[n3 - 1] = resultSetMetaData.getColumnLabel(n3);
                ++n3;
            }
            this.w.setHead(stringArray);
            while (resultSet.next()) {
                int n4 = 1;
                while (n4 <= n2) {
                    stringArray[n4 - 1] = resultSet.getString(n4);
                    if (resultSet.wasNull()) {
                        stringArray[n4 - 1] = "(null)";
                    }
                    ++n4;
                }
                this.w.addRow(stringArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void testPerformance() {
        String string = this.o.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l2 = 0L;
        int n2 = 0;
        while (n2 < string.length()) {
            char c2 = string.charAt(n2);
            if (c2 != '\n') {
                stringBuffer.append(c2);
            }
            ++n2;
        }
        string = stringBuffer.toString();
        String[] stringArray = new String[]{"ms", "count", "sql", "error"};
        this.w.setHead(stringArray);
        int n3 = 1;
        this.d = System.currentTimeMillis() - this.d;
        while (!string.equals("")) {
            String string2;
            int n4 = string.indexOf(59);
            if (n4 != -1) {
                string2 = string.substring(0, n4);
                string = string.substring(n4 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n3 = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            stringArray[2] = string2;
            long l3 = 0L;
            try {
                l3 = DatabaseManagerCommon.a(this.l, string2, n3);
                l2 += l3;
                stringArray[0] = "" + l3;
                stringArray[1] = "" + n3;
                stringArray[3] = "";
            }
            catch (SQLException sQLException) {
                stringArray[1] = "n/a";
                stringArray[0] = "n/a";
                stringArray[3] = sQLException.toString();
            }
            this.w.addRow(stringArray);
            System.out.println(l3 + " ms : " + string2);
        }
        stringArray[0] = "" + l2;
        stringArray[1] = "total";
        stringArray[2] = "";
        this.w.addRow(stringArray);
        this.d = System.currentTimeMillis() - this.d;
        this.updateResult();
    }

    private void showResultInText() {
        int n2;
        int n3;
        int n4;
        String[] stringArray;
        String[] stringArray2 = this.w.getHead();
        int n5 = stringArray2.length;
        int[] nArray = new int[n5];
        Vector vector = this.w.getData();
        int n6 = vector.size();
        int n7 = 0;
        while (n7 < n5) {
            nArray[n7] = stringArray2[n7].length();
            ++n7;
        }
        int n8 = 0;
        while (n8 < n6) {
            stringArray = (String[])vector.elementAt(n8);
            int n9 = 0;
            while (n9 < n5) {
                n4 = stringArray[n9].length();
                if (n4 > nArray[n9]) {
                    nArray[n9] = n4;
                }
                ++n9;
            }
            ++n8;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n4 = 0;
        while (n4 < n5) {
            stringBuffer.append(stringArray2[n4]);
            n3 = stringArray2[n4].length();
            while (n3 <= nArray[n4]) {
                stringBuffer.append(' ');
                ++n3;
            }
            ++n4;
        }
        stringBuffer.append(j);
        n3 = 0;
        while (n3 < n5) {
            n2 = 0;
            while (n2 < nArray[n3]) {
                stringBuffer.append('-');
                ++n2;
            }
            stringBuffer.append(' ');
            ++n3;
        }
        stringBuffer.append(j);
        n2 = 0;
        while (n2 < n6) {
            stringArray = (String[])vector.elementAt(n2);
            int n10 = 0;
            while (n10 < n5) {
                stringBuffer.append(stringArray[n10]);
                int n11 = stringArray[n10].length();
                while (n11 <= nArray[n10]) {
                    stringBuffer.append(' ');
                    ++n11;
                }
                ++n10;
            }
            stringBuffer.append(j);
            ++n2;
        }
        stringBuffer.append(j + n6 + " row(s) in " + this.d + " ms");
        this.h.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        int n2 = 0;
        while (n2 < x) {
            if (string.equals(this.F[n2])) {
                return;
            }
            ++n2;
        }
        if (this.F[this.e] != null) {
            this.s.remove(this.e);
        }
        this.F[this.e] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.setActionCommand("#" + this.e);
        jMenuItem.addActionListener(this);
        this.s.insert(jMenuItem, this.e);
        this.e = (this.e + 1) % x;
    }

    private void initGUI() {
        JPanel jPanel = new JPanel();
        this.q = new JPanel();
        this.E = new JSplitPane(0, jPanel, this.q);
        jPanel.setLayout(new BorderLayout());
        this.q.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.o = new JTextArea(5, 40);
        this.o.setMargin(new Insets(5, 5, 5, 5));
        this.o.addKeyListener(this);
        this.r = new JScrollPane(this.o);
        this.h = new JTextArea(20, 40);
        this.h.setMargin(new Insets(5, 5, 5, 5));
        this.B = new JScrollPane(this.h);
        this.o.setFont(font);
        this.h.setFont(new Font("Courier", 0, 12));
        jPanel.add((Component)this.r, "Center");
        this.w = new GridSwing();
        this.y = new JTable(this.w);
        this.u = new JScrollPane(this.y);
        this.q.add((Component)this.u, "Center");
        this.k = new DefaultMutableTreeNode("Connection");
        this.z = new DefaultTreeModel(this.k);
        this.C = new JTree(this.z);
        this.c = new JScrollPane(this.C);
        this.c.setPreferredSize(new Dimension(120, 400));
        this.c.setMinimumSize(new Dimension(70, 100));
        this.r.setPreferredSize(new Dimension(360, 100));
        this.r.setMinimumSize(new Dimension(180, 100));
        this.u.setPreferredSize(new Dimension(460, 300));
        this.a = new JSplitPane(1, this.c, this.E);
        this.t.getContentPane().add((Component)this.a, "Center");
        this.doLayout();
        this.t.pack();
    }

    private DefaultMutableTreeNode makeNode(Object object, MutableTreeNode mutableTreeNode) {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(object);
        if (mutableTreeNode != null) {
            this.z.insertNodeInto(defaultMutableTreeNode, mutableTreeNode, mutableTreeNode.getChildCount());
        }
        return defaultMutableTreeNode;
    }

    public void refreshTree() {
        String[] stringArray;
        while (this.z.getChildCount(this.k) > 0) {
            stringArray = (String[])this.z.getChild(this.k, 0);
            this.z.removeNodeFromParent((MutableTreeNode)stringArray);
            stringArray.removeAllChildren();
            stringArray.removeFromParent();
        }
        this.z.nodeStructureChanged(this.k);
        this.z.reload();
        this.c.repaint();
        try {
            this.k.setUserObject(this.v.getURL());
            stringArray = new String[]{"TABLE", "GLOBAL TEMPORARY", "VIEW"};
            ResultSet resultSet = this.v.getTables(null, null, null, stringArray);
            Vector<String> vector = new Vector<String>();
            Vector<String> vector2 = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(3));
                vector2.addElement(resultSet.getString(5));
            }
            resultSet.close();
            int n2 = 0;
            while (n2 < vector.size()) {
                String string;
                Object object;
                Object object2;
                String string2 = (String)vector.elementAt(n2);
                DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode(string2, this.k);
                ResultSet resultSet2 = this.v.getColumns(null, null, string2, null);
                String string3 = (String)vector2.elementAt(n2);
                if (string3 != null && !string3.trim().equals("")) {
                    this.makeNode(string3, defaultMutableTreeNode);
                }
                while (resultSet2.next()) {
                    object2 = resultSet2.getString(4);
                    object = this.makeNode(object2, defaultMutableTreeNode);
                    string = resultSet2.getString(6);
                    this.makeNode("Type: " + string, (MutableTreeNode)object);
                    boolean bl2 = resultSet2.getInt(11) != 0;
                    this.makeNode("Nullable: " + bl2, (MutableTreeNode)object);
                }
                resultSet2.close();
                object2 = this.makeNode("Indices", defaultMutableTreeNode);
                object = this.v.getIndexInfo(null, null, string2, false, false);
                string = null;
                while (object.next()) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = null;
                    boolean bl3 = object.getBoolean(4);
                    String string4 = object.getString(6);
                    if (string == null || !string.equals(string4)) {
                        defaultMutableTreeNode2 = this.makeNode(string4, (MutableTreeNode)object2);
                        this.makeNode("Unique: " + !bl3, defaultMutableTreeNode2);
                        string = string4;
                    }
                    this.makeNode(object.getString(9), defaultMutableTreeNode2);
                }
                object.close();
                ++n2;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Properties", this.k);
            this.makeNode("User: " + this.v.getUserName(), defaultMutableTreeNode);
            this.makeNode("ReadOnly: " + this.p.isReadOnly(), defaultMutableTreeNode);
            this.makeNode("AutoCommit: " + this.p.getAutoCommit(), defaultMutableTreeNode);
            this.makeNode("Driver: " + this.v.getDriverName(), defaultMutableTreeNode);
            this.makeNode("Product: " + this.v.getDatabaseProductName(), defaultMutableTreeNode);
            this.makeNode("Version: " + this.v.getDatabaseProductVersion(), defaultMutableTreeNode);
        }
        catch (SQLException sQLException) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.makeNode("Error getting metadata:", this.k);
            this.makeNode(sQLException.getMessage(), defaultMutableTreeNode);
            this.makeNode(sQLException.getSQLState(), defaultMutableTreeNode);
        }
        this.z.nodeStructureChanged(this.k);
        this.z.reload();
        this.c.repaint();
    }

    public JToolBar createToolBar() {
        JToolBar jToolBar = new JToolBar();
        jToolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        JButton jButton = new JButton("Clear SQL Statement");
        jButton.setToolTipText("Clear SQL Statement");
        jButton.addActionListener(new ActionListener(this){
            private final DatabaseManagerSwing this$0;
            {
                this.this$0 = databaseManagerSwing;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.a(this.this$0);
            }
        });
        JButton jButton2 = new JButton("Execute SQL Statement");
        jButton2.setToolTipText("Execute SQL Statement");
        jButton2.addActionListener(new ActionListener(this){
            private final DatabaseManagerSwing this$0;
            {
                this.this$0 = databaseManagerSwing;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                DatabaseManagerSwing.b(this.this$0);
            }
        });
        jToolBar.addSeparator();
        jToolBar.add(jButton);
        jToolBar.addSeparator();
        jToolBar.add(jButton2);
        jToolBar.addSeparator();
        jButton.setAlignmentY(0.5f);
        jButton.setAlignmentX(0.5f);
        jButton2.setAlignmentY(0.5f);
        jButton2.setAlignmentX(0.5f);
        return jToolBar;
    }

    public static void a(DatabaseManagerSwing databaseManagerSwing) {
        databaseManagerSwing.clear();
    }

    public static void b(DatabaseManagerSwing databaseManagerSwing) {
        databaseManagerSwing.execute();
    }
}

