/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class HsqlDeque {
    private Object[] list = new Object[10];
    private int firstindex = 0;
    private int endindex = 0;
    private int usedsize = 0;
    private final int DEFAULT_INITIAL_CAPACITY = 10;

    public int size() {
        return this.usedsize;
    }

    public Object getFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.firstindex];
    }

    public Object getLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        return this.list[this.endindex - 1];
    }

    public Object get(int n2) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        return this.list[n3];
    }

    public Object set(int n2, Object object) throws IndexOutOfBoundsException {
        int n3 = this.getInternalIndex(n2);
        Object object2 = this.list[n3];
        this.list[n3] = object;
        return object2;
    }

    public Object removeFirst() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        Object object = this.list[this.firstindex];
        this.list[this.firstindex] = null;
        ++this.firstindex;
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.firstindex == this.list.length) {
            this.firstindex = 0;
        }
        return object;
    }

    public Object removeLast() throws NoSuchElementException {
        if (this.usedsize == 0) {
            throw new NoSuchElementException();
        }
        --this.endindex;
        Object object = this.list[this.endindex];
        this.list[this.endindex] = null;
        --this.usedsize;
        if (this.usedsize == 0) {
            this.endindex = 0;
            this.firstindex = 0;
        } else if (this.endindex == 0) {
            this.endindex = this.list.length;
        }
        return object;
    }

    public boolean add(Object object) {
        this.resetCapacity();
        if (this.endindex == this.list.length) {
            this.endindex = 0;
        }
        this.list[this.endindex] = object;
        ++this.usedsize;
        ++this.endindex;
        return true;
    }

    public boolean addLast(Object object) {
        return this.add(object);
    }

    public boolean addFirst(Object object) {
        this.resetCapacity();
        --this.firstindex;
        if (this.firstindex < 0) {
            this.firstindex = this.list.length - 1;
            if (this.endindex == 0) {
                this.endindex = this.list.length;
            }
        }
        this.list[this.firstindex] = object;
        ++this.usedsize;
        return true;
    }

    public void clear() {
        this.usedsize = 0;
        this.endindex = 0;
        this.firstindex = 0;
        int n2 = 0;
        while (n2 < this.list.length) {
            this.list[n2] = null;
            ++n2;
        }
    }

    public boolean isEmpty() {
        return this.usedsize == 0;
    }

    private int getInternalIndex(int n2) throws IndexOutOfBoundsException {
        if (n2 < 0 || n2 >= this.usedsize) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.firstindex + n2;
        if (n3 >= this.list.length) {
            n3 -= this.list.length;
        }
        return n3;
    }

    public Enumeration elements() {
        Enumeration enumeration = new Enumeration(this){
            private int currentIndex;
            private final HsqlDeque this$0;
            {
                this.this$0 = hsqlDeque;
                this.currentIndex = 0;
            }

            public Object nextElement() {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException("Enumeration complete");
                }
                return this.this$0.get(this.currentIndex++);
            }

            public boolean hasMoreElements() {
                return HsqlDeque.a(this.this$0) > this.currentIndex;
            }
        };
        return enumeration;
    }

    private void resetCapacity() {
        if (this.usedsize < this.list.length) {
            return;
        }
        Object[] objectArray = new Object[this.list.length * 2];
        int n2 = 0;
        while (n2 < this.list.length) {
            objectArray[n2] = this.list[n2];
            ++n2;
        }
        this.list = objectArray;
        objectArray = null;
        if (this.endindex <= this.firstindex) {
            int n3 = this.firstindex + this.usedsize - this.endindex;
            int n4 = 0;
            while (n4 < this.endindex) {
                this.list[n3 + n4] = this.list[n4];
                this.list[n4] = null;
                ++n4;
            }
            this.endindex = this.firstindex + this.usedsize;
        }
    }

    public static int a(HsqlDeque hsqlDeque) {
        return hsqlDeque.usedsize;
    }
}

