/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.sql.SQLException;
import java.util.StringTokenizer;
import org.hsqldb.StringConverter;
import org.hsqldb.WebServer;

public class WebServerConnection
implements Runnable {
    private Socket mSocket;
    private WebServer mServer;
    private static final int GET = 1;
    private static final int HEAD = 2;
    private static final int POST = 3;
    private static final int BAD_REQUEST = 400;
    private static final int FORBIDDEN = 403;
    private static final int NOT_FOUND = 404;

    public WebServerConnection(Socket socket, WebServer webServer) {
        this.mServer = webServer;
        this.mSocket = socket;
    }

    public void run() {
        try {
            try {
                StringTokenizer stringTokenizer;
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.mSocket.getInputStream(), "8859_1"));
                String string2 = null;
                int n2 = 400;
                int n3 = -1;
                while ((string = bufferedReader.readLine()) != null && (stringTokenizer = new StringTokenizer(string, " ")).hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3.equals("GET")) {
                        n2 = 1;
                        string2 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string3.equals("HEAD")) {
                        n2 = 2;
                        string2 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (string3.equals("POST")) {
                        n2 = 3;
                        string2 = stringTokenizer.nextToken();
                        continue;
                    }
                    if (!string.toUpperCase().startsWith("CONTENT-LENGTH:")) continue;
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                }
                switch (n2) {
                    case 400: {
                        this.processError(400);
                        break;
                    }
                    case 1: {
                        this.processGet(string2, true);
                        break;
                    }
                    case 2: {
                        this.processGet(string2, false);
                        break;
                    }
                    case 3: {
                        this.processPost(bufferedReader, string2, n3);
                    }
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var9_10 = null;
                this.mServer.a(0);
            }
            Object var9_9 = null;
            this.mServer.a(0);
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            this.mServer.a(0);
            throw throwable;
        }
    }

    private void processGet(String string, boolean bl2) {
        try {
            String string2;
            Object object;
            if (string.endsWith("/")) {
                string = string + this.mServer.a;
            }
            if (string.indexOf("..") != -1) {
                this.processError(403);
                return;
            }
            string = this.mServer.f + string;
            if (this.mServer.e != '/') {
                string = string.replace('/', this.mServer.e);
            }
            String string3 = null;
            int n2 = string.lastIndexOf(".");
            if (n2 != -1) {
                object = string.substring(n2).toLowerCase();
                string3 = this.mServer.b.getProperty((String)object);
            }
            if (string3 == null) {
                string3 = "text/html";
            }
            object = null;
            try {
                object = new BufferedInputStream(new FileInputStream(new File(string)));
                int n3 = ((BufferedInputStream)object).available();
                string2 = this.getHead("HTTP/1.0 200 OK", "Content-Type: " + string3 + "\n" + "Content-Length: " + n3);
            }
            catch (IOException iOException) {
                this.processError(404);
                return;
            }
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string2.getBytes("8859_1"));
            if (bl2) {
                int n4;
                while ((n4 = ((BufferedInputStream)object).read()) != -1) {
                    dataOutputStream.writeByte(n4);
                }
            }
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.a("processGet: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private String getHead(String string, String string2) {
        return string + "\nAllow: GET, HEAD, POST\nMIME-Version: 1.0\n" + "Server: " + "HSQLDB/1.7.1" + "\n" + string2 + "\n\n";
    }

    private void processPost(BufferedReader bufferedReader, String string, int n2) throws SQLException {
        if (n2 < 0) {
            this.processError(400);
            return;
        }
        char[] cArray = new char[n2];
        try {
            bufferedReader.read(cArray, 0, n2);
        }
        catch (IOException iOException) {
            this.processError(400);
            return;
        }
        String string2 = new String(cArray);
        int n3 = string2.indexOf(43);
        int n4 = string2.indexOf(43, n3 + 1);
        if (n3 == -1 || n4 == -1) {
            this.processError(400);
            return;
        }
        String string3 = string2.substring(0, n3);
        string3 = StringConverter.hexStringToUnicode(string3);
        String string4 = string2.substring(n3 + 1, n4);
        string4 = StringConverter.hexStringToUnicode(string4);
        string2 = string2.substring(n4 + 1);
        string2 = StringConverter.hexStringToUnicode(string2);
        this.processQuery(string3, string4, string2);
    }

    private void processError(int n2) {
        this.mServer.b("processError " + n2);
        String string = null;
        switch (n2) {
            case 400: {
                string = this.getHead("HTTP/1.0 400 Bad Request", "") + "<HTML><BODY><H1>Bad Request</H1>" + "The server could not understand this request." + "<P></BODY></HTML>";
                break;
            }
            case 404: {
                string = this.getHead("HTTP/1.0 404 Not Found", "") + "<HTML><BODY><H1>Not Found</H1>" + "The server could not find this file.<P></BODY></HTML>";
                break;
            }
            case 403: {
                string = this.getHead("HTTP/1.0 403 Forbidden", "") + "<HTML><BODY><H1>Forbidden</H1>" + "Access is not allowed.<P></BODY></HTML>";
            }
        }
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string.getBytes("8859_1"));
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.a("processError: " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void processQuery(String string, String string2, String string3) {
        try {
            this.mServer.b(string3);
            byte[] byArray = this.mServer.c.a(string, string2, string3);
            int n2 = byArray.length;
            String string4 = this.getHead("HTTP/1.0 200 OK", "Content-Type: application/octet-stream\nContent-Length: " + n2);
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.mSocket.getOutputStream()));
            dataOutputStream.write(string4.getBytes("8859_1"));
            dataOutputStream.write(byArray);
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (Exception exception) {
            this.mServer.a("processQuery: " + exception.getMessage());
            exception.printStackTrace();
        }
    }
}

