/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.hsqldb.Database;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Server;
import org.hsqldb.Trace;
import org.hsqldb.WebServerConnection;
import org.hsqldb.jdbcSystem;

public class WebServer
extends Server {
    public String f;
    public String a;
    public char e;

    public static void main(String[] stringArray) {
        Object object;
        if (stringArray.length > 0 && (object = stringArray[0]) != null && ((String)object).startsWith("-?")) {
            WebServer.b();
            return;
        }
        object = new WebServer();
        HsqlProperties hsqlProperties = HsqlProperties.argArrayToProps(stringArray, "server");
        ((WebServer)object).a(hsqlProperties);
        super.run();
    }

    public void a(HsqlProperties hsqlProperties) {
        this.b = new HsqlProperties("webserver");
        try {
            this.b.load();
        }
        catch (Exception exception) {
            Trace.c("webserver.properties not found, using command line or default properties");
        }
        this.b.addProperties(hsqlProperties);
        this.b.setPropertyIfNotExists("server.database", "test");
        this.b.setPropertyIfNotExists("server.port", "80");
        this.f = this.b.setPropertyIfNotExists("server.root", "./");
        this.a = this.b.setPropertyIfNotExists("server.default_page", "index.html");
        if (this.b.isPropertyTrue("server.trace")) {
            jdbcSystem.a(true);
        }
        this.traceMessages = !this.b.isPropertyTrue("server.silent", true);
    }

    private void run() {
        Object object;
        this.socket = null;
        try {
            int n2 = this.b.getIntegerProperty("server.port", 80);
            object = this.b.getProperty("server.database");
            Trace.c("Opening database: " + (String)object);
            this.c();
            this.e = File.separatorChar;
            this.c = new Database((String)object);
            this.socket = new ServerSocket(n2);
        }
        catch (Exception exception) {
            this.a("WebServer.run/init: " + exception);
            return;
        }
        try {
            while (true) {
                Socket socket = this.socket.accept();
                object = new WebServerConnection(socket, this);
                this.thread = new Thread((Runnable)object);
                this.thread.start();
            }
        }
        catch (IOException iOException) {
            this.a("WebServer.run/loop: " + iOException.getMessage());
            return;
        }
    }

    public static void b() {
        Trace.c("Usage: java WebServer [-options]\nwhere options include:\n    -port <nr>            port where the server is listening\n    -database <name>      name of the database\n    -root <path>          root path for sending files\n    -default_page <file>  default page when page name is missing\n    -silent <true/false>  false means display all queries\n    -trace <true/false>   display JDBC trace messages\nThe command line arguments override the values in the webserver.properties file.");
    }

    public void c() {
        this.b("server.port        =" + this.b.getProperty("server.port"));
        this.b("server.database    =" + this.b.getProperty("server.database"));
        this.b("server.root        =" + this.b.getProperty("server.root"));
        this.b("server.default_page=" + this.b.getProperty("server.default_page"));
        this.b("server.silent      =" + this.b.getProperty("server.silent"));
        Trace.c("HSQLDB web server 1.7.1 is running");
        Trace.c("Use SHUTDOWN to close normally. Use [Ctrl]+[C] to abort abruptly");
    }
}

