/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Hashtable;
import org.hsqldb.Trace;

public class Tokenizer {
    private static final int NAME = 1;
    private static final int LONG_NAME = 2;
    private static final int SPECIAL = 3;
    private static final int NUMBER = 4;
    private static final int FLOAT = 5;
    private static final int STRING = 6;
    private static final int LONG = 7;
    private static final int DECIMAL = 8;
    private static final int QUOTED_IDENTIFIER = 9;
    private static final int REMARK_LINE = 10;
    private static final int REMARK = 11;
    private String sCommand;
    private int iLength;
    private Object oValue;
    private int iIndex;
    private int tokenIndex;
    private int nextTokenIndex;
    private int beginIndex;
    private int iType;
    private String sToken;
    private String sLongNameFirst;
    private String sLongNameLast;
    private boolean bWait;
    private static Hashtable hKeyword = new Hashtable(67);

    public Tokenizer(String string) {
        this.sCommand = string;
        this.iLength = string.length();
        this.iIndex = 0;
    }

    public void j() throws SQLException {
        Trace.a(!this.bWait, "back");
        this.nextTokenIndex = this.iIndex;
        this.iIndex = this.tokenIndex;
        this.bWait = true;
    }

    public void a(String string) throws SQLException {
        this.getToken();
        if (!this.sToken.equals(string)) {
            throw Trace.error(11, this.sToken);
        }
    }

    public String d() throws SQLException {
        this.getToken();
        if (this.iType == 6) {
            return this.sToken.toUpperCase();
        }
        if (this.iType == 1) {
            return this.sToken;
        }
        if (this.iType == 9) {
            return this.sToken.toUpperCase();
        }
        throw Trace.error(11, this.sToken);
    }

    public boolean p() {
        if (this.iType == 6 || this.iType == 4 || this.iType == 5 || this.iType == 7 || this.iType == 8) {
            return true;
        }
        return this.sToken.equals("NULL") || this.sToken.equals("TRUE") || this.sToken.equals("FALSE");
    }

    public boolean n() {
        return this.iType == 9;
    }

    public boolean q() {
        return this.iType == 2;
    }

    public boolean f() {
        if (this.iType == 9) {
            return true;
        }
        if (this.iType != 1) {
            return false;
        }
        return !hKeyword.containsKey(this.sToken);
    }

    public String h() {
        return this.sLongNameFirst;
    }

    public String i() {
        return this.sLongNameLast;
    }

    public String l() throws SQLException {
        this.getToken();
        if (!this.f()) {
            throw Trace.error(11, this.sToken);
        }
        return this.sToken;
    }

    public String o() throws SQLException {
        this.getToken();
        return this.sToken;
    }

    public int b() {
        switch (this.iType) {
            case 6: {
                return 12;
            }
            case 4: {
                return 4;
            }
            case 7: {
                return -5;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 3;
            }
        }
        return 0;
    }

    public Object g() throws SQLException {
        if (!this.p()) {
            throw Trace.error(11, this.sToken);
        }
        if (this.iType == 6) {
            return this.sToken;
        }
        if (this.sToken.equals("NULL")) {
            return null;
        }
        if (this.iType == 4) {
            if (this.sToken.length() < 10) {
                return new Integer(this.sToken);
            }
            if (this.sToken.length() == 10) {
                try {
                    return new Integer(this.sToken);
                }
                catch (Exception exception) {
                    this.iType = 7;
                    return new Long(this.sToken);
                }
            }
            if (this.sToken.length() < 19) {
                this.iType = 7;
                return new Long(this.sToken);
            }
            if (this.sToken.length() == 19) {
                try {
                    return new Long(this.sToken);
                }
                catch (Exception exception) {
                    this.iType = 8;
                    return new BigDecimal(this.sToken);
                }
            }
            this.iType = 8;
            return new BigDecimal(this.sToken);
        }
        if (this.iType == 5) {
            return new Double(this.sToken);
        }
        if (this.iType == 8) {
            return new BigDecimal(this.sToken);
        }
        return this.sToken;
    }

    public int k() {
        return this.iIndex;
    }

    public String a(int n2, int n3) {
        return this.sCommand.substring(n2, n3);
    }

    public int c() {
        return this.beginIndex;
    }

    public void e() {
        this.beginIndex = this.iIndex;
    }

    public void a(int n2) {
        this.beginIndex = n2;
    }

    public String a() {
        return this.sCommand.substring(this.beginIndex, this.iIndex);
    }

    /*
     * Unable to fully structure code
     */
    private void getToken() throws SQLException {
        if (!this.bWait) ** GOTO lbl6
        this.bWait = false;
        this.iIndex = this.nextTokenIndex;
        return;
lbl-1000:
        // 1 sources

        {
            ++this.iIndex;
lbl6:
            // 2 sources

            ** while (this.iIndex < this.iLength && Character.isWhitespace((char)this.sCommand.charAt((int)this.iIndex)))
        }
lbl7:
        // 1 sources

        this.sToken = "";
        this.tokenIndex = this.iIndex;
        if (this.iIndex >= this.iLength) {
            this.iType = 0;
            return;
        }
        var1_1 = this.sCommand.charAt(this.iIndex);
        var2_2 = false;
        var3_3 = false;
        var4_4 = false;
        var5_5 = false;
        var6_6 = false;
        var7_7 = '\u0000';
        if (Character.isJavaIdentifierStart(var1_1)) {
            this.iType = 1;
        } else if (Character.isDigit(var1_1)) {
            this.iType = 4;
            var3_3 = true;
        } else {
            switch (var1_1) {
                case '%': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case ';': 
                case '=': {
                    this.iType = 3;
                    ++this.iIndex;
                    this.sToken = String.valueOf(var1_1);
                    return;
                }
                case '\"': {
                    this.iType = 9;
                    ++this.iIndex;
                    this.sToken = this.getString('\"');
                    if (this.iIndex == this.sCommand.length()) {
                        return;
                    }
                    var1_1 = this.sCommand.charAt(this.iIndex);
                    if (var1_1 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        var8_8 = new StringBuffer(this.sLongNameFirst.length() + 1 + this.sLongNameLast.length());
                        var8_8.append(this.sLongNameFirst);
                        var8_8.append('.');
                        var8_8.append(this.sLongNameLast);
                        this.sToken = var8_8.toString();
                    }
                    return;
                }
                case '\'': {
                    this.iType = 6;
                    ++this.iIndex;
                    this.sToken = this.getString('\'');
                    return;
                }
                case '!': 
                case '-': 
                case '/': 
                case '<': 
                case '>': 
                case '|': {
                    var7_7 = var1_1;
                    this.iType = 3;
                    break;
                }
                case '.': {
                    this.iType = 8;
                    var2_2 = true;
                    break;
                }
                default: {
                    throw Trace.error(11, String.valueOf(var1_1));
                }
            }
        }
        var8_9 = this.iIndex++;
        while (true) {
            if (this.iIndex >= this.iLength) {
                var1_1 = ' ';
                var6_6 = true;
                Trace.a(this.iType != 6 && this.iType != 9, 12);
            } else {
                var1_1 = this.sCommand.charAt(this.iIndex);
            }
            switch (this.iType) {
                case 1: {
                    if (Character.isJavaIdentifierPart(var1_1)) break;
                    this.sToken = this.sCommand.substring(var8_9, this.iIndex).toUpperCase();
                    if (var1_1 == '.') {
                        this.sLongNameFirst = this.sToken;
                        ++this.iIndex;
                        this.getToken();
                        this.sLongNameLast = this.sToken;
                        this.iType = 2;
                        this.sToken = this.sLongNameFirst + "." + this.sLongNameLast;
                    }
                    return;
                }
                case 6: 
                case 9: {
                    break;
                }
                case 11: {
                    if (var6_6) {
                        this.iType = 0;
                        return;
                    }
                    if (var1_1 != 42) break;
                    ++this.iIndex;
                    if (this.iIndex >= this.iLength || this.sCommand.charAt(this.iIndex) != '/') break;
                    ++this.iIndex;
                    this.getToken();
                    return;
                }
                case 10: {
                    if (var6_6) {
                        this.iType = 0;
                        return;
                    }
                    if (var1_1 != '\r' && var1_1 != 10) break;
                    this.getToken();
                    return;
                }
                case 3: {
                    if (var1_1 == '/' && var7_7 == '/') {
                        this.iType = 10;
                        break;
                    }
                    if (var1_1 == '-' && var7_7 == '-') {
                        this.iType = 10;
                        break;
                    }
                    if (var1_1 == '*' && var7_7 == '/') {
                        this.iType = 11;
                        break;
                    }
                    if (var1_1 == '>' || var1_1 == '=' || var1_1 == '|') break;
                    this.sToken = this.sCommand.substring(var8_9, this.iIndex);
                    return;
                }
                case 4: 
                case 5: 
                case 8: {
                    if (Character.isDigit(var1_1)) {
                        var3_3 = true;
                        break;
                    }
                    if (var1_1 == '.') {
                        this.iType = 8;
                        if (var2_2) {
                            throw Trace.error(11, ".");
                        }
                        var2_2 = true;
                        break;
                    }
                    if (var1_1 == 'E' || var1_1 == 'e') {
                        if (var4_4) {
                            throw Trace.error(11, "E");
                        }
                        this.iType = 5;
                        var5_5 = true;
                        var2_2 = true;
                        var4_4 = true;
                        break;
                    }
                    if (var1_1 == '-' && var5_5) {
                        var5_5 = false;
                        break;
                    }
                    if (var1_1 == '+' && var5_5) {
                        var5_5 = false;
                        break;
                    }
                    var5_5 = false;
                    if (!var3_3) {
                        if (var2_2 && var8_9 == this.iIndex - 1) {
                            this.sToken = ".";
                            this.iType = 3;
                            return;
                        }
                        throw Trace.error(11, String.valueOf(var1_1));
                    }
                    this.sToken = this.sCommand.substring(var8_9, this.iIndex);
                    return;
                }
            }
            ++this.iIndex;
        }
    }

    private String getString(char c2) throws SQLException {
        try {
            int n2 = this.iIndex;
            boolean bl2 = false;
            while (true) {
                if ((n2 = this.sCommand.indexOf(c2, n2)) < 0) {
                    throw Trace.error(12);
                }
                if (n2 >= this.iLength - 1 || this.sCommand.charAt(n2 + 1) != c2) break;
                bl2 = true;
                n2 += 2;
            }
            char[] cArray = new char[n2 - this.iIndex];
            this.sCommand.getChars(this.iIndex, n2, cArray, 0);
            int n3 = cArray.length;
            if (bl2) {
                n3 = 0;
                int n4 = 0;
                while (n4 < cArray.length) {
                    if (cArray[n4] == c2) {
                        ++n4;
                    }
                    cArray[n3] = cArray[n4];
                    ++n4;
                    ++n3;
                }
            }
            this.iIndex = ++n2;
            return new String(cArray, 0, n3);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            exception.getMessage();
            return null;
        }
    }

    public void a(String string, int n2) {
        this.sCommand = string;
        this.iLength = string.length();
        this.bWait = false;
        this.iIndex = n2;
    }

    public int m() {
        return this.iLength;
    }

    static {
        String[] stringArray = new String[]{"AND", "ALL", "AVG", "BY", "BETWEEN", "COUNT", "CASEWHEN", "DISTINCT", "EXISTS", "EXCEPT", "FALSE", "FROM", "GROUP", "IF", "INTO", "IFNULL", "IS", "IN", "INTERSECT", "INNER", "LEFT", "LIKE", "MAX", "MIN", "NULL", "NOT", "ON", "ORDER", "OR", "OUTER", "PRIMARY", "SELECT", "SET", "SUM", "TO", "TRUE", "UNIQUE", "UNION", "VALUES", "WHERE", "CONVERT", "CAST", "CONCAT", "MINUS", "CALL"};
        int n2 = 0;
        while (n2 < stringArray.length) {
            hKeyword.put(stringArray[n2], hKeyword);
            ++n2;
        }
    }
}

