/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.Cache;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseFile;
import org.hsqldb.DatabaseRowOutputInterface;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.QuotedTextDatabaseRowInput;
import org.hsqldb.QuotedTextDatabaseRowOutput;
import org.hsqldb.Table;
import org.hsqldb.TextDatabaseRowInput;
import org.hsqldb.TextDatabaseRowOutput;
import org.hsqldb.Trace;

public class TextCache
extends Cache {
    public static final String NL = System.getProperty("line.separator");
    private String fs;
    private String vs;
    private String lvs;
    private DatabaseRowOutputInterface out;
    public boolean readOnly;
    public TextDatabaseRowInput in;
    public boolean ignoreFirst;
    public String ignoredFirst = NL;

    public TextCache(String string, String string2, HsqlDatabaseProperties hsqlDatabaseProperties) throws SQLException {
        super("", hsqlDatabaseProperties);
        String string3;
        String string4;
        String string5;
        TextSource textSource = new TextSource(this, string);
        this.fs = this.translateSep(textSource.a("fs", null));
        this.vs = textSource.a("vs", this.fs);
        if (this.vs != this.fs) {
            this.vs = this.translateSep(this.vs);
        }
        if ((string5 = textSource.a("lvs", this.fs)) != this.fs) {
            string5 = this.translateSep(string5);
        }
        if (this.fs == null) {
            this.fs = this.translateSep(hsqlDatabaseProperties.getProperty(string2 + "fs"), true);
            if (this.fs == null) {
                this.fs = ",";
            }
        }
        if (this.vs == null) {
            this.vs = hsqlDatabaseProperties.getProperty(string2 + "vs", this.fs);
            if (this.vs != this.fs) {
                this.vs = this.translateSep(this.vs, true);
            }
        }
        if (string5 == null && (string5 = hsqlDatabaseProperties.getProperty(string2 + "lvs", this.fs)) != this.fs) {
            string5 = this.translateSep(string5, true);
        }
        if ((string4 = textSource.a("ignore_first", null)) == null) {
            string4 = hsqlDatabaseProperties.getProperty(string2 + "ignore_first", "false");
        }
        this.ignoreFirst = string4.equals("true");
        String string6 = textSource.a("quoted", null);
        if (string6 == null) {
            string6 = hsqlDatabaseProperties.getProperty(string2 + "quoted", "true");
        }
        if ((string3 = textSource.a("empty_is_null", null)) == null) {
            string3 = hsqlDatabaseProperties.getProperty(string2 + "empty_is_null", "true");
        }
        this.sName = TextSource.a(textSource);
        if (this.sName.endsWith(";")) {
            this.sName = this.sName.substring(0, this.sName.length() - 1);
        }
        try {
            if (string6.equals("true")) {
                this.in = new QuotedTextDatabaseRowInput(this.fs, this.vs, string5, string3.equals("true"));
                this.out = new QuotedTextDatabaseRowOutput(this.fs, this.vs, string5);
            } else {
                this.in = new TextDatabaseRowInput(this.fs, this.vs, string5, string3.equals("true"));
                this.out = new TextDatabaseRowOutput(this.fs, this.vs, string5);
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, "invalid separator(s):" + iOException);
        }
    }

    private String translateSep(String string) {
        return this.translateSep(string, false);
    }

    private String translateSep(String string, boolean bl2) {
        if (string == null) {
            return null;
        }
        int n2 = 0;
        n2 = string.indexOf(92);
        if (n2 != -1) {
            int n3 = 0;
            char[] cArray = string.toCharArray();
            int n4 = 0;
            int n5 = string.length();
            StringBuffer stringBuffer = new StringBuffer(n5);
            do {
                stringBuffer.append(cArray, n3, n2 - n3);
                n3 = ++n2;
                if (n2 >= n5) {
                    stringBuffer.append('\\');
                    break;
                }
                if (!bl2) {
                    n4 = cArray[n2];
                }
                if (n4 == 110) {
                    stringBuffer.append('\n');
                    ++n3;
                    continue;
                }
                if (n4 == 114) {
                    stringBuffer.append('\r');
                    ++n3;
                    continue;
                }
                if (n4 == 116) {
                    stringBuffer.append('\t');
                    ++n3;
                    continue;
                }
                if (n4 == 92) {
                    stringBuffer.append('\\');
                    ++n3;
                    continue;
                }
                if (n4 == 117) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(++n3, n3 + 4), 16));
                    n3 += 4;
                    continue;
                }
                if (string.startsWith("semi", n2)) {
                    stringBuffer.append(';');
                    n3 += 4;
                    continue;
                }
                if (string.startsWith("space", n2)) {
                    stringBuffer.append(' ');
                    n3 += 5;
                    continue;
                }
                if (string.startsWith("quote", n2)) {
                    stringBuffer.append('\"');
                    n3 += 5;
                    continue;
                }
                if (string.startsWith("apos", n2)) {
                    stringBuffer.append('\'');
                    n3 += 4;
                    continue;
                }
                stringBuffer.append('\\');
                stringBuffer.append(cArray[n2]);
                ++n3;
            } while ((n2 = string.indexOf(92, n3)) != -1);
            stringBuffer.append(cArray, n3, n5 - n3);
            string = stringBuffer.toString();
        }
        return string;
    }

    public void a(boolean bl2) throws SQLException {
        try {
            this.rFile = new DatabaseFile(this.sName, bl2 ? "r" : "rw", 4096);
            this.iFreePos = (int)this.rFile.length();
            if (this.iFreePos == 0 && this.ignoreFirst) {
                this.rFile.write(this.ignoredFirst.getBytes());
                this.iFreePos = this.ignoredFirst.length();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " opening " + this.sName);
        }
        this.readOnly = bl2;
    }

    public void d() throws SQLException {
        this.a(this.readOnly);
        this.in.reset();
    }

    public void b() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(0L);
            this.saveAll();
            boolean bl2 = this.rFile.length() <= (long)NL.length();
            this.rFile.close();
            this.rFile = null;
            if (bl2 && !this.readOnly) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " closing " + this.sName);
        }
    }

    public void c() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            if (this.readOnly) {
                this.b();
            } else {
                this.rFile.close();
                this.rFile = null;
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " purging " + this.sName);
        }
    }

    public void a(CachedRow cachedRow) throws SQLException {
        int n2 = cachedRow.e;
        int n3 = cachedRow.f;
        StringBuffer stringBuffer = new StringBuffer(n3);
        n3 -= NL.length();
        int n4 = 0;
        while (n4 < n3) {
            stringBuffer.append(' ');
            ++n4;
        }
        stringBuffer.append(NL);
        try {
            this.rFile.seek(n2);
            this.rFile.writeBytes(stringBuffer.toString());
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException + "");
        }
        this.remove(cachedRow);
    }

    public void setStorageSize(CachedRow cachedRow) throws SQLException {
        int n2;
        try {
            this.out.writeData(cachedRow.d(), cachedRow.b());
            n2 = this.out.toByteArray().length;
        }
        catch (IOException iOException) {
            throw Trace.error(29, iOException + "");
        }
        cachedRow.f = n2;
    }

    public CachedRow makeRow(int n2, Table table) throws SQLException {
        CachedRow cachedRow = null;
        try {
            StringBuffer stringBuffer = new StringBuffer(80);
            boolean bl2 = true;
            boolean bl3 = false;
            try {
                int n3;
                this.rFile.readSeek(n2);
                while ((n3 = this.rFile.read()) != -1) {
                    char c2 = (char)(n3 & 0xFF);
                    if (c2 == '\n') {
                        stringBuffer.append('\n');
                        if (this.ignoreFirst && n2 == 0) {
                            this.ignoredFirst = stringBuffer.toString();
                            bl2 = true;
                        }
                        if (!bl2) {
                            bl3 = true;
                            break;
                        }
                        n2 += stringBuffer.length();
                        stringBuffer.setLength(0);
                        bl2 = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c2 == '\r') {
                        try {
                            n3 = this.rFile.read();
                            if (n3 == -1) break;
                            c2 = (char)(n3 & 0xFF);
                            if (c2 == '\n') {
                                stringBuffer.append('\n');
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        stringBuffer.append('\n');
                        if (this.ignoreFirst && n2 == 0) {
                            this.ignoredFirst = stringBuffer.toString();
                            bl2 = true;
                        }
                        if (!bl2) {
                            bl3 = true;
                            break;
                        }
                        n2 += stringBuffer.length();
                        stringBuffer.setLength(0);
                        bl2 = true;
                        this.in.skippedLine();
                        continue;
                    }
                    if (c2 != ' ') {
                        bl2 = false;
                    }
                    stringBuffer.append(c2);
                }
            }
            catch (Exception exception) {
                bl3 = false;
            }
            if (bl3) {
                this.in.setSource(stringBuffer.toString(), n2);
                cachedRow = new CachedRow(table, this.in);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw Trace.error(29, "reading: " + exception);
        }
        return cachedRow;
    }

    public void saveRow(CachedRow cachedRow) throws IOException, SQLException {
        this.rFile.seek(cachedRow.e);
        cachedRow.a(this.out);
        this.rFile.write(this.out.toByteArray());
    }

    private class TextSource {
        private String source;
        private final TextCache this$0;

        public TextSource(TextCache textCache, String string) {
            this.this$0 = textCache;
            this.source = string;
        }

        public String a(String string, String string2) {
            string = ";" + string + "=";
            int n2 = string.length();
            int n3 = this.source.indexOf(string);
            if (n3 != -1) {
                int n4 = this.source.indexOf(";", n3 += n2);
                if (n4 == -1) {
                    n4 = this.source.length();
                }
                string2 = this.source.substring(n3, n4);
                this.source = this.source.substring(0, n3 - n2) + this.source.substring(n4);
            }
            return string2;
        }

        public static String a(TextSource textSource) {
            return textSource.source;
        }
    }
}

