/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.CachedRow;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.Database;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Row;
import org.hsqldb.Session;
import org.hsqldb.Trace;
import org.hsqldb.TriggerDef;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringUtil;

public class Table {
    private Vector vColumn;
    private Vector vIndex;
    private int[] iPrimaryKey;
    private int iIndexCount;
    private int iIdentityColumn;
    private int iIdentityId;
    public Vector c;
    public Vector[] a;
    private int[] colTypes;
    private boolean isSystem;
    private boolean isText;
    private boolean isView;
    public int iColumnCount;
    public int iVisibleColumns;
    public Database dDatabase;
    public Cache cCache;
    public HsqlName tableName;
    public int tableType;
    public Session ownerSession;
    public boolean isReadOnly;
    public boolean isTemp;
    public boolean isCached;
    public int indexType;

    public Table(Database database, HsqlName hsqlName, int n2, Session session) throws SQLException {
        this.dDatabase = database;
        if (n2 == 0) {
            this.isTemp = true;
        } else if (n2 == 1) {
            Trace.a(session != null);
            this.isTemp = true;
            this.ownerSession = session;
        } else if (n2 == 3) {
            this.cCache = database.a.c();
            if (this.cCache != null) {
                this.isCached = true;
            } else {
                n2 = 2;
            }
        } else if (n2 == 4) {
            Trace.a(session != null);
            if (!database.a.b()) {
                throw Trace.error(63);
            }
            this.isTemp = true;
            this.isText = true;
            this.isReadOnly = true;
            this.isCached = true;
            this.ownerSession = session;
        } else if (n2 == 5) {
            if (!database.a.b()) {
                throw Trace.error(63);
            }
            this.isText = true;
            this.isCached = true;
        } else if (n2 == 6) {
            this.isView = true;
        }
        if (this.isText) {
            this.indexType = 2;
        } else if (this.isCached) {
            this.indexType = 1;
        }
        this.tableType = n2;
        this.tableName = hsqlName;
        this.iPrimaryKey = null;
        this.iIdentityColumn = -1;
        this.vColumn = new Vector();
        this.vIndex = new Vector();
        this.c = new Vector();
        this.a = new Vector[TriggerDef.numTrigs()];
        int n3 = 0;
        while (n3 < TriggerDef.numTrigs()) {
            this.a[n3] = new Vector();
            ++n3;
        }
    }

    public boolean a(String string, Session session) {
        if (this.isTemp && session.b() != this.ownerSession.b()) {
            return false;
        }
        return this.tableName.d.equals(string);
    }

    public boolean e(String string) {
        return this.tableName.d.equals(string);
    }

    public final boolean j() {
        return this.isText;
    }

    public final boolean p() {
        return this.isTemp;
    }

    public final boolean m() {
        return this.isView;
    }

    public final int b() {
        return this.indexType;
    }

    public final boolean u() {
        return this.isReadOnly;
    }

    public void a(boolean bl2) throws SQLException {
        this.isReadOnly = bl2;
    }

    public Session s() {
        return this.ownerSession;
    }

    public void setDataSource(String string, boolean bl2, Session session) throws SQLException {
        throw Trace.error(22);
    }

    public String getDataSource() throws SQLException {
        return null;
    }

    public boolean isDescDataSource() throws SQLException {
        return false;
    }

    public void a(Constraint constraint) {
        this.c.addElement(constraint);
    }

    public Vector n() {
        return this.c;
    }

    public Index a(int[] nArray, boolean bl2) {
        Index index = this.v();
        if (ArrayUtil.haveEquality(index.f(), nArray, nArray.length, bl2)) {
            return index;
        }
        int n2 = 0;
        while (n2 < this.c.size()) {
            Constraint constraint = (Constraint)this.c.elementAt(n2);
            index = constraint.i();
            if (ArrayUtil.haveEquality(index.f(), nArray, nArray.length, bl2)) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    public int a(int n2, int n3) {
        int n4 = n2;
        while (n4 < this.c.size()) {
            Constraint constraint = (Constraint)this.c.elementAt(n4);
            if (constraint.d() == n3) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public void a(String string, int n2) throws SQLException {
        Column column = new Column(new HsqlName(string, false), true, n2, 0, 0, false, false, null);
        this.a(column);
    }

    public void a(Column column) throws SQLException {
        if (this.a(column.d.d) >= 0) {
            throw Trace.error(27);
        }
        if (column.e()) {
            Trace.a(column.b() == 4, 16, column.d.d);
            Trace.a(this.iIdentityColumn == -1, 24, column.d.d);
            this.iIdentityColumn = this.iColumnCount;
        }
        Trace.a(this.iPrimaryKey == null, "Table.addColumn");
        this.vColumn.addElement(column);
        ++this.iColumnCount;
    }

    public void a(Result result) throws SQLException {
        int n2 = 0;
        while (n2 < result.d()) {
            Column column = new Column(new HsqlName(result.i[n2], result.a[n2]), true, result.g[n2], result.d[n2], result.j[n2], false, false, null);
            this.a(column);
            ++n2;
        }
    }

    public HsqlName r() {
        return this.tableName;
    }

    public void a(String string, boolean bl2) {
        this.tableName.rename(string, bl2);
        if (HsqlName.isReservedName(this.v().c().d)) {
            this.v().c().rename("SYS_PK", string, bl2);
        }
    }

    public Table duplicate() throws SQLException {
        Table table = new Table(this.dDatabase, this.tableName, this.tableType, this.ownerSession);
        return table;
    }

    public void a(int[] nArray, Table table, int[] nArray2) throws SQLException {
        if (nArray.length != nArray2.length) {
            throw Trace.error(5);
        }
        int n2 = 0;
        while (n2 < nArray.length) {
            if (nArray[n2] >= this.iColumnCount || nArray2[n2] >= table.iColumnCount) {
                throw Trace.error(5);
            }
            if (this.d(nArray[n2]).b() != table.d(nArray2[n2]).b()) {
                throw Trace.error(57);
            }
            ++n2;
        }
    }

    public Table a(String string, Column column, int n2, int n3) throws SQLException {
        int[] nArray;
        Table table = this.duplicate();
        int n4 = 0;
        while (n4 < this.iVisibleColumns + 1) {
            block10: {
                block8: {
                    block9: {
                        if (n4 != n2) break block8;
                        if (n3 <= 0) break block9;
                        table.a(column);
                        break block8;
                    }
                    if (n3 < 0) break block10;
                }
                if (n4 == this.iVisibleColumns) break;
                table.a(this.d(n4));
            }
            ++n4;
        }
        int[] nArray2 = nArray = this.iPrimaryKey[0] == this.iVisibleColumns ? null : this.iPrimaryKey;
        if (nArray != null) {
            int[] nArray3 = ArrayUtil.toAdjustedColumnArray(nArray, n2, n3);
            if (nArray.length != nArray3.length) {
                throw Trace.error(25);
            }
            nArray = nArray3;
        }
        table.a(this.getIndex(0).c(), nArray);
        table.c = this.c;
        int n5 = 1;
        while (n5 < this.a()) {
            Index index;
            Index index2 = this.getIndex(n5);
            if (!(string != null && index2.c().d.equals(string) || (index = table.createAdjustedIndex(index2, n2, n3)) != null)) {
                throw Trace.error(23);
            }
            ++n5;
        }
        return table;
    }

    public void b(Table table, int n2, int n3) throws SQLException {
        int n4 = 0;
        while (n4 < this.c.size()) {
            Constraint constraint = (Constraint)this.c.elementAt(n4);
            constraint.a(table, this, n2, n3);
            ++n4;
        }
    }

    public int g() {
        return this.iVisibleColumns;
    }

    public int a() {
        return this.iIndexCount;
    }

    public int l() {
        return this.iIdentityColumn;
    }

    public int g(String string) throws SQLException {
        int n2 = this.a(string);
        if (n2 == -1) {
            throw Trace.error(28, string);
        }
        return n2;
    }

    public int a(String string) {
        int n2 = 0;
        while (n2 < this.iColumnCount) {
            if (string.equals(((Column)this.vColumn.elementAt((int)n2)).d.d)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Index v() {
        if (this.iPrimaryKey == null) {
            return null;
        }
        return this.getIndex(0);
    }

    public Index b(int n2) throws SQLException {
        int n3 = 0;
        while (n3 < this.iIndexCount) {
            Index index = this.getIndex(n3);
            if (index.f()[0] == n2) {
                return index;
            }
            ++n3;
        }
        return null;
    }

    public Index b(int[] nArray, boolean bl2) throws SQLException {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            int[] nArray2 = index.f();
            if (ArrayUtil.haveEquality(nArray2, nArray, nArray.length, bl2) && (!bl2 || index.d())) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    public int[] d() throws SQLException {
        int[] nArray = new int[this.iIndexCount];
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Node node = this.getIndex(n2).b();
            nArray[n2] = node != null ? node.i() : -1;
            ++n2;
        }
        return nArray;
    }

    public String f() throws SQLException {
        Trace.a(this.isCached, "Table.getIndexRootData");
        String string = StringUtil.getList(this.d(), " ", "");
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(this.iIdentityId);
        return stringBuffer.toString();
    }

    public void a(int[] nArray) throws SQLException {
        Trace.a(this.isCached, 22);
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            int n3 = nArray[n2];
            CachedRow cachedRow = null;
            if (n3 != -1) {
                cachedRow = this.cCache.a(n3, this);
            }
            Node node = null;
            if (cachedRow != null) {
                node = ((Row)cachedRow).a(n2);
            }
            this.getIndex(n2).d(node);
            ++n2;
        }
    }

    public void c(String string) throws SQLException {
        Trace.a(this.isCached, 22);
        int[] nArray = new int[this.iIndexCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.iIndexCount) {
            int n4;
            int n5 = string.indexOf(32, n2);
            nArray[n3] = n4 = Integer.parseInt(string.substring(n2, n5));
            n2 = n5 + 1;
            ++n3;
        }
        this.a(nArray);
        this.iIdentityId = Integer.parseInt(string.substring(n2));
    }

    public void k() throws SQLException {
        this.a((HsqlName)null, (int[])null);
    }

    public void a(HsqlName hsqlName, int[] nArray) throws SQLException {
        Object object;
        Trace.a(this.iPrimaryKey == null, "Table.createPrimaryKey(column)");
        this.iVisibleColumns = this.iColumnCount;
        if (nArray == null) {
            nArray = new int[]{this.iColumnCount};
            object = new Column(new HsqlName("", false), false, 4, 0, 0, true, true, null);
            this.a((Column)object);
        } else {
            int n2 = 0;
            while (n2 < nArray.length) {
                this.d(nArray[n2]).a(false);
                this.d(nArray[n2]).b(true);
                ++n2;
            }
        }
        this.iPrimaryKey = nArray;
        object = hsqlName != null ? hsqlName : new HsqlName("SYS_PK", this.tableName.d, this.tableName.c);
        this.a(nArray, (HsqlName)object, true);
        this.colTypes = new int[this.iColumnCount];
        int n3 = 0;
        while (n3 < this.iColumnCount) {
            this.colTypes[n3] = this.d(n3).b();
            ++n3;
        }
    }

    private Index createAdjustedIndex(Index index, int n2, int n3) throws SQLException {
        int[] nArray = ArrayUtil.getAdjustedColumnArray(index.f(), index.e(), n2, n3);
        if (nArray.length != index.e()) {
            return null;
        }
        return this.a(nArray, index.c(), index.d());
    }

    public Index a(int[] nArray, HsqlName hsqlName, boolean bl2) throws SQLException {
        Trace.a(this.iPrimaryKey != null, "createIndex");
        int n2 = nArray.length;
        int n3 = this.iPrimaryKey.length;
        int[] nArray2 = new int[bl2 ? n2 : n2 + n3];
        int[] nArray3 = new int[bl2 ? n2 : n2 + n3];
        int n4 = 0;
        while (n4 < n2) {
            nArray2[n4] = nArray[n4];
            nArray3[n4] = this.d(nArray2[n4]).b();
            ++n4;
        }
        if (!bl2) {
            int n5 = 0;
            while (n5 < n3) {
                nArray2[n2 + n5] = this.iPrimaryKey[n5];
                nArray3[n2 + n5] = this.d(this.iPrimaryKey[n5]).b();
                ++n5;
            }
        }
        if (nArray2[0] == this.iVisibleColumns) {
            n2 = 0;
        }
        Index index = new Index(hsqlName, this, nArray2, nArray3, bl2, n2);
        Trace.a(this.o(), "createIndex");
        this.vIndex.addElement(index);
        ++this.iIndexCount;
        return index;
    }

    public void a(String string, Hashtable hashtable) throws SQLException {
        Index index = this.d(string);
        if (index == null) {
            throw Trace.error(26, string);
        }
        if (index.equals(this.getIndex(0))) {
            throw Trace.error(25, string);
        }
        int n2 = 0;
        while (n2 < this.c.size()) {
            Constraint constraint = (Constraint)this.c.elementAt(n2);
            if (hashtable.get(constraint) == null) {
                if (constraint.a(index)) {
                    throw Trace.error(50, string);
                }
                if (constraint.b(index)) {
                    throw Trace.error(56, string);
                }
            }
            ++n2;
        }
    }

    public boolean o() {
        if (this.iIndexCount == 0) {
            return true;
        }
        return this.getIndex(0).b() == null;
    }

    public Object[] q() {
        return new Object[this.iColumnCount];
    }

    public void a(Table table, int n2, int n3) throws SQLException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3 = null;
        if (n3 > 0) {
            object2 = this.d(n2);
            object3 = Column.a((Object)((Column)object2).d(), ((Column)object2).b());
        }
        object2 = table.v();
        Object object4 = ((Index)object2).a();
        while (object4 != null) {
            object = object4.f();
            objectArray = this.q();
            ArrayUtil.copyAdjustArray(object, objectArray, object3, n2, n3);
            this.a(objectArray, null, false);
            object4 = ((Index)object2).a((Node)object4);
        }
        object2 = table.v();
        object4 = ((Index)object2).a();
        while (object4 != null) {
            object = ((Index)object2).a((Node)object4);
            objectArray = object4.f();
            table.b(objectArray, null, false);
            object4 = object;
        }
    }

    public void a(int[] nArray, Result result, Result result2) throws SQLException {
        Trace.a(!this.isReadOnly, 32);
        if (this.dDatabase.b()) {
            int n2 = 0;
            while (n2 < this.c.size()) {
                Constraint constraint = (Constraint)this.c.elementAt(n2);
                constraint.a(nArray, result, result2);
                ++n2;
            }
        }
    }

    public void a(Result result, Session session) throws SQLException {
        Record record = result.l;
        int n2 = result.d();
        while (record != null) {
            Object[] objectArray = this.q();
            int n3 = 0;
            while (n3 < n2) {
                objectArray[n3] = record.data[n3];
                ++n3;
            }
            this.b(objectArray, session);
            record = record.next;
        }
    }

    public void b(Object[] objectArray, Session session) throws SQLException {
        Trace.a(!this.isReadOnly, 32);
        this.a(3, objectArray);
        if (this.dDatabase.b()) {
            int n2 = 0;
            while (n2 < this.c.size()) {
                ((Constraint)this.c.elementAt(n2)).b(objectArray);
                ++n2;
            }
        }
        this.a(objectArray, session, true);
        this.a(0, objectArray);
    }

    public void a(Object[] objectArray, Session session, boolean bl2) throws SQLException {
        int n2 = 0;
        while (n2 < this.iColumnCount) {
            if (objectArray[n2] == null) {
                boolean bl3;
                Column column = this.d(n2);
                boolean bl4 = bl3 = column.f() || column.e();
                if (!bl3) {
                    throw Trace.error(10);
                }
            }
            ++n2;
        }
        int n3 = this.iIdentityId;
        if (this.iIdentityColumn != -1) {
            Number number = (Number)objectArray[this.iIdentityColumn];
            if (number == null) {
                objectArray[this.iIdentityColumn] = new Integer(this.iIdentityId);
            } else {
                int n4 = number.intValue();
                if (this.iIdentityId < n4) {
                    this.iIdentityId = n3 = n4;
                }
            }
        }
        Row row = Row.a(this, objectArray);
        n3 = this.isText ? ((CachedRow)row).e + ((CachedRow)row).f : ++n3;
        this.a(row, true);
        if (session != null) {
            session.b(this.iIdentityId);
            session.a(this, objectArray);
        }
        this.iIdentityId = n3;
        if (bl2 && !this.isTemp && !this.isReadOnly && this.dDatabase.a.b()) {
            this.dDatabase.a.a(session, this.a(objectArray));
        }
    }

    public void a(int n2, Object[] objectArray) {
        if (!this.dDatabase.b()) {
            return;
        }
        Vector vector = this.a[n2];
        int n3 = vector.size();
        int n4 = 0;
        while (n4 < n3) {
            TriggerDef triggerDef = (TriggerDef)vector.elementAt(n4);
            triggerDef.a(objectArray);
            ++n4;
        }
    }

    public void a(int n2) {
        Object[] objectArray = new Object[]{new String("Statement-level")};
        this.a(n2, objectArray);
    }

    public void a(TriggerDef triggerDef) {
        if (Trace.TRACE) {
            Trace.b("Trigger added " + String.valueOf(triggerDef.d));
        }
        this.a[triggerDef.d].addElement(triggerDef);
    }

    public void c(Object[] objectArray, Session session, boolean bl2) throws SQLException {
        int n2 = 0;
        while (n2 < this.c.size()) {
            Node node;
            Constraint constraint = (Constraint)this.c.elementAt(n2);
            if (constraint.d() == 1 && constraint.f() != null && (node = constraint.a(objectArray)) != null) {
                boolean bl3;
                Table table = constraint.f();
                boolean bl4 = bl3 = table.a(0, 1) != -1;
                if (!bl2 && !bl3) {
                    return;
                }
                Index index = constraint.b();
                int[] nArray = constraint.a();
                Object[] objectArray2 = new Object[nArray.length];
                ArrayUtil.copyColumnValues(objectArray, nArray, objectArray2);
                Node node2 = node;
                while (index.a(objectArray2, node2.f()) == 0) {
                    Node node3 = index.a(node2);
                    if (bl3) {
                        table.c(node2.f(), session, bl2);
                    }
                    if (bl2) {
                        table.deleteNoRefCheck(node2.f(), session);
                        if (table == this) {
                            node3 = constraint.a(objectArray);
                        }
                    }
                    if (node3 == null) break;
                    node2 = node3;
                }
            }
            ++n2;
        }
    }

    public void a(Object[] objectArray, Session session) throws SQLException {
        this.a(10, objectArray);
        if (this.dDatabase.b()) {
            this.c(objectArray, session, false);
            this.c(objectArray, session, true);
        }
        this.b(objectArray, session, true);
        this.a(7, objectArray);
    }

    private void deleteNoRefCheck(Object[] objectArray, Session session) throws SQLException {
        this.a(10, objectArray);
        this.b(objectArray, session, true);
        this.a(7, objectArray);
    }

    public void b(Object[] objectArray, Session session, boolean bl2) throws SQLException {
        int n2 = 1;
        while (n2 < this.iIndexCount) {
            this.getIndex(n2).b(objectArray, false);
            ++n2;
        }
        this.getIndex(0).b(objectArray, true);
        if (session != null) {
            session.b(this, objectArray);
        }
        if (bl2 && !this.isTemp && !this.isReadOnly && this.dDatabase.a.b()) {
            this.dDatabase.a.a(session, this.getDeleteStatement(objectArray));
        }
    }

    public String a(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("INSERT INTO ");
        stringBuffer.append(this.tableName.b);
        stringBuffer.append(" VALUES(");
        int n2 = 0;
        while (n2 < this.iVisibleColumns) {
            stringBuffer.append(Column.c(objectArray[n2], this.d(n2).b()));
            stringBuffer.append(',');
            ++n2;
        }
        stringBuffer.setCharAt(stringBuffer.length() - 1, ')');
        return stringBuffer.toString();
    }

    public boolean e() {
        return this.isCached;
    }

    public boolean h() {
        return this.isCached;
    }

    public Index d(String string) {
        int n2 = 0;
        while (n2 < this.iIndexCount) {
            Index index = this.getIndex(n2);
            if (string.equals(index.c().d)) {
                return index;
            }
            ++n2;
        }
        return null;
    }

    public int b(String string) {
        int n2 = 0;
        while (n2 < this.c.size()) {
            Constraint constraint = (Constraint)this.c.elementAt(n2);
            if (constraint.g().d.equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Constraint f(String string) {
        int n2 = this.b(string);
        if (n2 >= 0) {
            return (Constraint)this.c.elementAt(n2);
        }
        return null;
    }

    public Column d(int n2) {
        return (Column)this.vColumn.elementAt(n2);
    }

    public int[] t() {
        return this.colTypes;
    }

    public Index getIndex(int n2) {
        return (Index)this.vIndex.elementAt(n2);
    }

    private String getDeleteStatement(Object[] objectArray) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("DELETE FROM ");
        stringBuffer.append(this.tableName.b);
        stringBuffer.append(" WHERE ");
        if (this.iVisibleColumns < this.iColumnCount) {
            int n2 = 0;
            while (n2 < this.iVisibleColumns) {
                Column column = this.d(n2);
                stringBuffer.append(column.d.b);
                stringBuffer.append('=');
                stringBuffer.append(Column.c(objectArray[n2], column.b()));
                if (n2 < this.iVisibleColumns - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.iPrimaryKey.length) {
                Column column = this.d(this.iPrimaryKey[n3]);
                stringBuffer.append(column.d.b);
                stringBuffer.append('=');
                stringBuffer.append(Column.c(objectArray[this.iPrimaryKey[n3]], column.b()));
                if (n3 < this.iPrimaryKey.length - 1) {
                    stringBuffer.append(" AND ");
                }
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public Row c(int n2) throws SQLException {
        if (this.isCached) {
            return this.cCache.a(n2, this);
        }
        return null;
    }

    public void a(CachedRow cachedRow) throws SQLException {
        boolean bl2 = false;
        if (this.cCache != null) {
            this.cCache.b(cachedRow);
        }
    }

    public void b(CachedRow cachedRow) throws SQLException {
        if (this.cCache != null) {
            this.cCache.a(cachedRow);
        }
    }

    public void c() throws SQLException {
        if (this.cCache != null) {
            this.cCache.a();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void a(Row var1_1, boolean var2_2) throws SQLException {
        block5: {
            if (var2_2) {
                var3_3 = 0;
                try {
                    var4_4 = null;
                    while (var3_3 < this.iIndexCount) {
                        var4_4 = var1_1.a(var4_4);
                        this.getIndex(var3_3).c(var4_4);
                        ++var3_3;
                    }
                    break block5;
                }
                catch (SQLException var4_5) {
                    --var3_3;
                    ** while (var3_3 >= 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.getIndex(var3_3).b(var1_1.d(), var3_3 == 0);
                    --var3_3;
                    continue;
                }
lbl17:
                // 1 sources

                throw var4_5;
            }
        }
    }
}

