/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.hsqldb.Cache;
import org.hsqldb.Database;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.Index;
import org.hsqldb.Node;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.ReverseTextCache;
import org.hsqldb.Session;
import org.hsqldb.StringConverter;
import org.hsqldb.Table;
import org.hsqldb.TextCache;
import org.hsqldb.Trace;

public class Log
implements Runnable {
    private static final int COPY_BLOCK_SIZE = 65536;
    private HsqlDatabaseProperties pProperties;
    private String sName;
    private Database dDatabase;
    private Session sysSession;
    private Writer wScript;
    private File scriptChecker;
    private String sFileScript;
    private String sFileCache;
    private String sFileBackup;
    private boolean bRestoring;
    private boolean bReadOnly;
    private int iLogSize;
    private int iLogCount;
    private Thread tRunner;
    private volatile boolean bNeedFlush;
    private volatile boolean bWriteDelay;
    private int mLastId;
    private Cache cCache;
    private static final String lineSep = System.getProperty("line.separator", "\n");
    private Hashtable textCacheList = new Hashtable();

    public Log(Database database, Session session, String string) throws SQLException {
        this.dDatabase = database;
        this.sysSession = session;
        this.sName = string;
        this.pProperties = database.c();
        this.tRunner = new Thread(this);
        this.tRunner.start();
    }

    public void run() {
        while (this.tRunner != null) {
            try {
                Thread.sleep(1000L);
                if (!this.bNeedFlush) continue;
                this.wScript.flush();
                this.bNeedFlush = false;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void b(boolean bl2) {
        this.bWriteDelay = bl2;
    }

    public boolean g() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!this.pProperties.checkFileExists()) {
            this.create();
            this.g();
            return true;
        }
        this.pProperties.load();
        this.sFileScript = this.sName + ".script";
        this.sFileCache = this.sName + ".data";
        this.sFileBackup = this.sName + ".backup";
        this.scriptChecker = new File(this.sFileScript);
        this.iLogSize = this.pProperties.getIntegerProperty("hsqldb.log_size", this.iLogSize);
        String string = this.pProperties.getProperty("hsqldb.compatible_version");
        int n2 = string.substring(0, 5).compareTo("1.7.1");
        Trace.a(n2 <= 0, 30);
        this.pProperties.setProperty("hsqldb.version", "1.7.1");
        if (this.pProperties.isPropertyTrue("readonly")) {
            this.bReadOnly = true;
            this.dDatabase.i();
            if (this.cCache != null) {
                this.cCache.a(true);
            }
            this.d();
            this.runScript();
            return false;
        }
        boolean bl2 = false;
        String string2 = this.pProperties.getProperty("modified");
        if (string2.equals("yes-new-files")) {
            this.renameNewToCurrent(this.sFileScript);
            this.renameNewToCurrent(this.sFileBackup);
        } else if (string2.equals("yes")) {
            if (this.isAlreadyOpen()) {
                throw Trace.error(1);
            }
            this.restoreBackup();
            bl2 = true;
        }
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.a(false);
        }
        this.d();
        this.runScript();
        if (bl2) {
            this.c(false);
            this.pProperties.setProperty("modified", "yes");
            this.pProperties.save();
            if (this.cCache != null) {
                this.cCache.a(false);
            }
            this.d();
        }
        this.openScript();
        return false;
    }

    public Cache b() throws SQLException {
        if (this.cCache == null) {
            this.cCache = new Cache(this.sFileCache, this.pProperties);
            this.cCache.a(this.bReadOnly);
        }
        return this.cCache;
    }

    public void f() {
        this.tRunner = null;
    }

    public void c(boolean bl2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (this.bReadOnly) {
            return;
        }
        this.closeScript();
        this.writeScript(bl2);
        if (this.cCache != null) {
            this.cCache.b();
        }
        this.a(bl2);
        this.backup();
        this.pProperties.setProperty("modified", "yes-new-files");
        this.pProperties.save();
        this.renameNewToCurrent(this.sFileScript);
        this.renameNewToCurrent(this.sFileBackup);
        this.pProperties.setProperty("modified", "no");
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("hsqldb.compatible_version", "1.7.0");
        this.pProperties.save();
        this.pProperties.close();
        if (bl2) {
            this.f();
            new File(this.sFileCache).delete();
            new File(this.sFileBackup).delete();
        }
    }

    public void c() throws SQLException {
        this.c(false);
        this.pProperties.setProperty("modified", "yes");
        this.pProperties.save();
        if (this.cCache != null) {
            this.cCache.a(false);
        }
        this.d();
        this.openScript();
    }

    public void a(int n2) {
        this.iLogSize = n2;
        this.pProperties.setProperty("hsqldb.log_size", this.iLogSize);
    }

    public void a(Session session, String string) throws SQLException {
        if (this.bRestoring || string == null || string.length() == 0) {
            return;
        }
        if (!this.bReadOnly) {
            int n2 = 0;
            if (session != null) {
                n2 = session.b();
            }
            if (n2 != this.mLastId) {
                string = "/*C" + n2 + "*/" + string;
                this.mLastId = n2;
            }
            try {
                Log.writeLine(this.wScript, string);
                if (this.bWriteDelay) {
                    this.bNeedFlush = true;
                } else {
                    this.wScript.flush();
                }
            }
            catch (IOException iOException) {
                throw Trace.error(29, this.sFileScript);
            }
            if (this.iLogSize > 0 && this.iLogCount++ > 100) {
                this.iLogCount = 0;
                if (this.scriptChecker.length() > (long)(this.iLogSize * 1024 * 1024)) {
                    this.c();
                }
            }
        }
    }

    public void e() throws SQLException {
        this.tRunner = null;
        if (this.cCache != null) {
            this.cCache.e();
            this.cCache = null;
        }
        this.a();
        this.closeScript();
        this.pProperties.close();
    }

    public static void a(Database database, String string, boolean bl2, Session session) throws SQLException {
        if (new File(string).exists()) {
            throw Trace.error(29, string);
        }
        try {
            long l2 = 0L;
            if (Trace.TRACE) {
                l2 = System.currentTimeMillis();
            }
            Result result = bl2 ? database.a(false, false, false, session) : database.a(false, false, true, session);
            Record record = result.l;
            FileWriter fileWriter = new FileWriter(string);
            while (record != null) {
                Log.writeLine(fileWriter, (String)record.data[0]);
                record = record.next;
            }
            Vector vector = database.a();
            int n2 = 0;
            while (n2 < vector.size()) {
                Object object;
                Table table = (Table)vector.elementAt(n2);
                if (!(!bl2 && table.e() || table.p() || table.m() || table.j() && table.u())) {
                    object = table.v();
                    Node node = ((Index)object).a();
                    while (node != null) {
                        Log.writeLine(fileWriter, table.a(node.f()));
                        node = ((Index)object).a(node);
                    }
                }
                if (table.u() && !table.p() && !table.j()) {
                    object = new StringBuffer("SET TABLE ");
                    ((StringBuffer)object).append(table.r().b);
                    ((StringBuffer)object).append(" READONLY TRUE");
                    Log.writeLine(fileWriter, ((StringBuffer)object).toString());
                }
                ++n2;
            }
            fileWriter.close();
            if (Trace.TRACE) {
                Trace.a(l2 - System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, string + " " + iOException);
        }
    }

    private void renameNewToCurrent(String string) {
        File file = new File(string + ".new");
        if (file.exists()) {
            File file2 = new File(string);
            file2.delete();
            file.renameTo(file2);
        }
    }

    private void create() throws SQLException {
        if (Trace.TRACE) {
            Trace.b(this.sName);
        }
        this.pProperties.setProperty("version", "1.7.1");
        this.pProperties.setProperty("sql.strict_fk", true);
        this.pProperties.save();
    }

    private boolean isAlreadyOpen() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        File file = new File(this.sName + ".lock");
        long l2 = file.lastModified();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        long l3 = file.lastModified();
        if (l2 != l3) {
            return true;
        }
        return this.pProperties.isFileOpen();
    }

    private void backup() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!new File(this.sFileCache).exists()) {
            return;
        }
        try {
            int n2;
            long l2 = 0L;
            if (Trace.TRACE) {
                l2 = System.currentTimeMillis();
            }
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)new FileOutputStream(this.sFileBackup + ".new"), new Deflater(1), 65536);
            byte[] byArray = new byte[65536];
            FileInputStream fileInputStream = new FileInputStream(this.sFileCache);
            while ((n2 = fileInputStream.read(byArray, 0, 65536)) != -1) {
                deflaterOutputStream.write(byArray, 0, n2);
            }
            deflaterOutputStream.close();
            fileInputStream.close();
            if (Trace.TRACE) {
                Trace.a(l2 - System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void restoreBackup() throws SQLException {
        if (Trace.TRACE) {
            Trace.b("not closed last time!");
        }
        if (!new File(this.sFileBackup).exists()) {
            new File(this.sFileCache).delete();
            return;
        }
        try {
            int n2;
            long l2 = 0L;
            if (Trace.TRACE) {
                l2 = System.currentTimeMillis();
            }
            InflaterInputStream inflaterInputStream = new InflaterInputStream(new FileInputStream(this.sFileBackup), new Inflater());
            FileOutputStream fileOutputStream = new FileOutputStream(this.sFileCache);
            byte[] byArray = new byte[65536];
            while ((n2 = inflaterInputStream.read(byArray, 0, 65536)) != -1) {
                fileOutputStream.write(byArray, 0, n2);
            }
            fileOutputStream.close();
            inflaterInputStream.close();
            if (Trace.TRACE) {
                Trace.a(l2 - System.currentTimeMillis());
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileBackup);
        }
    }

    private void openScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        try {
            this.wScript = new BufferedWriter(new FileWriter(this.sFileScript, true), 4096);
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void closeScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        try {
            if (this.wScript != null) {
                this.wScript.close();
                this.wScript = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.sFileScript);
        }
    }

    private void runScript() throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!new File(this.sFileScript).exists()) {
            return;
        }
        this.bRestoring = true;
        this.dDatabase.a(false);
        Vector<Session> vector = new Vector<Session>();
        vector.addElement(this.sysSession);
        Session session = this.sysSession;
        try {
            String string;
            long l2 = 0L;
            if (Trace.TRACE) {
                l2 = System.currentTimeMillis();
            }
            LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(this.sFileScript));
            while ((string = Log.readLine(lineNumberReader)) != null) {
                Result result;
                int n2;
                if (string.startsWith("/*C")) {
                    n2 = Integer.parseInt(string.substring(3, string.indexOf(42, 4)));
                    if (n2 >= vector.size()) {
                        vector.setSize(n2 + 1);
                    }
                    if ((session = (Session)vector.elementAt(n2)) == null) {
                        session = new Session(this.sysSession, n2);
                        vector.setElementAt(session, n2);
                        this.dDatabase.a(session);
                    }
                    string = string.substring(string.indexOf(47, 1) + 1);
                }
                if (string.length() != 0 && (result = this.dDatabase.d(string, session)) != null && result.f == 1) {
                    throw Trace.a(result.b, (Object)result.e);
                }
                if (!string.equals("DISCONNECT")) continue;
                n2 = session.b();
                session = new Session(this.sysSession, n2);
                vector.setElementAt(session, n2);
            }
            lineNumberReader.close();
            int n3 = 0;
            while (n3 < vector.size()) {
                session = (Session)vector.elementAt(n3);
                if (session != null) {
                    session.e();
                }
                ++n3;
            }
            if (Trace.TRACE) {
                Trace.a(l2 - System.currentTimeMillis());
            }
        }
        catch (IOException iOException) {
            throw Trace.error(29, this.sFileScript + " " + iOException);
        }
        this.dDatabase.a(true);
        this.bRestoring = false;
    }

    private void writeScript(boolean bl2) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        new File(this.sFileScript + ".new").delete();
        Log.a(this.dDatabase, this.sFileScript + ".new", bl2, this.sysSession);
    }

    private static int writeLine(Writer writer, String string) throws IOException {
        String string2 = StringConverter.unicodeToAscii(string).append(lineSep).toString();
        writer.write(string2);
        return string2.length();
    }

    private static String readLine(LineNumberReader lineNumberReader) throws IOException {
        String string = lineNumberReader.readLine();
        return StringConverter.asciiToUnicode(string);
    }

    public Cache a(String string, String string2, boolean bl2, boolean bl3) throws SQLException {
        String string3;
        this.a(string);
        if (this.pProperties.getProperty("textdb.allow_full_path", "false").equals("false")) {
            if (string2.indexOf("..") != -1) {
                throw Trace.error(33, string2);
            }
            string3 = new File(new File(this.sName).getAbsolutePath()).getParent();
            if (string3 != null) {
                string2 = string3 + File.separator + string2;
            }
        }
        string3 = "textdb." + string.toLowerCase() + ".";
        TextCache textCache = bl3 ? new ReverseTextCache(string2, string3, this.pProperties) : new TextCache(string2, string3, this.pProperties);
        textCache.a(bl2 || this.bReadOnly);
        this.textCacheList.put(string, textCache);
        return textCache;
    }

    public void a(String string) throws SQLException {
        TextCache textCache = (TextCache)this.textCacheList.remove(string);
        if (textCache != null) {
            textCache.b();
        }
    }

    public void a(boolean bl2) throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            if (bl2) {
                ((TextCache)enumeration.nextElement()).c();
                continue;
            }
            ((TextCache)enumeration.nextElement()).b();
        }
    }

    public void d() throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            ((TextCache)enumeration.nextElement()).d();
        }
    }

    public void a() throws SQLException {
        Enumeration enumeration = this.textCacheList.elements();
        while (enumeration.hasMoreElements()) {
            ((TextCache)enumeration.nextElement()).e();
        }
        this.textCacheList = new Hashtable();
    }
}

