/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Random;

public class Library {
    public static final String[][] b = new String[][]{{"ABS", "org.hsqldb.Library.abs"}, {"ACOS", "java.lang.Math.acos"}, {"ASIN", "java.lang.Math.asin"}, {"ATAN", "java.lang.Math.atan"}, {"ATAN2", "java.lang.Math.atan2"}, {"CEILING", "java.lang.Math.ceil"}, {"COS", "java.lang.Math.cos"}, {"COT", "org.hsqldb.Library.cot"}, {"DEGREES", "java.lang.Math.toDegrees"}, {"EXP", "java.lang.Math.exp"}, {"FLOOR", "java.lang.Math.floor"}, {"LOG", "java.lang.Math.log"}, {"LOG10", "org.hsqldb.Library.log10"}, {"MOD", "org.hsqldb.Library.mod"}, {"PI", "org.hsqldb.Library.pi"}, {"POWER", "java.lang.Math.pow"}, {"RADIANS", "java.lang.Math.toRadians"}, {"RAND", "java.lang.Math.random"}, {"ROUND", "org.hsqldb.Library.round"}, {"SIGN", "org.hsqldb.Library.sign"}, {"SIN", "java.lang.Math.sin"}, {"SQRT", "java.lang.Math.sqrt"}, {"TAN", "java.lang.Math.tan"}, {"TRUNCATE", "org.hsqldb.Library.truncate"}, {"BITAND", "org.hsqldb.Library.bitand"}, {"BITOR", "org.hsqldb.Library.bitor"}, {"ROUNDMAGIC", "org.hsqldb.Library.roundMagic"}};
    public static final String[][] a = new String[][]{{"ASCII", "org.hsqldb.Library.ascii"}, {"CHAR", "org.hsqldb.Library.character"}, {"CONCAT", "org.hsqldb.Library.concat"}, {"DIFFERENCE", "org.hsqldb.Library.difference"}, {"HEXTORAW", "org.hsqldb.Library.hexToRaw"}, {"INSERT", "org.hsqldb.Library.insert"}, {"LCASE", "org.hsqldb.Library.lcase"}, {"LEFT", "org.hsqldb.Library.left"}, {"LENGTH", "org.hsqldb.Library.length"}, {"LOCATE", "org.hsqldb.Library.locate"}, {"LTRIM", "org.hsqldb.Library.ltrim"}, {"RAWTOHEX", "org.hsqldb.Library.rawToHex"}, {"REPEAT", "org.hsqldb.Library.repeat"}, {"REPLACE", "org.hsqldb.Library.replace"}, {"RIGHT", "org.hsqldb.Library.right"}, {"RTRIM", "org.hsqldb.Library.rtrim"}, {"SOUNDEX", "org.hsqldb.Library.soundex"}, {"SPACE", "org.hsqldb.Library.space"}, {"SUBSTR", "org.hsqldb.Library.substring"}, {"SUBSTRING", "org.hsqldb.Library.substring"}, {"UCASE", "org.hsqldb.Library.ucase"}, {"LOWER", "org.hsqldb.Library.lcase"}, {"UPPER", "org.hsqldb.Library.ucase"}};
    public static final String[][] c = new String[][]{{"CURDATE", "org.hsqldb.Library.curdate"}, {"CURTIME", "org.hsqldb.Library.curtime"}, {"DAYNAME", "org.hsqldb.Library.dayname"}, {"DAYOFMONTH", "org.hsqldb.Library.dayofmonth"}, {"DAYOFWEEK", "org.hsqldb.Library.dayofweek"}, {"DAYOFYEAR", "org.hsqldb.Library.dayofyear"}, {"HOUR", "org.hsqldb.Library.hour"}, {"MINUTE", "org.hsqldb.Library.minute"}, {"MONTH", "org.hsqldb.Library.month"}, {"MONTHNAME", "org.hsqldb.Library.monthname"}, {"NOW", "org.hsqldb.Library.now"}, {"QUARTER", "org.hsqldb.Library.quarter"}, {"SECOND", "org.hsqldb.Library.second"}, {"WEEK", "org.hsqldb.Library.week"}, {"YEAR", "org.hsqldb.Library.year"}};
    public static final String[][] d = new String[][]{{"DATABASE", "org.hsqldb.Library.database"}, {"USER", "org.hsqldb.Library.user"}, {"IDENTITY", "org.hsqldb.Library.identity"}};
    private static final Random rRandom = new Random();
    private static final double LOG10_FACTOR = 0.4342944819032518;
    private static int sql_month = 0;
    private static boolean sql_month_set = false;

    public static void a(Hashtable hashtable) {
        Library.register(hashtable, b);
        Library.register(hashtable, a);
        Library.register(hashtable, c);
        Library.register(hashtable, d);
    }

    private static void register(Hashtable hashtable, String[][] stringArray) {
        int n2 = 0;
        while (n2 < stringArray.length) {
            hashtable.put(stringArray[n2][0], stringArray[n2][1]);
            ++n2;
        }
    }

    public static synchronized double rand(Integer n2) {
        if (n2 != null) {
            rRandom.setSeed(n2.intValue());
        }
        return rRandom.nextDouble();
    }

    public static double abs(double d2) {
        return Math.abs(d2);
    }

    public static double log10(double d2) {
        return Library.roundMagic(Math.log(d2) * 0.4342944819032518);
    }

    public static double roundMagic(double d2) {
        if (d2 < 1.0E-13 && d2 > -1.0E-13) {
            return 0.0;
        }
        if (d2 > 1.0E12 || d2 < -1.0E12) {
            return d2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(d2);
        int n2 = stringBuffer.length();
        if (n2 < 16) {
            return d2;
        }
        char c2 = stringBuffer.charAt(n2 - 1);
        char c3 = stringBuffer.charAt(n2 - 2);
        char c4 = stringBuffer.charAt(n2 - 3);
        char c5 = stringBuffer.charAt(n2 - 4);
        if (c3 == '0' && c4 == '0' && c5 == '0' && c2 != '.') {
            stringBuffer.setCharAt(n2 - 1, '0');
        } else if (c3 == '9' && c4 == '9' && c5 == '9' && c2 != '.') {
            stringBuffer.setCharAt(n2 - 1, '9');
            stringBuffer.append('9');
            stringBuffer.append('9');
        }
        return Double.valueOf(stringBuffer.toString());
    }

    public static double cot(double d2) {
        return 1.0 / Math.tan(d2);
    }

    public static int mod(int n2, int n3) {
        return n2 % n3;
    }

    public static double pi() {
        return Math.PI;
    }

    public static double round(double d2, int n2) {
        double d3 = Math.pow(10.0, n2);
        return (double)Math.round(d2 * d3) / d3;
    }

    public static int sign(double d2) {
        return d2 < 0.0 ? -1 : (d2 > 0.0 ? 1 : 0);
    }

    public static double truncate(double d2, int n2) {
        double d3 = Math.pow(10.0, n2);
        double d4 = d2 * d3;
        return (d2 < 0.0 ? Math.ceil(d4) : Math.floor(d4)) / d3;
    }

    public static int bitand(int n2, int n3) {
        return n2 & n3;
    }

    public static int bitor(int n2, int n3) {
        return n2 | n3;
    }

    public static Integer ascii(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        return new Integer(string.charAt(0));
    }

    public static String character(int n2) {
        return String.valueOf((char)n2);
    }

    public static String concat(String string, String string2) {
        if (string == null) {
            if (string2 == null) {
                return null;
            }
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + string2;
    }

    public static int difference(String string, String string2) {
        if (string == null || string2 == null) {
            return 0;
        }
        string = Library.soundex(string);
        string2 = Library.soundex(string2);
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            if (string.charAt(n3) != string2.charAt(n3)) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    public static String hexToRaw(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        if (n2 % 4 != 0) {
            return null;
        }
        int n3 = 0;
        while (n3 < n2) {
            char c2 = (char)Integer.parseInt(string.substring(n3, n3 + 4), 16);
            stringBuffer.append(c2);
            n3 += 4;
        }
        return stringBuffer.toString();
    }

    public static String insert(String string, int n2, int n3, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        int n4 = string.length();
        int n5 = string2.length();
        if (--n2 < 0 || n3 <= 0 || n5 == 0 || n2 > n4) {
            return string;
        }
        if (n2 + n3 > n4) {
            n3 = n4 - n2;
        }
        return string.substring(0, n2) + string2 + string.substring(n2 + n3);
    }

    public static String lcase(String string) {
        return string == null ? null : string.toLowerCase();
    }

    public static String left(String string, int n2) {
        if (string == null) {
            return null;
        }
        return string.substring(0, n2 < 0 ? 0 : (n2 < string.length() ? n2 : string.length()));
    }

    public static Integer length(String string) {
        return string == null ? null : new Integer(string.length());
    }

    public static int locate(String string, String string2, Integer n2) {
        if (string2 == null || string == null) {
            return 0;
        }
        int n3 = n2 == null ? 0 : n2 - 1;
        return string2.indexOf(string, n3 < 0 ? 0 : n3) + 1;
    }

    public static String ltrim(String string) {
        if (string == null) {
            return string;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2 && string.charAt(n3) <= ' ') {
            ++n3;
        }
        return n3 == 0 ? string : string.substring(n3);
    }

    public static String rawToHex(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < cArray.length) {
            String string2 = Integer.toHexString(cArray[n2] & 0xFFFF);
            int n3 = string2.length();
            while (n3 < 4) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string2);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String repeat(String string, Integer n2) {
        if (string == null || n2 == null || n2 < 0) {
            return null;
        }
        int n3 = n2;
        StringBuffer stringBuffer = new StringBuffer(string.length() * n3);
        while (n3-- > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String replace(String string, String string2, String string3) {
        if (string == null || string2 == null) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = string2.length();
        while (true) {
            int n4;
            if ((n4 = string.indexOf(string2, n2)) == -1) break;
            stringBuffer.append(string.substring(n2, n4));
            stringBuffer.append(string3);
            n2 = n4 + n3;
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String right(String string, int n2) {
        if (string == null) {
            return null;
        }
        n2 = string.length() - n2;
        return string.substring(n2 < 0 ? 0 : (n2 < string.length() ? n2 : string.length()));
    }

    public static String rtrim(String string) {
        int n2;
        if (string == null) {
            return string;
        }
        int n3 = n2 = string.length() - 1;
        while (n3 >= 0 && string.charAt(n3) == ' ') {
            --n3;
        }
        return n3 == n2 ? string : string.substring(0, n3 + 1);
    }

    public static String soundex(String string) {
        if (string == null) {
            return string;
        }
        string = string.toUpperCase();
        int n2 = string.length();
        char[] cArray = new char[]{'0', '0', '0', '0'};
        int n3 = 48;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n2 && n5 < 4) {
            block19: {
                int n6;
                char c2;
                block12: {
                    block18: {
                        block17: {
                            block16: {
                                block15: {
                                    block14: {
                                        block13: {
                                            block11: {
                                                c2 = string.charAt(n4);
                                                if ("AEIOUY".indexOf(c2) == -1) break block11;
                                                n6 = 55;
                                                break block12;
                                            }
                                            if (c2 != 'H' && c2 != 'W') break block13;
                                            n6 = 56;
                                            break block12;
                                        }
                                        if ("BFPV".indexOf(c2) == -1) break block14;
                                        n6 = 49;
                                        break block12;
                                    }
                                    if ("CGJKQSXZ".indexOf(c2) == -1) break block15;
                                    n6 = 50;
                                    break block12;
                                }
                                if (c2 != 'D' && c2 != 'T') break block16;
                                n6 = 51;
                                break block12;
                            }
                            if (c2 != 'L') break block17;
                            n6 = 52;
                            break block12;
                        }
                        if (c2 != 'M' && c2 != 'N') break block18;
                        n6 = 53;
                        break block12;
                    }
                    if (c2 != 'R') break block19;
                    n6 = 54;
                }
                if (n5 == 0) {
                    cArray[n5++] = c2;
                    n3 = n6;
                } else if (n6 <= 54) {
                    if (n6 != n3) {
                        cArray[n5++] = n6;
                        n3 = n6;
                    }
                } else if (n6 == 55) {
                    n3 = n6;
                }
            }
            ++n4;
        }
        return new String(cArray, 0, 4);
    }

    public static String space(int n2) {
        if (n2 < 0) {
            return null;
        }
        char[] cArray = new char[n2];
        while (n2 > 0) {
            cArray[--n2] = 32;
        }
        return new String(cArray);
    }

    public static String substring(String string, int n2, Integer n3) {
        if (string == null) {
            return null;
        }
        int n4 = string.length();
        n2 = --n2 > n4 ? n4 : n2;
        int n5 = n4;
        if (n3 != null) {
            n5 = n3;
        }
        if (n2 + n5 > n4) {
            n5 = n4 - n2;
        }
        return string.substring(n2, n2 + n5);
    }

    public static String ucase(String string) {
        return string == null ? null : string.toUpperCase();
    }

    public static java.sql.Date curdate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Time curtime() {
        return new Time(System.currentTimeMillis());
    }

    public static String dayname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEEE");
        return simpleDateFormat.format(date).toString();
    }

    private static int getDateTimePart(Date date, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(n2);
    }

    private static int getTimePart(Time time, int n2) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(time);
        return gregorianCalendar.get(n2);
    }

    public static int dayofmonth(java.sql.Date date) {
        return Library.getDateTimePart(date, 5);
    }

    public static int dayofweek(java.sql.Date date) {
        return Library.getDateTimePart(date, 7);
    }

    public static int dayofyear(java.sql.Date date) {
        return Library.getDateTimePart(date, 6);
    }

    public static int hour(Time time) {
        return Library.getDateTimePart(time, 11);
    }

    public static int minute(Time time) {
        return Library.getDateTimePart(time, 12);
    }

    public static void a(boolean bl2) {
        if (!sql_month_set) {
            sql_month = bl2 ? 1 : 0;
            sql_month_set = true;
        }
    }

    public static int month(java.sql.Date date) {
        return Library.getDateTimePart(date, 2) + sql_month;
    }

    public static String monthname(java.sql.Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM");
        return simpleDateFormat.format(date).toString();
    }

    public static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static int quarter(java.sql.Date date) {
        return Library.getDateTimePart(date, 2) / 3 + 1;
    }

    public static int second(Time time) {
        return Library.getDateTimePart(time, 13);
    }

    public static int week(java.sql.Date date) {
        return Library.getDateTimePart(date, 3);
    }

    public static int year(java.sql.Date date) {
        return Library.getDateTimePart(date, 1);
    }

    public static String database(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='DATABASE'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static String user(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT Value FROM SYSTEM_CONNECTIONINFO WHERE KEY='USER'";
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        return resultSet.getString(1);
    }

    public static int identity() throws SQLException {
        return 0;
    }

    public static boolean getAutoCommit(Connection connection) {
        try {
            return connection.getAutoCommit();
        }
        catch (SQLException sQLException) {
            return false;
        }
    }
}

