/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.FileInputStream;
import java.sql.SQLException;
import org.hsqldb.HsqlProperties;
import org.hsqldb.Trace;

public class HsqlDatabaseProperties
extends HsqlProperties {
    private FileInputStream propsFileStream;

    private HsqlDatabaseProperties() {
    }

    public HsqlDatabaseProperties(String string) {
        super(string);
        this.setProperty("sql.month", true);
        this.setProperty("sql.enforce_size", false);
        this.setProperty("sql.compare_in_locale", false);
        this.setProperty("sql.strict_fk", false);
        this.setProperty("sql.strong_fk", true);
        this.setProperty("hsqldb.compatible_version", "1.6.0");
        this.setProperty("hsqldb.original_version", "1.7.1");
        this.setProperty("hsqldb.cache_version", "1.6.0");
        this.setProperty("hsqldb.cache_scale", "14");
        this.setProperty("hsqldb.log_size", "200");
        this.setProperty("readonly", false);
        this.setProperty("modified", "no");
    }

    public void close() throws SQLException {
        try {
            if (this.propsFileStream != null) {
                if (Trace.TRACE) {
                    Trace.b();
                }
                this.propsFileStream.close();
                this.propsFileStream = null;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    public void load() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.b();
        }
        try {
            File file = new File(this.fileName + ".properties");
            this.propsFileStream = new FileInputStream(file);
            this.stringProps.load(this.propsFileStream);
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    public void save() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.b();
        }
        try {
            super.save();
            this.load();
        }
        catch (Exception exception) {
            throw Trace.error(29, this.fileName + ".properties " + exception);
        }
    }

    public boolean isFileOpen() throws SQLException {
        this.close();
        if (Trace.TRACE) {
            Trace.b();
        }
        if (!new File(this.fileName + ".properties").delete()) {
            return true;
        }
        this.save();
        return false;
    }
}

