/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DatabaseFile
extends RandomAccessFile {
    public byte[] in;
    public long pos;
    public int index;
    public int count;

    public DatabaseFile(String string, String string2, int n2) throws FileNotFoundException, IOException {
        super(string, string2);
        this.in = new byte[n2];
    }

    public void realSeek(long l2) throws IOException {
        super.seek(l2);
    }

    public void seek(long l2) throws IOException {
        super.seek(l2);
        this.pos = l2;
        this.count = 0;
        this.index = 0;
    }

    public void readSeek(long l2) throws IOException {
        if (this.in == null) {
            this.seek(l2);
        } else if (l2 != this.pos) {
            this.index += (int)(l2 - this.pos);
            if (this.index < 0 || this.index > this.count) {
                this.seek(l2);
            } else {
                this.pos = l2;
            }
        }
    }

    public int read() throws IOException {
        if (this.in == null) {
            return super.read();
        }
        if (this.index == this.count) {
            this.index = 0;
            this.count = super.read(this.in);
            if (this.count == -1) {
                this.count = 0;
            }
        }
        if (this.index == this.count) {
            return -1;
        }
        ++this.pos;
        return this.in[this.index++] & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = this.read();
            if (n3 == -1) {
                return -1;
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return n2;
    }

    public int readInteger() throws IOException {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 4) {
            int n4 = this.read();
            if (n4 == -1) {
                throw new EOFException();
            }
            n2 <<= 8;
            n2 += n4 & 0xFF;
            ++n3;
        }
        return n2;
    }

    public void write(byte[] byArray) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += (long)byArray.length;
        super.write(byArray);
    }

    public void writeInteger(int n2) throws IOException {
        this.count = 0;
        this.index = 0;
        this.pos += 4L;
        this.writeInt(n2);
    }

    public void close() throws IOException {
        super.close();
        this.in = null;
    }
}

