/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Hashtable;
import org.hsqldb.ByteArray;
import org.hsqldb.HsqlName;
import org.hsqldb.Library;
import org.hsqldb.StringConverter;
import org.hsqldb.Trace;
import org.hsqldb.lib.HsqlDateTime;

public class Column {
    private static Hashtable hTypes;
    public static final int[] a;
    public static final int[] c;
    public static final int[][] b;
    public HsqlName d;
    private int colType;
    private int colSize;
    private int colScale;
    private boolean isNullable;
    private boolean isIdentity;
    private boolean isPrimaryKey;
    private String defaultString;
    private static final BigDecimal BIGDECIMAL_0;
    private static Collator i18nCollator;
    private static boolean sql_compare_in_locale;

    public Column(HsqlName hsqlName, boolean bl2, int n2, int n3, int n4, boolean bl3, boolean bl4, String string) {
        this.d = hsqlName;
        this.isNullable = bl2;
        this.colType = n2;
        this.colSize = n3;
        this.colScale = n4;
        this.isIdentity = bl3;
        this.isPrimaryKey = bl4;
        this.defaultString = string;
    }

    public boolean e() {
        return this.isIdentity;
    }

    public boolean f() {
        return this.isNullable;
    }

    public void a(boolean bl2) {
        this.isNullable = bl2;
    }

    public boolean g() {
        return this.isPrimaryKey;
    }

    public void b(boolean bl2) {
        this.isPrimaryKey = bl2;
    }

    public String d() {
        return this.defaultString;
    }

    public int b() {
        return this.colType;
    }

    public int a() {
        return this.colSize;
    }

    public int c() {
        return this.colScale;
    }

    public static int a(String string) throws SQLException {
        Integer n2 = (Integer)hTypes.get(string);
        Trace.a(n2 != null, 16, string);
        return n2;
    }

    public static String a(int n2) throws SQLException {
        switch (n2) {
            case 0: {
                return "NULL";
            }
            case 4: {
                return "INTEGER";
            }
            case 8: {
                return "DOUBLE";
            }
            case 100: {
                return "VARCHAR_IGNORECASE";
            }
            case 12: {
                return "VARCHAR";
            }
            case 1: {
                return "CHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 3: {
                return "DECIMAL";
            }
            case -7: {
                return "BIT";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case -5: {
                return "BIGINT";
            }
            case 7: {
                return "REAL";
            }
            case 6: {
                return "FLOAT";
            }
            case 2: {
                return "NUMERIC";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 1111: {
                return "OBJECT";
            }
        }
        throw Trace.error(16, n2);
    }

    public static Object d(Object object, Object object2, int n2) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return new Double(d2 + d3);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return (String)object + (String)object2;
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.add(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return new Integer(n3 + n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return new Long(l2 + l3);
            }
        }
        throw Trace.error(20, n2);
    }

    public static Object a(Object object, Object object2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        return Column.convertObject(object) + Column.convertObject(object2);
    }

    public static Object b(Object object, int n2) throws SQLException {
        if (object == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(-((Number)object).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).negate();
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(-((Number)object).intValue());
            }
            case -5: {
                return new Long(-((Number)object).longValue());
            }
        }
        throw Trace.error(20, n2);
    }

    public static Object f(Object object, Object object2, int n2) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return new Double(d2 * d3);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.multiply(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return new Integer(n3 * n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return new Long(l2 * l3);
            }
        }
        throw Trace.error(20, n2);
    }

    public static Object c(Object object, Object object2, int n2) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return new Double(d2 / d3);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                int n3 = bigDecimal.scale() > bigDecimal2.scale() ? bigDecimal.scale() : bigDecimal2.scale();
                return bigDecimal2.signum() == 0 ? null : bigDecimal.divide(bigDecimal2, n3, 5);
            }
            case -6: 
            case 4: 
            case 5: {
                int n4 = ((Number)object).intValue();
                int n5 = ((Number)object2).intValue();
                Trace.a(n5 != 0, 6);
                return new Integer(n4 / n5);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return l3 == 0L ? null : new Long(l2 / l3);
            }
        }
        throw Trace.error(20, n2);
    }

    public static Object g(Object object, Object object2, int n2) throws SQLException {
        if (object == null || object2 == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return new Double(d2 - d3);
            }
            case 2: 
            case 3: {
                BigDecimal bigDecimal = (BigDecimal)object;
                BigDecimal bigDecimal2 = (BigDecimal)object2;
                return bigDecimal.subtract(bigDecimal2);
            }
            case -6: 
            case 4: 
            case 5: {
                int n3 = ((Number)object).intValue();
                int n4 = ((Number)object2).intValue();
                return new Integer(n3 - n4);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return new Long(l2 - l3);
            }
        }
        throw Trace.error(20, n2);
    }

    public static Object b(Object object, Object object2, int n2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(((Number)object).doubleValue() + ((Number)object2).doubleValue());
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).add((BigDecimal)object2);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)object).intValue() + ((Number)object2).intValue());
            }
            case -5: {
                return new Long(((Number)object).longValue() + ((Number)object2).longValue());
            }
        }
        throw Trace.error(15);
    }

    public static Object a(Object object, int n2, int n3) throws SQLException {
        if (object == null || n3 == 0) {
            return null;
        }
        switch (n2) {
            case 0: {
                return null;
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double((Double)object / (double)n3);
            }
            case 2: 
            case 3: {
                return ((BigDecimal)object).divide(new BigDecimal((double)n3), 5);
            }
            case -6: 
            case 4: 
            case 5: {
                return new Integer(((Number)object).intValue() / n3);
            }
            case -5: {
                return new Long((Long)object / (long)n3);
            }
        }
        throw Trace.error(15);
    }

    public static Object e(Object object, Object object2, int n2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.a(object, object2, n2) < 0) {
            return object;
        }
        return object2;
    }

    public static Object h(Object object, Object object2, int n2) throws SQLException {
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (Column.a(object, object2, n2) > 0) {
            return object;
        }
        return object2;
    }

    public static void c(boolean bl2) {
        sql_compare_in_locale = bl2;
    }

    public static int a(Object object, Object object2, int n2) throws SQLException {
        int n3 = 0;
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            if (object2 == null) {
                return 0;
            }
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        switch (n2) {
            case 0: {
                return 0;
            }
            case -1: 
            case 12: {
                if (sql_compare_in_locale) {
                    n3 = i18nCollator.compare((String)object, (String)object2);
                    break;
                }
                n3 = ((String)object).compareTo((String)object2);
                break;
            }
            case 1: {
                if (sql_compare_in_locale) {
                    n3 = i18nCollator.compare(Library.rtrim((String)object), Library.rtrim((String)object2));
                    break;
                }
                n3 = Library.rtrim((String)object).compareTo(Library.rtrim((String)object2));
                break;
            }
            case 100: {
                if (sql_compare_in_locale) {
                    n3 = i18nCollator.compare(((String)object).toUpperCase(), ((String)object2).toUpperCase());
                    break;
                }
                n3 = ((String)object).toUpperCase().compareTo(((String)object2).toUpperCase());
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                int n4 = ((Number)object).intValue();
                int n5 = ((Number)object2).intValue();
                return n4 > n5 ? 1 : (n5 > n4 ? -1 : 0);
            }
            case -5: {
                long l2 = ((Number)object).longValue();
                long l3 = ((Number)object2).longValue();
                return l2 > l3 ? 1 : (l3 > l2 ? -1 : 0);
            }
            case 6: 
            case 7: 
            case 8: {
                double d2 = ((Number)object).doubleValue();
                double d3 = ((Number)object2).doubleValue();
                return d2 > d3 ? 1 : (d3 > d2 ? -1 : 0);
            }
            case 2: 
            case 3: {
                n3 = ((BigDecimal)object).compareTo((BigDecimal)object2);
                break;
            }
            case 91: {
                if (((Date)object).after((Date)object2)) {
                    return 1;
                }
                if (((Date)object).before((Date)object2)) {
                    return -1;
                }
                return 0;
            }
            case 92: {
                if (((Time)object).after((Time)object2)) {
                    return 1;
                }
                if (((Time)object).before((Time)object2)) {
                    return -1;
                }
                return 0;
            }
            case 93: {
                if (((Timestamp)object).after((Timestamp)object2)) {
                    return 1;
                }
                if (((Timestamp)object).before((Timestamp)object2)) {
                    return -1;
                }
                return 0;
            }
            case -7: {
                boolean bl2 = (Boolean)object;
                boolean bl3 = (Boolean)object2;
                return bl2 == bl3 ? 0 : (bl3 ? -1 : 1);
            }
            case -4: 
            case -3: 
            case -2: {
                n3 = ByteArray.a((byte[])object, (byte[])object2);
                break;
            }
            case 1111: {
                return 0;
            }
            default: {
                throw Trace.error(20, n2);
            }
        }
        return n3 > 0 ? 1 : (n3 < 0 ? -1 : 0);
    }

    private static String convertObject(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Object a(Object object, int n2) throws SQLException {
        try {
            if (object == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return null;
                }
                case -6: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n3 = ((Number)object).intValue();
                        if (127 < n3 || n3 < -128) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (!(object instanceof Byte)) break;
                    return new Integer(((Number)object).intValue());
                }
                case 5: {
                    if (object instanceof String) {
                        object = new Integer((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        int n4 = ((Number)object).intValue();
                        if (Short.MAX_VALUE < n4 || n4 < Short.MIN_VALUE) {
                            throw new NumberFormatException();
                        }
                        return object;
                    }
                    if (!(object instanceof Byte) && !(object instanceof Short)) break;
                    return new Integer(((Number)object).intValue());
                }
                case 4: {
                    if (object instanceof String) {
                        return new Integer((String)object);
                    }
                    if (object instanceof Integer) {
                        return object;
                    }
                    if (!(object instanceof Long)) break;
                    long l2 = ((Number)object).longValue();
                    if (Integer.MAX_VALUE < l2 || l2 < Integer.MIN_VALUE) {
                        throw new NumberFormatException();
                    }
                    return new Integer(((Number)object).intValue());
                }
                case -5: {
                    if (object instanceof Long) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Long((String)object);
                    }
                    if (!(object instanceof Integer)) break;
                    return new Long(((Integer)object).longValue());
                }
                case 6: 
                case 7: 
                case 8: {
                    if (object instanceof Double) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Double((String)object);
                    }
                    if (!(object instanceof Number)) break;
                    return new Double(((Number)object).doubleValue());
                }
                case 2: 
                case 3: {
                    if (!(object instanceof BigDecimal)) break;
                    return object;
                }
                case -7: {
                    if (object instanceof Boolean) {
                        return object;
                    }
                    if (object instanceof String) {
                        return new Boolean((String)object);
                    }
                    if (object instanceof Integer || object instanceof Long) {
                        boolean bl2 = ((Number)object).longValue() != 0L;
                        return new Boolean(bl2);
                    }
                    if (object instanceof Double) {
                        boolean bl3 = (Double)object != 0.0;
                        return new Boolean(bl3);
                    }
                    if (!(object instanceof BigDecimal)) break;
                    boolean bl4 = ((BigDecimal)object).compareTo(BIGDECIMAL_0) != 0;
                    return new Boolean(bl4);
                }
                case -1: 
                case 1: 
                case 12: 
                case 100: {
                    if (object instanceof String) {
                        return object;
                    }
                    if (!(object instanceof byte[])) break;
                    return ByteArray.toString((byte[])object);
                }
                case 92: {
                    if (object instanceof Timestamp) {
                        return new Time(((java.util.Date)((Timestamp)object)).getTime());
                    }
                    if (!(object instanceof Date)) break;
                    return new Time(0L);
                }
                case 91: {
                    if (!(object instanceof Timestamp)) break;
                    return new Date(((java.util.Date)((Timestamp)object)).getTime());
                }
                case -4: 
                case -3: 
                case -2: {
                    if (!(object instanceof byte[])) break;
                    return object;
                }
                case 1111: {
                    if (object instanceof String) break;
                    return object;
                }
            }
            return Column.convertString(object.toString(), n2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            throw Trace.error(16, exception.getMessage());
        }
    }

    private static Object convertString(String string, int n2) throws SQLException {
        switch (n2) {
            case -6: 
            case 5: {
                return Column.a((Object)string, n2);
            }
            case 4: {
                return new Integer(string);
            }
            case -5: {
                return new Long(string);
            }
            case 6: 
            case 7: 
            case 8: {
                return new Double(string);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return string;
            }
            case 91: {
                return HsqlDateTime.dateValue(string);
            }
            case 92: {
                return HsqlDateTime.timeValue(string);
            }
            case 93: {
                return HsqlDateTime.timestampValue(string);
            }
            case 2: 
            case 3: {
                return new BigDecimal(string.trim());
            }
            case -7: {
                return new Boolean(string);
            }
            case -4: 
            case -3: 
            case -2: {
                return ByteArray.a(string);
            }
            case 1111: {
                return ByteArray.a(ByteArray.a(string));
            }
        }
        throw Trace.error(20, n2);
    }

    public static String c(Object object, int n2) throws SQLException {
        if (object == null) {
            return "NULL";
        }
        switch (n2) {
            case 0: {
                return "NULL";
            }
            case 6: 
            case 7: 
            case 8: {
                return Column.a(((Number)object).doubleValue());
            }
            case 91: 
            case 92: 
            case 93: {
                return StringConverter.a(object.toString(), '\'', false);
            }
            case -4: 
            case -3: 
            case -2: {
                return StringConverter.a(ByteArray.toString((byte[])object), '\'', false);
            }
            case 1111: {
                return StringConverter.a(ByteArray.b(object), '\'', false);
            }
            case -1: 
            case 1: 
            case 12: 
            case 100: {
                return Column.b((String)object);
            }
        }
        return object.toString();
    }

    public static String a(double d2) throws SQLException {
        if (d2 == Double.NEGATIVE_INFINITY) {
            return "-1E0/0";
        }
        if (d2 == Double.POSITIVE_INFINITY) {
            return "1E0/0";
        }
        if (Double.isNaN(d2)) {
            return "0E0/0E0";
        }
        String string = Double.toString(d2);
        if (string.indexOf(69) < 0) {
            string = string.concat("E0");
        }
        return string;
    }

    public static String b(String string) {
        return StringConverter.a(string, '\'', true);
    }

    public static int a(int n2, int n3, int n4) {
        int n5 = Column.getNumTypeWidth(n2);
        int n6 = Column.getNumTypeWidth(n3);
        if (n5 == 16 || n6 == 16) {
            return 8;
        }
        if (n4 != 14) {
            if (n5 + n6 <= 4) {
                return 4;
            }
            if (n5 + n6 <= 8) {
                return -5;
            }
            if (n5 + n6 <= 16) {
                return 2;
            }
        }
        return n5 > n6 ? n2 : n3;
    }

    private static int getNumTypeWidth(int n2) {
        switch (n2) {
            case -6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 6: 
            case 7: 
            case 8: {
                return 16;
            }
            case 2: 
            case 3: {
                return 32;
            }
        }
        return 32;
    }

    static {
        a = new int[]{-6, 5, 4, -5, 2, 3, 6, 7, 8};
        c = new int[]{-7, -4, -3, -2, -1, 1, 12, 91, 92, 93, 1111};
        b = new int[][]{a, c};
        BIGDECIMAL_0 = new BigDecimal("0");
        hTypes = new Hashtable(67, 1.0f);
        hTypes.put("INTEGER", new Integer(4));
        hTypes.put("INT", new Integer(4));
        hTypes.put("int", new Integer(4));
        hTypes.put("java.lang.Integer", new Integer(4));
        hTypes.put("IDENTITY", new Integer(4));
        hTypes.put("DOUBLE", new Integer(8));
        hTypes.put("double", new Integer(8));
        hTypes.put("java.lang.Double", new Integer(8));
        hTypes.put("FLOAT", new Integer(6));
        hTypes.put("REAL", new Integer(7));
        hTypes.put("VARCHAR", new Integer(12));
        hTypes.put("java.lang.String", new Integer(12));
        hTypes.put("CHAR", new Integer(1));
        hTypes.put("CHARACTER", new Integer(1));
        hTypes.put("LONGVARCHAR", new Integer(-1));
        hTypes.put("VARCHAR_IGNORECASE", new Integer(100));
        hTypes.put("DATE", new Integer(91));
        hTypes.put("java.sql.Date", new Integer(91));
        hTypes.put("TIME", new Integer(92));
        hTypes.put("java.sql.Time", new Integer(92));
        hTypes.put("TIMESTAMP", new Integer(93));
        hTypes.put("java.sql.Timestamp", new Integer(93));
        hTypes.put("DATETIME", new Integer(93));
        hTypes.put("DECIMAL", new Integer(3));
        hTypes.put("java.math.BigDecimal", new Integer(3));
        hTypes.put("NUMERIC", new Integer(2));
        hTypes.put("BIT", new Integer(-7));
        hTypes.put("boolean", new Integer(-7));
        hTypes.put("java.lang.Boolean", new Integer(-7));
        hTypes.put("TINYINT", new Integer(-6));
        hTypes.put("byte", new Integer(-6));
        hTypes.put("java.lang.Byte", new Integer(-6));
        hTypes.put("SMALLINT", new Integer(5));
        hTypes.put("short", new Integer(5));
        hTypes.put("java.lang.Short", new Integer(5));
        hTypes.put("BIGINT", new Integer(-5));
        hTypes.put("long", new Integer(-5));
        hTypes.put("java.lang.Long", new Integer(-5));
        hTypes.put("BINARY", new Integer(-2));
        hTypes.put("B[", new Integer(-2));
        hTypes.put("VARBINARY", new Integer(-3));
        hTypes.put("LONGVARBINARY", new Integer(-4));
        hTypes.put("OTHER", new Integer(1111));
        hTypes.put("OBJECT", new Integer(1111));
        hTypes.put("java.lang.Object", new Integer(1111));
        hTypes.put("NULL", new Integer(0));
        hTypes.put("void", new Integer(0));
        hTypes.put("java.lang.Void", new Integer(0));
        i18nCollator = Collator.getInstance();
        sql_compare_in_locale = false;
    }
}

