/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.ByteArray;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;

public class BinaryDatabaseRowInput
extends DatabaseRowInput
implements DatabaseRowInputInterface {
    public BinaryDatabaseRowInput(byte[] byArray, int n2) throws IOException {
        super(byArray, n2);
    }

    public int readType() throws IOException {
        return this.readInt();
    }

    public int readIntData() throws IOException {
        return this.readInt();
    }

    public String readString() throws IOException {
        return this.readUTF();
    }

    private String readNumericString() throws IOException {
        return this.readString();
    }

    public byte[] a() throws IOException {
        byte[] byArray = new byte[this.readInt()];
        this.readFully(byArray);
        return byArray;
    }

    public boolean checkNull() throws IOException {
        return this.readInt() == 0;
    }

    public String readChar(int n2) throws IOException {
        return this.readUTF();
    }

    public Integer readSmallint() throws IOException, SQLException {
        return Integer.valueOf(this.readNumericString());
    }

    public Integer readInteger() throws IOException, SQLException {
        return new Integer(this.readIntData());
    }

    public Long readBigint() throws IOException, SQLException {
        return Long.valueOf(this.readNumericString());
    }

    public Double readReal(int n2) throws IOException, SQLException {
        if (n2 == 7) {
            return Double.valueOf(this.readNumericString());
        }
        return new Double(Double.longBitsToDouble(this.readLong()));
    }

    public BigDecimal readDecimal() throws IOException, SQLException {
        return new BigDecimal(this.readNumericString());
    }

    public Boolean readBit() throws IOException, SQLException {
        return Boolean.valueOf(this.readString());
    }

    public Time readTime() throws IOException, SQLException {
        return Time.valueOf(this.readString());
    }

    public Date readDate() throws IOException, SQLException {
        return Date.valueOf(this.readString());
    }

    public Timestamp readTimestamp() throws IOException, SQLException {
        return Timestamp.valueOf(this.readString());
    }

    public Object readOther() throws IOException, SQLException {
        String string = this.readString();
        byte[] byArray = string.equals("**") ? this.a() : ByteArray.a(string);
        return ByteArray.a(byArray);
    }

    public byte[] readBinary(int n2) throws IOException, SQLException {
        String string = this.readString();
        if (string.equals("**")) {
            return this.a();
        }
        return ByteArray.a(string);
    }
}

