/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

public class WeakHashSet {
    public HashableWeakReference[] b;
    public int elementSize = 0;
    public int c;
    public ReferenceQueue a = new ReferenceQueue();

    public WeakHashSet() {
        this(5);
    }

    public WeakHashSet(int n2) {
        this.c = n2;
        int n3 = (int)((float)n2 * 1.75f);
        if (this.c == n3) {
            ++n3;
        }
        this.b = new HashableWeakReference[n3];
    }

    public Object add(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n2 = (object.hashCode() & Integer.MAX_VALUE) % this.b.length;
        while ((hashableWeakReference = this.b[n2]) != null) {
            Object t2 = hashableWeakReference.get();
            if (object.equals(t2)) {
                return t2;
            }
            n2 = (n2 + 1) % this.b.length;
        }
        this.b[n2] = new HashableWeakReference(this, object, this.a);
        if (++this.elementSize > this.c) {
            this.rehash();
        }
        return object;
    }

    private void addValue(HashableWeakReference hashableWeakReference) {
        HashableWeakReference hashableWeakReference2;
        Object t2 = hashableWeakReference.get();
        if (t2 == null) {
            return;
        }
        int n2 = this.b.length;
        int n3 = (hashableWeakReference.hashCode & Integer.MAX_VALUE) % n2;
        while ((hashableWeakReference2 = this.b[n3]) != null) {
            if (t2.equals(hashableWeakReference2.get())) {
                return;
            }
            n3 = (n3 + 1) % n2;
        }
        this.b[n3] = hashableWeakReference;
        if (++this.elementSize > this.c) {
            this.rehash();
        }
    }

    private void cleanupGarbageCollectedValues() {
        HashableWeakReference hashableWeakReference;
        block0: while ((hashableWeakReference = (HashableWeakReference)this.a.poll()) != null) {
            HashableWeakReference hashableWeakReference2;
            int n2 = hashableWeakReference.hashCode;
            int n3 = this.b.length;
            int n4 = (n2 & Integer.MAX_VALUE) % n3;
            while ((hashableWeakReference2 = this.b[n4]) != null) {
                if (hashableWeakReference2 == hashableWeakReference) {
                    int n5;
                    int n6 = n4;
                    while ((hashableWeakReference2 = this.b[n5 = (n6 + 1) % n3]) != null && hashableWeakReference2.hashCode == n2) {
                        n6 = n5;
                    }
                    this.b[n4] = this.b[n6];
                    this.b[n6] = null;
                    --this.elementSize;
                    continue block0;
                }
                n4 = (n4 + 1) % n3;
            }
        }
    }

    public boolean contains(Object object) {
        return this.get(object) != null;
    }

    public Object get(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n2 = this.b.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((hashableWeakReference = this.b[n3]) != null) {
            Object t2 = hashableWeakReference.get();
            if (object.equals(t2)) {
                return t2;
            }
            n3 = (n3 + 1) % n2;
        }
        return null;
    }

    private void rehash() {
        WeakHashSet weakHashSet = new WeakHashSet(this.elementSize * 2);
        weakHashSet.a = this.a;
        int n2 = 0;
        int n3 = this.b.length;
        while (n2 < n3) {
            HashableWeakReference hashableWeakReference = this.b[n2];
            if (hashableWeakReference != null) {
                weakHashSet.addValue(hashableWeakReference);
            }
            ++n2;
        }
        this.b = weakHashSet.b;
        this.c = weakHashSet.c;
        this.elementSize = weakHashSet.elementSize;
    }

    public Object remove(Object object) {
        HashableWeakReference hashableWeakReference;
        this.cleanupGarbageCollectedValues();
        int n2 = this.b.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((hashableWeakReference = this.b[n3]) != null) {
            Object t2 = hashableWeakReference.get();
            if (object.equals(t2)) {
                --this.elementSize;
                this.b[n3] = null;
                this.rehash();
                return t2;
            }
            n3 = (n3 + 1) % n2;
        }
        return null;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n2 = 0;
        int n3 = this.b.length;
        while (n2 < n3) {
            Object t2;
            HashableWeakReference hashableWeakReference = this.b[n2];
            if (hashableWeakReference != null && (t2 = hashableWeakReference.get()) != null) {
                stringBuffer.append(t2.toString());
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public class HashableWeakReference
    extends WeakReference {
        public int hashCode;
        public final WeakHashSet a;

        public HashableWeakReference(WeakHashSet weakHashSet, Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this.a = weakHashSet;
            this.hashCode = object.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashableWeakReference)) {
                return false;
            }
            Object t2 = this.get();
            Object t3 = ((HashableWeakReference)object).get();
            if (t2 == null) {
                return t3 == null;
            }
            return t2.equals(t3);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            Object t2 = this.get();
            if (t2 == null) {
                return "[hashCode=" + this.hashCode + "] <referent was garbage collected>";
            }
            return "[hashCode=" + this.hashCode + "] " + t2.toString();
        }
    }
}

