/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public final class SimpleLookupTable
implements Cloneable {
    public Object[] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    public int threshold;

    public SimpleLookupTable() {
        this(13);
    }

    public SimpleLookupTable(int n2) {
        this.threshold = n2;
        int n3 = (int)((float)n2 * 1.5f);
        if (this.threshold == n3) {
            ++n3;
        }
        this.keyTable = new Object[n3];
        this.valueTable = new Object[n3];
    }

    public Object clone() throws CloneNotSupportedException {
        SimpleLookupTable simpleLookupTable = (SimpleLookupTable)super.clone();
        simpleLookupTable.elementSize = this.elementSize;
        simpleLookupTable.threshold = this.threshold;
        int n2 = this.keyTable.length;
        simpleLookupTable.keyTable = new Object[n2];
        System.arraycopy(this.keyTable, 0, simpleLookupTable.keyTable, 0, n2);
        n2 = this.valueTable.length;
        simpleLookupTable.valueTable = new Object[n2];
        System.arraycopy(this.valueTable, 0, simpleLookupTable.valueTable, 0, n2);
        return simpleLookupTable;
    }

    public boolean containsKey(Object object) {
        Object object2;
        int n2 = this.keyTable.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.keyTable[n3]) != null) {
            if (object2.equals(object)) {
                return true;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return false;
    }

    public Object get(Object object) {
        Object object2;
        int n2 = this.keyTable.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.keyTable[n3]) != null) {
            if (object2.equals(object)) {
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return null;
    }

    public Object keyForValue(Object object) {
        if (object != null) {
            int n2 = 0;
            int n3 = this.keyTable.length;
            while (n2 < n3) {
                if (this.keyTable[n2] != null && object.equals(this.valueTable[n2])) {
                    return this.keyTable[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    public Object put(Object object, Object object2) {
        Object object3;
        int n2 = this.keyTable.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object3 = this.keyTable[n3]) != null) {
            if (object3.equals(object)) {
                this.valueTable[n3] = object2;
                return this.valueTable[n3];
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        this.keyTable[n3] = object;
        this.valueTable[n3] = object2;
        if (++this.elementSize > this.threshold) {
            this.rehash();
        }
        return object2;
    }

    public Object removeKey(Object object) {
        Object object2;
        int n2 = this.keyTable.length;
        int n3 = (object.hashCode() & Integer.MAX_VALUE) % n2;
        while ((object2 = this.keyTable[n3]) != null) {
            if (object2.equals(object)) {
                --this.elementSize;
                Object object3 = this.valueTable[n3];
                this.keyTable[n3] = null;
                this.valueTable[n3] = null;
                if (this.keyTable[n3 + 1 == n2 ? 0 : n3 + 1] != null) {
                    this.rehash();
                }
                return object3;
            }
            if (++n3 != n2) continue;
            n3 = 0;
        }
        return null;
    }

    public void removeValue(Object object) {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.valueTable.length;
        while (n2 < n3) {
            Object object2 = this.valueTable[n2];
            if (object2 != null && object2.equals(object)) {
                --this.elementSize;
                this.keyTable[n2] = null;
                this.valueTable[n2] = null;
                if (!bl2 && this.keyTable[n2 + 1 == n3 ? 0 : n2 + 1] != null) {
                    bl2 = true;
                }
            }
            ++n2;
        }
        if (bl2) {
            this.rehash();
        }
    }

    private void rehash() {
        SimpleLookupTable simpleLookupTable = new SimpleLookupTable(this.elementSize * 2);
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            Object object = this.keyTable[n2];
            if (object == null) continue;
            simpleLookupTable.put(object, this.valueTable[n2]);
        }
        this.keyTable = simpleLookupTable.keyTable;
        this.valueTable = simpleLookupTable.valueTable;
        this.elementSize = simpleLookupTable.elementSize;
        this.threshold = simpleLookupTable.threshold;
    }

    public String toString() {
        String string = "";
        int n2 = 0;
        int n3 = this.valueTable.length;
        while (n2 < n3) {
            Object object = this.valueTable[n2];
            if (object != null) {
                string = String.valueOf(string) + this.keyTable[n2].toString() + " -> " + object.toString() + "\n";
            }
            ++n2;
        }
        return string;
    }
}

