/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;

public final class HashtableOfObject
implements Cloneable {
    public char[][] keyTable;
    public Object[] valueTable;
    public int elementSize = 0;
    public int a;

    public HashtableOfObject() {
        this(13);
    }

    public HashtableOfObject(int n2) {
        this.a = n2;
        int n3 = (int)((float)n2 * 1.75f);
        if (this.a == n3) {
            ++n3;
        }
        this.keyTable = new char[n3][];
        this.valueTable = new Object[n3];
    }

    public Object clone() throws CloneNotSupportedException {
        HashtableOfObject hashtableOfObject = (HashtableOfObject)super.clone();
        hashtableOfObject.elementSize = this.elementSize;
        hashtableOfObject.a = this.a;
        int n2 = this.keyTable.length;
        hashtableOfObject.keyTable = new char[n2][];
        System.arraycopy(this.keyTable, 0, hashtableOfObject.keyTable, 0, n2);
        n2 = this.valueTable.length;
        hashtableOfObject.valueTable = new Object[n2];
        System.arraycopy(this.valueTable, 0, hashtableOfObject.valueTable, 0, n2);
        return hashtableOfObject;
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return false;
    }

    public Object get(char[] cArray) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return null;
    }

    public Object put(char[] cArray, Object object) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = object;
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = object;
        if (++this.elementSize > this.a) {
            this.rehash();
        }
        return object;
    }

    public Object removeKey(char[] cArray) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                Object object = this.valueTable[n2];
                --this.elementSize;
                this.keyTable[n2] = null;
                this.valueTable[n2] = null;
                this.rehash();
                return object;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return null;
    }

    private void rehash() {
        HashtableOfObject hashtableOfObject = new HashtableOfObject(this.elementSize * 2);
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            char[] cArray = this.keyTable[n2];
            if (cArray == null) continue;
            hashtableOfObject.put(cArray, this.valueTable[n2]);
        }
        this.keyTable = hashtableOfObject.keyTable;
        this.valueTable = hashtableOfObject.valueTable;
        this.a = hashtableOfObject.a;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n2 = 0;
        int n3 = this.valueTable.length;
        while (n2 < n3) {
            Object object = this.valueTable[n2];
            if (object != null) {
                string = String.valueOf(string) + new String(this.keyTable[n2]) + " -> " + object.toString() + "\n";
            }
            ++n2;
        }
        return string;
    }
}

