/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

public class FloatUtil {
    private static final int DOUBLE_FRACTION_WIDTH = 52;
    private static final int DOUBLE_PRECISION = 53;
    private static final int MAX_DOUBLE_EXPONENT = 1023;
    private static final int MIN_NORMALIZED_DOUBLE_EXPONENT = -1022;
    private static final int MIN_UNNORMALIZED_DOUBLE_EXPONENT = -1075;
    private static final int DOUBLE_EXPONENT_BIAS = 1023;
    private static final int DOUBLE_EXPONENT_SHIFT = 52;
    private static final int SINGLE_FRACTION_WIDTH = 23;
    private static final int SINGLE_PRECISION = 24;
    private static final int MAX_SINGLE_EXPONENT = 127;
    private static final int MIN_NORMALIZED_SINGLE_EXPONENT = -126;
    private static final int MIN_UNNORMALIZED_SINGLE_EXPONENT = -150;
    private static final int SINGLE_EXPONENT_BIAS = 127;
    private static final int SINGLE_EXPONENT_SHIFT = 23;

    public static float valueOfHexFloatLiteral(char[] cArray) {
        long l2 = FloatUtil.convertHexFloatingPointLiteralToBits(cArray);
        return Float.intBitsToFloat((int)l2);
    }

    public static double valueOfHexDoubleLiteral(char[] cArray) {
        long l2 = FloatUtil.convertHexFloatingPointLiteralToBits(cArray);
        return Double.longBitsToDouble(l2);
    }

    private static long convertHexFloatingPointLiteralToBits(char[] cArray) {
        int n2;
        long l2;
        int n3;
        int n4;
        int n5;
        int n6 = cArray.length;
        long l3 = 0L;
        int n7 = 0;
        char c2 = cArray[n7];
        c2 = cArray[n7];
        if (c2 != '0') {
            throw new NumberFormatException();
        }
        c2 = cArray[++n7];
        if (c2 == 'X' || c2 == 'x') {
            ++n7;
        } else {
            throw new NumberFormatException();
        }
        int n8 = -1;
        block19: while (true) {
            c2 = cArray[n7];
            switch (c2) {
                case '0': {
                    ++n7;
                    continue block19;
                }
                case '.': {
                    n8 = n7++;
                    continue block19;
                }
            }
            break;
        }
        int n9 = 0;
        int n10 = -1;
        block20: while (true) {
            c2 = cArray[n7];
            switch (c2) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n5 = c2 - 48;
                    break;
                }
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': {
                    n5 = c2 - 97 + 10;
                    break;
                }
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': {
                    n5 = c2 - 65 + 10;
                    break;
                }
                case '.': {
                    n8 = n7++;
                    continue block20;
                }
                default: {
                    if (n8 >= 0) break block20;
                    n8 = n7;
                    break block20;
                }
            }
            if (n9 == 0) {
                n10 = n7;
                l3 = n5;
                n9 = 4;
            } else if (n9 < 60) {
                l3 <<= 4;
                l3 |= (long)n5;
                n9 += 4;
            }
            ++n7;
        }
        if ((c2 = cArray[n7]) == 'P' || c2 == 'p') {
            ++n7;
        } else {
            throw new NumberFormatException();
        }
        n5 = 0;
        int n11 = 1;
        block21: while (n7 < n6) {
            c2 = cArray[n7];
            switch (c2) {
                case '+': {
                    n11 = 1;
                    ++n7;
                    break;
                }
                case '-': {
                    n11 = -1;
                    ++n7;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    n4 = c2 - 48;
                    n5 = n5 * 10 + n4;
                    ++n7;
                    break;
                }
                default: {
                    break block21;
                }
            }
        }
        n4 = 1;
        if (n7 < n6) {
            c2 = cArray[n7];
            switch (c2) {
                case 'F': 
                case 'f': {
                    n4 = 0;
                    ++n7;
                    break;
                }
                case 'D': 
                case 'd': {
                    n4 = 1;
                    ++n7;
                    break;
                }
                default: {
                    throw new NumberFormatException();
                }
            }
        }
        if (l3 == 0L) {
            return 0L;
        }
        int n12 = 0;
        long l4 = l3 >>> n9 - 4;
        if ((l4 & 8L) == 0L) {
            --n9;
            ++n12;
            if ((l4 & 4L) == 0L) {
                --n9;
                ++n12;
                if ((l4 & 2L) == 0L) {
                    --n9;
                    ++n12;
                }
            }
        }
        long l5 = 0L;
        if (n4 != 0) {
            int n13;
            long l6;
            int n14;
            if (n9 > 53) {
                n14 = n9 - 53;
                l6 = l3 >>> n14 - 1;
                long l7 = l6 & 1L;
                l6 += l7;
                if (((l6 >>>= 1) & 0x20000000000000L) != 0L) {
                    l6 >>>= 1;
                    --n12;
                }
            } else {
                l6 = l3 << 53 - n9;
            }
            n14 = 0;
            if (n9 > 0) {
                if (n10 < n8) {
                    n14 = 4 * (n8 - n10);
                    n14 -= n12;
                } else {
                    n14 = -4 * (n10 - n8 - 1);
                    n14 -= n12;
                }
            }
            if ((n13 = n11 * n5 + n14) - 1 > 1023) {
                l5 = Double.doubleToLongBits(Double.POSITIVE_INFINITY);
            } else if (n13 - 1 >= -1022) {
                long l8 = n13 - 1 + 1023;
                l5 = l6 & 0xFFEFFFFFFFFFFFFFL;
                l5 |= l8 << 52;
            } else if (n13 - 1 > -1075) {
                long l9 = 0L;
                l5 = l6 >>> -1022 - n13 + 1;
                l5 |= l9 << 52;
            } else {
                l5 = Double.doubleToLongBits(Double.NaN);
            }
            return l5;
        }
        if (n9 > 24) {
            n3 = n9 - 24;
            l2 = l3 >>> n3 - 1;
            long l10 = l2 & 1L;
            l2 += l10;
            if (((l2 >>>= 1) & 0x1000000L) != 0L) {
                l2 >>>= 1;
                --n12;
            }
        } else {
            l2 = l3 << 24 - n9;
        }
        n3 = 0;
        if (n9 > 0) {
            if (n10 < n8) {
                n3 = 4 * (n8 - n10);
                n3 -= n12;
            } else {
                n3 = -4 * (n10 - n8 - 1);
                n3 -= n12;
            }
        }
        if ((n2 = n11 * n5 + n3) - 1 > 127) {
            l5 = Float.floatToIntBits(Float.POSITIVE_INFINITY);
        } else if (n2 - 1 >= -126) {
            long l11 = n2 - 1 + 127;
            l5 = l2 & 0xFFFFFFFFFF7FFFFFL;
            l5 |= l11 << 23;
        } else if (n2 - 1 > -150) {
            long l12 = 0L;
            l5 = l2 >>> -126 - n2 + 1;
            l5 |= l12 << 23;
        } else {
            l5 = Float.floatToIntBits(Float.NaN);
        }
        return l5;
    }
}

