/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class ProblemHandler
implements ProblemSeverities {
    public static final String[] NoArgument = new String[0];
    public final IErrorHandlingPolicy policy;
    public final IProblemFactory problemFactory;
    public final CompilerOptions options;

    public ProblemHandler(IErrorHandlingPolicy iErrorHandlingPolicy, CompilerOptions compilerOptions, IProblemFactory iProblemFactory) {
        this.policy = iErrorHandlingPolicy;
        this.problemFactory = iProblemFactory;
        this.options = compilerOptions;
    }

    public int computeSeverity(int n2) {
        return 1;
    }

    public IProblem createProblem(char[] cArray, int n2, String[] stringArray, String[] stringArray2, int n3, int n4, int n5, int n6) {
        return this.problemFactory.createProblem(cArray, n2, stringArray, stringArray2, n3, n4, n5, n6);
    }

    public void handle(int n2, String[] stringArray, String[] stringArray2, int n3, int n4, int n5, ReferenceContext referenceContext, CompilationResult compilationResult) {
        if (n3 == -1) {
            return;
        }
        if (referenceContext == null) {
            if ((n3 & 1) != 0) {
                IProblem iProblem = this.createProblem(null, n2, stringArray, stringArray2, n3, 0, 0, 0);
                throw new AbortCompilation(null, iProblem);
            }
            return;
        }
        IProblem iProblem = this.createProblem(compilationResult.getFileName(), n2, stringArray, stringArray2, n3, n4, n5, n4 >= 0 ? ProblemHandler.searchLineNumber(compilationResult.lineSeparatorPositions, n4) : 0);
        if (iProblem == null) {
            return;
        }
        switch (n3 & 1) {
            case 1: {
                this.record(iProblem, compilationResult, referenceContext);
                referenceContext.tagAsHavingErrors();
                int n6 = this.policy.stopOnFirstError() ? 2 : n3 & 0x1E;
                if (n6 == 0) break;
                referenceContext.abort(n6, iProblem);
                break;
            }
            case 0: {
                this.record(iProblem, compilationResult, referenceContext);
            }
        }
    }

    public void handle(int n2, String[] stringArray, String[] stringArray2, int n3, int n4, ReferenceContext referenceContext, CompilationResult compilationResult) {
        this.handle(n2, stringArray, stringArray2, this.computeSeverity(n2), n3, n4, referenceContext, compilationResult);
    }

    public void record(IProblem iProblem, CompilationResult compilationResult, ReferenceContext referenceContext) {
        compilationResult.record(iProblem, referenceContext);
    }

    public static final int searchLineNumber(int[] nArray, int n2) {
        if (nArray == null) {
            return 1;
        }
        int n3 = nArray.length;
        if (n3 == 0) {
            return 1;
        }
        int n4 = 0;
        int n5 = n3 - 1;
        int n6 = 0;
        while (n4 <= n5) {
            n6 = (n4 + n5) / 2;
            if (n2 < nArray[n6]) {
                n5 = n6 - 1;
                continue;
            }
            if (n2 > nArray[n6]) {
                n4 = n6 + 1;
                continue;
            }
            return n6 + 1;
        }
        if (n2 < nArray[n6]) {
            return n6 + 1;
        }
        return n6 + 2;
    }
}

