/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredMethod
extends RecoveredElement
implements CompilerModifiers,
TerminalTokens,
BaseTypes {
    public AbstractMethodDeclaration methodDeclaration;
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock methodBody;
    public boolean discardBody = true;

    public RecoveredMethod(AbstractMethodDeclaration abstractMethodDeclaration, RecoveredElement recoveredElement, int n2, Parser parser) {
        super(recoveredElement, n2, parser);
        this.methodDeclaration = abstractMethodDeclaration;
        boolean bl2 = this.foundOpeningBrace = !this.bodyStartsAtHeaderEnd();
        if (this.foundOpeningBrace) {
            ++this.bracketBalance;
        }
    }

    public RecoveredElement add(Block block, int n2) {
        if (this.methodDeclaration.declarationSourceEnd > 0 && block.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(block, n2);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.methodBody = new RecoveredBlock(block, (RecoveredElement)this, n2);
        if (block.sourceEnd == 0) {
            return this.methodBody;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], VoidBinding.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n2);
        }
        if (this.methodDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, n2);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, n2);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int n3 = 0;
                while (n3 < this.bracketBalance - 1) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                    ++n3;
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(localDeclaration, n2);
        }
        return this.methodBody.add(localDeclaration, n2, true);
    }

    public RecoveredElement add(Statement statement, int n2) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, n2);
        }
        if (this.methodBody == null) {
            Block block = new Block(0);
            block.sourceStart = this.methodDeclaration.bodyStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            if (this.bracketBalance > 0) {
                int n3 = 0;
                while (n3 < this.bracketBalance - 1) {
                    recoveredElement = recoveredElement.add(new Block(0), 1);
                    ++n3;
                }
                this.bracketBalance = 1;
            }
            return recoveredElement.add(statement, n2);
        }
        return this.methodBody.add(statement, n2, true);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.methodDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.methodDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, n2);
        }
        if ((typeDeclaration.bits & 0x100) != 0) {
            if (this.methodBody == null) {
                Block block = new Block(0);
                block.sourceStart = this.methodDeclaration.bodyStart;
                this.add(block, 1);
            }
            return this.methodBody.add(typeDeclaration, n2, true);
        }
        switch (typeDeclaration.kind()) {
            case 2: 
            case 4: {
                this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(typeDeclaration.declarationSourceStart - 1));
                if (this.parent == null) {
                    return this;
                }
                return this.parent.add(typeDeclaration, n2);
            }
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.localTypes[this.localTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return recoveredType;
    }

    public boolean bodyStartsAtHeaderEnd() {
        return this.methodDeclaration.bodyStart == this.methodDeclaration.sourceEnd + 1;
    }

    public ASTNode parseTree() {
        return this.methodDeclaration;
    }

    public int sourceEnd() {
        return this.methodDeclaration.declarationSourceEnd;
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered method:\n");
        this.methodDeclaration.print(n2 + 1, stringBuffer);
        if (this.localTypes != null) {
            int n3 = 0;
            while (n3 < this.localTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.localTypes[n3].toString(n2 + 1));
                ++n3;
            }
        }
        if (this.methodBody != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.methodBody.toString(n2 + 1));
        }
        return stringBuffer.toString();
    }

    public void updateBodyStart(int n2) {
        this.foundOpeningBrace = true;
        this.methodDeclaration.bodyStart = n2;
    }

    public AbstractMethodDeclaration updatedMethodDeclaration() {
        Block block;
        if (this.methodBody != null && (block = this.methodBody.updatedBlock()) != null) {
            this.methodDeclaration.statements = block.statements;
            if (this.methodDeclaration.isConstructor()) {
                ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.methodDeclaration;
                if (this.methodDeclaration.statements != null && this.methodDeclaration.statements[0] instanceof ExplicitConstructorCall) {
                    constructorDeclaration.constructorCall = (ExplicitConstructorCall)this.methodDeclaration.statements[0];
                    int n2 = this.methodDeclaration.statements.length;
                    this.methodDeclaration.statements = new Statement[n2 - 1];
                    System.arraycopy(this.methodDeclaration.statements, 1, this.methodDeclaration.statements, 0, n2 - 1);
                }
                if (constructorDeclaration.constructorCall == null) {
                    constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
                }
            }
        }
        if (this.localTypeCount > 0) {
            this.methodDeclaration.bits |= 2;
        }
        return this.methodDeclaration;
    }

    public void updateFromParserState() {
        if (this.bodyStartsAtHeaderEnd() && this.parent != null) {
            Parser parser = this.parser();
            if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                if (this.methodDeclaration.sourceEnd == parser.rParenPos) {
                    boolean bl2;
                    int n2 = parser.astLengthStack[parser.astLengthPtr];
                    int n3 = parser.astPtr - n2;
                    boolean bl3 = bl2 = n3 >= 0;
                    if (bl2) {
                        if (!(parser.astStack[n3] instanceof AbstractMethodDeclaration)) {
                            bl2 = false;
                        }
                        int n4 = 1;
                        int n5 = n2 + 1;
                        while (n4 < n5) {
                            if (!(parser.astStack[n3 + n4] instanceof TypeReference)) {
                                bl2 = false;
                            }
                            ++n4;
                        }
                    }
                    if (bl2) {
                        parser.consumeMethodHeaderThrowsClause();
                    } else {
                        parser.listLength = 0;
                    }
                } else {
                    if (parser.currentToken == 28 || parser.currentToken == 27) {
                        int n6 = parser.astLengthPtr;
                        parser.astLengthStack[n6] = parser.astLengthStack[n6] - 1;
                        --parser.astPtr;
                        --parser.listLength;
                        parser.currentToken = 0;
                    }
                    int n7 = parser.astLengthStack[parser.astLengthPtr];
                    int n8 = parser.astPtr - n7 + 1;
                    boolean bl4 = parser.rParenPos < parser.lParenPos;
                    MemberValuePair[] memberValuePairArray = null;
                    if (n7 > 0 && parser.astStack[parser.astPtr] instanceof MemberValuePair) {
                        memberValuePairArray = new MemberValuePair[n7];
                        System.arraycopy(parser.astStack, n8, memberValuePairArray, 0, n7);
                        --parser.astLengthPtr;
                        parser.astPtr -= n7;
                        n7 = parser.astLengthStack[parser.astLengthPtr];
                        n8 = parser.astPtr - n7 + 1;
                        bl4 = true;
                    }
                    int n9 = 0;
                    while (n9 < n7) {
                        ASTNode aSTNode = parser.astStack[n8 + n9];
                        if (aSTNode instanceof Argument) {
                            Argument argument = (Argument)aSTNode;
                            char[][] cArray = argument.type.getTypeName();
                            if ((argument.modifiers & 0xFFFFFFEF) != 0 || cArray.length == 1 && CharOperation.equals(cArray[0], VoidBinding.sourceName())) {
                                parser.astLengthStack[parser.astLengthPtr] = n9;
                                parser.astPtr = n8 + n9 - 1;
                                parser.listLength = n9;
                                parser.currentToken = 0;
                                break;
                            }
                            if (bl4) {
                                parser.rParenPos = argument.sourceEnd + 1;
                            }
                        } else {
                            parser.astLengthStack[parser.astLengthPtr] = n9;
                            parser.astPtr = n8 + n9 - 1;
                            parser.listLength = n9;
                            parser.currentToken = 0;
                            break;
                        }
                        ++n9;
                    }
                    if (parser.listLength > 0 && parser.astLengthPtr > 0) {
                        boolean bl5;
                        int n10 = parser.astLengthStack[parser.astLengthPtr];
                        int n11 = parser.astPtr - n10;
                        boolean bl6 = bl5 = n11 >= 0;
                        if (bl5) {
                            if (!(parser.astStack[n11] instanceof AbstractMethodDeclaration)) {
                                bl5 = false;
                            }
                            int n12 = 1;
                            int n13 = n10 + 1;
                            while (n12 < n13) {
                                if (!(parser.astStack[n11 + n12] instanceof Argument)) {
                                    bl5 = false;
                                }
                                ++n12;
                            }
                        }
                        if (bl5) {
                            parser.consumeMethodHeaderRightParen();
                            if (parser.currentElement == this) {
                                this.methodDeclaration.sourceEnd = this.methodDeclaration.arguments[this.methodDeclaration.arguments.length - 1].sourceEnd;
                                parser.lastCheckPoint = this.methodDeclaration.bodyStart = this.methodDeclaration.sourceEnd + 1;
                            }
                        }
                    }
                    if (memberValuePairArray != null) {
                        System.arraycopy(memberValuePairArray, 0, parser.astStack, parser.astPtr + 1, memberValuePairArray.length);
                        parser.astPtr += memberValuePairArray.length;
                        parser.astLengthStack[++parser.astLengthPtr] = memberValuePairArray.length;
                    }
                }
            }
        }
    }

    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (this.methodDeclaration.isAnnotationMethod()) {
            this.updateSourceEndIfNecessary(n2, n3);
            if (!this.foundOpeningBrace && this.parent != null) {
                return this.parent.updateOnClosingBrace(n2, n3);
            }
            return this;
        }
        return super.updateOnClosingBrace(n2, n3);
    }

    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        if (this.bracketBalance == 0) {
            switch (this.parser().lastIgnoredToken) {
                case -1: 
                case 105: {
                    break;
                }
                default: {
                    this.foundOpeningBrace = true;
                    this.bracketBalance = 1;
                }
            }
        }
        return super.updateOnOpeningBrace(n2, n3);
    }

    public void updateParseTree() {
        this.updatedMethodDeclaration();
    }

    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.methodDeclaration.declarationSourceEnd == 0) {
            if (this.parser().rBraceSuccessorStart >= n3) {
                this.methodDeclaration.declarationSourceEnd = this.parser().rBraceEnd;
                this.methodDeclaration.bodyEnd = this.parser().rBraceStart;
            } else {
                this.methodDeclaration.declarationSourceEnd = n3;
                this.methodDeclaration.bodyEnd = n2 - 1;
            }
        }
    }
}

