/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredBlock;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredField;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredInitializer
extends RecoveredField
implements CompilerModifiers,
TerminalTokens,
BaseTypes {
    public RecoveredType[] localTypes;
    public int localTypeCount;
    public RecoveredBlock initializerBody;

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2) {
        this(fieldDeclaration, recoveredElement, n2, null);
    }

    public RecoveredInitializer(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2, Parser parser) {
        super(fieldDeclaration, recoveredElement, n2, parser);
        this.foundOpeningBrace = true;
    }

    public RecoveredElement add(Block block, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd > 0 && block.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(block, n2);
        }
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        this.initializerBody = new RecoveredBlock(block, (RecoveredElement)this, n2);
        if (block.sourceEnd == 0) {
            return this.initializerBody;
        }
        return this;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], VoidBinding.sourceName())) {
            if (this.parent == null) {
                return this;
            }
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n2);
        }
        if (this.fieldDeclaration.declarationSourceEnd > 0 && fieldDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(fieldDeclaration, n2);
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && localDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(localDeclaration, n2);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement recoveredElement = this.add(block, 1);
        return recoveredElement.add(localDeclaration, n2);
    }

    public RecoveredElement add(Statement statement, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && statement.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(statement, n2);
        }
        Block block = new Block(0);
        block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
        RecoveredElement recoveredElement = this.add(block, 1);
        return recoveredElement.add(statement, n2);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.declarationSourceStart > this.fieldDeclaration.declarationSourceEnd) {
            if (this.parent == null) {
                return this;
            }
            return this.parent.add(typeDeclaration, n2);
        }
        if ((typeDeclaration.bits & 0x100) != 0) {
            Block block = new Block(0);
            block.sourceStart = ((Initializer)this.fieldDeclaration).sourceStart;
            RecoveredElement recoveredElement = this.add(block, 1);
            return recoveredElement.add(typeDeclaration, n2);
        }
        if (this.localTypes == null) {
            this.localTypes = new RecoveredType[5];
            this.localTypeCount = 0;
        } else if (this.localTypeCount == this.localTypes.length) {
            this.localTypes = new RecoveredType[2 * this.localTypeCount];
            System.arraycopy(this.localTypes, 0, this.localTypes, 0, this.localTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.localTypes[this.localTypeCount++] = recoveredType;
        if (!this.foundOpeningBrace) {
            this.foundOpeningBrace = true;
            ++this.bracketBalance;
        }
        return recoveredType;
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered initializer:\n");
        this.fieldDeclaration.print(n2 + 1, stringBuffer);
        if (this.initializerBody != null) {
            stringBuffer.append("\n");
            stringBuffer.append(this.initializerBody.toString(n2 + 1));
        }
        return stringBuffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.initializerBody != null) {
            Block block = this.initializerBody.updatedBlock();
            if (block != null) {
                ((Initializer)this.fieldDeclaration).block = block;
            }
            if (this.localTypeCount > 0) {
                this.fieldDeclaration.bits |= 2;
            }
        }
        if (this.fieldDeclaration.sourceEnd == 0) {
            this.fieldDeclaration.sourceEnd = this.fieldDeclaration.declarationSourceEnd;
        }
        return this.fieldDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n2, n3);
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        ++this.bracketBalance;
        return this;
    }

    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            Initializer initializer = (Initializer)this.fieldDeclaration;
            if (this.parser().rBraceSuccessorStart >= n3) {
                initializer.declarationSourceEnd = initializer.bodyStart < this.parser().rBraceEnd ? this.parser().rBraceEnd : initializer.bodyStart;
                initializer.bodyEnd = initializer.bodyStart < this.parser().rBraceStart ? this.parser().rBraceStart : initializer.bodyStart;
            } else {
                initializer.declarationSourceEnd = n3;
                initializer.bodyEnd = n2 - 1;
            }
            if (initializer.block != null) {
                initializer.block.sourceEnd = initializer.declarationSourceEnd;
            }
        }
    }
}

