/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;

public class RecoveredField
extends RecoveredElement {
    public FieldDeclaration fieldDeclaration;
    public boolean a;
    public RecoveredType[] anonymousTypes;
    public int anonymousTypeCount;

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2) {
        this(fieldDeclaration, recoveredElement, n2, null);
    }

    public RecoveredField(FieldDeclaration fieldDeclaration, RecoveredElement recoveredElement, int n2, Parser parser) {
        super(recoveredElement, n2, parser);
        this.fieldDeclaration = fieldDeclaration;
        this.a = fieldDeclaration.initialization != null;
    }

    public RecoveredElement add(Statement statement, int n2) {
        if (this.a || !(statement instanceof Expression)) {
            return super.add(statement, n2);
        }
        this.a = true;
        this.fieldDeclaration.initialization = (Expression)statement;
        this.fieldDeclaration.declarationSourceEnd = statement.sourceEnd;
        this.fieldDeclaration.declarationEnd = statement.sourceEnd;
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        if (this.a || (typeDeclaration.bits & 0x200) == 0 || this.fieldDeclaration.declarationSourceEnd != 0 && typeDeclaration.sourceStart > this.fieldDeclaration.declarationSourceEnd) {
            return super.add(typeDeclaration, n2);
        }
        if (this.anonymousTypes == null) {
            this.anonymousTypes = new RecoveredType[5];
            this.anonymousTypeCount = 0;
        } else if (this.anonymousTypeCount == this.anonymousTypes.length) {
            this.anonymousTypes = new RecoveredType[2 * this.anonymousTypeCount];
            System.arraycopy(this.anonymousTypes, 0, this.anonymousTypes, 0, this.anonymousTypeCount);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.anonymousTypes[this.anonymousTypeCount++] = recoveredType;
        return recoveredType;
    }

    public ASTNode parseTree() {
        return this.fieldDeclaration;
    }

    public int sourceEnd() {
        return this.fieldDeclaration.declarationSourceEnd;
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered field:\n");
        this.fieldDeclaration.print(n2 + 1, stringBuffer);
        if (this.anonymousTypes != null) {
            int n3 = 0;
            while (n3 < this.anonymousTypeCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.anonymousTypes[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public FieldDeclaration updatedFieldDeclaration() {
        if (this.anonymousTypes != null) {
            if (this.fieldDeclaration.initialization == null) {
                int n2 = 0;
                while (n2 < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[n2];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    if (recoveredType.preserveContent) {
                        this.fieldDeclaration.initialization = recoveredType.updatedTypeDeclaration().allocation;
                    }
                    ++n2;
                }
                if (this.anonymousTypeCount > 0) {
                    this.fieldDeclaration.bits |= 2;
                }
            } else if (this.fieldDeclaration.getKind() == 3) {
                int n3 = 0;
                while (n3 < this.anonymousTypeCount) {
                    RecoveredType recoveredType = this.anonymousTypes[n3];
                    TypeDeclaration typeDeclaration = recoveredType.typeDeclaration;
                    if (typeDeclaration.declarationSourceEnd == 0) {
                        typeDeclaration.declarationSourceEnd = this.fieldDeclaration.declarationSourceEnd;
                        typeDeclaration.bodyEnd = this.fieldDeclaration.declarationSourceEnd;
                    }
                    recoveredType.updatedTypeDeclaration();
                    ++n3;
                }
            }
        }
        return this.fieldDeclaration;
    }

    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (this.bracketBalance > 0) {
            --this.bracketBalance;
            if (this.bracketBalance == 0) {
                if (this.fieldDeclaration.getKind() == 3) {
                    this.updateSourceEndIfNecessary(n3 - 1);
                    return this.parent;
                }
                this.a = true;
            }
            return this;
        }
        if (this.bracketBalance == 0) {
            this.a = true;
            this.updateSourceEndIfNecessary(n3 - 1);
        }
        if (this.parent != null) {
            return this.parent.updateOnClosingBrace(n2, n3);
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        if (this.fieldDeclaration.declarationSourceEnd == 0 && this.fieldDeclaration.type instanceof ArrayTypeReference && !this.a) {
            ++this.bracketBalance;
            return null;
        }
        if (this.fieldDeclaration.declarationSourceEnd == 0 && this.fieldDeclaration.getKind() == 3) {
            ++this.bracketBalance;
            return null;
        }
        this.updateSourceEndIfNecessary(n2 - 1, n3 - 1);
        return this.parent.updateOnOpeningBrace(n2, n3);
    }

    public void updateParseTree() {
        this.updatedFieldDeclaration();
    }

    public void updateSourceEndIfNecessary(int n2, int n3) {
        if (this.fieldDeclaration.declarationSourceEnd == 0) {
            this.fieldDeclaration.declarationSourceEnd = n3;
            this.fieldDeclaration.declarationEnd = n3;
        }
    }
}

