/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;

public class SignatureWrapper {
    public char[] signature;
    public int start;
    public int end;
    public int bracket;

    public SignatureWrapper(char[] cArray) {
        this.signature = cArray;
        this.start = 0;
        this.bracket = -1;
        this.end = -1;
    }

    public boolean atEnd() {
        return this.start < 0 || this.start >= this.signature.length;
    }

    public int computeEnd() {
        int n2 = this.start;
        while (this.signature[n2] == '[') {
            ++n2;
        }
        switch (this.signature[n2]) {
            case 'L': 
            case 'T': {
                this.end = CharOperation.indexOf(';', this.signature, this.start);
                if (this.bracket <= this.start) {
                    this.bracket = CharOperation.indexOf('<', this.signature, this.start);
                }
                if (this.bracket > this.start && this.bracket < this.end) {
                    this.end = this.bracket;
                    break;
                }
                if (this.end != -1) break;
                this.end = this.signature.length + 1;
                break;
            }
            default: {
                this.end = this.start;
            }
        }
        this.start = this.end + 1;
        return this.end;
    }

    public char[] nextWord() {
        this.end = CharOperation.indexOf(';', this.signature, this.start);
        if (this.bracket <= this.start) {
            this.bracket = CharOperation.indexOf('<', this.signature, this.start);
        }
        int n2 = CharOperation.indexOf('.', this.signature, this.start);
        if (this.bracket > this.start && this.bracket < this.end) {
            this.end = this.bracket;
        }
        if (n2 > this.start && n2 < this.end) {
            this.end = n2;
        }
        this.start = this.end;
        return CharOperation.subarray(this.signature, this.start, this.start);
    }

    public String toString() {
        return String.valueOf(new String(this.signature)) + " @ " + this.start;
    }
}

