/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.codegen.ObjectCache;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ExceptionHandlingFlowContext
extends FlowContext {
    public ReferenceBinding[] handledExceptions;
    public static final int BitCacheSize = 32;
    public int[] c;
    public int[] d;
    public UnconditionalFlowInfo[] a;
    public ObjectCache b = new ObjectCache();
    public boolean e;
    public UnconditionalFlowInfo initsOnReturn;
    public ArrayList extendedExceptions;

    public ExceptionHandlingFlowContext(FlowContext flowContext, ASTNode aSTNode, ReferenceBinding[] referenceBindingArray, BlockScope blockScope, UnconditionalFlowInfo unconditionalFlowInfo) {
        super(flowContext, aSTNode);
        this.e = blockScope == blockScope.methodScope();
        this.handledExceptions = referenceBindingArray;
        int n2 = referenceBindingArray.length;
        int n3 = n2 / 32 + 1;
        this.c = new int[n3];
        this.d = new int[n3];
        this.a = new UnconditionalFlowInfo[n2];
        int n4 = 0;
        while (n4 < n2) {
            this.b.put(referenceBindingArray[n4], n4);
            int n5 = n4 / 32;
            int n6 = 1 << n4 % 32;
            if (referenceBindingArray[n4].isUncheckedException(true)) {
                int n7 = n5;
                this.c[n7] = this.c[n7] | n6;
                this.a[n4] = unconditionalFlowInfo.copy().unconditionalInits();
            } else {
                this.a[n4] = FlowInfo.DEAD_END;
            }
            ++n4;
        }
        System.arraycopy(this.c, 0, this.d, 0, n3);
        this.initsOnReturn = FlowInfo.DEAD_END;
    }

    public void complainIfUnusedExceptionHandlers(AbstractMethodDeclaration abstractMethodDeclaration) {
        MethodScope methodScope = abstractMethodDeclaration.scope;
        if ((abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0 && !methodScope.compilerOptions().reportUnusedDeclaredThrownExceptionWhenOverriding) {
            return;
        }
        int n2 = 0;
        int n3 = this.handledExceptions.length;
        while (n2 < n3) {
            int n4;
            int n5 = this.b.get(this.handledExceptions[n2]);
            int n6 = n5 / 32;
            if ((this.c[n6] & (n4 = 1 << n5 % 32)) == 0) {
                methodScope.problemReporter().unusedDeclaredThrownException(this.handledExceptions[n5], abstractMethodDeclaration, abstractMethodDeclaration.thrownExceptions[n5]);
            }
            ++n2;
        }
    }

    public void complainIfUnusedExceptionHandlers(BlockScope blockScope, TryStatement tryStatement) {
        int n2 = 0;
        int n3 = this.handledExceptions.length;
        while (n2 < n3) {
            int n4;
            int n5 = this.b.get(this.handledExceptions[n2]);
            int n6 = n5 / 32;
            if ((this.c[n6] & (n4 = 1 << n5 % 32)) == 0) {
                blockScope.problemReporter().unreachableCatchBlock(this.handledExceptions[n5], tryStatement.catchArguments[n5].type);
            } else if ((this.d[n6] & n4) == 0) {
                blockScope.problemReporter().hiddenCatchBlock(this.handledExceptions[n5], tryStatement.catchArguments[n5].type);
            }
            ++n2;
        }
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Exception flow context");
        int n2 = this.handledExceptions.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 / 32;
            int n5 = 1 << n3 % 32;
            stringBuffer.append('[').append(this.handledExceptions[n3].readableName());
            if ((this.c[n4] & n5) != 0) {
                if ((this.d[n4] & n5) == 0) {
                    stringBuffer.append("-masked");
                } else {
                    stringBuffer.append("-reached");
                }
            } else {
                stringBuffer.append("-not reached");
            }
            stringBuffer.append('-').append(this.a[n3].toString()).append(']');
            ++n3;
        }
        stringBuffer.append("[initsOnReturn -").append(this.initsOnReturn.toString()).append(']');
        return stringBuffer.toString();
    }

    public UnconditionalFlowInfo initsOnException(ReferenceBinding referenceBinding) {
        int n2 = this.b.get(referenceBinding);
        if (n2 < 0) {
            return FlowInfo.DEAD_END;
        }
        return this.a[n2];
    }

    public UnconditionalFlowInfo initsOnReturn() {
        return this.initsOnReturn;
    }

    public void recordHandlingException(ReferenceBinding referenceBinding, UnconditionalFlowInfo unconditionalFlowInfo, TypeBinding typeBinding, ASTNode aSTNode, boolean bl2) {
        int n2 = this.b.get(referenceBinding);
        int n3 = n2 / 32;
        int n4 = 1 << n2 % 32;
        if (!bl2) {
            int n5 = n3;
            this.d[n5] = this.d[n5] | n4;
        }
        int n6 = n3;
        this.c[n6] = this.c[n6] | n4;
        this.a[n2] = this.a[n2] == FlowInfo.DEAD_END ? unconditionalFlowInfo.copy().unconditionalInits() : this.a[n2].mergedWith(unconditionalFlowInfo.copy().unconditionalInits());
    }

    public void recordReturnFrom(FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        this.initsOnReturn = this.initsOnReturn == FlowInfo.DEAD_END ? flowInfo.copy().unconditionalInits() : this.initsOnReturn.mergedWith(flowInfo.copy().unconditionalInits());
    }

    public void mergeUnhandledException(TypeBinding typeBinding) {
        int n2;
        if (this.extendedExceptions == null) {
            this.extendedExceptions = new ArrayList(5);
            n2 = 0;
            while (n2 < this.handledExceptions.length) {
                this.extendedExceptions.add(this.handledExceptions[n2]);
                ++n2;
            }
        }
        n2 = 0;
        int n3 = this.extendedExceptions.size() - 1;
        while (n3 >= 0) {
            switch (Scope.compareTypes(typeBinding, (TypeBinding)this.extendedExceptions.get(n3))) {
                case 1: {
                    this.extendedExceptions.remove(n3);
                    break;
                }
                case -1: {
                    n2 = 1;
                    break;
                }
            }
            --n3;
        }
        if (n2 == 0) {
            this.extendedExceptions.add(typeBinding);
        }
    }
}

