/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class DoubleCache {
    private double[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public DoubleCache() {
        this(13);
    }

    public DoubleCache(int n2) {
        this.keyTable = new double[n2];
        this.valueTable = new int[n2];
    }

    public void clear() {
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            this.keyTable[n2] = 0.0;
            this.valueTable[n2] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(double d2) {
        if (d2 == 0.0) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0) {
                    long l2 = Double.doubleToLongBits(d2);
                    long l3 = Double.doubleToLongBits(this.keyTable[n2]);
                    if (l2 == Long.MIN_VALUE && l3 == Long.MIN_VALUE) {
                        return true;
                    }
                    if (l2 == 0L && l3 == 0L) {
                        return true;
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = this.elementSize;
            while (n4 < n5) {
                if (this.keyTable[n4] == d2) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    public int get(double d2) {
        if (d2 == 0.0) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0) {
                    long l2 = Double.doubleToLongBits(d2);
                    long l3 = Double.doubleToLongBits(this.keyTable[n2]);
                    if (l2 == Long.MIN_VALUE && l3 == Long.MIN_VALUE) {
                        return this.valueTable[n2];
                    }
                    if (l2 == 0L && l3 == 0L) {
                        return this.valueTable[n2];
                    }
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = this.elementSize;
            while (n4 < n5) {
                if (this.keyTable[n4] == d2) {
                    return this.valueTable[n4];
                }
                ++n4;
            }
        }
        return -1;
    }

    public int put(double d2, int n2) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new double[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = d2;
        this.valueTable[this.elementSize] = n2;
        ++this.elementSize;
        return n2;
    }

    public String toString() {
        int n2 = this.elementSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n3 = 0;
        while (n3 < n2) {
            if (this.keyTable[n3] != 0.0 || this.keyTable[n3] == 0.0 && this.valueTable[n3] != 0) {
                stringBuffer.append(this.keyTable[n3]).append("->").append(this.valueTable[n3]);
            }
            if (n3 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

