/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

import org.eclipse.jdt.core.compiler.CharOperation;

public class CharArrayCache {
    public char[][] keyTable;
    public int[] valueTable;
    public int a = 0;
    public int b;

    public CharArrayCache() {
        this(13);
    }

    public CharArrayCache(int n2) {
        this.b = (int)((float)n2 * 0.66f);
        this.keyTable = new char[n2][];
        this.valueTable = new int[n2];
    }

    public void clear() {
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            this.keyTable[n2] = null;
            this.valueTable[n2] = 0;
        }
        this.a = 0;
    }

    public boolean containsKey(char[] cArray) {
        int n2 = this.hashCodeChar(cArray);
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                return true;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(char[] cArray) {
        int n2 = this.hashCodeChar(cArray);
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return -1;
    }

    private int hashCodeChar(char[] cArray) {
        int n2 = cArray.length;
        int n3 = 0;
        int n4 = 2;
        int n5 = 0;
        while (n5 < n2) {
            n3 += cArray[n5];
            n5 += n4;
        }
        return (n3 & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(char[] cArray, int n2) {
        int n3 = this.hashCodeChar(cArray);
        while (this.keyTable[n3] != null) {
            if (CharOperation.equals(this.keyTable[n3], cArray)) {
                this.valueTable[n3] = n2;
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        this.keyTable[n3] = cArray;
        this.valueTable[n3] = n2;
        if (++this.a > this.b) {
            this.rehash();
        }
        return n2;
    }

    private void rehash() {
        CharArrayCache charArrayCache = new CharArrayCache(this.keyTable.length * 2);
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            if (this.keyTable[n2] == null) continue;
            charArrayCache.put(this.keyTable[n2], this.valueTable[n2]);
        }
        this.keyTable = charArrayCache.keyTable;
        this.valueTable = charArrayCache.valueTable;
        this.b = charArrayCache.b;
    }

    public void remove(char[] cArray) {
        int n2 = this.hashCodeChar(cArray);
        while (this.keyTable[n2] != null) {
            if (CharOperation.equals(this.keyTable[n2], cArray)) {
                this.valueTable[n2] = 0;
                this.keyTable[n2] = null;
                return;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
    }

    public char[] returnKeyFor(int n2) {
        int n3 = this.keyTable.length;
        while (n3-- > 0) {
            if (this.valueTable[n3] != n2) continue;
            return this.keyTable[n3];
        }
        return null;
    }

    public int size() {
        return this.a;
    }

    public String toString() {
        int n2 = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n3 = 0;
        while (n3 < n2) {
            if (this.keyTable[n3] != null) {
                stringBuffer.append(this.keyTable[n3]).append("->").append(this.valueTable[n3]);
            }
            if (n3 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

