/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.util.Util;

public class FieldInfo
extends ClassFileStruct
implements AttributeNamesConstants,
IBinaryField,
Comparable,
TypeIds {
    private int accessFlags;
    private int attributeBytes;
    private Constant constant;
    private int[] constantPoolOffsets;
    private char[] descriptor;
    private char[] name;
    private char[] signature;
    private int signatureUtf8Offset;
    private long tagBits;
    private Object wrappedConstantValue;

    public FieldInfo(byte[] byArray, int[] nArray, int n2) {
        super(byArray, n2);
        this.constantPoolOffsets = nArray;
        this.accessFlags = -1;
        int n3 = this.u2At(6);
        int n4 = 8;
        this.signatureUtf8Offset = -1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = this.constantPoolOffsets[this.u2At(n4)] - this.a;
            char[] cArray = this.utf8At(n6 + 3, this.u2At(n6 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        this.signatureUtf8Offset = this.constantPoolOffsets[this.u2At(n4 + 6)] - this.a;
                        break;
                    }
                    case 'R': {
                        if (!CharOperation.equals(cArray, RuntimeVisibleAnnotationsName)) break;
                        this.decodeStandardAnnotations(n4);
                    }
                }
            }
            n4 = (int)((long)n4 + (6L + this.u4At(n4 + 2)));
            ++n5;
        }
        this.attributeBytes = n4;
    }

    public int compareTo(Object object) {
        if (!(object instanceof FieldInfo)) {
            throw new ClassCastException();
        }
        return new String(this.getName()).compareTo(new String(((FieldInfo)object).getName()));
    }

    private int decodeAnnotation(int n2) {
        int n3 = n2;
        int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.a;
        char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
        int n5 = this.u2At(n2 + 2);
        n3 += 4;
        if (cArray.length == 22 && CharOperation.equals(cArray, ConstantPool.JAVA_LANG_DEPRECATED)) {
            this.tagBits |= 0x200000000000L;
            return n3;
        }
        int n6 = 0;
        while (n6 < n5) {
            n3 += 2;
            n3 = this.decodeElementValue(n3);
            ++n6;
        }
        return n3;
    }

    private int decodeElementValue(int n2) {
        int n3 = n2;
        int n4 = this.u1At(n3);
        ++n3;
        switch (n4) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n3 += 2;
                break;
            }
            case 101: {
                n3 += 4;
                break;
            }
            case 99: {
                n3 += 2;
                break;
            }
            case 64: {
                n3 = this.decodeAnnotation(n3);
                break;
            }
            case 91: {
                int n5 = this.u2At(n3);
                n3 += 2;
                int n6 = 0;
                while (n6 < n5) {
                    n3 = this.decodeElementValue(n3);
                    ++n6;
                }
                break;
            }
        }
        return n3;
    }

    private void decodeStandardAnnotations(int n2) {
        int n3 = this.u2At(n2 + 6);
        int n4 = n2 + 8;
        int n5 = 0;
        while (n5 < n3) {
            n4 = this.decodeAnnotation(n4);
            ++n5;
        }
    }

    public Constant getConstant() {
        if (this.constant == null) {
            this.readConstantAttribute();
        }
        return this.constant;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public char[] getName() {
        if (this.name == null) {
            int n2 = this.constantPoolOffsets[this.u2At(2)] - this.a;
            this.name = this.utf8At(n2 + 3, this.u2At(n2 + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public char[] getTypeName() {
        if (this.descriptor == null) {
            int n2 = this.constantPoolOffsets[this.u2At(4)] - this.a;
            this.descriptor = this.utf8At(n2 + 3, this.u2At(n2 + 1));
        }
        return this.descriptor;
    }

    public Object getWrappedConstantValue() {
        if (this.wrappedConstantValue == null && this.hasConstant()) {
            Constant constant = this.getConstant();
            switch (constant.typeID()) {
                case 10: {
                    this.wrappedConstantValue = new Integer(constant.intValue());
                    break;
                }
                case 3: {
                    this.wrappedConstantValue = new Byte(constant.byteValue());
                    break;
                }
                case 4: {
                    this.wrappedConstantValue = new Short(constant.shortValue());
                    break;
                }
                case 2: {
                    this.wrappedConstantValue = new Character(constant.charValue());
                    break;
                }
                case 9: {
                    this.wrappedConstantValue = new Float(constant.floatValue());
                    break;
                }
                case 8: {
                    this.wrappedConstantValue = new Double(constant.doubleValue());
                    break;
                }
                case 5: {
                    this.wrappedConstantValue = Util.toBoolean(constant.booleanValue());
                    break;
                }
                case 7: {
                    this.wrappedConstantValue = new Long(constant.longValue());
                    break;
                }
                case 11: {
                    this.wrappedConstantValue = constant.stringValue();
                }
            }
        }
        return this.wrappedConstantValue;
    }

    public boolean hasConstant() {
        return this.getConstant() != Constant.NotAConstant;
    }

    public void a() {
        this.getModifiers();
        this.getName();
        this.getConstant();
        this.getTypeName();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readConstantAttribute() {
        int n2 = this.u2At(6);
        int n3 = 8;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.constantPoolOffsets[this.u2At(n3)] - this.a;
            char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
            if (CharOperation.equals(cArray, ConstantValueName)) {
                bl2 = true;
                int n6 = this.constantPoolOffsets[this.u2At(n3 + 6)] - this.a;
                block0 : switch (this.u1At(n6)) {
                    case 3: {
                        char[] cArray2 = this.getTypeName();
                        if (cArray2.length == 1) {
                            switch (cArray2[0]) {
                                case 'Z': {
                                    this.constant = new BooleanConstant(this.i4At(n6 + 1) == 1);
                                    break block0;
                                }
                                case 'I': {
                                    this.constant = new IntConstant(this.i4At(n6 + 1));
                                    break block0;
                                }
                                case 'C': {
                                    this.constant = new CharConstant((char)this.i4At(n6 + 1));
                                    break block0;
                                }
                                case 'B': {
                                    this.constant = new ByteConstant((byte)this.i4At(n6 + 1));
                                    break block0;
                                }
                                case 'S': {
                                    this.constant = new ShortConstant((short)this.i4At(n6 + 1));
                                    break block0;
                                }
                            }
                            this.constant = Constant.NotAConstant;
                            break;
                        }
                        this.constant = Constant.NotAConstant;
                        break;
                    }
                    case 4: {
                        this.constant = new FloatConstant(this.floatAt(n6 + 1));
                        break;
                    }
                    case 6: {
                        this.constant = new DoubleConstant(this.doubleAt(n6 + 1));
                        break;
                    }
                    case 5: {
                        this.constant = new LongConstant(this.i8At(n6 + 1));
                        break;
                    }
                    case 8: {
                        n5 = this.constantPoolOffsets[this.u2At(n6 + 1)] - this.a;
                        this.constant = new StringConstant(String.valueOf(this.utf8At(n5 + 3, this.u2At(n5 + 1))));
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + this.u4At(n3 + 2)));
            ++n4;
        }
        if (!bl2) {
            this.constant = Constant.NotAConstant;
        }
    }

    private void readModifierRelatedAttributes() {
        int n2 = this.u2At(6);
        int n3 = 8;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.constantPoolOffsets[this.u2At(n3)] - this.a;
            char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
            if (cArray.length != 0) {
                switch (cArray[0]) {
                    case 'D': {
                        if (!CharOperation.equals(cArray, DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(cArray, SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + this.u4At(n3 + 2)));
            ++n4;
        }
    }

    public void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public void throwFormatException() throws ClassFormatException {
        throw new ClassFormatException(17);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        int n2 = this.getModifiers();
        return stringBuffer.append("{").append(String.valueOf((n2 & 0x100000) != 0 ? "deprecated " : "") + ((n2 & 1) == 1 ? "public " : "") + ((n2 & 2) == 2 ? "private " : "") + ((n2 & 4) == 4 ? "protected " : "") + ((n2 & 8) == 8 ? "static " : "") + ((n2 & 0x10) == 16 ? "final " : "") + ((n2 & 0x40) == 64 ? "volatile " : "") + ((n2 & 0x80) == 128 ? "transient " : "")).append(this.getTypeName()).append(" ").append(this.getName()).append(" ").append(this.getConstant()).append("}").toString();
    }
}

