/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.classfmt.FieldInfo;
import org.eclipse.jdt.internal.compiler.classfmt.InnerClassInfo;
import org.eclipse.jdt.internal.compiler.classfmt.MethodInfo;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.util.Util;

public class ClassFileReader
extends ClassFileStruct
implements AttributeNamesConstants,
IBinaryType {
    private int accessFlags;
    private char[] classFileName;
    private char[] className;
    private int classNameIndex;
    private int constantPoolCount;
    private int[] constantPoolOffsets;
    private FieldInfo[] fields;
    private int fieldsCount;
    private InnerClassInfo innerInfo;
    private int innerInfoIndex;
    private InnerClassInfo[] innerInfos;
    private char[][] interfaceNames;
    private int interfacesCount;
    private MethodInfo[] methods;
    private int methodsCount;
    private char[] signature;
    private char[] sourceFileName;
    private char[] superclassName;
    private long tagBits;
    private long version;

    public static ClassFileReader read(File file) throws ClassFormatException, IOException {
        return ClassFileReader.read(file, false);
    }

    public static ClassFileReader read(File file, boolean bl2) throws ClassFormatException, IOException {
        byte[] byArray = Util.getFileByteContent(file);
        ClassFileReader classFileReader = new ClassFileReader(byArray, file.getAbsolutePath().toCharArray());
        if (bl2) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(ZipFile zipFile, String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(zipFile, string, false);
    }

    public static ClassFileReader read(ZipFile zipFile, String string, boolean bl2) throws ClassFormatException, IOException {
        ZipEntry zipEntry = zipFile.getEntry(string);
        if (zipEntry == null) {
            return null;
        }
        byte[] byArray = Util.getZipEntryByteContent(zipEntry, zipFile);
        ClassFileReader classFileReader = new ClassFileReader(byArray, string.toCharArray());
        if (bl2) {
            classFileReader.initialize();
        }
        return classFileReader;
    }

    public static ClassFileReader read(String string) throws ClassFormatException, IOException {
        return ClassFileReader.read(string, false);
    }

    public static ClassFileReader read(String string, boolean bl2) throws ClassFormatException, IOException {
        return ClassFileReader.read(new File(string), bl2);
    }

    public ClassFileReader(byte[] byArray, char[] cArray) throws ClassFormatException {
        this(byArray, cArray, false);
    }

    public ClassFileReader(byte[] byArray, char[] cArray, boolean bl2) throws ClassFormatException {
        super(byArray, 0);
        this.classFileName = cArray;
        int n2 = 10;
        try {
            int n3;
            int n4;
            this.version = ((long)this.u2At(6) << 16) + (long)this.u2At(4);
            this.constantPoolCount = this.u2At(8);
            this.constantPoolOffsets = new int[this.constantPoolCount];
            int n5 = 1;
            while (n5 < this.constantPoolCount) {
                n4 = this.u1At(n2);
                switch (n4) {
                    case 1: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += this.u2At(n2 + 1);
                        n2 += 3;
                        break;
                    }
                    case 3: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                        break;
                    }
                    case 4: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                        break;
                    }
                    case 5: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 9;
                        ++n5;
                        break;
                    }
                    case 6: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 9;
                        ++n5;
                        break;
                    }
                    case 7: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 3;
                        break;
                    }
                    case 8: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 3;
                        break;
                    }
                    case 9: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                        break;
                    }
                    case 10: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                        break;
                    }
                    case 11: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                        break;
                    }
                    case 12: {
                        this.constantPoolOffsets[n5] = n2;
                        n2 += 5;
                    }
                }
                ++n5;
            }
            this.accessFlags = this.u2At(n2);
            this.classNameIndex = this.u2At(n2 += 2);
            this.className = this.getConstantClassNameAt(this.classNameIndex);
            n5 = this.u2At(n2 += 2);
            n2 += 2;
            if (n5 != 0) {
                this.superclassName = this.getConstantClassNameAt(n5);
            }
            this.interfacesCount = this.u2At(n2);
            n2 += 2;
            if (this.interfacesCount != 0) {
                this.interfaceNames = new char[this.interfacesCount][];
                n4 = 0;
                while (n4 < this.interfacesCount) {
                    this.interfaceNames[n4] = this.getConstantClassNameAt(this.u2At(n2));
                    n2 += 2;
                    ++n4;
                }
            }
            this.fieldsCount = this.u2At(n2);
            n2 += 2;
            if (this.fieldsCount != 0) {
                this.fields = new FieldInfo[this.fieldsCount];
                n3 = 0;
                while (n3 < this.fieldsCount) {
                    FieldInfo fieldInfo;
                    this.fields[n3] = fieldInfo = new FieldInfo(this.b, this.constantPoolOffsets, n2);
                    n2 += fieldInfo.sizeInBytes();
                    ++n3;
                }
            }
            this.methodsCount = this.u2At(n2);
            n2 += 2;
            if (this.methodsCount != 0) {
                this.methods = new MethodInfo[this.methodsCount];
                n3 = 0;
                while (n3 < this.methodsCount) {
                    MethodInfo methodInfo;
                    this.methods[n3] = methodInfo = new MethodInfo(this.b, this.constantPoolOffsets, n2);
                    n2 += methodInfo.sizeInBytes();
                    ++n3;
                }
            }
            int n6 = this.u2At(n2);
            n2 += 2;
            n3 = 0;
            while (n3 < n6) {
                int n7 = this.constantPoolOffsets[this.u2At(n2)];
                char[] cArray2 = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                if (cArray2.length == 0) {
                    n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
                } else {
                    switch (cArray2[0]) {
                        case 'D': {
                            if (!CharOperation.equals(cArray2, DeprecatedName)) break;
                            this.accessFlags |= 0x100000;
                            break;
                        }
                        case 'I': {
                            int n8;
                            int n9;
                            if (!CharOperation.equals(cArray2, InnerClassName) || (n9 = this.u2At(n8 = n2 + 6)) == 0) break;
                            n8 += 2;
                            this.innerInfos = new InnerClassInfo[n9];
                            int n10 = 0;
                            while (n10 < n9) {
                                this.innerInfos[n10] = new InnerClassInfo(this.b, this.constantPoolOffsets, n8);
                                if (this.classNameIndex == this.innerInfos[n10].e) {
                                    this.innerInfo = this.innerInfos[n10];
                                    this.innerInfoIndex = n10;
                                }
                                n8 += 8;
                                ++n10;
                            }
                            break;
                        }
                        case 'S': {
                            if (cArray2.length <= 2) break;
                            switch (cArray2[1]) {
                                case 'o': {
                                    if (!CharOperation.equals(cArray2, SourceName)) break;
                                    n7 = this.constantPoolOffsets[this.u2At(n2 + 6)];
                                    this.sourceFileName = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                                    break;
                                }
                                case 'y': {
                                    if (!CharOperation.equals(cArray2, SyntheticName)) break;
                                    this.accessFlags |= 0x1000;
                                    break;
                                }
                                case 'i': {
                                    if (!CharOperation.equals(cArray2, SignatureName)) break;
                                    n7 = this.constantPoolOffsets[this.u2At(n2 + 6)];
                                    this.signature = this.utf8At(n7 + 3, this.u2At(n7 + 1));
                                }
                            }
                            break;
                        }
                        case 'R': {
                            if (!CharOperation.equals(cArray2, RuntimeVisibleAnnotationsName)) break;
                            this.decodeStandardAnnotations(n2);
                        }
                    }
                    n2 = (int)((long)n2 + (6L + this.u4At(n2 + 2)));
                }
                ++n3;
            }
            if (bl2) {
                this.initialize();
            }
        }
        catch (ClassFormatException classFormatException) {
            throw classFormatException;
        }
        catch (Exception exception) {
            throw new ClassFormatException(21, n2);
        }
    }

    public int accessFlags() {
        return this.accessFlags;
    }

    private int decodeAnnotation(int n2) {
        int n3 = n2;
        int n4 = this.constantPoolOffsets[this.u2At(n2)];
        char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
        int n5 = this.u2At(n2 + 2);
        n3 += 4;
        switch (cArray.length) {
            case 21: {
                if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_INHERITED)) break;
                this.tagBits |= 0x800000000000L;
                return n3;
            }
            case 22: {
                if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_DEPRECATED)) break;
                this.tagBits |= 0x200000000000L;
                return n3;
            }
            case 29: {
                if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_TARGET)) break;
                int n6 = 0;
                while (n6 < n5) {
                    n3 += 2;
                    n3 = this.decodeElementValueForJavaLangAnnotationTarget(n3);
                    ++n6;
                }
                return n3;
            }
            case 33: {
                if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_DOCUMENTED)) break;
                this.tagBits |= 0x400000000000L;
                return n3;
            }
            case 32: {
                if (!CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_RETENTION)) break;
                int n7 = 0;
                while (n7 < n5) {
                    n3 += 2;
                    n3 = this.decodeElementValueForJavaLangAnnotationRetention(n3);
                    ++n7;
                }
                return n3;
            }
        }
        int n8 = 0;
        while (n8 < n5) {
            n3 += 2;
            n3 = this.decodeElementValue(n3);
            ++n8;
        }
        return n3;
    }

    private int decodeElementValue(int n2) {
        int n3 = n2;
        int n4 = this.u1At(n3);
        ++n3;
        switch (n4) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n3 += 2;
                break;
            }
            case 101: {
                n3 += 4;
                break;
            }
            case 99: {
                n3 += 2;
                break;
            }
            case 64: {
                n3 = this.decodeAnnotation(n3);
                break;
            }
            case 91: {
                int n5 = this.u2At(n3);
                n3 += 2;
                int n6 = 0;
                while (n6 < n5) {
                    n3 = this.decodeElementValue(n3);
                    ++n6;
                }
                break;
            }
        }
        return n3;
    }

    private int decodeElementValueForJavaLangAnnotationTarget(int n2) {
        int n3 = n2;
        int n4 = this.u1At(n3);
        ++n3;
        switch (n4) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n3 += 2;
                break;
            }
            case 101: {
                int n5 = this.constantPoolOffsets[this.u2At(n3)];
                char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
                n5 = this.constantPoolOffsets[this.u2At(n3 += 2)];
                char[] cArray2 = this.utf8At(n5 + 3, this.u2At(n5 + 1));
                n3 += 2;
                if (cArray.length != 34 || !CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_ELEMENTTYPE)) break;
                this.tagBits |= Annotation.getTargetElementType(cArray2);
                break;
            }
            case 99: {
                n3 += 2;
                break;
            }
            case 64: {
                n3 = this.decodeAnnotation(n3);
                break;
            }
            case 91: {
                int n6 = this.u2At(n3);
                n3 += 2;
                if (n6 == 0) {
                    this.tagBits |= 0x400000000L;
                    break;
                }
                int n7 = 0;
                while (n7 < n6) {
                    n3 = this.decodeElementValueForJavaLangAnnotationTarget(n3);
                    ++n7;
                }
                break;
            }
        }
        return n3;
    }

    private int decodeElementValueForJavaLangAnnotationRetention(int n2) {
        int n3 = n2;
        int n4 = this.u1At(n3);
        ++n3;
        switch (n4) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n3 += 2;
                break;
            }
            case 101: {
                int n5 = this.constantPoolOffsets[this.u2At(n3)];
                char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
                n5 = this.constantPoolOffsets[this.u2At(n3 += 2)];
                char[] cArray2 = this.utf8At(n5 + 3, this.u2At(n5 + 1));
                n3 += 2;
                this.tagBits |= Annotation.getRetentionPolicy(cArray2);
                if (cArray.length != 38 || !CharOperation.equals(cArray, ConstantPool.JAVA_LANG_ANNOTATION_RETENTIONPOLICY)) break;
                this.tagBits |= Annotation.getRetentionPolicy(cArray2);
                break;
            }
            case 99: {
                n3 += 2;
                break;
            }
            case 64: {
                n3 = this.decodeAnnotation(n3);
                break;
            }
            case 91: {
                int n6 = this.u2At(n3);
                n3 += 2;
                int n7 = 0;
                while (n7 < n6) {
                    n3 = this.decodeElementValue(n3);
                    ++n7;
                }
                break;
            }
        }
        return n3;
    }

    private void decodeStandardAnnotations(int n2) {
        int n3 = this.u2At(n2 + 6);
        int n4 = n2 + 8;
        int n5 = 0;
        while (n5 < n3) {
            n4 = this.decodeAnnotation(n4);
            ++n5;
        }
    }

    private char[] getConstantClassNameAt(int n2) {
        int n3 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[n2] + 1)];
        return this.utf8At(n3 + 3, this.u2At(n3 + 1));
    }

    public int[] getConstantPoolOffsets() {
        return this.constantPoolOffsets;
    }

    public char[] getEnclosingTypeName() {
        if (this.innerInfo != null && !this.isAnonymous()) {
            return this.innerInfo.getEnclosingTypeName();
        }
        return null;
    }

    public IBinaryField[] getFields() {
        return this.fields;
    }

    public char[] getFileName() {
        return this.classFileName;
    }

    public char[] getGenericSignature() {
        return this.signature;
    }

    public char[] getInnerSourceName() {
        if (this.innerInfo != null) {
            return this.innerInfo.getSourceName();
        }
        return null;
    }

    public char[][] getInterfaceNames() {
        return this.interfaceNames;
    }

    public int getKind() {
        switch (this.getModifiers() & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public IBinaryNestedType[] getMemberTypes() {
        int n2;
        if (this.innerInfos == null) {
            return null;
        }
        int n3 = this.innerInfos.length;
        int n4 = n2 = this.innerInfo != null ? this.innerInfoIndex + 1 : 0;
        if (n3 != n2) {
            IBinaryNestedType[] iBinaryNestedTypeArray = new IBinaryNestedType[n3 - this.innerInfoIndex];
            int n5 = 0;
            int n6 = n2;
            while (n6 < n3) {
                InnerClassInfo innerClassInfo = this.innerInfos[n6];
                int n7 = innerClassInfo.d;
                int n8 = innerClassInfo.c;
                if (n7 != 0 && n8 != 0 && n7 == this.classNameIndex && innerClassInfo.getSourceName().length != 0) {
                    iBinaryNestedTypeArray[n5++] = innerClassInfo;
                }
                ++n6;
            }
            if (n5 == 0) {
                return null;
            }
            if (n5 != iBinaryNestedTypeArray.length) {
                IBinaryNestedType[] iBinaryNestedTypeArray2 = iBinaryNestedTypeArray;
                iBinaryNestedTypeArray = new IBinaryNestedType[n5];
                System.arraycopy(iBinaryNestedTypeArray2, 0, iBinaryNestedTypeArray, 0, n5);
            }
            return iBinaryNestedTypeArray;
        }
        return null;
    }

    public IBinaryMethod[] getMethods() {
        return this.methods;
    }

    public int getModifiers() {
        if (this.innerInfo != null) {
            return this.innerInfo.getModifiers() | this.accessFlags & 0x100000;
        }
        return this.accessFlags;
    }

    public char[] getName() {
        return this.className;
    }

    public char[] getSuperclassName() {
        return this.superclassName;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public long getVersion() {
        return this.version;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticFieldChanges(FieldInfo[] var1_1, FieldInfo[] var2_2) {
        var3_3 = var1_1 == null ? 0 : var1_1.length;
        var4_4 = var2_2 == null ? 0 : var2_2.length;
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl13
        block0: while (++var5_5 < var3_3) {
            while (!var1_1[var5_5].isSynthetic()) {
                while (var2_2[var6_6].isSynthetic()) {
                    if (++var6_6 >= var4_4) break block0;
                }
                if (this.hasStructuralFieldChanges(var1_1[var5_5++], var2_2[var6_6++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (var5_5 < var3_3 && var6_6 < var4_4) continue;
            }
        }
        while (var5_5 < var3_3) {
            if (var1_1[var5_5++].isSynthetic()) continue;
            return true;
        }
        while (var6_6 < var4_4) {
            if (var2_2[var6_6++].isSynthetic()) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean hasNonSyntheticMethodChanges(MethodInfo[] var1_1, MethodInfo[] var2_2) {
        var3_3 = var1_1 == null ? 0 : var1_1.length;
        var4_4 = var2_2 == null ? 0 : var2_2.length;
        var5_5 = 0;
        var6_6 = 0;
        ** GOTO lbl13
        block0: while (++var5_5 < var3_3) {
            while (!(var7_7 = var1_1[var5_5]).isSynthetic() && !var7_7.isClinit()) {
                while ((var7_7 = var2_2[var6_6]).isSynthetic() || var7_7.isClinit()) {
                    if (++var6_6 >= var4_4) break block0;
                }
                if (this.hasStructuralMethodChanges(var1_1[var5_5++], var2_2[var6_6++])) {
                    return true;
                }
lbl13:
                // 3 sources

                if (var5_5 < var3_3 && var6_6 < var4_4) continue;
            }
        }
        while (var5_5 < var3_3) {
            if ((var7_7 = var1_1[var5_5++]).isSynthetic() || var7_7.isClinit()) continue;
            return true;
        }
        while (var6_6 < var4_4) {
            if ((var7_7 = var2_2[var6_6++]).isSynthetic() || var7_7.isClinit()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStructuralChanges(byte[] byArray) {
        return this.hasStructuralChanges(byArray, true, true);
    }

    public boolean hasStructuralChanges(byte[] byArray, boolean bl2, boolean bl3) {
        try {
            int n2;
            Object[] objectArray;
            int n3;
            Object[] objectArray2;
            int n4;
            int n5;
            IBinaryNestedType[] iBinaryNestedTypeArray;
            IBinaryNestedType[] iBinaryNestedTypeArray2;
            int n6;
            ClassFileReader classFileReader = new ClassFileReader(byArray, this.classFileName);
            if (this.getModifiers() != classFileReader.getModifiers()) {
                return true;
            }
            if ((this.getTagBits() & 0x7FC00000000L | 0x200000000000L | 0x180000000000L) != (classFileReader.getTagBits() & 0x7FC00000000L | 0x200000000000L | 0x180000000000L)) {
                return true;
            }
            if (!CharOperation.equals(this.getGenericSignature(), classFileReader.getGenericSignature())) {
                return true;
            }
            if (!CharOperation.equals(this.getSuperclassName(), classFileReader.getSuperclassName())) {
                return true;
            }
            char[][] cArray = classFileReader.getInterfaceNames();
            if (this.interfaceNames != cArray) {
                int n7;
                int n8 = n7 = cArray == null ? 0 : cArray.length;
                if (n7 != this.interfacesCount) {
                    return true;
                }
                int n9 = 0;
                n6 = this.interfacesCount;
                while (n9 < n6) {
                    if (!CharOperation.equals(this.interfaceNames[n9], cArray[n9])) {
                        return true;
                    }
                    ++n9;
                }
            }
            if ((iBinaryNestedTypeArray2 = this.getMemberTypes()) != (iBinaryNestedTypeArray = classFileReader.getMemberTypes())) {
                n6 = iBinaryNestedTypeArray2 == null ? 0 : iBinaryNestedTypeArray2.length;
                int n10 = n5 = iBinaryNestedTypeArray == null ? 0 : iBinaryNestedTypeArray.length;
                if (n6 != n5) {
                    return true;
                }
                n4 = 0;
                while (n4 < n6) {
                    if (!CharOperation.equals(iBinaryNestedTypeArray2[n4].getName(), iBinaryNestedTypeArray[n4].getName()) || iBinaryNestedTypeArray2[n4].getModifiers() != iBinaryNestedTypeArray[n4].getModifiers()) {
                        return true;
                    }
                    ++n4;
                }
            }
            n5 = (objectArray2 = (FieldInfo[])classFileReader.getFields()) == null ? 0 : objectArray2.length;
            n4 = 1;
            if (this.fieldsCount == n5) {
                n3 = 0;
                while (n3 < this.fieldsCount) {
                    if (this.hasStructuralFieldChanges(this.fields[n3], objectArray2[n3])) break;
                    ++n3;
                }
                if ((n4 = n3 != this.fieldsCount ? 1 : 0) != 0 && !bl2 && !bl3) {
                    return true;
                }
            }
            if (n4 != 0) {
                if (this.fieldsCount != n5 && !bl3) {
                    return true;
                }
                if (bl2) {
                    if (this.fieldsCount != 0) {
                        Arrays.sort(this.fields);
                    }
                    if (n5 != 0) {
                        Arrays.sort(objectArray2);
                    }
                }
                if (bl3) {
                    if (this.hasNonSyntheticFieldChanges(this.fields, (FieldInfo[])objectArray2)) {
                        return true;
                    }
                } else {
                    n3 = 0;
                    while (n3 < this.fieldsCount) {
                        if (this.hasStructuralFieldChanges(this.fields[n3], (FieldInfo)objectArray2[n3])) {
                            return true;
                        }
                        ++n3;
                    }
                }
            }
            int n11 = (objectArray = (MethodInfo[])classFileReader.getMethods()) == null ? 0 : objectArray.length;
            boolean bl4 = true;
            if (this.methodsCount == n11) {
                n2 = 0;
                while (n2 < this.methodsCount) {
                    if (this.hasStructuralMethodChanges(this.methods[n2], objectArray[n2])) break;
                    ++n2;
                }
                if ((bl4 = n2 != this.methodsCount) && !bl2 && !bl3) {
                    return true;
                }
            }
            if (bl4) {
                if (this.methodsCount != n11 && !bl3) {
                    return true;
                }
                if (bl2) {
                    if (this.methodsCount != 0) {
                        Arrays.sort(this.methods);
                    }
                    if (n11 != 0) {
                        Arrays.sort(objectArray);
                    }
                }
                if (bl3) {
                    if (this.hasNonSyntheticMethodChanges(this.methods, (MethodInfo[])objectArray)) {
                        return true;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.methodsCount) {
                        if (this.hasStructuralMethodChanges(this.methods[n2], (MethodInfo)objectArray[n2])) {
                            return true;
                        }
                        ++n2;
                    }
                }
            }
            return false;
        }
        catch (ClassFormatException classFormatException) {
            return true;
        }
    }

    private boolean hasStructuralFieldChanges(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
        if (!CharOperation.equals(fieldInfo.getGenericSignature(), fieldInfo2.getGenericSignature())) {
            return true;
        }
        if (fieldInfo.getModifiers() != fieldInfo2.getModifiers()) {
            return true;
        }
        if ((fieldInfo.getTagBits() & 0x200000000000L) != (fieldInfo2.getTagBits() & 0x200000000000L)) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getName(), fieldInfo2.getName())) {
            return true;
        }
        if (!CharOperation.equals(fieldInfo.getTypeName(), fieldInfo2.getTypeName())) {
            return true;
        }
        if (fieldInfo.hasConstant() != fieldInfo2.hasConstant()) {
            return true;
        }
        if (fieldInfo.hasConstant()) {
            Constant constant = fieldInfo.getConstant();
            Constant constant2 = fieldInfo2.getConstant();
            if (constant.typeID() != constant2.typeID()) {
                return true;
            }
            if (!constant.getClass().equals(constant2.getClass())) {
                return true;
            }
            switch (constant.typeID()) {
                case 10: {
                    return constant.intValue() != constant2.intValue();
                }
                case 3: {
                    return constant.byteValue() != constant2.byteValue();
                }
                case 4: {
                    return constant.shortValue() != constant2.shortValue();
                }
                case 2: {
                    return constant.charValue() != constant2.charValue();
                }
                case 7: {
                    return constant.longValue() != constant2.longValue();
                }
                case 9: {
                    return constant.floatValue() != constant2.floatValue();
                }
                case 8: {
                    return constant.doubleValue() != constant2.doubleValue();
                }
                case 5: {
                    return constant.booleanValue() != constant2.booleanValue();
                }
                case 11: {
                    return !constant.stringValue().equals(constant2.stringValue());
                }
            }
        }
        return false;
    }

    private boolean hasStructuralMethodChanges(MethodInfo methodInfo, MethodInfo methodInfo2) {
        char[][] cArray;
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        if (methodInfo.getModifiers() != methodInfo2.getModifiers()) {
            return true;
        }
        if ((methodInfo.getTagBits() & 0x200000000000L) != (methodInfo2.getTagBits() & 0x200000000000L)) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getSelector(), methodInfo2.getSelector())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getMethodDescriptor(), methodInfo2.getMethodDescriptor())) {
            return true;
        }
        if (!CharOperation.equals(methodInfo.getGenericSignature(), methodInfo2.getGenericSignature())) {
            return true;
        }
        char[][] cArray2 = methodInfo.getExceptionTypeNames();
        if (cArray2 != (cArray = methodInfo2.getExceptionTypeNames())) {
            int n2;
            int n3 = cArray2 == null ? 0 : cArray2.length;
            int n4 = n2 = cArray == null ? 0 : cArray.length;
            if (n3 != n2) {
                return true;
            }
            int n5 = 0;
            while (n5 < n3) {
                if (!CharOperation.equals(cArray2[n5], cArray[n5])) {
                    return true;
                }
                ++n5;
            }
        }
        return false;
    }

    private void initialize() throws ClassFormatException {
        try {
            int n2 = 0;
            int n3 = this.fieldsCount;
            while (n2 < n3) {
                this.fields[n2].a();
                ++n2;
            }
            n2 = 0;
            n3 = this.methodsCount;
            while (n2 < n3) {
                this.methods[n2].a();
                ++n2;
            }
            if (this.innerInfos != null) {
                n2 = 0;
                n3 = this.innerInfos.length;
                while (n2 < n3) {
                    this.innerInfos[n2].a();
                    ++n2;
                }
            }
            this.reset();
        }
        catch (RuntimeException runtimeException) {
            ClassFormatException classFormatException = new ClassFormatException(runtimeException, this.classFileName);
            throw classFormatException;
        }
    }

    public boolean isAnonymous() {
        if (this.innerInfo == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray == null || cArray.length == 0;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLocal() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() != null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    public boolean isMember() {
        if (this.innerInfo == null) {
            return false;
        }
        if (this.innerInfo.getEnclosingTypeName() == null) {
            return false;
        }
        char[] cArray = this.innerInfo.getSourceName();
        return cArray != null && cArray.length > 0;
    }

    public boolean isNestedType() {
        return this.innerInfo != null;
    }

    public void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public char[] sourceFileName() {
        return this.sourceFileName;
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println(String.valueOf(this.getClass().getName()) + "{");
        printWriter.println(" this.className: " + new String(this.getName()));
        printWriter.println(" this.superclassName: " + (this.getSuperclassName() == null ? "null" : new String(this.getSuperclassName())));
        printWriter.println(" access_flags: " + ClassFileStruct.printTypeModifiers(this.accessFlags()) + "(" + this.accessFlags() + ")");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

