/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.batch.FileFinder;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.jdt.internal.compiler.util.Messages;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.compiler.util.Util;

public class Main
implements ProblemSeverities,
SuffixConstants {
    public static ResourceBundle bundle;
    public static final String bundleName = "org.eclipse.jdt.internal.compiler.batch.messages";
    public FileSystem.Classpath[] a;
    public String destinationPath;
    public String[] encodings;
    public Logger logger;
    public int exportedClassFilesCounter;
    public String[] filenames;
    public boolean generatePackagesStructure;
    public int globalErrorsCount;
    public int globalTasksCount;
    public int globalProblemsCount;
    public int globalWarningsCount;
    public long lineCount;
    public String log;
    public boolean noWarn = false;
    public Map options;
    public CompilerOptions compilerOptions;
    public boolean proceed = true;
    public boolean proceedOnError = false;
    public boolean produceRefInfo = false;
    public int repetitions;
    public int maxProblems;
    public boolean showProgress = false;
    public boolean systemExitWhenFinished = true;
    public long startTime;
    public boolean timing = false;
    public long[] times;
    public int timesCounter;
    public boolean verbose = false;
    private File javaHomeCache;
    private boolean javaHomeChecked;

    static {
        Main.relocalize();
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl2) {
        this(printWriter, printWriter2, bl2, null);
    }

    public Main(PrintWriter printWriter, PrintWriter printWriter2, boolean bl2, Map map) {
        this.logger = new Logger(printWriter, printWriter2);
        this.systemExitWhenFinished = bl2;
        this.options = new CompilerOptions().getMap();
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k2 = iterator.next();
                this.options.put(k2, map.get(k2));
            }
        }
    }

    public static String bind(String string) {
        return Main.bind(string, null);
    }

    public static String bind(String string, String string2) {
        return Main.bind(string, new String[]{string2});
    }

    public static String bind(String string, String string2, String string3) {
        return Main.bind(string, new String[]{string2, string3});
    }

    public static String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + bundleName;
        }
        return MessageFormat.format(string2, stringArray);
    }

    public static boolean compile(String string) {
        return Main.compile(string, new PrintWriter(System.out), new PrintWriter(System.err));
    }

    public static boolean compile(String string, PrintWriter printWriter, PrintWriter printWriter2) {
        return new Main(printWriter, printWriter2, false).compile(Main.tokenize(string));
    }

    public static void main(String[] stringArray) {
        new Main(new PrintWriter(System.out), new PrintWriter(System.err), true).compile(stringArray);
    }

    public static void relocalize() {
        try {
            bundle = ResourceBundle.getBundle(bundleName, Locale.getDefault());
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + bundleName.replace('.', '/') + ".properties for locale " + Locale.getDefault());
            throw missingResourceException;
        }
    }

    public static String[] tokenize(String string) {
        int n2 = 0;
        String[] stringArray = new String[10];
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \"", true);
        String string2 = "";
        boolean bl2 = false;
        boolean bl3 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) {
                if (bl2) {
                    int n3 = n2 - 1;
                    stringArray[n3] = String.valueOf(stringArray[n3]) + string2;
                    bl3 = false;
                    continue;
                }
                bl3 = true;
                continue;
            }
            if (string2.equals("\"")) {
                if (!bl2 && bl3) {
                    if (n2 == stringArray.length) {
                        String[] stringArray2 = stringArray;
                        stringArray = new String[n2 * 2];
                        System.arraycopy(stringArray2, 0, stringArray, 0, n2);
                    }
                    stringArray[n2++] = "";
                }
                bl2 = !bl2;
                bl3 = false;
                continue;
            }
            if (bl2) {
                int n4 = n2 - 1;
                stringArray[n4] = String.valueOf(stringArray[n4]) + string2;
            } else if (string2.length() > 0 && !bl3) {
                int n5 = n2 - 1;
                stringArray[n5] = String.valueOf(stringArray[n5]) + string2;
            } else {
                String string3;
                if (n2 == stringArray.length) {
                    String[] stringArray3 = stringArray;
                    stringArray = new String[n2 * 2];
                    System.arraycopy(stringArray3, 0, stringArray, 0, n2);
                }
                if ((string3 = string2.trim()).length() != 0) {
                    stringArray[n2++] = string3;
                }
            }
            bl3 = false;
        }
        String[] stringArray4 = stringArray;
        stringArray = new String[n2];
        System.arraycopy(stringArray4, 0, stringArray, 0, n2);
        return stringArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compile(String[] stringArray) {
        try {
            try {
                this.configure(stringArray);
                if (this.proceed) {
                    if (this.showProgress) {
                        this.logger.compiling();
                    }
                    int n2 = 0;
                    while (true) {
                        if (n2 >= this.repetitions) {
                            if (this.times != null) {
                                this.logger.logAverage(this.times, this.lineCount);
                            }
                            if (!this.showProgress) break;
                            this.logger.printNewLine();
                            break;
                        }
                        this.globalProblemsCount = 0;
                        this.globalErrorsCount = 0;
                        this.globalWarningsCount = 0;
                        this.globalTasksCount = 0;
                        this.lineCount = 0L;
                        this.exportedClassFilesCounter = 0;
                        if (this.repetitions > 1) {
                            this.logger.flush();
                            this.logger.logRepetition(n2, this.repetitions);
                        }
                        this.performCompilation();
                        ++n2;
                    }
                }
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(this.globalErrorsCount > 0 ? -1 : 0);
                }
            }
            catch (InvalidInputException invalidInputException) {
                this.logger.logException(invalidInputException);
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                Object var3_4 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
            catch (RuntimeException runtimeException) {
                if (this.systemExitWhenFinished) {
                    this.logger.flush();
                    this.logger.close();
                    System.exit(-1);
                }
                Object var3_5 = null;
                this.logger.flush();
                this.logger.close();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            this.logger.flush();
            this.logger.close();
            throw throwable;
        }
        {
            Object var3_7 = null;
            this.logger.flush();
            this.logger.close();
            return this.globalErrorsCount == 0;
        }
    }

    public void configure(String[] stringArray) throws InvalidInputException {
        File[] fileArray;
        int n2;
        if (stringArray == null || stringArray.length == 0) {
            this.printUsage();
            return;
        }
        int n3 = 4;
        ArrayList<FileSystem.Classpath> arrayList = new ArrayList<FileSystem.Classpath>(n3);
        ArrayList<FileSystem.Classpath> arrayList2 = new ArrayList<FileSystem.Classpath>(n3);
        ArrayList<String> arrayList3 = new ArrayList<String>(n3);
        ArrayList arrayList4 = new ArrayList(n3);
        ArrayList<FileSystem.Classpath> arrayList5 = new ArrayList<FileSystem.Classpath>(n3);
        String string = null;
        ArrayList<String> arrayList6 = new ArrayList<String>(n3);
        int n4 = -1;
        int n5 = 0;
        int n6 = stringArray.length;
        int n7 = 0;
        this.repetitions = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = false;
        boolean bl9 = false;
        boolean bl10 = false;
        String string2 = null;
        String string3 = "";
        boolean bl11 = false;
        int n8 = 0;
        while (n8 < n6) {
            if (stringArray[n8].startsWith("@")) {
                bl11 = true;
                break;
            }
            ++n8;
        }
        String[] stringArray2 = null;
        if (bl11) {
            stringArray2 = new String[n6];
            n4 = 0;
            n2 = 0;
            while (n2 < n6) {
                String[] stringArray3 = null;
                String string4 = stringArray[n2].trim();
                if (string4.startsWith("@")) {
                    try {
                        LineNumberReader lineNumberReader = new LineNumberReader(new StringReader(new String(Util.getFileCharContent(new File(string4.substring(1)), null))));
                        StringBuffer stringBuffer = new StringBuffer();
                        while ((fileArray = lineNumberReader.readLine()) != null) {
                            stringBuffer.append((String)fileArray).append(" ");
                        }
                        stringArray3 = Main.tokenize(stringBuffer.toString());
                    }
                    catch (IOException iOException) {
                        throw new InvalidInputException(Main.bind("configure.invalidexpansionargumentname", string4));
                    }
                }
                if (stringArray3 != null) {
                    int n9 = stringArray2.length;
                    int n10 = stringArray3.length;
                    String[] stringArray4 = stringArray2;
                    stringArray2 = new String[n9 + n10 - 1];
                    System.arraycopy(stringArray4, 0, stringArray2, 0, n4);
                    System.arraycopy(stringArray3, 0, stringArray2, n4, n10);
                    n4 += n10;
                } else {
                    stringArray2[n4++] = string4;
                }
                ++n2;
            }
            n4 = -1;
        } else {
            stringArray2 = stringArray;
            n2 = 0;
            while (n2 < n6) {
                stringArray2[n2] = stringArray2[n2].trim();
                ++n2;
            }
        }
        n6 = stringArray2.length;
        while (++n4 < n6) {
            File file;
            if (string2 != null) {
                throw new InvalidInputException(Main.bind("configure.unexpectedCustomEncoding", string3, string2));
            }
            string3 = stringArray2[n4];
            string2 = null;
            if (string3.endsWith("]") && n7 != 128 && n7 != 1 && n7 != 1024) {
                int n11 = string3.indexOf(91) + 1;
                int n12 = string3.length() - 1;
                if (n11 >= 1) {
                    if (n11 < n12) {
                        string2 = string3.substring(n11, n12);
                        try {
                            new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string2);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", string2));
                        }
                    }
                    string3 = string3.substring(0, n11 - 1);
                }
            }
            if (string3.endsWith(".java")) {
                if (this.filenames == null) {
                    this.filenames = new String[n6 - n4];
                    this.encodings = new String[n6 - n4];
                } else if (n5 == this.filenames.length) {
                    int n13 = this.filenames.length;
                    this.filenames = new String[n13 + n6 - n4];
                    System.arraycopy(this.filenames, 0, this.filenames, 0, n13);
                    this.encodings = new String[n13 + n6 - n4];
                    System.arraycopy(this.encodings, 0, this.encodings, 0, n13);
                }
                this.filenames[n5] = string3;
                this.encodings[n5++] = string2;
                string2 = null;
                n7 = 0;
                continue;
            }
            if (string3.equals("-log")) {
                if (this.log != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateLog", string3));
                }
                n7 = 8;
                continue;
            }
            if (string3.equals("-repeat")) {
                if (this.repetitions > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateRepeat", string3));
                }
                n7 = 16;
                continue;
            }
            if (string3.equals("-maxProblems")) {
                if (this.maxProblems > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateMaxProblems", string3));
                }
                n7 = 256;
                continue;
            }
            if (string3.equals("-source")) {
                n7 = 32;
                continue;
            }
            if (string3.equals("-encoding")) {
                n7 = 64;
                continue;
            }
            if (string3.equals("-1.3")) {
                if (bl5) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", string3));
                }
                bl5 = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.3");
                n7 = 0;
                continue;
            }
            if (string3.equals("-1.4")) {
                if (bl5) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", string3));
                }
                bl5 = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                n7 = 0;
                continue;
            }
            if (string3.equals("-1.5") || string3.equals("-5") || string3.equals("-5.0")) {
                if (bl5) {
                    throw new InvalidInputException(Main.bind("configure.duplicateCompliance", string3));
                }
                bl5 = true;
                this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                n7 = 0;
                continue;
            }
            if (string3.equals("-d")) {
                if (this.destinationPath != null) {
                    throw new InvalidInputException(Main.bind("configure.duplicateOutputPath", string3));
                }
                n7 = 2;
                this.generatePackagesStructure = true;
                continue;
            }
            if (string3.equals("-classpath") || string3.equals("-cp")) {
                n7 = 1;
                continue;
            }
            if (string3.equals("-bootclasspath")) {
                if (arrayList.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateBootClasspath", string3));
                }
                n7 = 128;
                continue;
            }
            if (string3.equals("-sourcepath")) {
                if (arrayList4.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSourcepath", string3));
                }
                n7 = 1024;
                continue;
            }
            if (string3.equals("-extdirs")) {
                if (arrayList3.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateExtdirs", string3));
                }
                n7 = 512;
                continue;
            }
            if (string3.equals("-progress")) {
                n7 = 0;
                this.showProgress = true;
                continue;
            }
            if (string3.equals("-proceedOnError")) {
                n7 = 0;
                this.proceedOnError = true;
                continue;
            }
            if (string3.equals("-time")) {
                n7 = 0;
                this.timing = true;
                continue;
            }
            if (string3.equals("-version") || string3.equals("-v")) {
                this.printVersion();
                this.proceed = false;
                return;
            }
            if (string3.equals("-showversion")) {
                bl3 = true;
                continue;
            }
            if ("-deprecation".equals(string3)) {
                bl8 = true;
                this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                continue;
            }
            if (string3.equals("-help") || string3.equals("-?")) {
                bl2 = true;
                continue;
            }
            if (string3.equals("-noExit")) {
                n7 = 0;
                this.systemExitWhenFinished = false;
                continue;
            }
            if (string3.equals("-verbose")) {
                n7 = 0;
                this.verbose = true;
                continue;
            }
            if (string3.equals("-referenceInfo")) {
                n7 = 0;
                this.produceRefInfo = true;
                continue;
            }
            if (string3.equals("-inlineJSR")) {
                n7 = 0;
                this.options.put("org.eclipse.jdt.core.compiler.codegen.inlineJsrBytecode", "enabled");
                continue;
            }
            if (string3.startsWith("-g")) {
                n7 = 0;
                String string5 = string3;
                int n14 = string3.length();
                if (n14 == 2) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                    continue;
                }
                if (n14 > 3) {
                    this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "do not generate");
                    this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "do not generate");
                    if (n14 == 7 && string5.equals("-g:none")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string5.substring(3, string5.length()), ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (string6.equals("vars")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.localVariable", "generate");
                            continue;
                        }
                        if (string6.equals("lines")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
                            continue;
                        }
                        if (string6.equals("source")) {
                            this.options.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
                            continue;
                        }
                        throw new InvalidInputException(Main.bind("configure.invalidDebugOption", string5));
                    }
                    continue;
                }
                throw new InvalidInputException(Main.bind("configure.invalidDebugOption", string5));
            }
            if (string3.startsWith("-nowarn")) {
                this.disableWarnings();
                n7 = 0;
                continue;
            }
            if (string3.startsWith("-warn")) {
                boolean bl12;
                int n15;
                n7 = 0;
                String string7 = string3;
                int n16 = string3.length();
                if (n16 == 10 && string7.equals("-warn:none")) {
                    this.disableWarnings();
                    continue;
                }
                if (n16 <= 6) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningConfiguration", string7));
                }
                switch (string7.charAt(6)) {
                    case '+': {
                        n15 = 7;
                        bl12 = true;
                        break;
                    }
                    case '-': {
                        n15 = 7;
                        bl12 = false;
                        break;
                    }
                    default: {
                        n15 = 6;
                        if (!bl9) {
                            this.disableWarnings();
                        }
                        bl12 = true;
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string7.substring(n15, string7.length()), ",");
                int n17 = 0;
                if (bl8) {
                    this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", "warning");
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string8 = stringTokenizer.nextToken();
                    ++n17;
                    if (string8.equals("constructorName")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.methodWithConstructorName", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("pkgDefaultMethod") || string8.equals("packageDefaultMethod")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("maskedCatchBlock") || string8.equals("maskedCatchBlocks")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("deprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", "disabled");
                        continue;
                    }
                    if (string8.equals("allDeprecation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecation", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode", bl12 ? "enabled" : "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.deprecationWhenOverridingDeprecatedMethod", bl12 ? "enabled" : "disabled");
                        continue;
                    }
                    if (string8.equals("unusedLocal") || string8.equals("unusedLocals")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unusedArgument") || string8.equals("unusedArguments")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unusedImport") || string8.equals("unusedImports")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unusedPrivate")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("localHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("fieldHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("specialParamHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.specialParameterHidingField", bl12 ? "enabled" : "disabled");
                        continue;
                    }
                    if (string8.equals("conditionAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.possibleAccidentalBooleanAssignment", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("syntheticAccess") || string8.equals("synthetic-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("nls")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("staticReceiver")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("indirectStatic")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("noEffectAssign")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noEffectAssignment", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("intfNonInherited") || string8.equals("interfaceNonInherited")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("charConcat") || string8.equals("noImplicitStringConversion")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("semicolon")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.emptyStatement", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("serial")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingSerialVersion", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("emptyBlock")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.undocumentedEmptyBlock", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("uselessTypeCheck")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryTypeCheck", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unchecked") || string8.equals("unsafe")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.uncheckedTypeOperation", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("finalBound")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.finalParameterBound", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("suppress")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.suppressWarnings", bl12 ? "enabled" : "disabled");
                        continue;
                    }
                    if (string8.equals("warningToken")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unhandledWarningToken", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unnecessaryElse")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unnecessaryElse", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("javadoc")) {
                        if (!bl10) {
                            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl12 ? "enabled" : "disabled");
                        }
                        if (!bl12) continue;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsDeprecatedRef", "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsNotVisibleRef", "disabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                        continue;
                    }
                    if (string8.equals("allJavadoc")) {
                        if (!bl10) {
                            this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", bl12 ? "enabled" : "disabled");
                        }
                        if (!bl12) continue;
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadoc", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTags", "enabled");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.invalidJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTags", "warning");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocTagsVisibility", "private");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingJavadocComments", "warning");
                        continue;
                    }
                    if (string8.startsWith("tasks")) {
                        String string9 = "";
                        int n18 = string8.indexOf(40);
                        int n19 = string8.indexOf(41);
                        if (n18 >= 0 && n19 >= 0 && n18 < n19) {
                            string9 = string8.substring(n18 + 1, n19).trim();
                            string9 = string9.replace('|', ',');
                        }
                        if (string9.length() == 0) {
                            throw new InvalidInputException(Main.bind("configure.invalidTaskTag", string8));
                        }
                        this.options.put("org.eclipse.jdt.core.compiler.taskTags", bl12 ? string9 : "");
                        continue;
                    }
                    if (string8.equals("assertIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.assertIdentifier", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("enumIdentifier")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.enumIdentifier", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("finally")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.finallyBlockNotCompletingNormally", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unusedThrown")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unqualifiedField") || string8.equals("unqualified-field-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unqualifiedFieldAccess", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("typeHiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("varargsCast")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.varargsArgumentNeedCast", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("null")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.nullReference", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("boxing")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.autoboxing", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("over-ann")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingOverrideAnnotation", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("dep-ann")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.missingDeprecatedAnnotation", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("intfAnnotation")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.annotationSuperInterface", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("enumSwitch") || string8.equals("incomplete-switch")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.incompleteEnumSwitch", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("hiding")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.localVariableHiding", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.fieldHiding", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.typeParameterHiding", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("static-access")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.staticAccessReceiver", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.indirectStaticAccess", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    if (string8.equals("unused")) {
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedLocal", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedParameter", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedImport", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedPrivateMember", bl12 ? "warning" : "ignore");
                        this.options.put("org.eclipse.jdt.core.compiler.problem.unusedDeclaredThrownException", bl12 ? "warning" : "ignore");
                        continue;
                    }
                    throw new InvalidInputException(Main.bind("configure.invalidWarning", string8));
                }
                if (n17 == 0) {
                    throw new InvalidInputException(Main.bind("configure.invalidWarningOption", string3));
                }
                bl9 = true;
                continue;
            }
            if (string3.equals("-target")) {
                n7 = 4;
                continue;
            }
            if (string3.equals("-preserveAllLocals")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.unusedLocal", "preserve");
                continue;
            }
            if (string3.equals("-enableJavadoc")) {
                this.options.put("org.eclipse.jdt.core.compiler.doc.comment.support", "enabled");
                bl10 = true;
                continue;
            }
            if (string3.startsWith("-X")) {
                n7 = 0;
                continue;
            }
            if (string3.startsWith("-J")) {
                n7 = 0;
                continue;
            }
            if (string3.equals("-O")) {
                n7 = 0;
                continue;
            }
            if (string3.equals("-sourcepath")) {
                if (arrayList4.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSourcepath", string3));
                }
                n7 = 1024;
                continue;
            }
            if (string3.equals("-extdirs")) {
                if (arrayList3.size() > 0) {
                    throw new InvalidInputException(Main.bind("configure.duplicateExtdirs", string3));
                }
                n7 = 512;
                continue;
            }
            if (n7 == 4) {
                if (bl7) {
                    throw new InvalidInputException(Main.bind("configure.duplicateTarget", string3));
                }
                bl7 = true;
                if (string3.equals("1.1")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                } else if (string3.equals("1.2")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (string3.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.3");
                } else if (string3.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                    if (bl5 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x300000L) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                } else if (string3.equals("1.5") || string3.equals("5") || string3.equals("5.0")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                    if (bl5 && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x310000L) {
                        throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                } else {
                    throw new InvalidInputException(Main.bind("configure.targetJDK", string3));
                }
                n7 = 0;
                continue;
            }
            if (n7 == 8) {
                this.log = string3;
                n7 = 0;
                continue;
            }
            if (n7 == 16) {
                try {
                    this.repetitions = Integer.parseInt(string3);
                    if (this.repetitions <= 0) {
                        throw new InvalidInputException(Main.bind("configure.repetition", string3));
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(Main.bind("configure.repetition", string3));
                }
                n7 = 0;
                continue;
            }
            if (n7 == 256) {
                try {
                    this.maxProblems = Integer.parseInt(string3);
                    if (this.maxProblems <= 0) {
                        throw new InvalidInputException(Main.bind("configure.maxProblems", string3));
                    }
                    this.options.put("org.eclipse.jdt.core.compiler.maxProblemPerUnit", string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidInputException(Main.bind("configure.maxProblems", string3));
                }
                n7 = 0;
                continue;
            }
            if (n7 == 32) {
                if (bl4) {
                    throw new InvalidInputException(Main.bind("configure.duplicateSource", string3));
                }
                bl4 = true;
                if (string3.equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                } else if (string3.equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.4");
                } else if (string3.equals("1.5") || string3.equals("5") || string3.equals("5.0")) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                } else {
                    throw new InvalidInputException(Main.bind("configure.source", string3));
                }
                n7 = 0;
                continue;
            }
            if (n7 == 64) {
                if (bl6) {
                    throw new InvalidInputException(Main.bind("configure.duplicateDefaultEncoding", string3));
                }
                try {
                    new InputStreamReader((InputStream)new ByteArrayInputStream(new byte[0]), string3);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new InvalidInputException(Main.bind("configure.unsupportedEncoding", string3));
                }
                this.options.put("org.eclipse.jdt.core.encoding", string3);
                bl6 = true;
                n7 = 0;
                continue;
            }
            if (n7 == 2) {
                this.destinationPath = string3;
                n7 = 0;
                continue;
            }
            if (n7 == 1 || n7 == 128 || n7 == 1024) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, String.valueOf(File.pathSeparator) + "[]", true);
                int n20 = 0;
                String string10 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string10 = stringTokenizer.nextToken();
                    if (string10.equals(File.pathSeparator)) {
                        switch (n20) {
                            case 0: {
                                break;
                            }
                            case 1: 
                            case 2: 
                            case 3: {
                                n20 = 3;
                                this.addNewEntry(1, 1024, arrayList, arrayList5, arrayList4, string, arrayList6, n7, string2);
                                break;
                            }
                            case 6: {
                                n20 = 4;
                                break;
                            }
                            default: {
                                n20 = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    if (string10.equals("[")) {
                        switch (n20) {
                            case 1: {
                                n20 = 5;
                                break;
                            }
                            default: {
                                n20 = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    if (string10.equals("]")) {
                        switch (n20) {
                            case 6: {
                                n20 = 2;
                                break;
                            }
                            default: {
                                n20 = 99;
                                break;
                            }
                        }
                        continue;
                    }
                    switch (n20) {
                        case 0: 
                        case 3: {
                            n20 = 1;
                            string = string10;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n20 = 6;
                            arrayList6.add(string10);
                            break;
                        }
                        default: {
                            n20 = 99;
                        }
                    }
                }
                switch (n20) {
                    case 1: 
                    case 2: 
                    case 3: {
                        this.addNewEntry(1, 1024, arrayList, arrayList5, arrayList4, string, arrayList6, n7, string2);
                        break;
                    }
                    default: {
                        this.logger.logIncorrectClasspath(string3);
                    }
                }
                n7 = 0;
                continue;
            }
            if (n7 == 512) {
                StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator, false);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList3.add(stringTokenizer.nextToken());
                }
                if (arrayList3.size() == 0) {
                    arrayList3.add("");
                }
                n7 = 0;
                continue;
            }
            if ((string3 = string3.replace('/', File.separatorChar)).endsWith(File.separator)) {
                string3 = string3.substring(0, string3.length() - File.separator.length());
            }
            if (!(file = new File(string3)).isDirectory()) {
                throw new InvalidInputException(Main.bind("configure.directoryNotExist", string3));
            }
            FileFinder fileFinder = new FileFinder();
            try {
                fileFinder.find(file, ".JAVA", this.verbose);
            }
            catch (Exception exception) {
                throw new InvalidInputException(Main.bind("configure.IOError", string3));
            }
            if (this.filenames != null) {
                String[] stringArray5 = fileFinder.resultFiles;
                int n21 = stringArray5.length;
                this.filenames = new String[n21 + n5];
                System.arraycopy(this.filenames, 0, this.filenames, 0, n5);
                this.encodings = new String[n21 + n5];
                System.arraycopy(this.encodings, 0, this.encodings, 0, n5);
                System.arraycopy(stringArray5, 0, this.filenames, n5, n21);
                int n22 = 0;
                while (n22 < n21) {
                    this.encodings[n5 + n22] = string2;
                    ++n22;
                }
                n5 += n21;
                string2 = null;
            } else {
                this.filenames = fileFinder.resultFiles;
                n5 = this.filenames.length;
                this.encodings = new String[n5];
                int n23 = 0;
                while (n23 < n5) {
                    this.encodings[n23] = string2;
                    ++n23;
                }
                string2 = null;
            }
            n7 = 0;
        }
        if (this.log != null) {
            this.logger.setLog(this.log);
        } else {
            this.showProgress = false;
        }
        if (bl2 || n5 == 0) {
            this.printUsage();
            this.proceed = false;
            return;
        }
        if (bl3) {
            this.printVersion();
        }
        if (n5 != 0) {
            this.filenames = new String[n5];
            System.arraycopy(this.filenames, 0, this.filenames, 0, n5);
        }
        if (arrayList5.size() == 0) {
            String string11 = System.getProperty("java.class.path");
            if (string11 == null || string11.length() == 0) {
                this.logger.logNoClasspath();
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string11, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    String string12 = stringTokenizer.nextToken();
                    FileSystem.Classpath classpath = FileSystem.a(string12, string2, 0, null);
                    if (classpath != null) {
                        arrayList5.add(classpath);
                        continue;
                    }
                    this.logger.logIncorrectClasspath(string12);
                }
            }
        }
        if (arrayList.size() == 0) {
            File[] fileArray2;
            File[][] fileArray3;
            String string13 = System.getProperty("java.version");
            if (string13 != null && string13.equalsIgnoreCase("1.1.8")) {
                this.logger.logWrongJDK();
                this.proceed = false;
                return;
            }
            if (this.getJavaHome() != null && (fileArray3 = this.getLibrariesFiles(fileArray2 = new File[]{new File(this.getJavaHome(), "lib")})) != null) {
                int n24 = 0;
                int n25 = fileArray3.length;
                while (n24 < n25) {
                    fileArray = fileArray3[n24];
                    if (fileArray != null) {
                        int n26 = 0;
                        int n27 = fileArray.length;
                        while (n26 < n27) {
                            FileSystem.Classpath classpath = FileSystem.a(fileArray[n26].getAbsolutePath(), null, 0, null);
                            if (classpath != null) {
                                arrayList.add(classpath);
                            }
                            ++n26;
                        }
                    }
                    ++n24;
                }
            }
        }
        if (arrayList3.size() == 0) {
            String string14 = System.getProperty("java.ext.dirs");
            if (string14 == null) {
                arrayList3.add(String.valueOf(this.getJavaHome().getAbsolutePath()) + "/lib/ext");
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string14, File.pathSeparator);
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList3.add(stringTokenizer.nextToken());
                }
            }
        }
        if (arrayList3.size() != 0) {
            File[] fileArray4 = new File[arrayList3.size()];
            int n28 = 0;
            while (n28 < fileArray4.length) {
                fileArray4[n28] = new File((String)arrayList3.get(n28));
                ++n28;
            }
            File[][] fileArray5 = this.getLibrariesFiles(fileArray4);
            if (fileArray5 != null) {
                int n29 = 0;
                int n30 = fileArray5.length;
                while (n29 < n30) {
                    File[] fileArray6 = fileArray5[n29];
                    if (fileArray6 != null) {
                        int n31 = 0;
                        int n32 = fileArray6.length;
                        while (n31 < n32) {
                            FileSystem.Classpath classpath = FileSystem.a(fileArray6[n31].getAbsolutePath(), null, 0, null);
                            if (classpath != null) {
                                arrayList2.add(classpath);
                            }
                            ++n31;
                        }
                    }
                    ++n29;
                }
            }
        }
        arrayList.addAll(arrayList2);
        arrayList.addAll(arrayList4);
        arrayList.addAll(arrayList5);
        arrayList5 = arrayList;
        this.a = new FileSystem.Classpath[arrayList5.size()];
        arrayList5.toArray(this.a);
        if (this.destinationPath == null) {
            this.generatePackagesStructure = false;
        } else if ("none".equals(this.destinationPath)) {
            this.destinationPath = null;
        }
        if (bl5) {
            Object v2 = this.options.get("org.eclipse.jdt.core.compiler.compliance");
            if ("1.3".equals(v2)) {
                if (!bl4) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!bl7) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
                }
            } else if ("1.4".equals(v2)) {
                if (!bl4) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.3");
                }
                if (!bl7) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                }
            } else if ("1.5".equals(v2)) {
                if (!bl4) {
                    this.options.put("org.eclipse.jdt.core.compiler.source", "1.5");
                }
                if (!bl7) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        if (bl4) {
            Object v3 = this.options.get("org.eclipse.jdt.core.compiler.source");
            if ("1.4".equals(v3)) {
                if (!bl5) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.4");
                }
                if (!bl7) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if ("1.5".equals(v3)) {
                if (!bl5) {
                    this.options.put("org.eclipse.jdt.core.compiler.compliance", "1.5");
                }
                if (!bl7) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        if (bl7) {
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.source")) >= 0x310000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) < 0x310000L) {
                throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"), "1.5"));
            }
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.source")) >= 0x300000L && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")) < 0x300000L) {
                throw new InvalidInputException(Main.bind("configure.incompatibleTargetForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"), "1.4"));
            }
            if (CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform"))) {
                throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForTarget", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), (String)this.options.get("org.eclipse.jdt.core.compiler.codegen.targetPlatform")));
            }
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.5") && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x310000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.5"));
        }
        if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4") && CompilerOptions.versionToJdkLevel(this.options.get("org.eclipse.jdt.core.compiler.compliance")) < 0x300000L) {
            throw new InvalidInputException(Main.bind("configure.incompatibleComplianceForSource", (String)this.options.get("org.eclipse.jdt.core.compiler.compliance"), "1.4"));
        }
        if (!bl7) {
            if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.3")) {
                this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.1");
            } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.4")) {
                if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                }
            } else if (this.options.get("org.eclipse.jdt.core.compiler.compliance").equals("1.5")) {
                if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.3")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.2");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.4")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.4");
                } else if (this.options.get("org.eclipse.jdt.core.compiler.source").equals("1.5")) {
                    this.options.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.5");
                }
            }
        }
        this.logger.logCommandLineArguments(stringArray2);
        this.logger.logOptions(this.options);
        this.logger.logClasspath(this.a);
        if (this.repetitions == 0) {
            this.repetitions = 1;
        }
        if (this.repetitions >= 3 && this.timing) {
            this.times = new long[this.repetitions];
            this.timesCounter = 0;
        }
    }

    private void addNewEntry(int n2, int n3, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, String string, ArrayList arrayList4, int n4, String string2) {
        Object object;
        AccessRule[] accessRuleArray = new AccessRule[arrayList4.size()];
        boolean bl2 = true;
        Iterator iterator = arrayList4.iterator();
        int n5 = 0;
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            char c2 = ((String)object).charAt(0);
            String string3 = ((String)object).substring(1);
            if (string3.length() > 0) {
                switch (c2) {
                    case '+': {
                        accessRuleArray[n5++] = new AccessRule(string3.toCharArray(), -1);
                        break;
                    }
                    case '~': {
                        accessRuleArray[n5++] = new AccessRule(string3.toCharArray(), 0x1000118);
                        break;
                    }
                    case '-': {
                        accessRuleArray[n5++] = new AccessRule(string3.toCharArray(), 0x1000133);
                        break;
                    }
                    default: {
                        bl2 = false;
                        break;
                    }
                }
                continue;
            }
            bl2 = false;
        }
        if (bl2) {
            object = new AccessRuleSet(accessRuleArray, "{0}");
            FileSystem.Classpath classpath = FileSystem.a(string, string2, 0, (AccessRuleSet)object);
            if (classpath != null) {
                if (n4 == n2) {
                    arrayList2.add(classpath);
                } else if (n4 == n3) {
                    if (classpath instanceof ClasspathDirectory) {
                        ((ClasspathDirectory)classpath).mode = 1;
                    }
                    arrayList3.add(classpath);
                } else {
                    arrayList.add(classpath);
                }
            } else {
                this.logger.logIncorrectClasspath(string);
            }
        } else {
            this.logger.logIncorrectClasspath(string);
        }
    }

    private File getJavaHome() {
        if (!this.javaHomeChecked) {
            this.javaHomeChecked = true;
            String string = System.getProperty("java.home");
            if (string != null) {
                this.javaHomeCache = new File(string);
                if (!this.javaHomeCache.exists()) {
                    this.javaHomeCache = null;
                }
            }
        }
        return this.javaHomeCache;
    }

    private void disableWarnings() {
        Object[] objectArray = this.options.entrySet().toArray();
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3) {
            Map.Entry entry = (Map.Entry)objectArray[n2];
            if (entry.getKey() instanceof String && entry.getValue() instanceof String && ((String)entry.getValue()).equals("warning")) {
                this.options.put(entry.getKey(), "ignore");
            }
            ++n2;
        }
        this.options.put("org.eclipse.jdt.core.compiler.taskTags", "");
    }

    public String extractDestinationPathFromSourceFile(CompilationResult compilationResult) {
        ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
        if (iCompilationUnit != null) {
            char[] cArray = iCompilationUnit.getFileName();
            int n2 = CharOperation.lastIndexOf(File.separatorChar, cArray);
            if (n2 == -1) {
                return System.getProperty("user.dir");
            }
            return new String(cArray, 0, n2);
        }
        return System.getProperty("user.dir");
    }

    public ICompilerRequestor getBatchRequestor() {
        return new ICompilerRequestor(this){
            public int a;
            public final Main b;
            {
                this.b = main;
                this.a = 0;
            }

            public void acceptResult(CompilationResult compilationResult) {
                int n2;
                if (compilationResult.lineSeparatorPositions != null) {
                    n2 = compilationResult.lineSeparatorPositions.length;
                    this.b.lineCount += (long)n2;
                    this.a += n2;
                    if (this.b.showProgress && this.a > 2000) {
                        this.b.logger.logProgress();
                        this.a = 0;
                    }
                }
                this.b.logger.startLoggingSource(compilationResult);
                if (compilationResult.hasProblems() || compilationResult.hasTasks()) {
                    n2 = this.b.logger.logProblems(compilationResult.getAllProblems(), compilationResult.compilationUnit.getContents(), this.b);
                    if (this.b.systemExitWhenFinished && !this.b.proceedOnError && n2 > 0) {
                        this.b.logger.endLoggingSource();
                        this.b.logger.endLoggingSources();
                        this.b.logger.printStats(this.b);
                        this.b.logger.flush();
                        this.b.logger.close();
                        System.exit(-1);
                    }
                }
                this.b.outputClassFiles(compilationResult);
                this.b.logger.endLoggingSource();
            }
        };
    }

    public CompilationUnit[] getCompilationUnits() throws InvalidInputException {
        int n2 = this.filenames.length;
        CompilationUnit[] compilationUnitArray = new CompilationUnit[n2];
        HashtableOfObject hashtableOfObject = new HashtableOfObject(n2);
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(string)) {
            string = null;
        }
        int n3 = 0;
        while (n3 < n2) {
            char[] cArray = this.filenames[n3].toCharArray();
            if (hashtableOfObject.get(cArray) != null) {
                throw new InvalidInputException(Main.bind("unit.more", this.filenames[n3]));
            }
            hashtableOfObject.put(cArray, cArray);
            File file = new File(this.filenames[n3]);
            if (!file.exists()) {
                throw new InvalidInputException(Main.bind("unit.missing", this.filenames[n3]));
            }
            String string2 = this.encodings[n3];
            if (string2 == null) {
                string2 = string;
            }
            compilationUnitArray[n3] = new CompilationUnit(null, this.filenames[n3], string2);
            ++n3;
        }
        return compilationUnitArray;
    }

    private File[][] getLibrariesFiles(File[] fileArray) {
        FilenameFilter filenameFilter = new FilenameFilter(this){
            public final Main a;
            {
                this.a = main;
            }

            public boolean accept(File file, String string) {
                String string2 = string.toLowerCase();
                return string2.endsWith(".jar") || string2.endsWith(".zip");
            }
        };
        int n2 = fileArray.length;
        File[][] fileArray2 = new File[n2][];
        int n3 = 0;
        while (n3 < n2) {
            File file = fileArray[n3];
            if (file.exists() && file.isDirectory()) {
                fileArray2[n3] = file.listFiles(filenameFilter);
            }
            ++n3;
        }
        return fileArray2;
    }

    public IErrorHandlingPolicy getHandlingPolicy() {
        return new IErrorHandlingPolicy(this){
            public final Main a;
            {
                this.a = main;
            }

            public boolean proceedOnErrors() {
                return this.a.proceedOnError;
            }

            public boolean stopOnFirstError() {
                return false;
            }
        };
    }

    public FileSystem getLibraryAccess() {
        String string = (String)this.options.get("org.eclipse.jdt.core.encoding");
        if ("".equals(string)) {
            string = null;
        }
        return new FileSystem(this.a, this.filenames);
    }

    public IProblemFactory getProblemFactory() {
        return new DefaultProblemFactory(Locale.getDefault());
    }

    public void outputClassFiles(CompilationResult compilationResult) {
        if (compilationResult != null && (!compilationResult.hasErrors() || this.proceedOnError)) {
            ClassFile[] classFileArray = compilationResult.getClassFiles();
            if (!this.generatePackagesStructure) {
                this.destinationPath = this.extractDestinationPathFromSourceFile(compilationResult);
            }
            if (this.destinationPath != null) {
                int n2 = 0;
                int n3 = classFileArray.length;
                while (n2 < n3) {
                    ClassFile classFile = classFileArray[n2];
                    char[] cArray = classFile.fileName();
                    int n4 = cArray.length;
                    char[] cArray2 = new char[n4 + 6];
                    System.arraycopy(cArray, 0, cArray2, 0, n4);
                    System.arraycopy(SUFFIX_class, 0, cArray2, n4, 6);
                    CharOperation.replace(cArray2, '/', File.separatorChar);
                    String string = new String(cArray2);
                    try {
                        if (this.compilerOptions.verbose) {
                            System.out.println(Messages.bind(Messages.compilation_write, new String[]{String.valueOf(this.exportedClassFilesCounter + 1), string}));
                        }
                        ClassFile.writeToDisk(this.generatePackagesStructure, this.destinationPath, string, classFile.getBytes());
                        this.logger.logClassFile(this.generatePackagesStructure, this.destinationPath, string);
                    }
                    catch (IOException iOException) {
                        String string2 = String.valueOf(this.destinationPath) + string;
                        iOException.printStackTrace();
                        this.logger.logNoClassFileCreated(string2);
                    }
                    ++this.exportedClassFilesCounter;
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performCompilation() throws InvalidInputException {
        this.startTime = System.currentTimeMillis();
        FileSystem fileSystem = this.getLibraryAccess();
        Compiler compiler = new Compiler(fileSystem, this.getHandlingPolicy(), this.options, this.getBatchRequestor(), this.getProblemFactory());
        this.compilerOptions = compiler.options;
        this.compilerOptions.verbose = this.verbose;
        this.compilerOptions.produceReferenceInfo = this.produceRefInfo;
        try {
            this.logger.startLoggingSources();
            compiler.compile(this.getCompilationUnits());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.logger.endLoggingSources();
            throw throwable;
        }
        {
            Object var3_5 = null;
            this.logger.endLoggingSources();
            this.logger.printStats(this);
            fileSystem.cleanup();
            return;
        }
    }

    public void printUsage() {
        this.logger.logUsage(Main.bind("misc.usage", new String[]{System.getProperty("path.separator"), Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")}));
        this.logger.flush();
    }

    public void printVersion() {
        this.logger.logVersion();
        this.logger.flush();
    }

    public static class Logger {
        private static final String CLASS = "class";
        private static final String CLASS_FILE = "classfile";
        private static final String CLASSPATH = "classpath";
        private static final String CLASSPATH_ID = "id";
        private static final String CLASSPATH_FILE = "FILE";
        private static final String CLASSPATH_FOLDER = "FOLDER";
        private static final String CLASSPATH_JAR = "JAR";
        private static final String CLASSPATHS = "classpaths";
        private static final String COMMAND_LINE_ARGUMENT = "argument";
        private static final String COMMAND_LINE_ARGUMENTS = "command_line";
        private static final String COMPILER = "compiler";
        private static final String COMPILER_COPYRIGHT = "copyright";
        private static final String COMPILER_VERSION = "version";
        private static final String COMPILER_NAME = "name";
        private static final String EXCEPTION = "exception";
        private static final String ERROR = "ERROR";
        private static final String ERROR_TAG = "error";
        private static final String KEY = "key";
        private static final String MESSAGE = "message";
        private static final String NUMBER_OF_CLASSFILES = "number_of_classfiles";
        private static final String NUMBER_OF_ERRORS = "errors";
        private static final String NUMBER_OF_LINES = "number_of_lines";
        private static final String NUMBER_OF_PROBLEMS = "problems";
        private static final String NUMBER_OF_TASKS = "tasks";
        private static final String NUMBER_OF_WARNINGS = "warnings";
        private static final String OPTION = "option";
        private static final String OPTIONS = "options";
        private static final String PATH = "path";
        private static final String PROBLEM_ARGUMENT = "argument";
        private static final String PROBLEM_ARGUMENT_VALUE = "value";
        private static final String PROBLEM_ARGUMENTS = "arguments";
        private static final String PROBLEM_ID = "id";
        private static final String PROBLEM_LINE = "line";
        private static final String PROBLEM_MESSAGE = "message";
        private static final String PROBLEM_SEVERITY = "severity";
        private static final String PROBLEM_SOURCE_START = "charStart";
        private static final String PROBLEM_SOURCE_END = "charEnd";
        private static final String PROBLEM_SUMMARY = "problem_summary";
        private static final String PROBLEM_TAG = "problem";
        private static final String PROBLEMS = "problems";
        private static final String SOURCE = "source";
        private static final String SOURCE_CONTEXT = "source_context";
        private static final String SOURCE_END = "sourceEnd";
        private static final String SOURCE_START = "sourceStart";
        private static final String SOURCES = "sources";
        private static final String STATS = "stats";
        private static final String TASK = "task";
        private static final String TASKS = "tasks";
        private static final String TIME = "time";
        private static final String VALUE = "value";
        private static final String WARNING = "WARNING";
        private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
        private static final String XML_DTD_DECLARATION = "<!DOCTYPE compiler SYSTEM \"compiler.dtd\">";
        private static final HashMap FIELD_TABLE = new HashMap();
        private PrintWriter err;
        public boolean a;
        private PrintWriter log;
        private PrintWriter out;
        private int tab;
        private HashMap parameters;
        public static Class b;

        static {
            try {
                Class<?> clazz = b;
                if (clazz == null) {
                    try {
                        clazz = b = Class.forName("org.eclipse.jdt.core.compiler.IProblem");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Class<?> clazz2 = clazz;
                Field[] fieldArray = clazz2.getFields();
                int n2 = 0;
                int n3 = fieldArray.length;
                while (n2 < n3) {
                    Field field = fieldArray[n2];
                    FIELD_TABLE.put(field.get(null), field.getName());
                    ++n2;
                }
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        private static void appendEscapedChar(StringBuffer stringBuffer, char c2) {
            String string = Logger.getReplacement(c2);
            if (string != null) {
                stringBuffer.append('&');
                stringBuffer.append(string);
                stringBuffer.append(';');
            } else {
                stringBuffer.append(c2);
            }
        }

        private static String getEscaped(String string) {
            StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
            int n2 = 0;
            while (n2 < string.length()) {
                Logger.appendEscapedChar(stringBuffer, string.charAt(n2));
                ++n2;
            }
            return stringBuffer.toString();
        }

        private static String getReplacement(char c2) {
            switch (c2) {
                case '<': {
                    return "lt";
                }
                case '>': {
                    return "gt";
                }
                case '\"': {
                    return "quot";
                }
                case '\'': {
                    return "apos";
                }
                case '&': {
                    return "amp";
                }
            }
            return null;
        }

        public Logger(PrintWriter printWriter, PrintWriter printWriter2) {
            this.out = printWriter;
            this.err = printWriter2;
            this.a = false;
            this.parameters = new HashMap();
        }

        public String buildFileName(String string, String string2) {
            char c2 = File.separatorChar;
            String string3 = File.separator;
            string = string.replace('/', c2);
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!string.endsWith(string3)) {
                stringBuffer.append(string3);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            String string4 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                stringBuffer.append(string4).append(string3);
                string4 = stringTokenizer.nextToken();
            }
            return stringBuffer.append(string4).toString();
        }

        public void close() {
            if (this.log != null) {
                if (this.a) {
                    this.endTag(COMPILER);
                    this.flush();
                }
                this.log.close();
            }
        }

        public void compiling() {
            this.printlnOut(Main.bind("progress.compiling"));
        }

        private void endLoggingProblems() {
            this.endTag("problems");
        }

        public void endLoggingSource() {
            if (this.a) {
                this.endTag(SOURCE);
            }
        }

        public void endLoggingSources() {
            if (this.a) {
                this.endTag(SOURCES);
            }
        }

        public void endLoggingTasks() {
            if (this.a) {
                this.endTag("tasks");
            }
        }

        public void endTag(String string) {
            --this.tab;
            this.printTag(String.valueOf('/') + string, null, true, false);
            --this.tab;
        }

        private void extractContext(IProblem iProblem, char[] cArray) {
            char c2;
            int n2;
            int n3 = iProblem.getSourceStart();
            if (n3 > (n2 = iProblem.getSourceEnd()) || n3 < 0 && n2 < 0) {
                this.parameters.put("value", Messages.problem_noSourceInformation);
                this.parameters.put(SOURCE_START, "-1");
                this.parameters.put(SOURCE_END, "-1");
                return;
            }
            int n4 = cArray.length;
            int n5 = n3 >= n4 ? n4 - 1 : n3;
            while (n5 > 0) {
                c2 = cArray[n5 - 1];
                if (c2 == '\n' || c2 == '\r') break;
                --n5;
            }
            int n6 = n2 >= n4 ? n4 - 1 : n2;
            while (n6 + 1 < n4) {
                c2 = cArray[n6 + 1];
                if (c2 == '\r' || c2 == '\n') break;
                ++n6;
            }
            while ((c2 = cArray[n5]) == ' ' || c2 == '\t') {
                ++n5;
            }
            while ((c2 = cArray[n6]) == ' ' || c2 == '\t') {
                --n6;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(cArray, n5, n6 - n5 + 1);
            this.parameters.put("value", String.valueOf(stringBuffer));
            this.parameters.put(SOURCE_START, Integer.toString(n3 - n5));
            this.parameters.put(SOURCE_END, Integer.toString(n2 - n5));
        }

        private String getFieldName(int n2) {
            return (String)FIELD_TABLE.get(new Integer(n2));
        }

        public void flush() {
            this.out.flush();
            this.err.flush();
            if (this.log != null) {
                this.log.flush();
            }
        }

        public void logAverage(long[] lArray, long l2) {
            Arrays.sort(lArray);
            int n2 = lArray.length;
            long l3 = 0L;
            int n3 = 1;
            int n4 = n2 - 1;
            while (n3 < n4) {
                l3 += lArray[n3];
                ++n3;
            }
            long l4 = l3 / (long)(n2 - 2);
            this.printlnOut(Main.bind("compile.averageTime", new String[]{String.valueOf(l2), String.valueOf(l4), String.valueOf((double)((int)((double)l2 * 10000.0 / (double)l4)) / 10.0)}));
        }

        public void logClasspath(FileSystem.Classpath[] classpathArray) {
            int n2;
            if (classpathArray == null) {
                return;
            }
            if (this.a && (n2 = classpathArray.length) != 0) {
                this.printTag(CLASSPATHS, null, true, false);
                int n3 = 0;
                while (n3 < n2) {
                    this.parameters.clear();
                    String string = classpathArray[n3].getPath();
                    this.parameters.put(PATH, string);
                    File file = new File(string);
                    String string2 = null;
                    if (file.isFile()) {
                        string2 = Util.isArchiveFileName(string) ? CLASSPATH_JAR : CLASSPATH_FILE;
                    } else if (file.isDirectory()) {
                        string2 = CLASSPATH_FOLDER;
                    }
                    if (string2 != null) {
                        this.parameters.put("id", string2);
                        this.printTag(CLASSPATH, this.parameters, true, true);
                    }
                    ++n3;
                }
                this.endTag(CLASSPATHS);
            }
        }

        public void logClassFile(boolean bl2, String string, String string2) {
            if (this.a) {
                String string3 = null;
                if (bl2) {
                    string3 = this.buildFileName(string, string2);
                } else {
                    char c2 = File.separatorChar;
                    String string4 = File.separator;
                    string = string.replace('/', c2);
                    int n2 = string2.lastIndexOf(c2);
                    if (n2 == -1) {
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2 : String.valueOf(string) + string4 + string2;
                    } else {
                        int n3 = string2.length();
                        string3 = string.endsWith(string4) ? String.valueOf(string) + string2.substring(n2 + 1, n3) : String.valueOf(string) + string4 + string2.substring(n2 + 1, n3);
                    }
                }
                File file = new File(string3);
                try {
                    this.parameters.clear();
                    this.parameters.put(PATH, file.getCanonicalPath());
                    this.printTag(CLASS_FILE, this.parameters, true, true);
                }
                catch (IOException iOException) {
                    this.logNoClassFileCreated(string3);
                }
            }
        }

        public void logCommandLineArguments(String[] stringArray) {
            int n2;
            if (stringArray == null) {
                return;
            }
            if (this.a && (n2 = stringArray.length) != 0) {
                this.printTag(COMMAND_LINE_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int n3 = 0;
                while (n3 < n2) {
                    this.parameters.put("value", stringArray[n3]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n3;
                }
                this.endTag(COMMAND_LINE_ARGUMENTS);
            }
        }

        public void logException(Exception exception) {
            String string = exception.getMessage();
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("message", string);
                this.parameters.put(CLASS, exception.getClass());
                this.printTag(EXCEPTION, this.parameters, true, true);
            }
            this.printlnErr(string);
        }

        public void logIncorrectClasspath(String string) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.incorrectClasspath", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.incorrectClasspath", string));
        }

        public void logNoClassFileCreated(String string) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("output.noClassFileCreated", string));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("output.noClassFileCreated", string));
        }

        public void logNoClasspath() {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.noClasspath"));
                this.printTag(ERROR_TAG, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.noClasspath"));
        }

        public void logNumberOfClassFilesGenerated(int n2) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("value", new Integer(n2));
                this.printTag(NUMBER_OF_CLASSFILES, this.parameters, true, true);
            }
            if (n2 == 1) {
                this.printlnOut(Main.bind("compile.oneClassFileGenerated"));
            } else {
                this.printlnOut(Main.bind("compile.severalClassFilesGenerated", String.valueOf(n2)));
            }
        }

        public void logOptions(Map map) {
            if (this.a) {
                this.printTag(OPTIONS, null, true, false);
                Set set = map.keySet();
                Object[] objectArray = set.toArray();
                Arrays.sort(objectArray);
                int n2 = 0;
                int n3 = objectArray.length;
                while (n2 < n3) {
                    this.parameters.clear();
                    Object object = objectArray[n2];
                    this.parameters.put(KEY, object);
                    this.parameters.put("value", map.get(object));
                    this.printTag(OPTION, this.parameters, true, true);
                    ++n2;
                }
                this.endTag(OPTIONS);
            }
        }

        private void logProblem(IProblem iProblem, int n2, int n3, char[] cArray) {
            if (n2 == 0) {
                this.printlnErr("----------");
            }
            this.printlnErr(iProblem.isError() ? Main.bind("requestor.error", Integer.toString(n3), new String(iProblem.getOriginatingFileName())) : Main.bind("requestor.warning", Integer.toString(n3), new String(iProblem.getOriginatingFileName())));
            try {
                this.printlnErr(((DefaultProblem)iProblem).errorReportSource(cArray));
                this.printlnErr(iProblem.getMessage());
            }
            catch (Exception exception) {
                this.printlnErr(Main.bind("requestor.notRetrieveErrorMessage", iProblem.toString()));
            }
            this.printlnErr("----------");
        }

        public void logProblemsSummary(int n2, int n3, int n4, int n5) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("problems", new Integer(n2));
                this.parameters.put(NUMBER_OF_ERRORS, new Integer(n3));
                this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n4));
                this.parameters.put("tasks", new Integer(n5));
                this.printTag(PROBLEM_SUMMARY, this.parameters, true, true);
            }
            if (n2 == 1) {
                String string = null;
                string = n3 == 1 ? Main.bind("compile.oneError") : Main.bind("compile.oneWarning");
                this.printErr(Main.bind("compile.oneProblem", string));
            } else {
                int n6;
                String string = null;
                String string2 = null;
                if (n3 > 0) {
                    string = n3 == 1 ? Main.bind("compile.oneError") : Main.bind("compile.severalErrors", String.valueOf(n3));
                }
                if ((n6 = n4 + n5) > 0) {
                    string2 = n6 == 1 ? Main.bind("compile.oneWarning") : Main.bind("compile.severalWarnings", String.valueOf(n6));
                }
                if (string == null || string2 == null) {
                    if (string == null) {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n2), string2));
                    } else {
                        this.printErr(Main.bind("compile.severalProblemsErrorsOrWarnings", String.valueOf(n2), string));
                    }
                } else {
                    this.printErr(Main.bind("compile.severalProblemsErrorsAndWarnings", new String[]{String.valueOf(n2), string, string2}));
                }
            }
        }

        public int logProblems(IProblem[] iProblemArray, char[] cArray, Main main) {
            int n2 = iProblemArray.length;
            int n3 = 0;
            if (n2 != 0) {
                if (this.a) {
                    IProblem iProblem;
                    int n4 = 0;
                    int n5 = 0;
                    int n6 = 0;
                    int n7 = 0;
                    while (n7 < n2) {
                        iProblem = iProblemArray[n7];
                        if (iProblem != null) {
                            ++main.globalProblemsCount;
                            this.logProblem(iProblem, n3, main.globalProblemsCount, cArray);
                            if (iProblem.isError()) {
                                ++n4;
                                ++main.globalErrorsCount;
                                ++n3;
                            } else if (iProblem.getID() == 536871362) {
                                ++main.globalTasksCount;
                                ++n6;
                            } else {
                                ++main.globalWarningsCount;
                                ++n5;
                            }
                        }
                        ++n7;
                    }
                    if (n4 + n5 != 0) {
                        this.startLoggingProblems(n4, n5);
                        n7 = 0;
                        while (n7 < n2) {
                            iProblem = iProblemArray[n7];
                            if (iProblem != null && iProblem.getID() != 536871362) {
                                this.logXmlProblem(iProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingProblems();
                    }
                    if (n6 != 0) {
                        this.startLoggingTasks(n6);
                        n7 = 0;
                        while (n7 < n2) {
                            iProblem = iProblemArray[n7];
                            if (iProblem != null && iProblem.getID() == 536871362) {
                                this.logXmlTask(iProblem, cArray);
                            }
                            ++n7;
                        }
                        this.endLoggingTasks();
                    }
                } else {
                    int n8 = 0;
                    while (n8 < n2) {
                        if (iProblemArray[n8] != null) {
                            ++main.globalProblemsCount;
                            this.logProblem(iProblemArray[n8], n3, main.globalProblemsCount, cArray);
                            if (iProblemArray[n8].isError()) {
                                ++main.globalErrorsCount;
                                ++n3;
                            } else {
                                ++main.globalWarningsCount;
                            }
                        }
                        ++n8;
                    }
                }
            }
            return n3;
        }

        public void logProgress() {
            this.printOut('.');
        }

        public void logRepetition(int n2, int n3) {
            this.printlnOut(Main.bind("compile.repetition", String.valueOf(n2 + 1), String.valueOf(n3)));
        }

        public void printStats(Main main) {
            boolean bl2 = main.timing;
            if (this.a) {
                this.printTag(STATS, null, true, false);
            }
            if (bl2) {
                long l2 = System.currentTimeMillis() - main.startTime;
                this.logTiming(l2, main.lineCount);
                if (main.times != null) {
                    main.times[main.timesCounter++] = l2;
                }
            }
            if (main.globalProblemsCount > 0) {
                this.logProblemsSummary(main.globalProblemsCount, main.globalErrorsCount, main.globalWarningsCount, main.globalTasksCount);
            }
            if (main.exportedClassFilesCounter != 0 && (main.showProgress || bl2 || main.verbose)) {
                this.logNumberOfClassFilesGenerated(main.exportedClassFilesCounter);
            }
            if (this.a) {
                this.endTag(STATS);
            }
        }

        public void logTiming(long l2, long l3) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("value", new Long(l2));
                this.printTag(TIME, this.parameters, true, true);
                this.parameters.clear();
                this.parameters.put("value", new Long(l3));
                this.printTag(NUMBER_OF_LINES, this.parameters, true, true);
            }
            if (l3 != 0L) {
                this.printlnOut(Main.bind("compile.instantTime", new String[]{String.valueOf(l3), String.valueOf(l2), String.valueOf((double)((int)((double)l3 * 10000.0 / (double)l2)) / 10.0)}));
            } else {
                this.printlnOut(Main.bind("compile.totalTime", String.valueOf(l2)));
            }
        }

        public void logUsage(String string) {
            this.printlnOut(string);
        }

        public void logVersion() {
            this.printlnOut(Main.bind("misc.version", new String[]{Main.bind("compiler.name"), Main.bind("compiler.version"), Main.bind("compiler.copyright")}));
        }

        public void logWrongJDK() {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("message", Main.bind("configure.requiresJDK1.2orAbove"));
                this.printTag(ERROR, this.parameters, true, true);
            }
            this.printlnErr(Main.bind("configure.requiresJDK1.2orAbove"));
        }

        private void logXmlProblem(IProblem iProblem, char[] cArray) {
            int n2 = iProblem.getSourceStart();
            int n3 = iProblem.getSourceEnd();
            this.parameters.clear();
            this.parameters.put("id", this.getFieldName(iProblem.getID()));
            this.parameters.put(PROBLEM_SEVERITY, iProblem.isError() ? ERROR : WARNING);
            this.parameters.put(PROBLEM_LINE, new Integer(iProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(n2));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(n3));
            this.printTag(PROBLEM_TAG, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", iProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(iProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            String[] stringArray = iProblem.getArguments();
            int n4 = stringArray.length;
            if (n4 != 0) {
                this.printTag(PROBLEM_ARGUMENTS, null, true, false);
                this.parameters.clear();
                int n5 = 0;
                while (n5 < n4) {
                    this.parameters.put("value", stringArray[n5]);
                    this.printTag("argument", this.parameters, true, true);
                    ++n5;
                }
                this.endTag(PROBLEM_ARGUMENTS);
            }
            this.endTag(PROBLEM_TAG);
        }

        private void logXmlTask(IProblem iProblem, char[] cArray) {
            this.parameters.clear();
            this.parameters.put(PROBLEM_LINE, new Integer(iProblem.getSourceLineNumber()));
            this.parameters.put(PROBLEM_SOURCE_START, new Integer(iProblem.getSourceStart()));
            this.parameters.put(PROBLEM_SOURCE_END, new Integer(iProblem.getSourceEnd()));
            this.printTag(TASK, this.parameters, true, false);
            this.parameters.clear();
            this.parameters.put("value", iProblem.getMessage());
            this.printTag("message", this.parameters, true, true);
            this.parameters.clear();
            this.extractContext(iProblem, cArray);
            this.printTag(SOURCE_CONTEXT, this.parameters, true, true);
            this.endTag(TASK);
        }

        private void printErr(String string) {
            this.err.print(string);
            if (!this.a && this.log != null) {
                this.log.print(string);
            }
        }

        private void printlnErr(String string) {
            this.err.println(string);
            if (!this.a && this.log != null) {
                this.log.println(string);
            }
        }

        private void printlnOut(String string) {
            this.out.println(string);
            if (!this.a && this.log != null) {
                this.log.println(string);
            }
        }

        public void printNewLine() {
            this.out.println();
        }

        private void printOut(char c2) {
            this.out.print(c2);
        }

        public void printTag(String string, HashMap hashMap, boolean bl2, boolean bl3) {
            int n2 = this.tab;
            while (n2 > 0) {
                this.log.print('\t');
                --n2;
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<");
            stringBuffer.append(string);
            if (hashMap != null) {
                Enumeration enumeration = Collections.enumeration(hashMap.keySet());
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append(" ");
                    String string2 = (String)enumeration.nextElement();
                    stringBuffer.append(string2);
                    stringBuffer.append("=\"");
                    stringBuffer.append(Logger.getEscaped(String.valueOf(hashMap.get(string2))));
                    stringBuffer.append("\"");
                }
            }
            if (bl3) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">");
                ++this.tab;
            }
            if (bl2) {
                this.log.println(String.valueOf(stringBuffer));
            } else {
                this.log.print(String.valueOf(stringBuffer));
            }
        }

        public void setLog(String string) throws InvalidInputException {
            Date date = new Date();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("d MMM yyyy HH:mm:ss", Locale.getDefault());
            try {
                this.log = new PrintWriter(new FileOutputStream(string, false));
                int n2 = string.lastIndexOf(46);
                if (n2 != -1) {
                    if (string.substring(n2).toLowerCase().equals(".xml")) {
                        this.a = true;
                        this.log.println(XML_HEADER);
                        this.log.println("<!-- " + simpleDateFormat.format(date) + " -->");
                        this.log.println(XML_DTD_DECLARATION);
                        this.tab = 0;
                        this.parameters.clear();
                        this.parameters.put(COMPILER_NAME, Main.bind("compiler.name"));
                        this.parameters.put(COMPILER_VERSION, Main.bind("compiler.version"));
                        this.parameters.put(COMPILER_COPYRIGHT, Main.bind("compiler.copyright"));
                        this.printTag(COMPILER, this.parameters, true, false);
                    } else {
                        this.log.println("# " + simpleDateFormat.format(date));
                    }
                } else {
                    this.log.println("# " + simpleDateFormat.format(date));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new InvalidInputException(Main.bind("configure.cannotOpenLog"));
            }
        }

        private void startLoggingProblems(int n2, int n3) {
            this.parameters.clear();
            this.parameters.put("problems", new Integer(n2 + n3));
            this.parameters.put(NUMBER_OF_ERRORS, new Integer(n2));
            this.parameters.put(NUMBER_OF_WARNINGS, new Integer(n3));
            this.printTag("problems", this.parameters, true, false);
        }

        public void startLoggingSource(CompilationResult compilationResult) {
            if (this.a) {
                ICompilationUnit iCompilationUnit = compilationResult.compilationUnit;
                char[] cArray = iCompilationUnit.getFileName();
                File file = new File(new String(cArray));
                if (cArray != null) {
                    this.parameters.clear();
                    if (iCompilationUnit != null) {
                        this.parameters.put(PATH, file.getAbsolutePath());
                    }
                }
                this.printTag(SOURCE, this.parameters, true, false);
            }
        }

        public void startLoggingSources() {
            if (this.a) {
                this.printTag(SOURCES, null, true, false);
            }
        }

        public void startLoggingTasks(int n2) {
            if (this.a) {
                this.parameters.clear();
                this.parameters.put("tasks", new Integer(n2));
                this.printTag("tasks", this.parameters, true, false);
            }
        }
    }
}

