/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class UnaryExpression
extends OperatorExpression {
    public Expression expression;
    public Constant optimizedBooleanConstant;

    public UnaryExpression(Expression expression, int n2) {
        this.expression = expression;
        this.bits |= n2 << 6;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0xFC0) >> 6 == 11) {
            return this.expression.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.expression.analyseCode(blockScope, flowContext, flowInfo);
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl2) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 11: {
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 5: {
                        Label label = new Label(codeStream);
                        this.expression.generateOptimizedBoolean(blockScope, codeStream, null, label, bl2);
                        if (bl2) {
                            codeStream.iconst_0();
                            if (!label.hasForwardReferences()) break;
                            Label label2 = new Label(codeStream);
                            codeStream.goto_(label2);
                            codeStream.decrStackSize(1);
                            label.place();
                            codeStream.iconst_1();
                            label2.place();
                            break;
                        }
                        label.place();
                    }
                }
                break;
            }
            case 12: {
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        this.expression.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.iconst_m1();
                        codeStream.ixor();
                        break;
                    }
                    case 7: {
                        this.expression.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ldc2_w(-1L);
                        codeStream.lxor();
                    }
                }
                break;
            }
            case 13: {
                if (this.constant != NotAConstant) {
                    if (!bl2) break;
                    switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                        case 10: {
                            codeStream.generateInlinedValue(this.constant.intValue() * -1);
                            break;
                        }
                        case 9: {
                            codeStream.generateInlinedValue(this.constant.floatValue() * -1.0f);
                            break;
                        }
                        case 7: {
                            codeStream.generateInlinedValue(this.constant.longValue() * -1L);
                            break;
                        }
                        case 8: {
                            codeStream.generateInlinedValue(this.constant.doubleValue() * -1.0);
                        }
                    }
                    break;
                }
                this.expression.generateCode(blockScope, codeStream, bl2);
                if (!bl2) break;
                switch ((this.expression.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.ineg();
                        break;
                    }
                    case 9: {
                        codeStream.fneg();
                        break;
                    }
                    case 7: {
                        codeStream.lneg();
                        break;
                    }
                    case 8: {
                        codeStream.dneg();
                    }
                }
                break;
            }
            case 14: {
                this.expression.generateCode(blockScope, codeStream, bl2);
            }
        }
        if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            super.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
            return;
        }
        if ((this.bits & 0xFC0) >> 6 == 11) {
            this.expression.generateOptimizedBoolean(blockScope, codeStream, label2, label, bl2);
        } else {
            super.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
        }
    }

    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.operatorToString()).append(' ');
        return this.expression.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n2;
        boolean bl2;
        TypeBinding typeBinding;
        boolean bl3 = this.expression instanceof CastExpression;
        if (bl3) {
            this.expression.bits |= 0x20;
        }
        if ((typeBinding = this.expression.resolveType(blockScope)) == null) {
            this.constant = NotAConstant;
            return null;
        }
        int n3 = typeBinding.id;
        boolean bl4 = bl2 = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        if (bl2 && !typeBinding.isBaseType()) {
            n3 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id;
        }
        if (n3 > 15) {
            this.constant = NotAConstant;
            blockScope.problemReporter().invalidOperator(this, typeBinding);
            return null;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 11: {
                n2 = 0;
                break;
            }
            case 12: {
                n2 = 10;
                break;
            }
            default: {
                n2 = 13;
            }
        }
        int n4 = OperatorSignatures[n2][(n3 << 4) + n3];
        this.expression.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 16 & 0xF), typeBinding);
        this.bits |= n4 & 0xF;
        switch (n4 & 0xF) {
            case 5: {
                this.resolvedType = BooleanBinding;
                break;
            }
            case 3: {
                this.resolvedType = ByteBinding;
                break;
            }
            case 2: {
                this.resolvedType = CharBinding;
                break;
            }
            case 8: {
                this.resolvedType = DoubleBinding;
                break;
            }
            case 9: {
                this.resolvedType = FloatBinding;
                break;
            }
            case 10: {
                this.resolvedType = IntBinding;
                break;
            }
            case 7: {
                this.resolvedType = LongBinding;
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                if (n3 != 0) {
                    blockScope.problemReporter().invalidOperator(this, typeBinding);
                }
                return null;
            }
        }
        if (this.expression.constant != Constant.NotAConstant) {
            this.constant = Constant.computeConstantOperation(this.expression.constant, n3, (this.bits & 0xFC0) >> 6);
        } else {
            Constant constant;
            this.constant = Constant.NotAConstant;
            if ((this.bits & 0xFC0) >> 6 == 11 && (constant = this.expression.optimizedBooleanConstant()) != Constant.NotAConstant) {
                this.optimizedBooleanConstant = Constant.fromValue(!constant.booleanValue());
            }
        }
        if (bl3) {
            CastExpression.checkNeedForArgumentCast(blockScope, n2, n4, this.expression, n3);
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

