/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SingleTypeReference
extends TypeReference {
    public char[] token;

    public SingleTypeReference(char[] cArray, long l2) {
        this.token = cArray;
        this.sourceStart = (int)(l2 >>> 32);
        this.sourceEnd = (int)(l2 & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int n2) {
        return new ArrayTypeReference(this.token, n2, ((long)this.sourceStart << 32) + (long)this.sourceEnd);
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        this.resolvedType = scope.getType(this.token);
        if (scope.kind == 3 && this.resolvedType.isValidBinding() && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this, null)) {
            return null;
        }
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return new char[][]{this.token};
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        return stringBuffer.append(this.token);
    }

    public TypeBinding resolveTypeEnclosing(BlockScope blockScope, ReferenceBinding referenceBinding) {
        ReferenceBinding referenceBinding2 = blockScope.getMemberType(this.token, referenceBinding);
        if (!referenceBinding2.isValidBinding()) {
            this.resolvedType = referenceBinding2;
            blockScope.problemReporter().invalidEnclosingType(this, referenceBinding2, referenceBinding);
            return null;
        }
        if (this.isTypeUseDeprecated(referenceBinding2, blockScope)) {
            blockScope.problemReporter().deprecatedType(referenceBinding2, this);
        }
        this.resolvedType = blockScope.environment().convertToRawType(referenceBinding2);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

