/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class ParameterizedQualifiedTypeReference
extends ArrayQualifiedTypeReference {
    public TypeReference[][] typeArguments;
    private boolean didResolve = false;

    public ParameterizedQualifiedTypeReference(char[][] cArray, TypeReference[][] typeReferenceArray, int n2, long[] lArray) {
        super(cArray, n2, lArray);
        this.typeArguments = typeReferenceArray;
    }

    public void checkBounds(Scope scope) {
        if (this.resolvedType == null) {
            return;
        }
        this.checkBounds((ReferenceBinding)this.resolvedType.leafComponentType(), scope, this.typeArguments.length - 1);
    }

    public void checkBounds(ReferenceBinding referenceBinding, Scope scope, int n2) {
        if (referenceBinding.enclosingType() != null) {
            this.checkBounds(referenceBinding.enclosingType(), scope, n2 - 1);
        }
        if (referenceBinding.isParameterizedType()) {
            ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)referenceBinding;
            ReferenceBinding referenceBinding2 = parameterizedTypeBinding.type;
            TypeVariableBinding[] typeVariableBindingArray = referenceBinding2.typeVariables();
            TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
            if (typeBindingArray != null && typeVariableBindingArray != null) {
                parameterizedTypeBinding.boundCheck(scope, this.typeArguments[n2]);
            }
        }
    }

    public TypeReference copyDims(int n2) {
        return new ParameterizedQualifiedTypeReference(this.tokens, this.typeArguments, n2, this.sourcePositions);
    }

    public char[][] getParameterizedTypeName() {
        int n2;
        Object[] objectArray;
        int n3 = this.tokens.length;
        char[][] cArray = new char[n3][];
        int n4 = 0;
        while (n4 < n3) {
            objectArray = this.typeArguments[n4];
            if (objectArray == null) {
                cArray[n4] = this.tokens[n4];
            } else {
                StringBuffer stringBuffer = new StringBuffer(5);
                stringBuffer.append(this.tokens[n4]);
                stringBuffer.append('<');
                n2 = 0;
                int n5 = objectArray.length;
                while (n2 < n5) {
                    if (n2 > 0) {
                        stringBuffer.append(',');
                    }
                    stringBuffer.append(CharOperation.concatWith(objectArray[n2].getParameterizedTypeName(), '.'));
                    ++n2;
                }
                stringBuffer.append('>');
                n2 = stringBuffer.length();
                cArray[n4] = new char[n2];
                stringBuffer.getChars(0, n2, cArray[n4], 0);
            }
            ++n4;
        }
        n4 = this.a;
        if (n4 > 0) {
            objectArray = new char[n4 * 2];
            int n6 = 0;
            while (n6 < n4) {
                n2 = n6 * 2;
                objectArray[n2] = (TypeReference)91;
                objectArray[n2 + 1] = (TypeReference)93;
                ++n6;
            }
            cArray[n3 - 1] = CharOperation.concat(cArray[n3 - 1], (char[])objectArray);
        }
        return cArray;
    }

    public TypeBinding getTypeBinding(Scope scope) {
        return null;
    }

    private TypeBinding internalResolveType(Scope scope, boolean bl2) {
        this.constant = NotAConstant;
        if (this.didResolve) {
            if (this.resolvedType != null && !this.resolvedType.isValidBinding()) {
                return null;
            }
            return this.resolvedType;
        }
        this.didResolve = true;
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            this.resolvedType = (ReferenceBinding)binding;
            this.reportInvalidType(scope);
            return null;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl3 = scope.kind == 3;
        boolean bl4 = true;
        TypeBinding typeBinding = null;
        int n2 = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int n3 = this.tokens.length;
        while (n2 < n3) {
            TypeReference[] typeReferenceArray;
            this.findNextTypeBinding(n2, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                this.reportInvalidType(scope);
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            if (typeBinding == null && (typeBinding = referenceBinding.enclosingType()) != null && referenceBinding.isStatic() && (typeBinding.isGenericType() || typeBinding.isParameterizedType())) {
                typeBinding = scope.environment().createRawType((ReferenceBinding)typeBinding.erasure(), typeBinding.enclosingType());
            }
            if (bl4 && referenceBinding.isStatic() && typeBinding != null && (typeBinding.isParameterizedType() || typeBinding.isGenericType())) {
                scope.problemReporter().staticMemberOfParameterizedType(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding));
                bl4 = false;
            }
            if ((typeReferenceArray = this.typeArguments[n2]) != null) {
                boolean bl5;
                TypeVariableBinding[] typeVariableBindingArray;
                TypeBinding typeBinding2;
                TypeReference typeReference = null;
                if (bl3) {
                    typeReference = ((ClassScope)scope).superTypeReference;
                    ((ClassScope)scope).superTypeReference = null;
                }
                int n4 = typeReferenceArray.length;
                TypeBinding[] typeBindingArray = new TypeBinding[n4];
                boolean bl6 = false;
                int n5 = 0;
                while (n5 < n4) {
                    TypeReference typeReference2 = typeReferenceArray[n5];
                    TypeBinding typeBinding3 = typeBinding2 = bl3 ? typeReference2.resolveTypeArgument((ClassScope)scope, referenceBinding, n5) : typeReference2.resolveTypeArgument((BlockScope)scope, referenceBinding, n5);
                    if (typeBinding2 == null) {
                        bl6 = true;
                    } else {
                        typeBindingArray[n5] = typeBinding2;
                    }
                    ++n5;
                }
                if (bl6) {
                    return null;
                }
                if (bl3) {
                    ((ClassScope)scope).superTypeReference = typeReference;
                    if (((ClassScope)scope).detectHierarchyCycle(referenceBinding, this, typeBindingArray)) {
                        return null;
                    }
                }
                if ((typeVariableBindingArray = referenceBinding.typeVariables()) == NoTypeVariables) {
                    scope.problemReporter().nonGenericTypeCannotBeParameterized(this, referenceBinding, typeBindingArray);
                    return null;
                }
                if (n4 != typeVariableBindingArray.length) {
                    scope.problemReporter().incorrectArityForParameterizedType(this, referenceBinding, typeBindingArray);
                    return null;
                }
                if (bl4 && !referenceBinding.isStatic() && typeBinding != null && typeBinding.isRawType()) {
                    scope.problemReporter().rawMemberTypeCannotBeParameterized(this, scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)typeBinding), typeBindingArray);
                    bl4 = false;
                }
                boolean bl7 = bl5 = typeBinding == null || typeBinding instanceof SourceTypeBinding;
                if (bl5) {
                    int n6 = 0;
                    while (n6 < n4) {
                        if (typeVariableBindingArray[n6] != typeBindingArray[n6]) {
                            bl5 = false;
                            break;
                        }
                        ++n6;
                    }
                }
                if (bl5) {
                    typeBinding = (ReferenceBinding)referenceBinding.erasure();
                } else {
                    typeBinding2 = scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), typeBindingArray, (ReferenceBinding)typeBinding);
                    if (bl2) {
                        ((ParameterizedTypeBinding)typeBinding2).boundCheck(scope, typeReferenceArray);
                    }
                    typeBinding = typeBinding2;
                }
            } else {
                if (bl3 && ((ClassScope)scope).detectHierarchyCycle(referenceBinding, this, null)) {
                    return null;
                }
                if (referenceBinding.isGenericType()) {
                    if (bl4 && typeBinding != null && typeBinding.isParameterizedType()) {
                        scope.problemReporter().parameterizedMemberTypeMissingArguments(this, scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding));
                        bl4 = false;
                    }
                    typeBinding = scope.environment().createRawType(referenceBinding, (ReferenceBinding)typeBinding);
                } else {
                    typeBinding = typeBinding != null && typeBinding.isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding) : referenceBinding;
                }
            }
            ++n2;
        }
        this.resolvedType = typeBinding;
        if (this.isTypeUseDeprecated(this.resolvedType, scope)) {
            this.reportDeprecatedType(scope);
        }
        if (this.a > 0) {
            if (this.a > 255) {
                scope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = scope.createArrayType(this.resolvedType, this.a);
        }
        return this.resolvedType;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        int n3;
        int n4 = this.tokens.length;
        int n5 = 0;
        while (n5 < n4 - 1) {
            stringBuffer.append(this.tokens[n5]);
            TypeReference[] typeReferenceArray = this.typeArguments[n5];
            if (typeReferenceArray != null) {
                stringBuffer.append('<');
                n3 = typeReferenceArray.length - 1;
                int n6 = 0;
                while (n6 < n3) {
                    typeReferenceArray[n6].print(0, stringBuffer);
                    stringBuffer.append(", ");
                    ++n6;
                }
                typeReferenceArray[n3].print(0, stringBuffer);
                stringBuffer.append('>');
            }
            stringBuffer.append('.');
            ++n5;
        }
        stringBuffer.append(this.tokens[n4 - 1]);
        TypeReference[] typeReferenceArray = this.typeArguments[n4 - 1];
        if (typeReferenceArray != null) {
            stringBuffer.append('<');
            int n7 = typeReferenceArray.length - 1;
            n3 = 0;
            while (n3 < n7) {
                typeReferenceArray[n3].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n3;
            }
            typeReferenceArray[n7].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        if ((this.bits & 0x4000) != 0) {
            int n8 = 0;
            while (n8 < this.a - 1) {
                stringBuffer.append("[]");
                ++n8;
            }
            stringBuffer.append("...");
        } else {
            int n9 = 0;
            while (n9 < this.a) {
                stringBuffer.append("[]");
                ++n9;
            }
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope, boolean bl2) {
        return this.internalResolveType(blockScope, bl2);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope, false);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2 = 0;
            int n3 = this.typeArguments.length;
            while (n2 < n3) {
                if (this.typeArguments[n2] != null) {
                    int n4 = 0;
                    int n5 = this.typeArguments[n2].length;
                    while (n4 < n5) {
                        this.typeArguments[n2][n4].traverse(aSTVisitor, blockScope);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n2 = 0;
            int n3 = this.typeArguments.length;
            while (n2 < n3) {
                if (this.typeArguments[n2] != null) {
                    int n4 = 0;
                    int n5 = this.typeArguments[n2].length;
                    while (n4 < n5) {
                        this.typeArguments[n2][n4].traverse(aSTVisitor, classScope);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

