/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;
    public TypeParameter[] typeParameters;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding typeBinding;
            int n2;
            int n3;
            if (this.binding == null) {
                return;
            }
            if (!this.binding.isUsed() && (this.binding.isPrivate() || (this.binding.modifiers & 0x30000000) == 0 && this.binding.declaringClass.isLocalType()) && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.declaringClass.isEnum() && (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF)) {
                return;
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.arguments != null) {
                n3 = 0;
                n2 = this.arguments.length;
                while (n3 < n2) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[n3].binding);
                    ++n3;
                }
            }
            if (this.statements != null) {
                n3 = 0;
                n2 = 0;
                int n4 = this.statements.length;
                while (n2 < n4) {
                    Statement statement = this.statements[n2];
                    if (!statement.complainIfUnreachable(flowInfo, this.scope, n3 != 0)) {
                        flowInfo = statement.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                    } else {
                        n3 = 1;
                    }
                    ++n2;
                }
            }
            if ((typeBinding = this.binding.returnType) == VoidBinding || this.isAbstract()) {
                this.needFreeReturn = flowInfo.isReachable();
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(typeBinding, this);
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean isMethod() {
        return true;
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    public StringBuffer printReturnType(int n2, StringBuffer stringBuffer) {
        if (this.returnType == null) {
            return stringBuffer;
        }
        return this.returnType.printExpression(0, stringBuffer).append(' ');
    }

    public void resolveStatements() {
        int n2;
        int n3;
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        if (this.typeParameters != null) {
            n3 = 0;
            n2 = this.typeParameters.length;
            while (n3 < n2) {
                this.typeParameters[n3].resolve(this.scope);
                ++n3;
            }
        }
        if (this.binding != null && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
            n3 = this.binding.modifiers;
            n2 = (this.binding.tagBits & 0x1000000000000L) != 0L ? 1 : 0;
            boolean bl2 = this.binding.declaringClass.isInterface();
            if (n2 != 0) {
                if ((n3 & 0x10000000) == 0 || bl2) {
                    this.scope.problemReporter().methodMustOverride(this);
                }
            } else if (!bl2 && (n3 & 0x10000008) == 0x10000000) {
                this.scope.problemReporter().missingOverrideAnnotation(this);
            }
        }
        switch (this.scope.referenceType().kind()) {
            case 3: {
                if (this.selector == TypeConstants.VALUES || this.selector == TypeConstants.VALUEOF) break;
            }
            case 1: {
                if ((this.modifiers & 0x1000000) != 0) {
                    if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) break;
                    this.scope.problemReporter().methodNeedBody(this);
                    break;
                }
                if ((this.modifiers & 0x100) == 0 && (this.modifiers & 0x400) == 0) break;
                this.scope.problemReporter().methodNeedingNoBody(this);
            }
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n2;
            int n3;
            if (this.annotations != null) {
                n3 = this.annotations.length;
                n2 = 0;
                while (n2 < n3) {
                    this.annotations[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.typeParameters != null) {
                n3 = this.typeParameters.length;
                n2 = 0;
                while (n2 < n3) {
                    this.typeParameters[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.returnType != null) {
                this.returnType.traverse(aSTVisitor, this.scope);
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                n2 = 0;
                while (n2 < n3) {
                    this.arguments[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.thrownExceptions != null) {
                n3 = this.thrownExceptions.length;
                n2 = 0;
                while (n2 < n3) {
                    this.thrownExceptions[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.statements != null) {
                n3 = this.statements.length;
                n2 = 0;
                while (n2 < n3) {
                    this.statements[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

