/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class MemberValuePair
extends ASTNode {
    public char[] name;
    public Expression value;
    public MethodBinding binding;

    public MemberValuePair(char[] cArray, int n2, int n3, Expression expression) {
        this.name = cArray;
        this.sourceStart = n2;
        this.sourceEnd = n3;
        this.value = expression;
        if (expression instanceof ArrayInitializer) {
            expression.bits |= 1;
        }
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        stringBuffer.append(this.name).append(" = ");
        this.value.print(0, stringBuffer);
        return stringBuffer;
    }

    public void resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeIds typeIds;
        if (typeBinding == null) {
            return;
        }
        if (this.value == null) {
            return;
        }
        this.value.setExpectedType(typeBinding);
        if (this.value instanceof ArrayInitializer) {
            typeIds = (ArrayInitializer)this.value;
            if (((ArrayInitializer)typeIds).resolveTypeExpecting(blockScope, this.binding.returnType) != null) {
                ((ArrayInitializer)typeIds).binding = (ArrayBinding)this.binding.returnType;
                this.value.resolvedType = ((ArrayInitializer)typeIds).binding;
            }
        } else {
            this.value.resolveType(blockScope);
        }
        if ((typeIds = this.value.resolvedType) == null) {
            return;
        }
        TypeBinding typeBinding2 = typeBinding.leafComponentType();
        if (!(this.value.isConstantValueOfTypeAssignableToType((TypeBinding)typeIds, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, ((TypeBinding)typeIds).id) || ((TypeBinding)typeIds).isCompatibleWith(typeBinding))) {
            if (!(typeBinding.isArrayType() && typeBinding.dimensions() == 1 && (this.value.isConstantValueOfTypeAssignableToType((TypeBinding)typeIds, typeBinding2) || typeBinding2.isBaseType() && BaseTypeBinding.isWidening(typeBinding2.id, ((TypeBinding)typeIds).id)) || ((TypeBinding)typeIds).isCompatibleWith(typeBinding2))) {
                if (typeBinding2.isAnnotationType() && !((TypeBinding)typeIds).isAnnotationType()) {
                    blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, typeBinding2);
                } else {
                    blockScope.problemReporter().typeMismatchError((TypeBinding)typeIds, typeBinding, this.value);
                }
                return;
            }
        } else {
            blockScope.compilationUnitScope().recordTypeConversion(typeBinding.leafComponentType(), ((TypeBinding)typeIds).leafComponentType());
            this.value.computeConversion(blockScope, typeBinding, (TypeBinding)typeIds);
        }
        switch (typeBinding2.erasure().id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n2 = 0;
                    int n3 = expressionArray.length;
                    while (n2 < n3) {
                        if (expressionArray[n2].constant == NotAConstant) {
                            blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, expressionArray[n2]);
                        }
                        ++n2;
                    }
                    break;
                }
                if (this.value.constant != NotAConstant) break;
                blockScope.problemReporter().annotationValueMustBeConstant(this.binding.declaringClass, this.name, this.value);
                break;
            }
            case 16: {
                if (this.value instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)this.value;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n4 = 0;
                    int n5 = expressionArray.length;
                    while (n4 < n5) {
                        if (!(expressionArray[n4] instanceof ClassLiteralAccess)) {
                            blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, expressionArray[n4]);
                        }
                        ++n4;
                    }
                    break;
                }
                if (this.value instanceof ClassLiteralAccess) break;
                blockScope.problemReporter().annotationValueMustBeClassLiteral(this.binding.declaringClass, this.name, this.value);
                break;
            }
            default: {
                if (typeBinding2.isEnum() || !typeBinding2.isAnnotationType() || ((TypeBinding)typeIds).leafComponentType().isAnnotationType()) break;
                blockScope.problemReporter().annotationValueMustBeAnnotation(this.binding.declaringClass, this.name, this.value, typeBinding2);
            }
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.value != null) {
            this.value.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (aSTVisitor.visit(this, compilationUnitScope) && this.value != null) {
            this.value.traverse(aSTVisitor, compilationUnitScope);
        }
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

