/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(char[] cArray, int n2, int n3) {
        this.name = cArray;
        this.sourceStart = n2;
        this.sourceEnd = n3;
        this.declarationEnd = n3;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (flowInfo.isReachable()) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        int n2 = this.initialization.nullStatus(flowInfo);
        flowInfo = this.initialization.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        flowInfo.markAsDefinitelyAssigned(this.binding);
        switch (n2) {
            case 1: {
                flowInfo.markAsDefinitelyNull(this.binding);
                break;
            }
            case -1: {
                flowInfo.markAsDefinitelyNonNull(this.binding);
            }
        }
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if (this.binding.resolvedPosition != -1) {
            codeStream.addVisibleLocalVariable(this.binding);
        }
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.initialization != null) {
            Constant constant = this.initialization.constant;
            if (constant != NotAConstant) {
                if (this.binding.resolvedPosition != -1) {
                    int n3 = codeStream.position;
                    codeStream.generateConstant(constant, this.initialization.implicitConversion);
                    codeStream.recordPositionsFrom(n3, this.initialization.sourceStart);
                    codeStream.store(this.binding, false);
                    this.binding.recordInitializationStartPC(codeStream.position);
                }
            } else {
                this.initialization.generateCode(blockScope, codeStream, true);
                if (this.binding.resolvedPosition != -1) {
                    if (this.binding.type.isArrayType() && (this.initialization.resolvedType == NullBinding || this.initialization instanceof CastExpression && ((CastExpression)this.initialization).innermostCastedExpression().resolvedType == NullBinding)) {
                        codeStream.checkcast(this.binding.type);
                    }
                    codeStream.store(this.binding, false);
                    if (this.binding.initializationCount == 0) {
                        this.binding.recordInitializationStartPC(codeStream.position);
                    }
                } else if (this.binding.type == LongBinding || this.binding.type == DoubleBinding) {
                    codeStream.pop2();
                } else {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public int getKind() {
        return 4;
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.checkModifiers();
        if (typeBinding != null) {
            if (typeBinding == VoidBinding) {
                blockScope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).leafComponentType == VoidBinding) {
                blockScope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        Binding binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false);
        boolean bl2 = true;
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                bl2 = false;
                blockScope.problemReporter().redefineLocal(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if (bl2) {
            if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
                this.modifiers |= 0x4000000;
            }
            this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, false);
            blockScope.addLocalVariable(this.binding);
            this.binding.setConstant(NotAConstant);
        }
        if (typeBinding == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(blockScope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding typeBinding2 = this.initialization.resolveTypeExpecting(blockScope, typeBinding);
                if (typeBinding2 != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)typeBinding2;
                    this.initialization.computeConversion(blockScope, typeBinding, typeBinding2);
                }
            } else {
                this.initialization.setExpectedType(typeBinding);
                TypeBinding typeBinding3 = this.initialization.resolveType(blockScope);
                if (typeBinding3 != null) {
                    if (typeBinding != typeBinding3) {
                        blockScope.compilationUnitScope().recordTypeConversion(typeBinding, typeBinding3);
                    }
                    if (this.initialization.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding) || typeBinding.isBaseType() && BaseTypeBinding.isWidening(typeBinding.id, typeBinding3.id) || typeBinding3.isCompatibleWith(typeBinding)) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                        if (typeBinding3.needsUncheckedConversion(typeBinding)) {
                            blockScope.problemReporter().unsafeTypeConversion(this.initialization, typeBinding3, typeBinding);
                        }
                    } else if (blockScope.isBoxingCompatibleWith(typeBinding3, typeBinding) || typeBinding3.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding.isBaseType() && this.initialization.isConstantValueOfTypeAssignableToType(typeBinding3, blockScope.environment().computeBoxingType(typeBinding))) {
                        this.initialization.computeConversion(blockScope, typeBinding, typeBinding3);
                    } else {
                        blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding, this);
                    }
                }
            }
            if (this.binding != null) {
                this.binding.setConstant(this.binding.isFinal() ? this.initialization.constant.castTo((typeBinding.id << 4) + this.initialization.constant.typeID()) : NotAConstant);
            }
        }
        if (this.binding != null) {
            LocalDeclaration.resolveAnnotations(blockScope, this.annotations, this.binding);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.type.traverse(aSTVisitor, blockScope);
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

