/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocArgumentExpression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class JavadocMessageSend
extends MessageSend {
    public int tagSourceStart;
    public int tagSourceEnd;
    public int tagValue;
    public boolean superAccess = false;

    public JavadocMessageSend(char[] cArray, long l2) {
        this.selector = cArray;
        this.nameSourcePosition = l2;
        this.sourceStart = (int)(this.nameSourcePosition >>> 32);
        this.sourceEnd = (int)this.nameSourcePosition;
        this.bits |= 0x8000;
    }

    public JavadocMessageSend(char[] cArray, long l2, JavadocArgumentExpression[] javadocArgumentExpressionArray) {
        this(cArray, l2);
        this.arguments = javadocArgumentExpressionArray;
    }

    private TypeBinding internalResolveType(Scope scope) {
        ParameterizedMethodBinding parameterizedMethodBinding;
        CompilerModifiers compilerModifiers;
        int n2;
        this.constant = NotAConstant;
        this.actualReceiverType = this.receiver == null ? scope.enclosingSourceType() : (scope.kind == 3 ? this.receiver.resolveType((ClassScope)scope) : this.receiver.resolveType((BlockScope)scope));
        TypeBinding[] typeBindingArray = NoParameters;
        boolean bl2 = false;
        if (this.arguments != null) {
            boolean bl3 = false;
            n2 = this.arguments.length;
            typeBindingArray = new TypeBinding[n2];
            int n3 = 0;
            while (n3 < n2) {
                compilerModifiers = this.arguments[n3];
                typeBindingArray[n3] = scope.kind == 3 ? ((Expression)compilerModifiers).resolveType((ClassScope)scope) : ((Expression)compilerModifiers).resolveType((BlockScope)scope);
                if (typeBindingArray[n3] == null) {
                    bl3 = true;
                } else if (!bl2) {
                    bl2 = typeBindingArray[n3].isTypeVariable();
                }
                ++n3;
            }
            if (bl3) {
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        this.actualReceiverType = scope.environment().convertToRawType(this.receiver.resolvedType);
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        boolean bl4 = this.superAccess = sourceTypeBinding == null ? false : sourceTypeBinding.isCompatibleWith(this.actualReceiverType);
        if (this.actualReceiverType.isBaseType()) {
            scope.problemReporter().javadocErrorNoMethodFor(this, this.actualReceiverType, typeBindingArray, scope.getDeclarationModifiers());
            return null;
        }
        this.binding = scope.getMethod(this.actualReceiverType, this.selector, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            TypeBinding typeBinding = this.actualReceiverType;
            MethodBinding methodBinding = this.binding;
            while (!methodBinding.isValidBinding() && (typeBinding.isMemberType() || typeBinding.isLocalType())) {
                typeBinding = typeBinding.enclosingType();
                methodBinding = scope.getMethod(typeBinding, this.selector, typeBindingArray, this);
            }
            if (methodBinding.isValidBinding()) {
                this.binding = methodBinding;
            } else {
                typeBinding = this.actualReceiverType;
                compilerModifiers = this.binding;
                while (!((Binding)compilerModifiers).isValidBinding() && (typeBinding.isMemberType() || typeBinding.isLocalType())) {
                    if (!CharOperation.equals(this.selector, (typeBinding = typeBinding.enclosingType()).shortReadableName())) continue;
                    compilerModifiers = scope.getConstructor((ReferenceBinding)typeBinding, typeBindingArray, this);
                }
                if (((Binding)compilerModifiers).isValidBinding()) {
                    this.binding = compilerModifiers;
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            switch (this.binding.problemId()) {
                case 5: 
                case 6: 
                case 7: {
                    MethodBinding methodBinding = ((ProblemMethodBinding)this.binding).closestMatch;
                    if (methodBinding == null) break;
                    this.binding = methodBinding;
                }
            }
        }
        if (!this.binding.isValidBinding()) {
            MethodBinding methodBinding;
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    scope.problemReporter().javadocErrorNoMethodFor(this, this.actualReceiverType, typeBindingArray, scope.getDeclarationModifiers());
                    return null;
                }
            }
            scope.problemReporter().javadocInvalidMethod(this, this.binding, scope.getDeclarationModifiers());
            if (this.binding instanceof ProblemMethodBinding && (methodBinding = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                this.binding = methodBinding;
            }
            this.resolvedType = this.binding == null ? null : this.binding.returnType;
            return this.resolvedType;
        }
        if (bl2) {
            ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.selector, typeBindingArray, 1);
            scope.problemReporter().javadocInvalidMethod(this, problemMethodBinding, scope.getDeclarationModifiers());
        } else if (this.binding.isVarargs()) {
            n2 = typeBindingArray.length;
            if (this.binding.parameters.length != n2 || !typeBindingArray[n2 - 1].isArrayType()) {
                ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.selector, typeBindingArray, 1);
                scope.problemReporter().javadocInvalidMethod(this, problemMethodBinding, scope.getDeclarationModifiers());
            }
        } else if (this.binding instanceof ParameterizedMethodBinding && this.actualReceiverType instanceof ReferenceBinding && (parameterizedMethodBinding = (ParameterizedMethodBinding)this.binding).hasSubstitutedParameters()) {
            int n4 = typeBindingArray.length;
            int n5 = 0;
            while (n5 < n4) {
                if (parameterizedMethodBinding.parameters[n5] != typeBindingArray[n5] && parameterizedMethodBinding.parameters[n5].erasure() != typeBindingArray[n5].erasure()) {
                    ProblemMethodBinding problemMethodBinding = new ProblemMethodBinding(this.binding, this.selector, typeBindingArray, 1);
                    scope.problemReporter().javadocInvalidMethod(this, problemMethodBinding, scope.getDeclarationModifiers());
                    break;
                }
                ++n5;
            }
        }
        if (this.isMethodUseDeprecated(this.binding, scope)) {
            scope.problemReporter().javadocDeprecatedMethod(this.binding, this, scope.getDeclarationModifiers());
        }
        this.resolvedType = this.binding.returnType;
        return this.resolvedType;
    }

    public boolean isSuperAccess() {
        return this.superAccess;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        if (this.receiver != null) {
            this.receiver.printExpression(0, stringBuffer);
        }
        stringBuffer.append('#').append(this.selector).append('(');
        if (this.arguments != null) {
            int n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].printExpression(0, stringBuffer);
                ++n3;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return this.internalResolveType(blockScope);
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return this.internalResolveType(classScope);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.receiver != null) {
                this.receiver.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                int n2 = this.arguments.length;
                int n3 = 0;
                while (n3 < n2) {
                    this.arguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

