/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.JavadocAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.JavadocFieldReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocMessageSend;
import org.eclipse.jdt.internal.compiler.ast.JavadocQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.JavadocSingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;

public class Javadoc
extends ASTNode {
    public JavadocSingleNameReference[] paramReferences;
    public JavadocSingleTypeReference[] paramTypeParameters;
    public TypeReference[] exceptionReferences;
    public JavadocReturnStatement returnStatement;
    public Expression[] seeReferences;
    public long inheritedPositions = -1L;
    public JavadocSingleNameReference[] invalidParameters;

    public Javadoc(int n2, int n3) {
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        int n3;
        int n4;
        Javadoc.printIndent(n2, stringBuffer).append("/**\n");
        if (this.paramReferences != null) {
            n4 = 0;
            n3 = this.paramReferences.length;
            while (n4 < n3) {
                Javadoc.printIndent(n2 + 1, stringBuffer).append(" * @param ");
                this.paramReferences[n4].print(n2, stringBuffer).append('\n');
                ++n4;
            }
        }
        if (this.paramTypeParameters != null) {
            n4 = 0;
            n3 = this.paramTypeParameters.length;
            while (n4 < n3) {
                Javadoc.printIndent(n2 + 1, stringBuffer).append(" * @param <");
                this.paramTypeParameters[n4].print(n2, stringBuffer).append(">\n");
                ++n4;
            }
        }
        if (this.returnStatement != null) {
            Javadoc.printIndent(n2 + 1, stringBuffer).append(" * @");
            this.returnStatement.print(n2, stringBuffer).append('\n');
        }
        if (this.exceptionReferences != null) {
            n4 = 0;
            n3 = this.exceptionReferences.length;
            while (n4 < n3) {
                Javadoc.printIndent(n2 + 1, stringBuffer).append(" * @throws ");
                this.exceptionReferences[n4].print(n2, stringBuffer).append('\n');
                ++n4;
            }
        }
        if (this.seeReferences != null) {
            n4 = 0;
            n3 = this.seeReferences.length;
            while (n4 < n3) {
                Javadoc.printIndent(n2 + 1, stringBuffer).append(" * @see");
                this.seeReferences[n4].print(n2, stringBuffer).append('\n');
                ++n4;
            }
        }
        Javadoc.printIndent(n2, stringBuffer).append(" */\n");
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        int n2 = this.paramReferences == null ? 0 : this.paramReferences.length;
        int n3 = 0;
        while (n3 < n2) {
            JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n3];
            classScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
            ++n3;
        }
        this.resolveTypeParameterTags(classScope, true);
        if (this.returnStatement != null) {
            classScope.problemReporter().javadocUnexpectedTag(this.returnStatement.sourceStart, this.returnStatement.sourceEnd);
        }
        n3 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            int n6;
            TypeReference typeReference;
            TypeReference typeReference2 = this.exceptionReferences[n4];
            if (typeReference2 instanceof JavadocSingleTypeReference) {
                typeReference = (JavadocSingleTypeReference)typeReference2;
                n6 = typeReference.tagSourceStart;
                n5 = typeReference.tagSourceEnd;
            } else if (typeReference2 instanceof JavadocQualifiedTypeReference) {
                typeReference = (JavadocQualifiedTypeReference)typeReference2;
                n6 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                n5 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
            } else {
                n6 = typeReference2.sourceStart;
                n5 = typeReference2.sourceEnd;
            }
            classScope.problemReporter().javadocUnexpectedTag(n6, n5);
            ++n4;
        }
        n4 = this.seeReferences == null ? 0 : this.seeReferences.length;
        int n7 = 0;
        while (n7 < n4) {
            this.resolveReference(this.seeReferences[n7], classScope);
            ++n7;
        }
    }

    public void resolve(MethodScope methodScope) {
        int n2;
        AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
        boolean bl2 = abstractMethodDeclaration == null || abstractMethodDeclaration.binding == null ? false : !abstractMethodDeclaration.binding.isStatic() && (abstractMethodDeclaration.binding.modifiers & 0x30000000) != 0;
        int n3 = this.seeReferences == null ? 0 : this.seeReferences.length;
        boolean bl3 = false;
        int n4 = 0;
        while (n4 < n3) {
            this.resolveReference(this.seeReferences[n4], methodScope);
            try {
                if (abstractMethodDeclaration != null && (abstractMethodDeclaration.isConstructor() || bl2) && !bl3) {
                    Expression expression;
                    if (this.seeReferences[n4] instanceof JavadocMessageSend) {
                        expression = (JavadocMessageSend)this.seeReferences[n4];
                        if (expression.binding != null && expression.binding.isValidBinding() && abstractMethodDeclaration.binding.declaringClass.isCompatibleWith(expression.actualReceiverType) && CharOperation.equals(expression.selector, abstractMethodDeclaration.selector) && abstractMethodDeclaration.binding.returnType.isCompatibleWith(expression.binding.returnType)) {
                            if (expression.arguments == null && abstractMethodDeclaration.arguments == null) {
                                bl3 = true;
                            } else if (expression.arguments != null && abstractMethodDeclaration.arguments != null) {
                                bl3 = abstractMethodDeclaration.binding.areParametersCompatibleWith(expression.binding.parameters);
                            }
                        }
                    } else if (this.seeReferences[n4] instanceof JavadocAllocationExpression) {
                        expression = (JavadocAllocationExpression)this.seeReferences[n4];
                        if (((JavadocAllocationExpression)expression).binding != null && ((JavadocAllocationExpression)expression).binding.isValidBinding() && abstractMethodDeclaration.binding.declaringClass.isCompatibleWith(((JavadocAllocationExpression)expression).resolvedType)) {
                            if (((JavadocAllocationExpression)expression).arguments == null && abstractMethodDeclaration.arguments == null) {
                                bl3 = true;
                            } else if (((JavadocAllocationExpression)expression).arguments != null && abstractMethodDeclaration.arguments != null) {
                                bl3 = abstractMethodDeclaration.binding.areParametersCompatibleWith(((JavadocAllocationExpression)expression).binding.parameters);
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {}
            ++n4;
        }
        int n5 = n4 = abstractMethodDeclaration != null && (bl2 && this.inheritedPositions != -1L || bl3 || abstractMethodDeclaration.binding.declaringClass != null && abstractMethodDeclaration.binding.declaringClass.isLocalType()) ? 0 : 1;
        if (!bl2 && this.inheritedPositions != -1L) {
            int n6 = (int)(this.inheritedPositions >>> 32);
            n2 = (int)this.inheritedPositions;
            methodScope.problemReporter().javadocUnexpectedTag(n6, n2);
        }
        this.resolveParamTags(methodScope, n4 != 0);
        this.resolveTypeParameterTags(methodScope, n4 != 0);
        if (this.returnStatement == null) {
            if (n4 != 0 && abstractMethodDeclaration != null && abstractMethodDeclaration.isMethod()) {
                MethodDeclaration methodDeclaration = (MethodDeclaration)abstractMethodDeclaration;
                if (methodDeclaration.binding.returnType != VoidBinding) {
                    methodScope.problemReporter().javadocMissingReturnTag(methodDeclaration.returnType.sourceStart, methodDeclaration.returnType.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                }
            }
        } else {
            this.returnStatement.resolve(methodScope);
        }
        this.resolveThrowsTags(methodScope, n4 != 0);
        int n7 = this.invalidParameters == null ? 0 : this.invalidParameters.length;
        n2 = 0;
        while (n2 < n7) {
            this.invalidParameters[n2].resolve(methodScope, false);
            ++n2;
        }
    }

    private void resolveReference(Expression expression, Scope scope) {
        int n2;
        Expression expression2;
        boolean bl2;
        switch (scope.kind) {
            case 2: {
                expression.resolveType((MethodScope)scope);
                break;
            }
            case 3: {
                expression.resolveType((ClassScope)scope);
            }
        }
        boolean bl3 = bl2 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (expression instanceof JavadocFieldReference) {
            expression2 = (JavadocFieldReference)expression;
            int n3 = n2 = expression2.binding == null ? -1 : expression2.binding.modifiers;
            if (expression2.methodBinding != null) {
                if (expression2.tagValue == 10) {
                    scope.problemReporter().javadocInvalidValueReference(expression2.sourceStart, expression2.sourceEnd, n2);
                } else if (expression2.receiverType != null) {
                    expression2.superAccess = scope.enclosingSourceType().isCompatibleWith(expression2.receiverType);
                    expression2.methodBinding = scope.findMethod((ReferenceBinding)expression2.receiverType, expression2.token, new TypeBinding[0], (InvocationSite)((Object)expression2));
                }
            } else if (bl2 && expression2.binding != null && expression2.binding.isValidBinding() && expression2.tagValue == 10 && !expression2.binding.isStatic()) {
                scope.problemReporter().javadocInvalidValueReference(expression2.sourceStart, expression2.sourceEnd, n2);
            }
        }
        if (!bl2) {
            return;
        }
        if (expression instanceof JavadocMessageSend) {
            expression2 = (JavadocMessageSend)expression;
            int n4 = n2 = ((JavadocMessageSend)expression2).binding == null ? -1 : ((JavadocMessageSend)expression2).binding.modifiers;
            if (((JavadocMessageSend)expression2).tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(((JavadocMessageSend)expression2).sourceStart, ((JavadocMessageSend)expression2).sourceEnd, n2);
            }
        } else if (expression instanceof JavadocAllocationExpression) {
            expression2 = (JavadocAllocationExpression)expression;
            int n5 = n2 = ((JavadocAllocationExpression)expression2).binding == null ? -1 : ((JavadocAllocationExpression)expression2).binding.modifiers;
            if (((JavadocAllocationExpression)expression2).tagValue == 10) {
                scope.problemReporter().javadocInvalidValueReference(((JavadocAllocationExpression)expression2).sourceStart, ((JavadocAllocationExpression)expression2).sourceEnd, n2);
            }
        }
        if (expression.resolvedType != null && expression.resolvedType.isTypeVariable()) {
            scope.problemReporter().javadocInvalidReference(expression.sourceStart, expression.sourceEnd);
        }
    }

    private void resolveParamTags(MethodScope methodScope, boolean bl2) {
        block14: {
            int n2;
            boolean bl3;
            Statement statement;
            int n3;
            int n4;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block13: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n5 = n4 = this.paramReferences == null ? 0 : this.paramReferences.length;
                if (abstractMethodDeclaration == null) {
                    int n6 = 0;
                    while (n6 < n4) {
                        JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n6];
                        methodScope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                        ++n6;
                    }
                    return;
                }
                int n7 = n3 = abstractMethodDeclaration.arguments == null ? 0 : abstractMethodDeclaration.arguments.length;
                if (n4 != 0) break block13;
                if (!bl2) break block14;
                int n8 = 0;
                while (n8 < n3) {
                    Argument argument = abstractMethodDeclaration.arguments[n8];
                    methodScope.problemReporter().javadocMissingParamTag(argument.name, argument.sourceStart, argument.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    ++n8;
                }
                break block14;
            }
            LocalVariableBinding[] localVariableBindingArray = new LocalVariableBinding[n4];
            int n9 = 0;
            int n10 = 0;
            while (n10 < n4) {
                statement = this.paramReferences[n10];
                statement.resolve(methodScope);
                if (statement.binding != null && statement.binding.isValidBinding()) {
                    bl3 = false;
                    n2 = 0;
                    while (n2 < n9 && !bl3) {
                        if (localVariableBindingArray[n2] == statement.binding) {
                            methodScope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, abstractMethodDeclaration.binding.modifiers);
                            bl3 = true;
                        }
                        ++n2;
                    }
                    if (!bl3) {
                        localVariableBindingArray[n9++] = (LocalVariableBinding)statement.binding;
                    }
                }
                ++n10;
            }
            if (bl2) {
                n10 = 0;
                while (n10 < n3) {
                    statement = abstractMethodDeclaration.arguments[n10];
                    bl3 = false;
                    n2 = 0;
                    while (n2 < n9 && !bl3) {
                        LocalVariableBinding localVariableBinding = localVariableBindingArray[n2];
                        if (((Argument)statement).binding == localVariableBinding) {
                            bl3 = true;
                        }
                        ++n2;
                    }
                    if (!bl3) {
                        methodScope.problemReporter().javadocMissingParamTag(((Argument)statement).name, ((Argument)statement).sourceStart, ((Argument)statement).sourceEnd, abstractMethodDeclaration.binding.modifiers);
                    }
                    ++n10;
                }
            }
        }
    }

    private void resolveTypeParameterTags(Scope scope, boolean bl2) {
        block24: {
            int n2;
            TypeParameter[] typeParameterArray;
            int n3;
            TypeVariableBinding[] typeVariableBindingArray;
            int n4;
            block23: {
                n4 = this.paramTypeParameters == null ? 0 : this.paramTypeParameters.length;
                TypeDeclaration typeDeclaration = null;
                AbstractMethodDeclaration abstractMethodDeclaration = null;
                typeVariableBindingArray = null;
                n3 = -1;
                switch (scope.kind) {
                    case 2: {
                        abstractMethodDeclaration = ((MethodScope)scope).referenceMethod();
                        if (abstractMethodDeclaration == null) {
                            int n5 = 0;
                            while (n5 < n4) {
                                JavadocSingleNameReference javadocSingleNameReference = this.paramReferences[n5];
                                scope.problemReporter().javadocUnexpectedTag(javadocSingleNameReference.tagSourceStart, javadocSingleNameReference.tagSourceEnd);
                                ++n5;
                            }
                            return;
                        }
                        typeVariableBindingArray = abstractMethodDeclaration.binding.typeVariables;
                        n3 = abstractMethodDeclaration.binding.modifiers;
                        break;
                    }
                    case 3: {
                        typeDeclaration = ((ClassScope)scope).referenceContext;
                        typeVariableBindingArray = typeDeclaration.binding.typeVariables;
                        n3 = typeDeclaration.binding.modifiers;
                    }
                }
                if (typeVariableBindingArray == null || typeVariableBindingArray.length == 0) {
                    int n6 = 0;
                    while (n6 < n4) {
                        JavadocSingleTypeReference javadocSingleTypeReference = this.paramTypeParameters[n6];
                        scope.problemReporter().javadocUnexpectedTag(javadocSingleTypeReference.tagSourceStart, javadocSingleTypeReference.tagSourceEnd);
                        ++n6;
                    }
                    return;
                }
                typeParameterArray = typeDeclaration == null ? abstractMethodDeclaration.typeParameters() : typeDeclaration.typeParameters;
                int n7 = n2 = typeParameterArray == null ? 0 : typeParameterArray.length;
                if (n4 != 0) break block23;
                if (!bl2) break block24;
                int n8 = 0;
                int n9 = typeParameterArray.length;
                while (n8 < n9) {
                    scope.problemReporter().javadocMissingParamTag(typeParameterArray[n8].name, typeParameterArray[n8].sourceStart, typeParameterArray[n8].sourceEnd, n3);
                    ++n8;
                }
                break block24;
            }
            if (typeVariableBindingArray.length == n2) {
                int n10;
                Statement statement;
                TypeVariableBinding[] typeVariableBindingArray2 = new TypeVariableBinding[n4];
                int n11 = 0;
                while (n11 < n4) {
                    statement = this.paramTypeParameters[n11];
                    TypeBinding typeBinding = statement.a(scope);
                    if (typeBinding != null && typeBinding.isValidBinding()) {
                        if (typeBinding.isTypeVariable()) {
                            n10 = 0;
                            int n12 = 0;
                            while (n12 < n11 && n10 == 0) {
                                if (typeVariableBindingArray2[n12] == statement.resolvedType) {
                                    scope.problemReporter().javadocDuplicatedParamTag(statement.token, statement.sourceStart, statement.sourceEnd, n3);
                                    n10 = 1;
                                }
                                ++n12;
                            }
                            if (n10 == 0) {
                                typeVariableBindingArray2[n11] = (TypeVariableBinding)statement.resolvedType;
                            }
                        } else {
                            scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n3);
                        }
                    }
                    ++n11;
                }
                n11 = 0;
                while (n11 < n2) {
                    statement = typeParameterArray[n11];
                    boolean bl3 = false;
                    n10 = 0;
                    while (n10 < n4 && !bl3) {
                        if (((TypeParameter)statement).binding == typeVariableBindingArray2[n10]) {
                            bl3 = true;
                            typeVariableBindingArray2[n10] = null;
                        }
                        ++n10;
                    }
                    if (!bl3 && bl2) {
                        scope.problemReporter().javadocMissingParamTag(((TypeParameter)statement).name, ((TypeParameter)statement).sourceStart, ((TypeParameter)statement).sourceEnd, n3);
                    }
                    ++n11;
                }
                n11 = 0;
                while (n11 < n4) {
                    if (typeVariableBindingArray2[n11] != null) {
                        statement = this.paramTypeParameters[n11];
                        scope.problemReporter().javadocUndeclaredParamTagName(statement.token, statement.sourceStart, statement.sourceEnd, n3);
                    }
                    ++n11;
                }
            }
        }
    }

    private void resolveThrowsTags(MethodScope methodScope, boolean bl2) {
        block23: {
            TypeBinding typeBinding;
            int n2;
            TypeIds typeIds;
            int n3;
            int n4;
            int n5;
            AbstractMethodDeclaration abstractMethodDeclaration;
            block22: {
                abstractMethodDeclaration = methodScope.referenceMethod();
                int n6 = n5 = this.exceptionReferences == null ? 0 : this.exceptionReferences.length;
                if (abstractMethodDeclaration == null) {
                    int n7 = 0;
                    while (n7 < n5) {
                        TypeReference typeReference = this.exceptionReferences[n7];
                        int n8 = typeReference.sourceStart;
                        int n9 = typeReference.sourceEnd;
                        if (typeReference instanceof JavadocQualifiedTypeReference) {
                            n8 = ((JavadocQualifiedTypeReference)typeReference).tagSourceStart;
                            n9 = ((JavadocQualifiedTypeReference)typeReference).tagSourceEnd;
                        } else if (typeReference instanceof JavadocSingleTypeReference) {
                            n8 = ((JavadocSingleTypeReference)typeReference).tagSourceStart;
                            n9 = ((JavadocSingleTypeReference)typeReference).tagSourceEnd;
                        }
                        methodScope.problemReporter().javadocUnexpectedTag(n8, n9);
                        ++n7;
                    }
                    return;
                }
                n4 = abstractMethodDeclaration.binding == null || abstractMethodDeclaration.binding.thrownExceptions == null ? 0 : abstractMethodDeclaration.binding.thrownExceptions.length;
                int n10 = n3 = abstractMethodDeclaration.thrownExceptions == null ? 0 : abstractMethodDeclaration.thrownExceptions.length;
                if (n5 != 0) break block22;
                if (!bl2) break block23;
                int n11 = 0;
                while (n11 < n4) {
                    ReferenceBinding referenceBinding = abstractMethodDeclaration.binding.thrownExceptions[n11];
                    if (referenceBinding != null && referenceBinding.isValidBinding()) {
                        int n12 = n11;
                        while (n12 < n3 && referenceBinding != abstractMethodDeclaration.thrownExceptions[n12].resolvedType) {
                            ++n12;
                        }
                        if (n12 < n3) {
                            methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n12], abstractMethodDeclaration.binding.modifiers);
                        }
                    }
                    ++n11;
                }
                break block23;
            }
            int n13 = 0;
            TypeReference[] typeReferenceArray = new TypeReference[n5];
            int n14 = 0;
            while (n14 < n5) {
                typeIds = this.exceptionReferences[n14];
                ((Expression)typeIds).resolve(methodScope);
                TypeBinding typeBinding2 = ((TypeReference)typeIds).resolvedType;
                if (typeBinding2 != null && typeBinding2.isValidBinding() && typeBinding2.isClass()) {
                    typeReferenceArray[n13++] = typeIds;
                }
                ++n14;
            }
            n14 = 0;
            while (n14 < n4) {
                typeIds = abstractMethodDeclaration.binding.thrownExceptions[n14];
                boolean bl3 = false;
                n2 = 0;
                while (n2 < n13 && !bl3) {
                    if (typeReferenceArray[n2] != null && typeIds == (typeBinding = typeReferenceArray[n2].resolvedType)) {
                        bl3 = true;
                        typeReferenceArray[n2] = null;
                    }
                    ++n2;
                }
                if (!bl3 && bl2 && typeIds != null && ((Binding)((Object)typeIds)).isValidBinding()) {
                    n2 = n14;
                    while (n2 < n3 && typeIds != abstractMethodDeclaration.thrownExceptions[n2].resolvedType) {
                        ++n2;
                    }
                    if (n2 < n3) {
                        methodScope.problemReporter().javadocMissingThrowsTag(abstractMethodDeclaration.thrownExceptions[n2], abstractMethodDeclaration.binding.modifiers);
                    }
                }
                ++n14;
            }
            n14 = 0;
            while (n14 < n13) {
                typeIds = typeReferenceArray[n14];
                if (typeIds != null) {
                    boolean bl4 = false;
                    n2 = 0;
                    while (n2 < n3 && !bl4) {
                        typeBinding = abstractMethodDeclaration.thrownExceptions[n2].resolvedType;
                        if (typeBinding != null) {
                            bl4 = ((TypeReference)typeIds).resolvedType.isCompatibleWith(typeBinding);
                        }
                        ++n2;
                    }
                    if (!bl4 && !((TypeReference)typeIds).resolvedType.isUncheckedException(false)) {
                        methodScope.problemReporter().javadocInvalidThrowsClassName((TypeReference)typeIds, abstractMethodDeclaration.binding.modifiers);
                    }
                }
                ++n14;
            }
        }
    }

    public ASTNode getNodeStartingAt(int n2) {
        Expression expression;
        int n3;
        int n4 = 0;
        if (this.paramReferences != null) {
            n4 = this.paramReferences.length;
            n3 = 0;
            while (n3 < n4) {
                expression = this.paramReferences[n3];
                if (expression.sourceStart == n2) {
                    return expression;
                }
                ++n3;
            }
        }
        if (this.invalidParameters != null) {
            n4 = this.invalidParameters.length;
            n3 = 0;
            while (n3 < n4) {
                expression = this.invalidParameters[n3];
                if (expression.sourceStart == n2) {
                    return expression;
                }
                ++n3;
            }
        }
        if (this.paramTypeParameters != null) {
            n4 = this.paramTypeParameters.length;
            n3 = 0;
            while (n3 < n4) {
                expression = this.paramTypeParameters[n3];
                if (((JavadocSingleTypeReference)expression).sourceStart == n2) {
                    return expression;
                }
                ++n3;
            }
        }
        if (this.exceptionReferences != null) {
            n4 = this.exceptionReferences.length;
            n3 = 0;
            while (n3 < n4) {
                expression = this.exceptionReferences[n3];
                if (((TypeReference)expression).sourceStart == n2) {
                    return expression;
                }
                ++n3;
            }
        }
        if (this.seeReferences != null) {
            n4 = this.seeReferences.length;
            n3 = 0;
            while (n3 < n4) {
                int n5;
                int n6;
                Expression expression2;
                expression = this.seeReferences[n3];
                if (expression.sourceStart == n2) {
                    return expression;
                }
                if (expression instanceof JavadocAllocationExpression) {
                    expression2 = (JavadocAllocationExpression)this.seeReferences[n3];
                    if (expression2.binding != null && expression2.binding.isValidBinding() && expression2.arguments != null) {
                        n6 = 0;
                        n5 = expression2.arguments.length;
                        while (n6 < n5) {
                            if (expression2.arguments[n6].sourceStart == n2) {
                                return expression2.arguments[n6];
                            }
                            ++n6;
                        }
                    }
                } else if (expression instanceof JavadocMessageSend) {
                    expression2 = (JavadocMessageSend)this.seeReferences[n3];
                    if (((JavadocMessageSend)expression2).binding != null && ((JavadocMessageSend)expression2).binding.isValidBinding() && ((JavadocMessageSend)expression2).arguments != null) {
                        n6 = 0;
                        n5 = ((JavadocMessageSend)expression2).arguments.length;
                        while (n6 < n5) {
                            if (((JavadocMessageSend)expression2).arguments[n6].sourceStart == n2) {
                                return ((JavadocMessageSend)expression2).arguments[n6];
                            }
                            ++n6;
                        }
                    }
                }
                ++n3;
            }
        }
        return null;
    }
}

