/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class InstanceOfExpression
extends OperatorExpression {
    public Expression expression;
    public TypeReference type;

    public InstanceOfExpression(Expression expression, TypeReference typeReference, int n2) {
        this.expression = expression;
        this.type = typeReference;
        this.bits |= n2 << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = typeReference.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        this.expression.checkNullStatus(blockScope, flowContext, flowInfo, -1);
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        this.expression.generateCode(blockScope, codeStream, true);
        codeStream.instance_of(this.type.resolvedType);
        if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        this.expression.printExpression(n2, stringBuffer).append(" instanceof ");
        return this.type.print(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        this.constant = NotAConstant;
        TypeBinding typeBinding = this.expression.resolveType(blockScope);
        TypeBinding typeBinding2 = this.type.resolveType(blockScope, true);
        if (typeBinding == null || typeBinding2 == null) {
            return null;
        }
        if (!typeBinding2.isReifiable()) {
            blockScope.problemReporter().illegalInstanceOfGenericType(typeBinding2, this);
        } else {
            boolean bl2 = this.checkCastTypesCompatibility(blockScope, typeBinding2, typeBinding, null);
            if (!bl2) {
                blockScope.problemReporter().notCompatibleTypesError(this, typeBinding, typeBinding2);
            }
        }
        this.resolvedType = BooleanBinding;
        return this.resolvedType;
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
        if (this.expression.resolvedType != NullBinding) {
            scope.problemReporter().unnecessaryInstanceof(this, typeBinding);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, blockScope);
            this.type.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

