/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class ImportReference
extends ASTNode {
    public char[][] tokens;
    public long[] sourcePositions;
    public boolean onDemand = true;
    public int declarationEnd;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public boolean used;
    public int modifiers;
    public Annotation[] annotations;

    public ImportReference(char[][] cArray, long[] lArray, boolean bl2, int n2) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.onDemand = bl2;
        this.sourceEnd = (int)(lArray[lArray.length - 1] & 0xFFFFFFFFFFFFFFFFL);
        this.sourceStart = (int)(lArray[0] >>> 32);
        this.modifiers = n2;
    }

    public boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public char[][] getImportName() {
        return this.tokens;
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        return this.print(n2, stringBuffer, true);
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer, boolean bl2) {
        int n3 = 0;
        while (n3 < this.tokens.length) {
            if (n3 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[n3]);
            ++n3;
        }
        if (bl2 && this.onDemand) {
            stringBuffer.append(".*");
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        aSTVisitor.visit(this, compilationUnitScope);
        if (this.annotations != null) {
            int n2 = this.annotations.length;
            int n3 = 0;
            while (n3 < n2) {
                this.annotations[n3].traverse(aSTVisitor, compilationUnitScope);
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

