/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IfStatement
extends Statement {
    public Expression condition;
    public Statement thenStatement;
    public Statement elseStatement;
    public boolean c;
    public int b = -1;
    public int a = -1;
    public int d = -1;

    public IfStatement(Expression expression, Statement statement, int n2, int n3) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public IfStatement(Expression expression, Statement statement, Statement statement2, int n2, int n3) {
        this.condition = expression;
        this.thenStatement = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.elseStatement = statement2;
        if (statement2 instanceof IfStatement) {
            statement2.bits |= 0x20000000;
        }
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.condition.analyseCode(blockScope, flowContext, flowInfo);
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl2 = constant != NotAConstant && constant.booleanValue();
        boolean bl3 = constant != NotAConstant && !constant.booleanValue();
        FlowInfo flowInfo2 = flowInfo.initsWhenTrue().copy();
        if (bl3) {
            flowInfo2.setReachMode(1);
        }
        FlowInfo flowInfo3 = flowInfo.initsWhenFalse().copy();
        if (bl2) {
            flowInfo3.setReachMode(1);
        }
        this.condition.checkNullComparison(blockScope, flowContext, flowInfo, flowInfo2, flowInfo3);
        if (this.thenStatement != null) {
            this.b = blockScope.methodScope().recordInitializationStates(flowInfo2);
            if (!this.thenStatement.complainIfUnreachable(flowInfo2, blockScope, false)) {
                flowInfo2 = this.thenStatement.analyseCode(blockScope, flowContext, flowInfo2);
            }
        }
        boolean bl4 = this.c = !flowInfo2.isReachable();
        if (this.elseStatement != null) {
            if (flowInfo2 == FlowInfo.DEAD_END && (this.bits & 0x20000000) == 0 && !(this.elseStatement instanceof IfStatement)) {
                blockScope.problemReporter().unnecessaryElse(this.elseStatement);
            }
            this.a = blockScope.methodScope().recordInitializationStates(flowInfo3);
            if (!this.elseStatement.complainIfUnreachable(flowInfo3, blockScope, false)) {
                flowInfo3 = this.elseStatement.analyseCode(blockScope, flowContext, flowInfo3);
            }
        }
        FlowInfo flowInfo4 = FlowInfo.mergedOptimizedBranches(flowInfo2, bl2, flowInfo3, bl3, true);
        this.d = blockScope.methodScope().recordInitializationStates(flowInfo4);
        return flowInfo4;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        boolean bl2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        Label label = new Label(codeStream);
        Constant constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = (constant == NotAConstant || constant.booleanValue()) && this.thenStatement != null && !this.thenStatement.isEmptyBlock();
        boolean bl4 = bl2 = (constant == NotAConstant || !constant.booleanValue()) && this.elseStatement != null && !this.elseStatement.isEmptyBlock();
        if (bl3) {
            Label label2 = new Label(codeStream);
            this.condition.generateOptimizedBoolean(blockScope, codeStream, null, label2, true);
            if (this.b != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.b);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.b);
            }
            this.thenStatement.generateCode(blockScope, codeStream);
            if (bl2 && !this.c) {
                this.thenStatement.branchChainTo(label);
                int n3 = codeStream.position;
                codeStream.goto_(label);
                codeStream.updateLastRecordedEndPC(this.thenStatement instanceof Block ? ((Block)this.thenStatement).scope : blockScope, n3);
            }
            label2.place();
        } else if (bl2) {
            this.condition.generateOptimizedBoolean(blockScope, codeStream, label, null, true);
        } else {
            this.condition.generateCode(blockScope, codeStream, false);
            codeStream.recordPositionsFrom(n2, this.sourceStart);
        }
        if (bl2) {
            if (this.a != -1) {
                codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
                codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
            }
            this.elseStatement.generateCode(blockScope, codeStream);
        }
        label.place();
        if (this.d != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.d);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        IfStatement.printIndent(n2, stringBuffer).append("if (");
        this.condition.printExpression(0, stringBuffer).append(")\n");
        this.thenStatement.printStatement(n2 + 2, stringBuffer);
        if (this.elseStatement != null) {
            stringBuffer.append('\n');
            IfStatement.printIndent(n2, stringBuffer);
            stringBuffer.append("else\n");
            this.elseStatement.printStatement(n2 + 2, stringBuffer);
        }
        return stringBuffer;
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, BooleanBinding);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.thenStatement != null) {
            this.thenStatement.resolve(blockScope);
        }
        if (this.elseStatement != null) {
            this.elseStatement.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.condition.traverse(aSTVisitor, blockScope);
            if (this.thenStatement != null) {
                this.thenStatement.traverse(aSTVisitor, blockScope);
            }
            if (this.elseStatement != null) {
                this.elseStatement.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

