/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Assignment;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.IntLiteral;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedThisReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class FieldReference
extends Reference
implements InvocationSite {
    public Expression receiver;
    public char[] token;
    public FieldBinding binding;
    public FieldBinding codegenBinding;
    public MethodBinding[] syntheticAccessors;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public long nameSourcePosition;
    public TypeBinding receiverType;
    public TypeBinding genericCast;

    public FieldReference(char[] cArray, long l2) {
        this.token = cArray;
        this.nameSourcePosition = l2;
        this.sourceStart = (int)(l2 >>> 32);
        this.sourceEnd = (int)(l2 & 0xFFFFFFFFL);
        this.bits |= 1;
    }

    public FlowInfo analyseAssignment(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean bl2) {
        if (bl2) {
            if (this.binding.isBlankFinal() && this.receiver.isThis() && blockScope.allowBlankFinalFieldAssignment(this.binding) && !flowInfo.isDefinitelyAssigned(this.binding)) {
                blockScope.problemReporter().uninitializedBlankFinalField(this.binding, this);
            }
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, !this.binding.isStatic()).unconditionalInits();
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, false);
        if (this.binding.isFinal()) {
            if (this.binding.isBlankFinal() && !bl2 && this.receiver.isThis() && !(this.receiver instanceof QualifiedThisReference) && (this.receiver.bits & 0x1FE00000) == 0 && blockScope.allowBlankFinalFieldAssignment(this.binding)) {
                if (flowInfo.isPotentiallyAssigned(this.binding)) {
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField(this.binding, this);
                } else {
                    flowContext.recordSettingFinal(this.binding, this, flowInfo);
                }
                flowInfo.markAsDefinitelyAssigned(this.binding);
            } else {
                blockScope.problemReporter().cannotAssignToFinalField(this.binding, this);
            }
        }
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(blockScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl2) {
        boolean bl3 = !this.binding.isStatic();
        this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl3);
        if (bl3) {
            this.receiver.checkNullStatus(blockScope, flowContext, flowInfo, -1);
        }
        if (bl2 || blockScope.compilerOptions().complianceLevel >= 0x300000L) {
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo, true);
        }
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        FieldBinding fieldBinding;
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding() && (fieldBinding = this.binding.original()) != this.binding && (fieldBinding.type.tagBits & 0x20000000L) != 0L && typeBinding.id != 1) {
            TypeBinding typeBinding3 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
            this.genericCast = fieldBinding.type.genericCast(typeBinding3);
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public FieldBinding fieldBinding() {
        return this.binding;
    }

    public void generateAssignment(BlockScope blockScope, CodeStream codeStream, Assignment assignment, boolean bl2) {
        int n2 = codeStream.position;
        this.receiver.generateCode(blockScope, codeStream, !this.codegenBinding.isStatic());
        codeStream.recordPositionsFrom(n2, this.sourceStart);
        assignment.expression.generateCode(blockScope, codeStream, true);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], bl2);
        if (bl2) {
            codeStream.generateImplicitConversion(assignment.implicitConversion);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (this.constant != NotAConstant) {
            if (bl2) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
        } else {
            boolean bl3 = this.codegenBinding.isStatic();
            if (this.codegenBinding.isConstantValue()) {
                this.receiver.generateCode(blockScope, codeStream, !bl3);
                if (!bl3) {
                    codeStream.invokeObjectGetClass();
                    codeStream.pop();
                }
                if (bl2) {
                    codeStream.generateConstant(this.codegenBinding.constant(), this.implicitConversion);
                }
            } else {
                this.receiver.generateCode(blockScope, codeStream, !bl3);
                if (bl2 || blockScope.compilerOptions().complianceLevel >= 0x300000L) {
                    if (this.codegenBinding.declaringClass == null) {
                        codeStream.arraylength();
                        if (bl2) {
                            codeStream.generateImplicitConversion(this.implicitConversion);
                        } else {
                            codeStream.pop();
                        }
                    } else {
                        if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                            if (bl3) {
                                codeStream.getstatic(this.codegenBinding);
                            } else {
                                codeStream.getfield(this.codegenBinding);
                            }
                        } else {
                            codeStream.invokestatic(this.syntheticAccessors[0]);
                        }
                        if (bl2) {
                            if (this.genericCast != null) {
                                codeStream.checkcast(this.genericCast);
                            }
                            codeStream.generateImplicitConversion(this.implicitConversion);
                        } else {
                            switch (this.codegenBinding.type.id) {
                                case 7: 
                                case 8: {
                                    codeStream.pop2();
                                    break;
                                }
                                default: {
                                    codeStream.pop();
                                    break;
                                }
                            }
                        }
                    }
                } else if (!bl3) {
                    codeStream.invokeObjectGetClass();
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateCompoundAssignment(BlockScope blockScope, CodeStream codeStream, Expression expression, int n2, int n3, boolean bl2) {
        boolean bl3 = this.codegenBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl3);
        if (bl3) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        }
        int n4 = (this.implicitConversion & 0xFF) >> 4;
        switch (n4) {
            case 0: 
            case 1: 
            case 11: {
                codeStream.generateStringConcatenationAppend(blockScope, null, expression);
                break;
            }
            default: {
                if (this.genericCast != null) {
                    codeStream.checkcast(this.genericCast);
                }
                codeStream.generateImplicitConversion(this.implicitConversion);
                if (expression == IntLiteral.One) {
                    codeStream.generateConstant(expression.constant, this.implicitConversion);
                } else {
                    expression.generateCode(blockScope, codeStream, true);
                }
                codeStream.sendOperator(n2, n4);
                codeStream.generateImplicitConversion(n3);
            }
        }
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], bl2);
    }

    public void generatePostIncrement(BlockScope blockScope, CodeStream codeStream, CompoundAssignment compoundAssignment, boolean bl2) {
        boolean bl3 = this.codegenBinding.isStatic();
        this.receiver.generateCode(blockScope, codeStream, !bl3);
        if (bl3) {
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getstatic(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        } else {
            codeStream.dup();
            if (this.syntheticAccessors == null || this.syntheticAccessors[0] == null) {
                codeStream.getfield(this.codegenBinding);
            } else {
                codeStream.invokestatic(this.syntheticAccessors[0]);
            }
        }
        if (bl2) {
            if (bl3) {
                if (this.codegenBinding.type == LongBinding || this.codegenBinding.type == DoubleBinding) {
                    codeStream.dup2();
                } else {
                    codeStream.dup();
                }
            } else if (this.codegenBinding.type == LongBinding || this.codegenBinding.type == DoubleBinding) {
                codeStream.dup2_x1();
            } else {
                codeStream.dup_x1();
            }
        }
        if (this.genericCast != null) {
            codeStream.checkcast(this.genericCast);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.generateConstant(compoundAssignment.expression.constant, this.implicitConversion);
        codeStream.sendOperator(compoundAssignment.operator, this.implicitConversion & 0xF);
        codeStream.generateImplicitConversion(compoundAssignment.preAssignImplicitConversion);
        this.fieldStore(codeStream, this.codegenBinding, this.syntheticAccessors == null ? null : this.syntheticAccessors[1], false);
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public static final Constant getConstantFor(FieldBinding fieldBinding, Reference reference, boolean bl2, Scope scope) {
        if (fieldBinding.declaringClass == null) {
            return NotAConstant;
        }
        if (!fieldBinding.isFinal()) {
            fieldBinding.setConstant(NotAConstant);
            return NotAConstant;
        }
        Constant constant = fieldBinding.constant();
        if (constant != null) {
            if (bl2 || reference instanceof QualifiedNameReference && fieldBinding == ((QualifiedNameReference)reference).binding) {
                return constant;
            }
            return NotAConstant;
        }
        FieldBinding fieldBinding2 = fieldBinding.original();
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding2.declaringClass;
        TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
        FieldDeclaration fieldDeclaration = typeDeclaration.declarationOf(fieldBinding2);
        fieldDeclaration.resolve(fieldBinding2.isStatic() ? typeDeclaration.staticInitializerScope : typeDeclaration.initializerScope);
        if (bl2 || reference instanceof QualifiedNameReference && fieldBinding == ((QualifiedNameReference)reference).binding) {
            return fieldBinding.constant();
        }
        return NotAConstant;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo, boolean bl2) {
        ProblemReasons problemReasons;
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (blockScope.enclosingSourceType() != this.codegenBinding.declaringClass && !this.binding.isConstantValue()) {
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[bl2 ? 0 : 1] = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, bl2);
                blockScope.problemReporter().needToEmulateFieldAccess(this.codegenBinding, this, bl2);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).a;
                if (this.syntheticAccessors == null) {
                    this.syntheticAccessors = new MethodBinding[2];
                }
                this.syntheticAccessors[bl2 ? 0 : 1] = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, bl2);
                blockScope.problemReporter().needToEmulateFieldAccess(this.codegenBinding, this, bl2);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                problemReasons = blockScope.enclosingSourceType();
                if (this.binding.declaringClass.getPackage() != problemReasons.getPackage()) {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)problemReasons.enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    if (this.syntheticAccessors == null) {
                        this.syntheticAccessors = new MethodBinding[2];
                    }
                    this.syntheticAccessors[bl2 ? 0 : 1] = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, bl2);
                    blockScope.problemReporter().needToEmulateFieldAccess(this.codegenBinding, this, bl2);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.receiverType && !this.receiverType.isArrayType() && this.binding.declaringClass != null && !this.binding.isConstantValue()) {
            problemReasons = blockScope.compilerOptions();
            if (!((((CompilerOptions)problemReasons).targetJDK < 0x2E0000L || ((CompilerOptions)problemReasons).complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(blockScope))) {
                this.codegenBinding = blockScope.enclosingSourceType().getUpdatedFieldBinding(this.codegenBinding, (ReferenceBinding)this.receiverType.erasure());
            }
        }
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        return this.receiver.printExpression(0, stringBuffer).append('.').append(this.token);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        ReferenceBinding referenceBinding;
        boolean bl2 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl2 = true;
        }
        this.receiverType = this.receiver.resolveType(blockScope);
        if (this.receiverType == null) {
            this.constant = NotAConstant;
            return null;
        }
        if (bl2 && ((CastExpression)this.receiver).expression.resolvedType == this.receiverType) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        this.codegenBinding = this.binding = blockScope.getField(this.receiverType, this.token, this);
        FieldBinding fieldBinding = this.binding;
        if (!fieldBinding.isValidBinding()) {
            this.constant = NotAConstant;
            blockScope.problemReporter().invalidField(this, this.receiverType);
            return null;
        }
        TypeBinding typeBinding = this.receiverType.erasure();
        if (typeBinding instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(fieldBinding.declaringClass)) == null) {
            this.receiverType = fieldBinding.declaringClass;
        }
        this.receiver.computeConversion(blockScope, this.receiverType, this.receiverType);
        if (this.isFieldUseDeprecated(fieldBinding, blockScope, (this.bits & 0x2000) != 0)) {
            blockScope.problemReporter().deprecatedField(fieldBinding, this);
        }
        boolean bl3 = this.receiver.isImplicitThis();
        this.constant = FieldReference.getConstantFor(fieldBinding, this, bl3, blockScope);
        if (!bl3) {
            this.constant = NotAConstant;
        }
        if (fieldBinding.isStatic()) {
            if (!(bl3 || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                blockScope.problemReporter().nonStaticAccessToStaticField(this, fieldBinding);
            }
            if (!bl3 && fieldBinding.declaringClass != this.receiverType) {
                blockScope.problemReporter().indirectAccessToStaticField(this, fieldBinding);
            }
        }
        this.resolvedType = (this.bits & 0x2000) == 0 ? fieldBinding.type.capture(blockScope, this.sourceEnd) : fieldBinding.type;
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
    }

    public void setDepth(int n2) {
        this.bits &= 0xFFFFE01F;
        if (n2 > 0) {
            this.bits |= (n2 & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int n2) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.receiver.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

