/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReasons;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class ConstructorDeclaration
extends AbstractMethodDeclaration {
    public ExplicitConstructorCall constructorCall;
    public boolean isDefaultConstructor = false;
    public TypeParameter[] typeParameters;

    public ConstructorDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationFlowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (!(this.binding == null || this.binding.isUsed() || !this.binding.isPrivate() && (this.binding.declaringClass.tagBits & 0x30L) != 16L || classScope.referenceCompilationUnit().compilationResult.hasSyntaxError)) {
            this.scope.problemReporter().unusedPrivateConstructor(this);
        }
        if (this.isRecursive(null)) {
            this.scope.problemReporter().recursiveConstructorInvocation(this.constructorCall);
        }
        try {
            CompilerModifiers compilerModifiers;
            int n2;
            FieldBinding[] fieldBindingArray;
            ExceptionHandlingFlowContext exceptionHandlingFlowContext = new ExceptionHandlingFlowContext(initializationFlowContext.parent, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            initializationFlowContext.checkInitializerExceptions(this.scope, exceptionHandlingFlowContext, flowInfo);
            if (this.binding.declaringClass.isAnonymousType() && (fieldBindingArray = exceptionHandlingFlowContext.extendedExceptions) != null && (n2 = fieldBindingArray.size()) > 0) {
                ReferenceBinding[] referenceBindingArray = new ReferenceBinding[n2];
                fieldBindingArray.toArray(referenceBindingArray);
                this.binding.thrownExceptions = referenceBindingArray;
            }
            if (this.arguments != null) {
                int n3 = 0;
                n2 = this.arguments.length;
                while (n3 < n2) {
                    flowInfo.markAsDefinitelyAssigned(this.arguments[n3].binding);
                    ++n3;
                }
            }
            if (this.constructorCall != null) {
                if (this.constructorCall.accessMode == 3) {
                    fieldBindingArray = this.binding.declaringClass.fields();
                    n2 = 0;
                    int n4 = fieldBindingArray.length;
                    while (n2 < n4) {
                        compilerModifiers = fieldBindingArray[n2];
                        if (!((FieldBinding)compilerModifiers).isStatic()) {
                            flowInfo.markAsDefinitelyAssigned((FieldBinding)compilerModifiers);
                        }
                        ++n2;
                    }
                }
                flowInfo = this.constructorCall.analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
            }
            if (this.statements != null) {
                boolean bl2 = false;
                n2 = 0;
                int n5 = this.statements.length;
                while (n2 < n5) {
                    compilerModifiers = this.statements[n2];
                    if (!((Statement)compilerModifiers).complainIfUnreachable(flowInfo, this.scope, bl2)) {
                        flowInfo = ((Statement)compilerModifiers).analyseCode(this.scope, exceptionHandlingFlowContext, flowInfo);
                    } else {
                        bl2 = true;
                    }
                    ++n2;
                }
            }
            this.needFreeReturn = flowInfo.isReachable();
            if (this.constructorCall != null && this.constructorCall.accessMode != 3) {
                flowInfo = flowInfo.mergedWith(exceptionHandlingFlowContext.initsOnReturn);
                FieldBinding[] fieldBindingArray2 = this.binding.declaringClass.fields();
                n2 = 0;
                int n6 = fieldBindingArray2.length;
                while (n2 < n6) {
                    compilerModifiers = fieldBindingArray2[n2];
                    if (!((FieldBinding)compilerModifiers).isStatic() && ((VariableBinding)compilerModifiers).isFinal() && !flowInfo.isDefinitelyAssigned(fieldBindingArray2[n2])) {
                        this.scope.problemReporter().uninitializedBlankFinalField((FieldBinding)compilerModifiers, this.isDefaultConstructor ? this.scope.referenceType() : this);
                    }
                    ++n2;
                }
            }
            exceptionHandlingFlowContext.complainIfUnusedExceptionHandlers(this);
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n2 = 0;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n3 = iProblemArray.length;
            IProblem[] iProblemArray2 = new IProblem[n3];
            System.arraycopy(iProblemArray, 0, iProblemArray2, 0, n3);
            classFile.addProblemConstructor(this, this.binding, iProblemArray2);
            return;
        }
        try {
            n2 = classFile.contentsOffset;
            this.internalGenerateCode(classScope, classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n2;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.internalGenerateCode(classScope, classFile);
                }
                catch (AbortMethod abortMethod2) {
                    IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n4 = iProblemArray.length;
                    IProblem[] iProblemArray3 = new IProblem[n4];
                    System.arraycopy(iProblemArray, 0, iProblemArray3, 0, n4);
                    classFile.addProblemConstructor(this, this.binding, iProblemArray3, n2);
                }
            }
            IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n5 = iProblemArray.length;
            IProblem[] iProblemArray4 = new IProblem[n5];
            System.arraycopy(iProblemArray, 0, iProblemArray4, 0, n5);
            classFile.addProblemConstructor(this, this.binding, iProblemArray4, n2);
        }
    }

    public void generateSyntheticFieldInitializationsIfNecessary(MethodScope methodScope, CodeStream codeStream, ReferenceBinding referenceBinding) {
        SyntheticArgumentBinding syntheticArgumentBinding;
        if (!referenceBinding.isNestedType()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)referenceBinding;
        SyntheticArgumentBinding[] syntheticArgumentBindingArray = nestedTypeBinding.syntheticEnclosingInstances();
        int n2 = 0;
        int n3 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        while (n2 < n3) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n2];
            if (syntheticArgumentBinding.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.putfield(syntheticArgumentBinding.matchingField);
            }
            ++n2;
        }
        syntheticArgumentBindingArray = nestedTypeBinding.syntheticOuterLocalVariables();
        n2 = 0;
        n3 = syntheticArgumentBindingArray == null ? 0 : syntheticArgumentBindingArray.length;
        while (n2 < n3) {
            syntheticArgumentBinding = syntheticArgumentBindingArray[n2];
            if (syntheticArgumentBinding.matchingField != null) {
                codeStream.aload_0();
                codeStream.load(syntheticArgumentBinding);
                codeStream.putfield(syntheticArgumentBinding.matchingField);
            }
            ++n2;
        }
    }

    private void internalGenerateCode(ClassScope classScope, ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n2 = classFile.contentsOffset;
        int n3 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n4;
            boolean bl2;
            int n5;
            ProblemReasons problemReasons;
            TypeDeclaration typeDeclaration = classScope.referenceContext;
            int n6 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            ReferenceBinding referenceBinding = this.binding.declaringClass;
            int n7 = referenceBinding.isEnum() ? 2 : 0;
            int n8 = 1 + n7;
            if (referenceBinding.isNestedType()) {
                problemReasons = (NestedTypeBinding)referenceBinding;
                this.scope.extraSyntheticArguments = ((NestedTypeBinding)problemReasons).syntheticOuterLocalVariables();
                this.scope.computeLocalVariablePositions(((NestedTypeBinding)problemReasons).enclosingInstancesSlotSize + 1 + n7, codeStream);
                n8 += ((NestedTypeBinding)problemReasons).enclosingInstancesSlotSize;
                n8 += ((NestedTypeBinding)problemReasons).outerLocalVariablesSlotSize;
            } else {
                this.scope.computeLocalVariablePositions(1 + n7, codeStream);
            }
            if (this.arguments != null) {
                int n9 = 0;
                n5 = this.arguments.length;
                while (n9 < n5) {
                    LocalVariableBinding localVariableBinding = this.arguments[n9].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    TypeBinding typeBinding = localVariableBinding.type;
                    n8 = typeBinding == LongBinding || typeBinding == DoubleBinding ? (n8 += 2) : ++n8;
                    ++n9;
                }
            }
            problemReasons = typeDeclaration.initializerScope;
            ((MethodScope)problemReasons).computeLocalVariablePositions(n8, codeStream);
            n5 = this.constructorCall != null && this.constructorCall.accessMode == 3 ? 0 : 1;
            boolean bl3 = bl2 = this.scope.compilerOptions().targetJDK >= 0x300000L;
            if (n5 != 0 && bl2) {
                this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
            }
            if (this.constructorCall != null) {
                this.constructorCall.generateCode(this.scope, codeStream);
            }
            if (n5 != 0) {
                if (!bl2) {
                    this.generateSyntheticFieldInitializationsIfNecessary(this.scope, codeStream, referenceBinding);
                }
                if (typeDeclaration.fields != null) {
                    int n10 = 0;
                    n4 = typeDeclaration.fields.length;
                    while (n10 < n4) {
                        FieldDeclaration fieldDeclaration = typeDeclaration.fields[n10];
                        if (!fieldDeclaration.isStatic()) {
                            fieldDeclaration.generateCode((BlockScope)problemReasons, codeStream);
                        }
                        ++n10;
                    }
                }
            }
            if (this.statements != null) {
                int n11 = 0;
                n4 = this.statements.length;
                while (n11 < n4) {
                    this.statements[n11].generateCode(this.scope, codeStream);
                    ++n11;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.bodyEnd);
            classFile.completeCodeAttribute(n6);
            ++n3;
        }
        classFile.completeMethodInfo(n2, n3);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    public boolean isConstructor() {
        return true;
    }

    public boolean isDefaultConstructor() {
        return this.isDefaultConstructor;
    }

    public boolean isInitializationMethod() {
        return true;
    }

    public boolean isRecursive(ArrayList arrayList) {
        if (this.binding == null || this.constructorCall == null || this.constructorCall.binding == null || this.constructorCall.isSuperAccess() || !this.constructorCall.binding.isValidBinding()) {
            return false;
        }
        ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)this.scope.referenceType().declarationOf(this.constructorCall.binding.original());
        if (this == constructorDeclaration) {
            return true;
        }
        if (arrayList == null) {
            arrayList = new ArrayList<ConstructorDeclaration>(1);
        } else {
            int n2 = arrayList.indexOf(this);
            if (n2 >= 0) {
                return n2 == 0;
            }
        }
        arrayList.add(this);
        return constructorDeclaration.isRecursive(arrayList);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        if (this.isDefaultConstructor && this.constructorCall == null) {
            this.constructorCall = SuperReference.implicitSuperConstructorCall();
            this.constructorCall.sourceStart = this.sourceStart;
            this.constructorCall.sourceEnd = this.sourceEnd;
            return;
        }
        parser.parse(this, compilationUnitDeclaration);
    }

    public StringBuffer printBody(int n2, StringBuffer stringBuffer) {
        stringBuffer.append(" {");
        if (this.constructorCall != null) {
            stringBuffer.append('\n');
            this.constructorCall.printStatement(n2, stringBuffer);
        }
        if (this.statements != null) {
            int n3 = 0;
            while (n3 < this.statements.length) {
                stringBuffer.append('\n');
                this.statements[n3].printStatement(n2, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append('\n');
        ConstructorDeclaration.printIndent(n2 == 0 ? 0 : n2 - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public void resolveJavadoc() {
        if (this.binding == null || this.javadoc != null) {
            super.resolveJavadoc();
        } else if (!this.isDefaultConstructor) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (!CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().missingReturnType(this);
        }
        if (this.typeParameters != null) {
            int n2 = 0;
            int n3 = this.typeParameters.length;
            while (n2 < n3) {
                this.typeParameters[n2].resolve(this.scope);
                ++n2;
            }
        }
        if (this.constructorCall != null) {
            if (this.binding != null && this.binding.declaringClass.id == 1 && this.constructorCall.accessMode != 3) {
                if (this.constructorCall.accessMode == 2) {
                    this.scope.problemReporter().cannotUseSuperInJavaLangObject(this.constructorCall);
                }
                this.constructorCall = null;
            } else {
                this.constructorCall.resolve(this.scope);
            }
        }
        if ((this.modifiers & 0x1000000) != 0) {
            this.scope.problemReporter().methodNeedBody(this);
        }
        super.resolveStatements();
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            int n2;
            int n3;
            if (this.annotations != null) {
                n3 = this.annotations.length;
                n2 = 0;
                while (n2 < n3) {
                    this.annotations[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.typeParameters != null) {
                n3 = this.typeParameters.length;
                n2 = 0;
                while (n2 < n3) {
                    this.typeParameters[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                n2 = 0;
                while (n2 < n3) {
                    this.arguments[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.thrownExceptions != null) {
                n3 = this.thrownExceptions.length;
                n2 = 0;
                while (n2 < n3) {
                    this.thrownExceptions[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.constructorCall != null) {
                this.constructorCall.traverse(aSTVisitor, this.scope);
            }
            if (this.statements != null) {
                n3 = this.statements.length;
                n2 = 0;
                while (n2 < n3) {
                    this.statements[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }

    public TypeParameter[] typeParameters() {
        return this.typeParameters;
    }
}

