/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public abstract class BranchStatement
extends Statement {
    public char[] label;
    public Label targetLabel;
    public SubRoutineStatement[] subroutines;

    public BranchStatement(char[] cArray, int n2, int n3) {
        this.label = cArray;
        this.sourceStart = n2;
        this.sourceEnd = n3;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.subroutines != null) {
            int n3 = 0;
            int n4 = this.subroutines.length;
            while (n3 < n4) {
                SubRoutineStatement subRoutineStatement = this.subroutines[n3];
                subRoutineStatement.generateSubRoutineInvocation(blockScope, codeStream);
                if (subRoutineStatement.isSubRoutineEscaping()) {
                    codeStream.recordPositionsFrom(n2, this.sourceStart);
                    SubRoutineStatement.reenterExceptionHandlers(this.subroutines, n3, codeStream);
                    return;
                }
                subRoutineStatement.exitAnyExceptionHandler();
                ++n3;
            }
        }
        codeStream.goto_(this.targetLabel);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
        SubRoutineStatement.reenterExceptionHandlers(this.subroutines, -1, codeStream);
    }

    public void resolve(BlockScope blockScope) {
    }
}

