/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AssertStatement
extends Statement {
    public Expression assertExpression;
    public Expression exceptionArgument;
    public int a = -1;
    private FieldBinding assertionSyntheticFieldBinding;

    public AssertStatement(Expression expression, Expression expression2, int n2) {
        this.assertExpression = expression2;
        this.exceptionArgument = expression;
        this.sourceStart = n2;
        this.sourceEnd = expression.sourceEnd;
    }

    public AssertStatement(Expression expression, int n2) {
        this.assertExpression = expression;
        this.sourceStart = n2;
        this.sourceEnd = expression.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.a = blockScope.methodScope().recordInitializationStates(flowInfo);
        Constant constant = this.assertExpression.optimizedBooleanConstant();
        boolean bl2 = constant != NotAConstant && constant.booleanValue();
        boolean bl3 = constant != NotAConstant && !constant.booleanValue();
        FlowInfo flowInfo2 = flowInfo.copy();
        if (bl2) {
            flowInfo2.setReachMode(1);
        }
        flowInfo2 = this.assertExpression.analyseCode(blockScope, flowContext, flowInfo2).unconditionalInits();
        if (this.exceptionArgument != null) {
            FlowInfo flowInfo3 = this.exceptionArgument.analyseCode(blockScope, flowContext, flowInfo2.copy());
            if (!bl2) {
                flowContext.checkExceptionHandlers(blockScope.getJavaLangAssertionError(), (ASTNode)this, flowInfo3, blockScope);
            }
        }
        if (!bl2) {
            this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        }
        if (bl3) {
            return flowInfo;
        }
        return flowInfo.mergedWith(flowInfo2.unconditionalInits());
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        if (this.assertionSyntheticFieldBinding != null) {
            Label label = new Label(codeStream);
            codeStream.getstatic(this.assertionSyntheticFieldBinding);
            codeStream.ifne(label);
            Label label2 = new Label(codeStream);
            label2 = new Label(codeStream);
            this.assertExpression.generateOptimizedBoolean(blockScope, codeStream, label2, null, true);
            codeStream.newJavaLangAssertionError();
            codeStream.dup();
            if (this.exceptionArgument != null) {
                this.exceptionArgument.generateCode(blockScope, codeStream, true);
                codeStream.invokeJavaLangAssertionErrorConstructor(this.exceptionArgument.implicitConversion & 0xF);
            } else {
                codeStream.invokeJavaLangAssertionErrorDefaultConstructor();
            }
            codeStream.athrow();
            label2.place();
            label.place();
        }
        if (this.a != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding;
        this.assertExpression.resolveTypeExpecting(blockScope, BooleanBinding);
        if (this.exceptionArgument != null && (typeBinding = this.exceptionArgument.resolveType(blockScope)) != null) {
            int n2 = typeBinding.id;
            switch (n2) {
                case 6: {
                    blockScope.problemReporter().illegalVoidExpression(this.exceptionArgument);
                }
                default: {
                    n2 = 1;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
            }
            this.exceptionArgument.implicitConversion = (n2 << 4) + n2;
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.assertExpression.traverse(aSTVisitor, blockScope);
            if (this.exceptionArgument != null) {
                this.exceptionArgument.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        BaseTypes baseTypes;
        if (!flowInfo.isReachable()) {
            return;
        }
        SourceTypeBinding sourceTypeBinding = blockScope.enclosingSourceType();
        while (sourceTypeBinding.isLocalType()) {
            baseTypes = sourceTypeBinding.enclosingType();
            if (baseTypes == null || baseTypes.isInterface()) break;
            sourceTypeBinding = (SourceTypeBinding)baseTypes;
        }
        this.assertionSyntheticFieldBinding = sourceTypeBinding.addSyntheticFieldForAssert(blockScope);
        baseTypes = sourceTypeBinding.scope.referenceType();
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = ((TypeDeclaration)baseTypes).methods;
        int n2 = 0;
        int n3 = abstractMethodDeclarationArray.length;
        while (n2 < n3) {
            AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n2];
            if (abstractMethodDeclaration.isClinit()) {
                ((Clinit)abstractMethodDeclaration).setAssertionSupport(this.assertionSyntheticFieldBinding, blockScope.compilerOptions().sourceLevel < 0x310000L);
                break;
            }
            ++n2;
        }
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        AssertStatement.printIndent(n2, stringBuffer);
        stringBuffer.append("assert ");
        this.assertExpression.printExpression(0, stringBuffer);
        if (this.exceptionArgument != null) {
            stringBuffer.append(": ");
            this.exceptionArgument.printExpression(0, stringBuffer);
        }
        return stringBuffer.append(';');
    }
}

