/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] cArray, long l2, TypeReference typeReference, int n2) {
        super(cArray, (int)(l2 >>> 32), (int)l2);
        this.declarationSourceEnd = (int)l2;
        this.modifiers = n2;
        this.type = typeReference;
        this.bits |= 0x40000000;
    }

    public void bind(MethodScope methodScope, TypeBinding typeBinding, boolean bl2) {
        int n2 = this.modifiers;
        Binding binding = methodScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                methodScope.problemReporter().redefineArgument(this);
                return;
            }
            boolean bl3 = false;
            if (binding instanceof FieldBinding) {
                if (methodScope.isInsideConstructor()) {
                    bl3 = true;
                } else {
                    AbstractMethodDeclaration abstractMethodDeclaration = methodScope.referenceMethod();
                    if (abstractMethodDeclaration != null && CharOperation.prefixEquals(SET, abstractMethodDeclaration.selector)) {
                        bl3 = true;
                    }
                }
            }
            methodScope.problemReporter().localVariableHiding(this, binding, bl3);
        }
        this.binding = new LocalVariableBinding(this, typeBinding, n2, true);
        methodScope.addLocalVariable(this.binding);
        Argument.resolveAnnotations(methodScope, this.annotations, this.binding);
        this.binding.declaration = this;
        this.binding.useFlag = bl2 ? 1 : 0;
    }

    public int getKind() {
        return 5;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        Argument.printIndent(n2, stringBuffer);
        Argument.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            Argument.printAnnotations(this.annotations, stringBuffer);
        }
        if (this.type == null) {
            stringBuffer.append("<no type> ");
        } else {
            this.type.print(0, stringBuffer).append(' ');
        }
        return stringBuffer.append(this.name);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        return this.print(n2, stringBuffer).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        if (typeBinding == null) {
            return null;
        }
        if (typeBinding.isGenericType() || typeBinding.isBoundParameterizedType()) {
            blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this);
            return null;
        }
        if (typeBinding.isTypeVariable()) {
            blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this);
            return null;
        }
        ReferenceBinding referenceBinding = blockScope.getJavaLangThrowable();
        if (!typeBinding.isCompatibleWith(referenceBinding)) {
            blockScope.problemReporter().typeMismatchError(typeBinding, referenceBinding, this);
            return null;
        }
        Binding binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineArgument(this);
                return null;
            }
            blockScope.problemReporter().localVariableHiding(this, binding, false);
        }
        this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, false);
        Argument.resolveAnnotations(blockScope, this.annotations, this.binding);
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(NotAConstant);
        return typeBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.initialization != null) {
                this.initialization.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

